/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.ICategoryActivityBinding;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.NotDefinedException;
import org.eclipse.ui.internal.activities.ws.ActivityCategoryContentProvider;
import org.eclipse.ui.internal.activities.ws.ActivityCategoryLabelProvider;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.activities.ws.CategorizedActivity;

public class ActivityEnabler {
    private static final int ALL = 2;
    private static final int NONE = 0;
    private static final int SOME = 1;
    private IWorkbenchActivitySupport activitySupport;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            try {
                if (element instanceof ICategory) {
                    ActivityEnabler.this.descriptionText.setText(((ICategory)element).getDescription());
                } else if (element instanceof IActivity) {
                    ActivityEnabler.this.descriptionText.setText(((IActivity)element).getDescription());
                }
            }
            catch (NotDefinedException notDefinedException) {
                ActivityEnabler.this.descriptionText.setText("");
            }
        }
    };
    private ICheckStateListener checkListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            HashSet<Object> checked = new HashSet<Object>(Arrays.asList(ActivityEnabler.this.dualViewer.getCheckedElements()));
            Object element = event.getElement();
            if (element instanceof ICategory) {
                ActivityEnabler.this.dualViewer.setSubtreeChecked(element, event.getChecked());
                ActivityEnabler.this.dualViewer.setGrayed(element, false);
            } else {
                CategorizedActivity proxy = (CategorizedActivity)element;
                Object[] children = ActivityEnabler.this.provider.getChildren(proxy.getCategory());
                int state = 0;
                int count = 0;
                int i = 0;
                while (i < children.length) {
                    if (checked.contains(children[i])) {
                        ++count;
                    }
                    ++i;
                }
                if (count == children.length) {
                    state = 2;
                } else if (count != 0) {
                    state = 1;
                }
                if (state == 0) {
                    checked.remove(proxy.getCategory());
                } else {
                    checked.add(proxy.getCategory());
                }
                ActivityEnabler.this.dualViewer.setGrayed((Object)proxy.getCategory(), state == 1);
                ActivityEnabler.this.dualViewer.setCheckedElements(checked.toArray());
            }
        }
    };
    private CheckboxTreeViewer dualViewer;
    private Set managedActivities = new HashSet(7);
    private ActivityCategoryContentProvider provider = new ActivityCategoryContentProvider();
    private Text descriptionText;

    public ActivityEnabler(IWorkbenchActivitySupport activitySupport) {
        this.activitySupport = activitySupport;
    }

    public Control createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        Composite c = new Composite(mainComposite, 0);
        c.setLayoutData((Object)new GridData(1040));
        c.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(c, 0);
        label.setText(ActivityMessages.getString("ActivityEnabler.activities"));
        label.setLayoutData((Object)new GridData(768));
        this.dualViewer = new CheckboxTreeViewer(c);
        this.dualViewer.setSorter(new ViewerSorter());
        this.dualViewer.setAutoExpandLevel(-1);
        this.dualViewer.setLabelProvider((IBaseLabelProvider)new ActivityCategoryLabelProvider());
        this.dualViewer.setContentProvider((IContentProvider)this.provider);
        this.dualViewer.setInput((Object)this.activitySupport.getActivityManager());
        this.dualViewer.getControl().setLayoutData((Object)new GridData(1808));
        c = new Composite(mainComposite, 0);
        c.setLayoutData((Object)new GridData(1808));
        c.setLayout((Layout)new GridLayout(1, true));
        label = new Label(c, 0);
        label.setText(ActivityMessages.getString("ActivityEnabler.description"));
        label.setLayoutData((Object)new GridData(768));
        this.descriptionText = new Text(c, 72);
        this.descriptionText.setLayoutData((Object)new GridData(1810));
        this.setInitialStates();
        this.dualViewer.addCheckStateListener(this.checkListener);
        this.dualViewer.addSelectionChangedListener(this.selectionListener);
        this.dualViewer.setSelection((ISelection)new StructuredSelection());
        return mainComposite;
    }

    private Collection getCategoryActivityIds(String categoryId) {
        ICategory category = this.activitySupport.getActivityManager().getCategory(categoryId);
        Set activityBindings = category.getCategoryActivityBindings();
        ArrayList<String> categoryActivities = new ArrayList<String>(activityBindings.size());
        Iterator i = activityBindings.iterator();
        while (i.hasNext()) {
            ICategoryActivityBinding binding = (ICategoryActivityBinding)i.next();
            String activityId = binding.getActivityId();
            categoryActivities.add(activityId);
        }
        return categoryActivities;
    }

    private void setInitialStates() {
        Set enabledActivities = this.activitySupport.getActivityManager().getEnabledActivityIds();
        Set categories = this.activitySupport.getActivityManager().getDefinedCategoryIds();
        ArrayList<Comparable> checked = new ArrayList<Comparable>(10);
        ArrayList<ICategory> grayed = new ArrayList<ICategory>(10);
        Iterator i = categories.iterator();
        while (i.hasNext()) {
            String categoryId = (String)i.next();
            ICategory category = this.activitySupport.getActivityManager().getCategory(categoryId);
            int state = 0;
            Collection activities = this.getCategoryActivityIds(categoryId);
            int foundCount = 0;
            Iterator j = activities.iterator();
            while (j.hasNext()) {
                String activityId = (String)j.next();
                this.managedActivities.add(activityId);
                if (!enabledActivities.contains(activityId)) continue;
                IActivity activity = this.activitySupport.getActivityManager().getActivity(activityId);
                checked.add(new CategorizedActivity(category, activity));
                ++foundCount;
            }
            if (foundCount == activities.size()) {
                state = 2;
            } else if (foundCount > 0) {
                state = 1;
            }
            if (state == 0) continue;
            checked.add(category);
            if (state != 1) continue;
            grayed.add(category);
        }
        this.dualViewer.setCheckedElements(checked.toArray());
        this.dualViewer.setGrayedElements(grayed.toArray());
    }

    public void updateActivityStates() {
        HashSet<String> enabledActivities = new HashSet<String>(this.activitySupport.getActivityManager().getEnabledActivityIds());
        enabledActivities.removeAll(this.managedActivities);
        Object[] checked = this.dualViewer.getCheckedElements();
        int i = 0;
        while (i < checked.length) {
            Object element = checked[i];
            if (!(element instanceof ICategory) && !this.dualViewer.getGrayed(element)) {
                enabledActivities.add(((IActivity)element).getId());
            }
            ++i;
        }
        this.activitySupport.setEnabledActivityIds(enabledActivities);
    }
}

