/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.intro.IIntroDescriptor;
import org.eclipse.ui.intro.IIntroPart;

public class IntroDescriptor
implements IIntroDescriptor,
IPluginContribution {
    private static final String ATT_ID = "id";
    private static final String ATT_CLASS = "class";
    private static final String ATT_NAME = "name";
    private static final String ATT_PRODUCTID = "productId";
    private IConfigurationElement configElement;
    private String id;
    private String pluginId;
    private String productId;
    private String name;

    public IntroDescriptor(IConfigurationElement configElement) throws CoreException {
        this.configElement = configElement;
        this.loadFromExtension();
    }

    public String getProductId() {
        return this.productId;
    }

    private void loadFromExtension() throws CoreException {
        this.id = this.configElement.getAttribute(ATT_ID);
        this.name = this.configElement.getAttribute(ATT_NAME);
        this.productId = this.configElement.getAttribute(ATT_PRODUCTID);
        this.pluginId = this.configElement.getDeclaringExtension().getNamespace();
        String className = this.configElement.getAttribute(ATT_CLASS);
        if (this.name == null || className == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getDeclaringExtension().getNamespace(), 0, "Invalid extension (missing label or class name): " + this.id, null));
        }
    }

    public IIntroPart createIntro() throws CoreException {
        return (IIntroPart)WorkbenchPlugin.createExtension(this.configElement, ATT_CLASS);
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getLabel() {
        return this.name;
    }

    public String getLocalId() {
        return this.id;
    }

    public String getPluginId() {
        return this.pluginId;
    }
}

