/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.progress.ErrorInfo;
import org.eclipse.ui.internal.progress.ErrorNotificationDialog;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class ErrorNotificationManager {
    private static final String ERROR_JOB = "errorstate.gif";
    static final String ERROR_JOB_KEY = "ERROR_JOB";
    private Collection errors = Collections.synchronizedSet(new HashSet());
    private ErrorNotificationDialog dialog;
    private boolean dialogActive = false;

    void setUpImages(URL iconsRoot) throws MalformedURLException {
        JFaceResources.getImageRegistry().put(ERROR_JOB_KEY, ImageDescriptor.createFromURL((URL)new URL(iconsRoot, ERROR_JOB)));
    }

    void addError(IStatus status, String jobName) {
        this.errors.add(new ErrorInfo(status, jobName));
        if (this.dialogActive) {
            if (this.dialog != null) {
                this.refreshDialog();
            }
        } else {
            this.openErrorDialog();
        }
    }

    private void refreshDialog() {
        UIJob refreshJob = new UIJob(ProgressMessages.getString("ErrorNotificationManager.RefreshErrorDialogJob")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ErrorNotificationManager.this.dialog.refresh();
                return Status.OK_STATUS;
            }
        };
        refreshJob.setSystem(true);
        refreshJob.schedule();
    }

    Collection getErrors() {
        return this.errors;
    }

    private void openErrorDialog() {
        this.dialogActive = true;
        WorkbenchJob job = new WorkbenchJob(ProgressMessages.getString("ErrorNotificationManager.OpenErrorDialogJob")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench instanceof Workbench && ((Workbench)workbench).isClosing()) {
                    return Status.CANCEL_STATUS;
                }
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null) {
                    return Status.CANCEL_STATUS;
                }
                ErrorNotificationManager.this.dialog = new ErrorNotificationDialog(window.getShell());
                ErrorNotificationManager.this.dialog.open();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    void removeErrors(Collection errorsToRemove) {
        this.errors.removeAll(errorsToRemove);
    }

    void clearAllErrors() {
        this.errors.clear();
    }

    void clearDialog() {
        this.dialog = null;
        this.dialogActive = false;
    }
}

