/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.commands;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Stack;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackListener;

public class CommandStack {
    private int undoLimit = 0;
    private int saveLocation = 0;
    private Stack undo = new Stack();
    private Stack redo = new Stack();
    protected List listeners = new ArrayList();

    public void addCommandStackListener(CommandStackListener listener) {
        this.listeners.add(listener);
    }

    public boolean canRedo() {
        return !this.redo.isEmpty();
    }

    public boolean canUndo() {
        if (this.undo.size() == 0) {
            return false;
        }
        return ((Command)this.undo.lastElement()).canUndo();
    }

    public void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.flushRedo();
        command.execute();
        if (this.getUndoLimit() > 0) {
            while (this.undo.size() >= this.getUndoLimit()) {
                ((Command)this.undo.remove(0)).dispose();
                if (this.saveLocation <= -1) continue;
                --this.saveLocation;
            }
        }
        if (this.saveLocation > this.undo.size()) {
            this.saveLocation = -1;
        }
        this.undo.push(command);
        this.notifyListeners();
    }

    public void dispose() {
        this.flushUndo();
        this.flushRedo();
    }

    public void flush() {
        this.flushRedo();
        this.flushUndo();
        this.saveLocation = 0;
        this.notifyListeners();
    }

    private void flushRedo() {
        while (!this.redo.isEmpty()) {
            ((Command)this.redo.pop()).dispose();
        }
    }

    private void flushUndo() {
        while (!this.undo.isEmpty()) {
            ((Command)this.undo.pop()).dispose();
        }
    }

    public Object[] getCommands() {
        ArrayList commands = new ArrayList(this.undo);
        int i = this.redo.size() - 1;
        while (i >= 0) {
            commands.add(this.redo.get(i));
            --i;
        }
        return commands.toArray();
    }

    public Command getRedoCommand() {
        return this.redo.isEmpty() ? null : (Command)this.redo.peek();
    }

    public Command getUndoCommand() {
        return this.undo.isEmpty() ? null : (Command)this.undo.peek();
    }

    public int getUndoLimit() {
        return this.undoLimit;
    }

    public boolean isDirty() {
        return this.undo.size() != this.saveLocation;
    }

    public void markSaveLocation() {
        this.saveLocation = this.undo.size();
        this.notifyListeners();
    }

    protected void notifyListeners() {
        EventObject event = new EventObject(this);
        int i = 0;
        while (i < this.listeners.size()) {
            ((CommandStackListener)this.listeners.get(i)).commandStackChanged(event);
            ++i;
        }
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        Command command = (Command)this.redo.pop();
        command.redo();
        this.undo.push(command);
        this.notifyListeners();
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        this.listeners.remove(listener);
    }

    public void setUndoLimit(int undoLimit) {
        this.undoLimit = undoLimit;
    }

    public void undo() {
        Command command = (Command)this.undo.pop();
        command.undo();
        this.redo.push(command);
        this.notifyListeners();
    }
}

