/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.registry.BundleModel;
import org.eclipse.core.internal.registry.ExtensionDelta;
import org.eclipse.core.internal.registry.IExtensionLinker;
import org.eclipse.core.internal.registry.IRegistryElement;
import org.eclipse.core.internal.registry.RegistryCacheReader;
import org.eclipse.core.internal.registry.RegistryChangeEvent;
import org.eclipse.core.internal.registry.RegistryDelta;
import org.eclipse.core.internal.registry.RegistryModelObject;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class ExtensionRegistry
extends RegistryModelObject
implements IExtensionRegistry {
    private static final String OPTION_DEBUG_EVENTS_EXTENSION = "org.eclipse.core.runtime/registry/debug/events/extension";
    public static boolean DEBUG;
    private Map elements = new HashMap(11);
    private transient Map listeners = new HashMap(11);
    private transient Map deltas = new HashMap(11);
    private Map orphanExtensions = new HashMap(11);
    private Map orphanFragments = new HashMap(11);
    private transient IExtensionLinker linker;
    private transient RegistryCacheReader reader = null;
    private transient boolean isDirty = false;

    public void add(IRegistryElement[] elements) {
        ExtensionRegistry extensionRegistry = this;
        synchronized (extensionRegistry) {
            this.isDirty = true;
            int i = 0;
            while (i < elements.length) {
                this.basicAdd(elements[i], true);
                ++i;
            }
            this.fireRegistryChangeEvent();
        }
    }

    public void add(IRegistryElement element) {
        ExtensionRegistry extensionRegistry = this;
        synchronized (extensionRegistry) {
            this.isDirty = true;
            this.basicAdd(element, true);
            this.fireRegistryChangeEvent();
        }
    }

    void basicAdd(IRegistryElement element, boolean link) {
        if (this.elements.containsKey(element.getUniqueIdentifier())) {
            if (DEBUG) {
                System.out.println("********* Element already added: " + element.getUniqueIdentifier() + " - ignored.");
            }
            return;
        }
        this.elements.put(element.getUniqueIdentifier(), element);
        ((BundleModel)element).setParent(this);
        if (!link) {
            return;
        }
        if (element.isFragment()) {
            this.addFragmentTo(element.getUniqueIdentifier(), element.getHostIdentifier());
            if (!this.elements.containsKey(element.getHostIdentifier())) {
                return;
            }
        } else {
            Collection fragmentNames = this.getFragmentNames(element.getUniqueIdentifier());
            Iterator iter = fragmentNames.iterator();
            while (iter.hasNext()) {
                IRegistryElement fragment = (IRegistryElement)this.elements.get(iter.next());
                this.addExtensionsAndExtensionPoints(fragment);
            }
        }
        this.addExtensionsAndExtensionPoints(element);
    }

    private void addExtensionsAndExtensionPoints(IRegistryElement element) {
        IExtensionPoint[] extPoints = element.getExtensionPoints();
        int i = 0;
        while (i < extPoints.length) {
            this.addExtensionPoint(extPoints[i]);
            ++i;
        }
        IExtension[] extensions = element.getExtensions();
        int i2 = 0;
        while (i2 < extensions.length) {
            this.addExtension(extensions[i2]);
            ++i2;
        }
    }

    private Object addArrays(Object a, Object b) {
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), Array.getLength(a) + Array.getLength(b));
        System.arraycopy(a, 0, result, 0, Array.getLength(a));
        System.arraycopy(b, 0, result, Array.getLength(a), Array.getLength(b));
        return result;
    }

    private void addFragmentTo(String fragmentName, String masterName) {
        HashSet<String> fragmentNames = (HashSet<String>)this.orphanFragments.get(masterName);
        if (fragmentNames == null) {
            fragmentNames = new HashSet<String>();
            this.orphanFragments.put(masterName, fragmentNames);
        }
        fragmentNames.add(fragmentName);
    }

    private void removeFragmentFrom(String fragmentName, String masterName) {
        Set fragmentNames = (Set)this.orphanFragments.get(masterName);
        if (fragmentNames == null) {
            return;
        }
        fragmentNames.remove(fragmentName);
        if (fragmentNames.isEmpty()) {
            this.orphanFragments.remove(masterName);
        }
    }

    private Collection getFragmentNames(String masterName) {
        Collection fragmentNames = (Collection)this.orphanFragments.get(masterName);
        return fragmentNames == null ? Collections.EMPTY_SET : fragmentNames;
    }

    private void addExtension(IExtension extension) {
        IExtension[] newExtensions;
        IExtensionPoint extPoint = this.getExtensionPoint(extension.getExtensionPointUniqueIdentifier());
        if (extPoint == null) {
            IExtension[] existingOrphanExtensions = (IExtension[])this.orphanExtensions.get(extension.getExtensionPointUniqueIdentifier());
            if (existingOrphanExtensions != null) {
                IExtension[] newOrphanExtensions = new IExtension[existingOrphanExtensions.length + 1];
                System.arraycopy(existingOrphanExtensions, 0, newOrphanExtensions, 0, existingOrphanExtensions.length);
                newOrphanExtensions[newOrphanExtensions.length - 1] = extension;
                this.orphanExtensions.put(extension.getExtensionPointUniqueIdentifier(), newOrphanExtensions);
            } else {
                this.orphanExtensions.put(extension.getExtensionPointUniqueIdentifier(), new IExtension[]{extension});
            }
            return;
        }
        IExtension[] existingExtensions = extPoint.getExtensions();
        if (existingExtensions == null) {
            newExtensions = new IExtension[]{extension};
        } else {
            newExtensions = new IExtension[existingExtensions.length + 1];
            System.arraycopy(existingExtensions, 0, newExtensions, 0, existingExtensions.length);
            newExtensions[newExtensions.length - 1] = extension;
        }
        this.linker.link(extPoint, newExtensions);
        this.recordChange(extPoint, extension, 1);
    }

    private void addExtensionPoint(IExtensionPoint extPoint) {
        IExtension[] existingExtensions = (IExtension[])this.orphanExtensions.remove(extPoint.getUniqueIdentifier());
        if (existingExtensions == null) {
            return;
        }
        this.linker.link(extPoint, existingExtensions);
        this.recordChange(extPoint, existingExtensions, 1);
    }

    public void addRegistryChangeListener(IRegistryChangeListener listener, String filter) {
        this.listeners.put(listener, filter);
    }

    public void addRegistryChangeListener(IRegistryChangeListener listener) {
        this.listeners.put(listener, null);
    }

    private void fireRegistryChangeEvent() {
        if (this.deltas.isEmpty() || this.listeners.isEmpty()) {
            return;
        }
        HashMap tmpListeners = new HashMap(this.listeners);
        HashMap tmpDeltas = new HashMap(this.deltas);
        this.deltas.clear();
        new ExtensionEventDispatcherJob(tmpListeners, tmpDeltas).schedule();
    }

    private RegistryDelta getDelta(String elementName) {
        RegistryDelta existingDelta = (RegistryDelta)this.deltas.get(elementName);
        if (existingDelta != null) {
            return existingDelta;
        }
        RegistryDelta delta = new RegistryDelta(elementName);
        this.deltas.put(elementName, delta);
        return delta;
    }

    public String[] getElementIdentifiers() {
        return this.getNamespaces();
    }

    public String[] getNamespaces() {
        return this.elements.keySet().toArray(new String[this.elements.size()]);
    }

    public IConfigurationElement[] getConfigurationElementsFor(String extensionPointId) {
        int lastdot = extensionPointId.lastIndexOf(46);
        if (lastdot == -1) {
            return new IConfigurationElement[0];
        }
        return this.getConfigurationElementsFor(extensionPointId.substring(0, lastdot), extensionPointId.substring(lastdot + 1));
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String extensionPointSimpleId) {
        IExtensionPoint extPoint = this.getExtensionPoint(pluginId, extensionPointSimpleId);
        if (extPoint == null) {
            return new IConfigurationElement[0];
        }
        IExtension[] extensions = extPoint.getExtensions();
        if (extensions.length == 0) {
            return new IConfigurationElement[0];
        }
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] toAdd = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < toAdd.length) {
                result.add(toAdd[j]);
                ++j;
            }
            ++i;
        }
        return result.toArray(new IConfigurationElement[result.size()]);
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String extensionPointName, String extensionId) {
        IExtension extension = this.getExtension(pluginId, extensionPointName, extensionId);
        if (extension == null) {
            return new IConfigurationElement[0];
        }
        return extension.getConfigurationElements();
    }

    public IExtension[] getExtensions(String elementName) {
        IRegistryElement element = (IRegistryElement)this.elements.get(elementName);
        if (element == null) {
            return new IExtension[0];
        }
        Collection fragmentNames = this.getFragmentNames(elementName);
        IExtension[] allExtensions = element.getExtensions();
        Iterator iter = fragmentNames.iterator();
        while (iter.hasNext()) {
            IRegistryElement fragment = (IRegistryElement)this.elements.get(iter.next());
            allExtensions = (IExtension[])this.addArrays(allExtensions, fragment.getExtensions());
        }
        return allExtensions;
    }

    public IExtension getExtension(String extensionPointId, String extensionId) {
        int lastdot = extensionPointId.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        return this.getExtension(extensionPointId.substring(0, lastdot), extensionPointId.substring(lastdot + 1), extensionId);
    }

    public IExtension getExtension(String pluginId, String extensionPointName, String extensionId) {
        IExtensionPoint extPoint = this.getExtensionPoint(pluginId, extensionPointName);
        if (extPoint != null) {
            return extPoint.getExtension(extensionId);
        }
        return null;
    }

    public IExtensionPoint[] getExtensionPoints(String elementName) {
        IRegistryElement element = (IRegistryElement)this.elements.get(elementName);
        if (element == null) {
            return new IExtensionPoint[0];
        }
        Collection fragmentNames = this.getFragmentNames(elementName);
        IExtensionPoint[] allExtensionPoints = element.getExtensionPoints();
        Iterator iter = fragmentNames.iterator();
        while (iter.hasNext()) {
            IRegistryElement fragment = (IRegistryElement)this.elements.get(iter.next());
            allExtensionPoints = (IExtensionPoint[])this.addArrays(allExtensionPoints, fragment.getExtensionPoints());
        }
        return allExtensionPoints;
    }

    public IExtensionPoint[] getExtensionPoints() {
        ArrayList<IExtensionPoint> extensionPoints = new ArrayList<IExtensionPoint>();
        Iterator iter = this.elements.values().iterator();
        while (iter.hasNext()) {
            IRegistryElement model = (IRegistryElement)iter.next();
            IExtensionPoint[] toAdd = model.getExtensionPoints();
            int i = 0;
            while (i < toAdd.length) {
                extensionPoints.add(toAdd[i]);
                ++i;
            }
        }
        return extensionPoints.toArray(new IExtensionPoint[extensionPoints.size()]);
    }

    public IExtensionPoint getExtensionPoint(String xptUniqueId) {
        int lastdot = xptUniqueId.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        return this.getExtensionPoint(xptUniqueId.substring(0, lastdot), xptUniqueId.substring(lastdot + 1));
    }

    public IExtensionPoint getExtensionPoint(String elementName, String xpt) {
        IRegistryElement element = (IRegistryElement)this.elements.get(elementName);
        if (element == null) {
            return null;
        }
        IExtensionPoint extPoint = element.getExtensionPoint(xpt);
        if (extPoint != null) {
            return extPoint;
        }
        Collection fragmentNames = this.getFragmentNames(elementName);
        Iterator iter = fragmentNames.iterator();
        while (iter.hasNext()) {
            extPoint = ((IRegistryElement)this.elements.get(iter.next())).getExtensionPoint(xpt);
            if (extPoint == null) continue;
            return extPoint;
        }
        return null;
    }

    private void recordChange(IExtensionPoint extPoint, IExtension extension, int kind) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ExtensionDelta extensionDelta = new ExtensionDelta();
        extensionDelta.setExtension(extension);
        extensionDelta.setExtensionPoint(extPoint);
        extensionDelta.setKind(kind);
        this.getDelta(extPoint.getNamespace()).addExtensionDelta(extensionDelta);
    }

    private void recordChange(IExtensionPoint extPoint, IExtension[] extensions, int kind) {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (extensions.length == 0) {
            return;
        }
        RegistryDelta pluginDelta = this.getDelta(extPoint.getNamespace());
        int i = 0;
        while (i < extensions.length) {
            ExtensionDelta extensionDelta = new ExtensionDelta();
            extensionDelta.setExtension(extensions[i]);
            extensionDelta.setExtensionPoint(extPoint);
            extensionDelta.setKind(kind);
            pluginDelta.addExtensionDelta(extensionDelta);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(String elementName, long bundleId) {
        ExtensionRegistry extensionRegistry = this;
        synchronized (extensionRegistry) {
            IRegistryElement element = (IRegistryElement)this.elements.get(elementName);
            if (element == null) {
                if (!DEBUG) return false;
                System.out.println("********* Element unknown: " + elementName + " - not removed.");
                return false;
            }
            if (element.getId() != bundleId) {
                return false;
            }
            this.isDirty = true;
            if (element.isFragment()) {
                if (!this.elements.containsKey(element.getHostIdentifier())) {
                    this.removeFragmentFrom(elementName, element.getHostIdentifier());
                    this.elements.remove(elementName);
                    return true;
                }
            } else {
                Collection fragmentNames = this.getFragmentNames(element.getUniqueIdentifier());
                Iterator iter = fragmentNames.iterator();
                while (iter.hasNext()) {
                    IRegistryElement fragment = (IRegistryElement)this.elements.get(iter.next());
                    this.removeExtensionsAndExtensionPoints(fragment);
                }
            }
            this.removeExtensionsAndExtensionPoints(element);
            this.removeFragmentFrom(elementName, element.getHostIdentifier());
            this.elements.remove(elementName);
            this.fireRegistryChangeEvent();
            return true;
        }
    }

    private void removeExtensionsAndExtensionPoints(IRegistryElement element) {
        IExtension[] extensions = element.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.removeExtension(extensions[i]);
            ++i;
        }
        IExtensionPoint[] extPoints = element.getExtensionPoints();
        int i2 = 0;
        while (i2 < extPoints.length) {
            this.removeExtensionPoint(extPoints[i2]);
            ++i2;
        }
    }

    private void removeExtensionPoint(IExtensionPoint extPoint) {
        if (extPoint.getExtensions() != null) {
            IExtension[] existingExtensions = extPoint.getExtensions();
            this.orphanExtensions.put(extPoint.getUniqueIdentifier(), existingExtensions);
            this.linker.link(extPoint, null);
            this.recordChange(extPoint, existingExtensions, 2);
        }
    }

    private void removeExtension(IExtension extension) {
        IExtensionPoint extPoint = this.getExtensionPoint(extension.getExtensionPointUniqueIdentifier());
        if (extPoint == null) {
            IExtension[] existingOrphanExtensions = (IExtension[])this.orphanExtensions.get(extension.getExtensionPointUniqueIdentifier());
            if (existingOrphanExtensions == null) {
                return;
            }
            IExtension[] newOrphanExtensions = new IExtension[existingOrphanExtensions.length - 1];
            int i = 0;
            int j = 0;
            while (i < existingOrphanExtensions.length) {
                if (extension != existingOrphanExtensions[i]) {
                    newOrphanExtensions[j++] = existingOrphanExtensions[i];
                }
                ++i;
            }
            this.orphanExtensions.put(extension.getExtensionPointUniqueIdentifier(), newOrphanExtensions);
            return;
        }
        IExtension[] existingExtensions = extPoint.getExtensions();
        IExtension[] newExtensions = null;
        if (existingExtensions.length >= 1) {
            newExtensions = new IExtension[existingExtensions.length - 1];
            int i = 0;
            int j = 0;
            while (i < existingExtensions.length) {
                if (existingExtensions[i] != extension) {
                    newExtensions[j++] = existingExtensions[i];
                }
                ++i;
            }
        }
        this.linker.link(extPoint, newExtensions);
        this.recordChange(extPoint, extension, 2);
    }

    public void removeRegistryChangeListener(IRegistryChangeListener listener) {
        this.listeners.remove(listener);
    }

    public ExtensionRegistry(IExtensionLinker extensionLinker) {
        this.linker = extensionLinker;
        String debugOption = InternalPlatform.getDefault().getOption(OPTION_DEBUG_EVENTS_EXTENSION);
        boolean bl = DEBUG = debugOption == null ? false : debugOption.equalsIgnoreCase("true");
        if (DEBUG) {
            this.addRegistryChangeListener(new IRegistryChangeListener(){

                public void registryChanged(IRegistryChangeEvent event) {
                    System.out.println(event);
                }
            });
        }
    }

    public IRegistryElement getElement(String elementId) {
        return (IRegistryElement)this.elements.get(elementId);
    }

    public void setCacheReader(RegistryCacheReader value) {
        this.reader = value;
    }

    public RegistryCacheReader getCacheReader() {
        return this.reader;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean value) {
        this.isDirty = value;
    }

    private static final class ExtensionEventDispatcherJob
    extends Job {
        private static final ISchedulingRule EXTENSION_EVENT_RULE = new ISchedulingRule(){

            public boolean contains(ISchedulingRule rule) {
                return rule == this;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this;
            }
        };
        private Map listeners;
        private Map deltas;

        public ExtensionEventDispatcherJob(Map listeners, Map deltas) {
            super("RegistryChangeEventDispatcherJob");
            this.listeners = listeners;
            this.deltas = deltas;
            this.setRule(EXTENSION_EVENT_RULE);
        }

        public IStatus run(IProgressMonitor monitor) {
            MultiStatus result = new MultiStatus("org.eclipse.core.runtime", 0, Policy.bind("plugin.eventListenerError"), null);
            Iterator iter = this.listeners.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                IRegistryChangeListener listener = (IRegistryChangeListener)entry.getKey();
                String filter = (String)entry.getValue();
                if (filter != null && !this.deltas.containsKey(filter)) continue;
                try {
                    listener.registryChanged(new RegistryChangeEvent(this.deltas, filter));
                }
                catch (RuntimeException re) {
                    String message = re.getMessage() == null ? "" : re.getMessage();
                    result.add(new Status(4, "org.eclipse.core.runtime", 0, message, re));
                }
            }
            return result;
        }
    }
}

