/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.preferences.PreferenceForwarder;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.CompatibilityHelper;
import org.eclipse.core.internal.runtime.FindSupport;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.internal.runtime.SafeFileInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public abstract class Plugin
implements BundleActivator {
    public static final String PLUGIN_PREFERENCE_SCOPE = "instance";
    protected Bundle bundle;
    private BundleContext context;
    private boolean debug = false;
    private IPluginDescriptor descriptor;
    public static final String PREFERENCES_DEFAULT_OVERRIDE_BASE_NAME = "preferences";
    public static final String PREFERENCES_DEFAULT_OVERRIDE_FILE_NAME = "preferences.ini";
    private static final String PREFERENCES_DEFAULT_OVERRIDE_FILE_NAME_BACKUP = "preferences.ini.bak";
    private Preferences preferences = null;

    public Plugin() {
    }

    public Plugin(BundleContext context) {
        this.context = context;
    }

    public Plugin(IPluginDescriptor descriptor) {
        Assert.isNotNull(descriptor);
        Assert.isTrue(!descriptor.isPluginActivated(), Policy.bind("plugin.deactivatedLoad", this.getClass().getName(), String.valueOf(descriptor.getUniqueIdentifier()) + " is not activated"));
        this.descriptor = descriptor;
        String key = String.valueOf(descriptor.getUniqueIdentifier()) + "/debug";
        String value = InternalPlatform.getDefault().getOption(key);
        this.debug = value == null ? false : value.equalsIgnoreCase("true");
        this.bundle = InternalPlatform.getDefault().getBundle(descriptor.getUniqueIdentifier());
        try {
            if ((this.bundle.getState() & 0x38) == 0) {
                this.bundle.start();
            }
        }
        catch (BundleException e) {
            e.printStackTrace();
        }
    }

    public final URL find(IPath path) {
        return FindSupport.find(this.bundle, path, null);
    }

    public final URL find(IPath path, Map override) {
        return FindSupport.find(this.bundle, path, override);
    }

    public final IPluginDescriptor getDescriptor() {
        if (this.descriptor != null) {
            return this.descriptor;
        }
        IPluginDescriptor descriptor = CompatibilityHelper.getPluginDescriptor(this.bundle.getSymbolicName());
        if (descriptor != null) {
            CompatibilityHelper.setPlugin(descriptor, this);
        }
        return descriptor;
    }

    public final ILog getLog() {
        return InternalPlatform.getDefault().getLog(this.bundle);
    }

    public final IPath getStateLocation() throws IllegalStateException {
        return InternalPlatform.getDefault().getStateLocation(this.bundle, true);
    }

    public final Preferences getPluginPreferences() {
        if (this.preferences != null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Plugin preferences already loaded for " + this.bundle.getSymbolicName());
            }
            return this.preferences;
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Loading preferences for plugin " + this.bundle.getSymbolicName());
        }
        this.preferences = new PreferenceForwarder(this.bundle.getSymbolicName());
        this.loadPluginPreferences();
        this.initializeDefaultPluginPreferences();
        this.applyInternalPluginDefaultOverrides();
        this.applyExternalPluginDefaultOverrides();
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Completed loading preferences for plugin " + this.bundle.getSymbolicName());
        }
        return this.preferences;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPluginPreferences() {
        block15: {
            if (this.preferences instanceof PreferenceForwarder) {
                return;
            }
            prefFile = InternalPlatform.getDefault().getMetaArea().getPreferenceLocation(this.bundle, false).toFile();
            if (!prefFile.exists()) {
                if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                System.out.println("Plugin preference file " + prefFile + " not found.");
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Loading preferences from " + prefFile);
            }
            in = null;
            try {
                try {
                    in = new SafeFileInputStream(prefFile);
                    this.preferences.load(in);
                }
                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        System.out.println("IOException encountered loading preference file " + prefFile);
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable var5_5) {
                var4_7 = null;
                if (in == null) throw var5_5;
                try {
                    in.close();
                    throw var5_5;
                }
                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES == false) throw var5_5;
                    System.out.println("IOException encountered closing preference file " + prefFile);
                    e.printStackTrace();
                }
                throw var5_5;
            }
            {
                var4_8 = null;
                if (in == null) break block15;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 173->180)] { 
lbl36:
            // 1 sources

            in.close();
            break block15;
lbl38:
            // 1 sources

            catch (IOException e) {
                if (!InternalPlatform.DEBUG_PREFERENCES) break block15;
                System.out.println("IOException encountered closing preference file " + prefFile);
                e.printStackTrace();
            }
        }
        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
        System.out.println("Preferences now set as follows:");
        prefNames = this.preferences.propertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) break;
            value = this.preferences.getString(prefNames[i]);
            System.out.println("\t" + prefNames[i] + " = " + value);
            ++i;
        }
        prefNames = this.preferences.defaultPropertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) {
                return;
            }
            value = this.preferences.getDefaultString(prefNames[i]);
            System.out.println("\tDefault values: " + prefNames[i] + " = " + value);
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    public final void savePluginPreferences() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 278->282)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void initializeDefaultPluginPreferences() {
    }

    private void applyExternalPluginDefaultOverrides() {
        InternalPlatform.getDefault().applyPrimaryFeaturePluginDefaultOverrides(this.bundle.getSymbolicName(), this.preferences);
        InternalPlatform.getDefault().applyCommandLinePluginDefaultOverrides(this.bundle.getSymbolicName(), this.preferences);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyInternalPluginDefaultOverrides() {
        block20: {
            baseURL = FindSupport.find(this.bundle, new Path("preferences.ini"));
            if (baseURL == null) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    System.out.println("Plugin preference file preferences.ini not found.");
                }
                if ((baseURL = FindSupport.find(this.bundle, new Path("preferences.ini.bak"))) == null) {
                    return;
                }
            }
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Loading preferences from " + baseURL);
            }
            overrides = new Properties();
            in = null;
            try {
                try {
                    in = new BufferedInputStream(baseURL.openStream());
                    overrides.load(in);
                }
                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        System.out.println("IOException encountered loading preference file " + baseURL);
                        e.printStackTrace();
                    }
                    var5_6 = null;
                    try {
                        if (in == null) return;
                        in.close();
                        return;
                    }
                    catch (IOException e) {
                        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                        System.out.println("IOException encountered closing preference file " + baseURL);
                        e.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable var6_12) {
                var5_7 = null;
                ** try [egrp 2[TRYBLOCK] [3 : 166->177)] { 
lbl35:
                // 1 sources

                if (in == null) throw var6_12;
                in.close();
                throw var6_12;
lbl38:
                // 1 sources

                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES == false) throw var6_12;
                    System.out.println("IOException encountered closing preference file " + baseURL);
                    e.printStackTrace();
                }
                throw var6_12;
            }
            {
                var5_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 166->177)] { 
lbl45:
            // 1 sources

            if (in != null) {
                in.close();
            }
            break block20;
lbl48:
            // 1 sources

            catch (IOException e) {
                if (!InternalPlatform.DEBUG_PREFERENCES) break block20;
                System.out.println("IOException encountered closing preference file " + baseURL);
                e.printStackTrace();
            }
        }
        props = null;
        if (!overrides.isEmpty()) {
            props = InternalPlatform.getDefault().getPreferenceTranslator(this.bundle.getSymbolicName(), "preferences");
        }
        it = overrides.entrySet().iterator();
        while (true) {
            if (!it.hasNext()) break;
            entry = it.next();
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            value = InternalPlatform.getDefault().translatePreference(value, props);
            this.preferences.setDefault(key, value);
        }
        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
        System.out.println("Preferences now set as follows:");
        prefNames = this.preferences.propertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) break;
            value = this.preferences.getString(prefNames[i]);
            System.out.println("\t" + prefNames[i] + " = " + value);
            ++i;
        }
        prefNames = this.preferences.defaultPropertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) {
                return;
            }
            value = this.preferences.getDefaultString(prefNames[i]);
            System.out.println("\tDefault values: " + prefNames[i] + " = " + value);
            ++i;
        }
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public final InputStream openStream(IPath file) throws IOException {
        return FindSupport.openStream(this.bundle, file, false);
    }

    public final InputStream openStream(IPath file, boolean localized) throws IOException {
        return FindSupport.openStream(this.bundle, file, localized);
    }

    public void setDebugging(boolean value) {
        this.debug = value;
    }

    public void shutdown() throws CoreException {
        try {
            Method m = this.descriptor.getClass().getMethod("doPluginDeactivation", new Class[0]);
            m.invoke((Object)this.descriptor, null);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void startup() throws CoreException {
    }

    public String toString() {
        return this.descriptor.toString();
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.bundle = context.getBundle();
        this.descriptor = CompatibilityHelper.getPluginDescriptor(this.bundle.getSymbolicName());
        CompatibilityHelper.setPlugin(this.descriptor, this);
        CompatibilityHelper.setActive(this.descriptor);
    }

    public void stop(BundleContext context) throws Exception {
        context = null;
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

