/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JCheckBoxMenuItem.java,v $
   Revision 1.14  2004/09/24 22:42:52  dannaab
   Fix JComboBox.removeItem bug; from JTree.drawTree, move root node expansion to end of method (has no effect if node has no children).

   Revision 1.13  2004/05/25 01:04:12  dannaab
   Misc bugfixes, ActionMap.java added, added swt source to lib dir (for debugging
   purposes), misc import optimization
 
   Revision 1.12  2004/03/30 10:42:46  bobintetley
   Many minor bug fixes, event improvements by Dan Naab. Full swing.Icon support

   Revision 1.11  2004/01/26 08:11:00  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.10  2004/01/23 08:04:56  bobintetley
   JComboBox fixes and better Action implementation

   Revision 1.9  2004/01/20 09:17:15  bobintetley
   Menu class overhaul for compatibility, Action support and thread safety

   Revision 1.8  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications

   Revision 1.7  2003/12/15 15:54:25  bobintetley
   Additional core methods

   Revision 1.6  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

import swingwt.awt.event.*;

import java.util.*;

public class JCheckBoxMenuItem extends JMenuItem implements SwingConstants, ButtonModel {
    
    protected boolean pState = false;
    private Shell shell = null;
    protected Vector itemListeners = new Vector();
    private Object retval;
    
    public JCheckBoxMenuItem() {setModel(this);}
    public JCheckBoxMenuItem(Action a) { setAction(a); setModel(this);}
    public JCheckBoxMenuItem(Icon icon) { this("", icon); }
    public JCheckBoxMenuItem(Icon icon, boolean b) { this("", icon, b); }
    public JCheckBoxMenuItem(String text) { this(text, null, false); }
    public JCheckBoxMenuItem(String text, boolean b) { this(text, null, b); }
    public JCheckBoxMenuItem(String text, Icon icon) { this(text, null, false); }
    public JCheckBoxMenuItem(String text, Icon icon, boolean b) { pText = text; pImage = icon; pState = b; setModel(this);}
    public JCheckBoxMenuItem(String text, int mnemonic) { pText = text; setMnemonic(mnemonic); setModel(this);}
    public JCheckBoxMenuItem(String text, int mnemonic, boolean b) { pText = text; setMnemonic(mnemonic); pState = b; setModel(this); }
    
    public void addItemListener(ItemListener l) {
        itemListeners.add(l);
    }
    
    public void removeItemListener(ItemListener l) {
        itemListeners.remove(l);
    }
    
    /** 
     *  Sends action events to listeners
     *  Overriden from JSWTMenuComponent to handle selection events
     */
    public void processActionEvent(int id) {
        super.processActionEvent(id);
	processItemEvent();
    }
    
    /**
     * Handles firing of Item events for when selection changes
     */
    public void processItemEvent() {
        if (itemListeners.size() == 0) return;
        Iterator i = itemListeners.iterator();
        ItemEvent e = new ItemEvent(this, 0, this, (ppeer.getSelection() ? ItemEvent.SELECTED : ItemEvent.DESELECTED));
        while (i.hasNext()) {
            ItemListener il = (ItemListener) i.next();
            il.itemStateChanged(e);
        }
    }
    
    public Object[] getSelectedObjects() { return new Object[] { getText() };}
    public boolean getState() { 
         SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(peer))
                    retval = new Boolean(peer.getSelection());
                else
                    retval = new Boolean(pState);
            }
         });
         return ((Boolean) retval).booleanValue();
    }
        
    public void setState(boolean b) { 
         pState = b;
         SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(peer))
                    ppeer.setSelection(pState);
            }
         });
    }
    
    public boolean isSelected() { return getState(); }
    public void setSelected(boolean b) { setState(b); }
    
    public void setSwingWTParent(Menu parent, Shell shell) throws Exception { 
        this.shell = shell;
        peer = new MenuItem(parent, SWT.CHECK);
        peer.setSelection(pState);
    }
    
}
