/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: TitledBorder.java,v $
   Revision 1.9  2004/07/14 21:23:22  dannaab
   remove unneeded import

   Revision 1.8  2004/07/14 00:42:45  dannaab
   Make TItledBorder look a little nicer / more like the host platform

   Revision 1.7  2004/05/05 12:43:22  bobintetley
   Patches/new files from Laurent Martell

   Revision 1.6  2004/04/23 00:52:32  dannaab
   Handle borders in a Swing-like way. Implement EmptyBorder & TitledBorder

   Revision 1.5  2004/01/26 12:02:49  bobintetley
   JPanel titled border support

   Revision 1.4  2004/01/09 14:48:40  bobintetley
   *** empty log message ***

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing.border;

import org.eclipse.swt.SWT;

import swingwt.awt.*;
import swingwtx.swing.SwingWTUtils;

public class TitledBorder extends AbstractBorder implements Border {

    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    
    protected String title = "";
    protected Font font = null;
    protected Color color = null;
    protected Border border = null;

    public TitledBorder(String title) {this.title = title; this.border = new EmptyBorder(0, 0, 0, 0);}
    public TitledBorder(Border border) {this.border = border;}
    public TitledBorder(Border border, String title) {this.title = title; this.border = border;}
    public TitledBorder(Border border, String title, int titleJustification, int titlePosition) {this.title = title; this.border = border;}
    public TitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont) {this.title = title; font = titleFont; this.border = border; }
    public TitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {this.title = title; font = titleFont; color = titleColor; this.border = border;}
    
    /** Getter for property title.
     * @return Value of property title.
     *
     */
    public java.lang.String getTitle() {
        return title;
    }    
    
    /** Setter for property title.
     * @param title New value of property title.
     *
     */
    public void setTitle(java.lang.String title) {
        this.title = title;
    }    
    
    /** Getter for property font.
     * @return Value of property font.
     *
     */
    public swingwt.awt.Font getFont() {
        return font;
    }
    
    /** Setter for property font.
     * @param font New value of property font.
     *
     */
    public void setFont(swingwt.awt.Font font) {
        this.font = font;
    }
    
    /** Getter for property color.
     * @return Value of property color.
     *
     */
    public swingwt.awt.Color getColor() {
        return color;
    }
    
    /** Setter for property color.
     * @param color New value of property color.
     *
     */
    public void setColor(swingwt.awt.Color color) {
        this.color = color;
    }
    
    /** Getter for property border.
     * @return Value of property border.
     *
     */
    public swingwtx.swing.border.Border getBorder() {
        return border;
    }
    
    /** Setter for property border.
     * @param border New value of property border.
     *
     */
    public void setBorder(swingwtx.swing.border.Border border) {
        this.border = border;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        /**
         * This is a bit of a hack (and doesn't create perfect Swing-like behavior),
         * but IMO looks nicer than drawing a solid black line.  If the SWT control happens to have
         * the SWT.BORDER style bit set (automatically done in JPanels if the border is an instance of
         * TitledBorder), then don't draw the border.  Instead, we just draw the title offset slighly.
         */
        
        g.setColor( SystemColor.getSystemColor(SWT.COLOR_WIDGET_NORMAL_SHADOW) );
        
        g.drawLine(2, 10, width - 3, 10);
        g.drawLine(2, 10, 2, height - 3);
        g.drawLine(2, height - 3, width - 2, height - 3);
        g.drawLine(width - 3, 10, width - 3, height - 3);
        
        if (color != null) g.setColor( color );
        else g.setColor( SystemColor.getSystemColor(SWT.COLOR_WIDGET_BORDER) );
        
        if (font != null) g.setFont( font );
        g.drawString(title, 8, 3);
    }

    public Insets getBorderInsets(Component c) {
        return getBorderInsets(c, new Insets());
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = insets.bottom = SwingWTUtils.getRenderStringHeight("W");
        insets.top += insets.top / 2;
        insets.left = insets.right = 4;
        return insets;
    }
    
    public void setTitleJustification( int titleJustification) {}
    public int getTitleJustification() { return DEFAULT_JUSTIFICATION; }

}
