/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.EventObject;
import java.util.Vector;
import swingwtx.swing.CellEditor;
import swingwtx.swing.event.CellEditorListener;
import swingwtx.swing.event.ChangeEvent;

public abstract class AbstractCellEditor
implements CellEditor {
    protected Vector listeners = new Vector();

    public boolean isCellEditable(EventObject e) {
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    public CellEditorListener[] getCellEditorListeners() {
        if (this.listeners.size() == 0) {
            return null;
        }
        CellEditorListener[] l = new CellEditorListener[this.listeners.size()];
        for (int i = 0; i < this.listeners.size(); ++i) {
            l[i] = (CellEditorListener)this.listeners.get(i);
        }
        return l;
    }

    protected void fireEditingStopped() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ChangeEvent e = new ChangeEvent(this);
            ((CellEditorListener)this.listeners.get(i)).editingStopped(e);
        }
    }

    protected void fireEditingCanceled() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ChangeEvent e = new ChangeEvent(this);
            ((CellEditorListener)this.listeners.get(i)).editingCanceled(e);
        }
    }
}

