/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Insets;
import swingwt.awt.event.ActionEvent;
import swingwtx.swing.Action;
import swingwtx.swing.Icon;
import swingwtx.swing.JButton;
import swingwtx.swing.JButtonMappedAction;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JPopupMenu;
import swingwtx.swing.JRadioButton;
import swingwtx.swing.JSeparator;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class JToolBar
extends JComponent
implements SwingConstants {
    protected Composite lastAdd;
    protected int orientation = 0;
    protected String titleString = "";
    protected boolean coolbar = false;
    protected boolean rollover = false;
    protected Container parent = null;
    protected Composite ppeer = null;
    private boolean cached = false;
    private Vector cache = new Vector();
    private Object threadSafeObjectRetValue = null;
    private boolean threadSafeBoolean = false;

    public JToolBar() {
        this("", 0);
    }

    public JToolBar(String titleString) {
        this(titleString, 0);
    }

    public JToolBar(int orientation) {
        this("", orientation);
    }

    public JToolBar(String titleString, int orientation) {
        this.titleString = titleString;
        this.orientation = orientation;
        if (!SWT.getPlatform().equals("carbon")) {
            this.rollover = true;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public boolean isRollover() {
        return this.rollover;
    }

    public void setRollover(boolean b) {
        this.rollover = b;
    }

    public Component getComponentAtIndex(int index) {
        return (Component)this.comps.get(index);
    }

    public int getComponentIndex(Component c) {
        for (int i = 0; i < this.comps.size(); ++i) {
            if (!this.comps.get(i).equals(c)) continue;
            return i;
        }
        return 0;
    }

    public Insets getMargin() {
        Rectangle bounds = this.ppeer.getBounds();
        Rectangle client = this.ppeer.getClientArea();
        Insets insets = new Insets();
        insets.left = client.x;
        insets.top = client.y;
        insets.right = bounds.width - (client.width + client.x);
        insets.bottom = bounds.height - (client.height + client.y);
        return insets;
    }

    public void setMargin(Insets insets) {
    }

    public void invalidate() {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JToolBar.this.ppeer.layout();
                JToolBar.this.parent.invalidate();
            }
        });
    }

    public ToolBarUI getUI() {
        return null;
    }

    public void setUI(ToolBarUI ui) {
    }

    public void setBorderPainted(boolean b) {
    }

    public boolean isBorderPainted() {
        return false;
    }

    public boolean isFloatable() {
        return false;
    }

    public void setFloatable(boolean b) {
    }

    public void addSeparator() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JToolBar.this.ppeer)) {
                    JToolBar.this.cache.add(new JSeparator());
                } else {
                    ToolBar peer = JToolBar.this.lastAdd instanceof ToolBar ? (ToolBar)JToolBar.this.lastAdd : new ToolBar(JToolBar.this.ppeer, JToolBar.this.orientation);
                    new ToolItem(peer, 2);
                    JToolBar.this.lastAdd = peer;
                }
            }
        });
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.parent = parent;
        this.lastAdd = this.ppeer = new Composite(parent.getComposite(), 0);
        this.peer = this.ppeer;
        this.composite = this.ppeer;
        RowLayout lay = null;
        lay = this.orientation == 0 ? new RowLayout(256) : new RowLayout(512);
        lay.fill = true;
        lay.wrap = false;
        this.ppeer.setLayout((Layout)lay);
        if (this.cached) {
            for (int i = 0; i < this.cache.size(); ++i) {
                if (this.cache.get(i) instanceof Action) {
                    this.add((Action)this.cache.get(i));
                    continue;
                }
                if (this.cache.get(i) instanceof JSeparator) {
                    this.addSeparator();
                    continue;
                }
                this.add((Component)this.cache.get(i));
            }
            this.cached = false;
        }
    }

    public Component add(JButton b) {
        if (b.pText != null && b.pText.length() == 2 && b.pText.startsWith("&")) {
            this.add((Component)b);
            return b;
        }
        if (SwingWTUtils.isMacOSX() && !b.getText().equals("")) {
            this.add((Component)b);
            return b;
        }
        if (SwingWTUtils.isMacOSX() && this.orientation == 1) {
            this.add((Component)b);
        }
        JButtonMappedAction x = new JButtonMappedAction(b);
        x.putValue("Name", b.getText());
        x.putValue("ShortDescription", b.getToolTipText());
        x.putValue("SmallIcon", b.getIcon());
        x.putValue("DisabledIcon", b.getIcon());
        x.putValue("MnemonicKey", new Integer(b.getMnemonic()));
        b.setAction(x, false);
        this.add(x);
        return b;
    }

    public Component add(JCheckBox checkBox) {
        this.add((Component)checkBox);
        return checkBox;
    }

    public Component add(JRadioButton radioButton) {
        this.add((Component)radioButton);
        return radioButton;
    }

    public Component add(final Component c) {
        this.comps.add(c);
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            this.cached = true;
            this.cache.add(c);
            return c;
        }
        final JToolBar me = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                try {
                    c.setSwingWTParent(me);
                    c.setCachedProperties();
                    c.registerEvents();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JToolBar.this.lastAdd = JToolBar.this.ppeer;
            }
        });
        return c;
    }

    public JButton add(final Action a) {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            this.cached = true;
            this.cache.add(a);
            return null;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JButton btnWrapper = a instanceof JButtonMappedAction ? ((JButtonMappedAction)a).getJButton() : new JButton(a, false);
                ToolBar toolbar = JToolBar.this.lastAdd instanceof ToolBar ? (ToolBar)JToolBar.this.lastAdd : new ToolBar(JToolBar.this.ppeer, (JToolBar.this.orientation == 0 ? 256 : 512) | 0x800000);
                ToolItem peer = a.getValue("DropMenu") != null ? new ToolItem(toolbar, 4) : new ToolItem(toolbar, 8);
                btnWrapper.pSWTToolButton = peer;
                btnWrapper.pSWTToolButton.setEnabled(btnWrapper.isEnabled());
                if (a.getValue("SmallIcon") != null) {
                    peer.setHotImage(SwingWTUtils.getSWTImageFromSwingIcon(btnWrapper, (Icon)a.getValue("SmallIcon")));
                }
                if (a.getValue("Name") != null) {
                    peer.setText((String)a.getValue("Name"));
                }
                if (a.getValue("ShortDescription") != null) {
                    peer.setToolTipText((String)a.getValue("ShortDescription"));
                }
                if (JToolBar.this.rollover && a.getValue("DisabledIcon") != null) {
                    peer.setImage(SwingWTUtils.getSWTImageFromSwingIcon(btnWrapper, (Icon)a.getValue("DisabledIcon")));
                }
                if (!SWT.getPlatform().equals("carbon") && a.getValue("DisabledIcon") != null) {
                    peer.setImage(SwingWTUtils.getSWTImageFromSwingIcon(btnWrapper, (Icon)a.getValue("DisabledIcon")));
                }
                if (a.getValue("DropMenu") != null) {
                    JPopupMenu jmenu = (JPopupMenu)a.getValue("DropMenu");
                    try {
                        jmenu.setSwingWTParent(JToolBar.this.ppeer.getShell());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    peer.addListener(13, new Listener(this, jmenu, peer){
                        private final /* synthetic */ JPopupMenu val$jmenu;
                        private final /* synthetic */ ToolItem val$peer;
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$jmenu = val$jmenu;
                            this.val$peer = val$peer;
                        }

                        public void handleEvent(Event e) {
                            if (e.detail == 4) {
                                Menu menu = this.val$jmenu.menu;
                                Rectangle rect = this.val$peer.getBounds();
                                Point pt = new Point(rect.x, rect.y + rect.height);
                                pt = 4.access$100(this.this$1).ppeer.toDisplay(pt);
                                menu.setLocation(pt);
                                menu.setVisible(true);
                            }
                        }
                    });
                }
                JButton btnWrapper2 = btnWrapper;
                peer.addSelectionListener((SelectionListener)new SelectionAdapter(this, btnWrapper2){
                    private final /* synthetic */ JButton val$btnWrapper2;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$btnWrapper2 = val$btnWrapper2;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        4.access$200(this.this$1).actionPerformed(new ActionEvent(this.val$btnWrapper2, 0));
                    }
                });
                JToolBar.this.threadSafeObjectRetValue = btnWrapper;
                JToolBar.this.lastAdd = toolbar;
            }

            static /* synthetic */ JToolBar access$100(4 x0) {
                return x0.JToolBar.this;
            }

            static /* synthetic */ Action access$200(4 x0) {
                return x0.a;
            }
        });
        return (JButton)this.threadSafeObjectRetValue;
    }

    public class ToolBarUI {
    }
}

