/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwtx.swing.DefaultCellEditor;
import swingwtx.swing.JComponent;
import swingwtx.swing.JLabel;
import swingwtx.swing.JTextField;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.event.CellEditorListener;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.TreeExpansionEvent;
import swingwtx.swing.event.TreeExpansionListener;
import swingwtx.swing.event.TreeModelEvent;
import swingwtx.swing.event.TreeModelListener;
import swingwtx.swing.event.TreeSelectionEvent;
import swingwtx.swing.event.TreeSelectionListener;
import swingwtx.swing.event.TreeWillExpandListener;
import swingwtx.swing.plaf.TreeUI;
import swingwtx.swing.tree.DefaultMutableTreeNode;
import swingwtx.swing.tree.DefaultTreeCellRenderer;
import swingwtx.swing.tree.DefaultTreeModel;
import swingwtx.swing.tree.DefaultTreeSelectionModel;
import swingwtx.swing.tree.ExpandVetoException;
import swingwtx.swing.tree.TreeCellEditor;
import swingwtx.swing.tree.TreeCellRenderer;
import swingwtx.swing.tree.TreeModel;
import swingwtx.swing.tree.TreeNode;
import swingwtx.swing.tree.TreePath;
import swingwtx.swing.tree.TreeSelectionModel;

public class JTree
extends JComponent
implements TreeModelListener,
CellEditorListener {
    protected Tree ppeer = null;
    protected TreeModel model = null;
    protected TreeCellRenderer cellRenderer = new DefaultTreeCellRenderer();
    protected TreeCellEditor cellEditor = new DefaultCellEditor(new JTextField());
    protected boolean isEditable = false;
    protected boolean isRootVisible = true;
    protected TreePath anchorSelectionPath = null;
    protected TreeEditor swtEditor = null;
    protected TreeItem editingTreeItem = null;
    protected Object editingNode = null;
    protected Component editingComponent = null;
    private Object retval = null;
    protected Vector treeWillExpansionListeners = new Vector();
    protected Vector treeExpansionListeners = new Vector();
    protected Vector treeSelectionListeners = new Vector();
    private HashMap mPeerMap = new HashMap();

    public JTree() {
        this.cellEditor.addCellEditorListener(this);
    }

    public JTree(TreeNode root) {
        this.model = new DefaultTreeModel(root);
        this.cellEditor.addCellEditorListener(this);
    }

    public JTree(TreeModel model) {
        this.model = model;
        this.cellEditor.addCellEditorListener(this);
    }

    protected TreeItem getPeerTreeItem(Object swingNode) {
        return (TreeItem)this.mPeerMap.get(swingNode);
    }

    public void addTreeExpansionListener(TreeExpansionListener l) {
        this.treeExpansionListeners.add(l);
    }

    public void removeTreeExpansionListener(TreeExpansionListener l) {
        this.treeExpansionListeners.remove(l);
    }

    public void addWillTreeExpansionListener(TreeWillExpandListener l) {
        this.treeWillExpansionListeners.add(l);
    }

    public void removeTreeWillExpansionListener(TreeWillExpandListener l) {
        this.treeWillExpansionListeners.remove(l);
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.treeSelectionListeners.add(l);
    }

    public void removeTreeSelectionListener(TreeSelectionListener l) {
        this.treeSelectionListeners.remove(l);
    }

    public void setModel(TreeModel model) {
        this.model = model;
        model.addTreeModelListener(this);
        this.drawTree();
    }

    public TreeModel getModel() {
        return this.model;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean b) {
        this.isEditable = b;
    }

    public void setCellEditor(TreeCellEditor cell) {
        this.cellEditor = cell;
    }

    public TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = new Tree(parent.getComposite(), 2048);
        this.swtEditor = new TreeEditor(this.ppeer);
        this.peer = this.ppeer;
        this.parent = parent;
        this.drawTree();
        this.registerTreeEvents();
    }

    protected void registerTreeEvents() {
        this.ppeer.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JTree.this.processTreeSelection(e);
                JTree.this.processTreeEdit(e.item.getData(), (TreeItem)e.item);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.ppeer.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                JTree.this.processTreeExpansion(e, true);
            }

            public void treeExpanded(TreeEvent e) {
                JTree.this.processTreeExpansion(e, false);
            }
        });
    }

    protected void processTreeEdit(Object node, TreeItem item) {
        if (!this.isEditable) {
            return;
        }
        if (!(node instanceof DefaultMutableTreeNode)) {
            return;
        }
        this.editingTreeItem = item;
        this.editingNode = node;
        Object userObject = null;
        if (node instanceof DefaultMutableTreeNode) {
            userObject = ((DefaultMutableTreeNode)node).getUserObject();
        }
        this.editingComponent = this.cellEditor.getTreeCellEditorComponent(this, userObject, true, true, this.model.isLeaf(node), 1);
        if (this.swtEditor != null) {
            if (this.swtEditor.getEditor() != null) {
                this.swtEditor.getEditor().dispose();
            }
            this.swtEditor.dispose();
            this.swtEditor = null;
        }
        try {
            this.editingComponent.setSwingWTParent(new TreeEditorContainer(this));
            this.editingComponent.registerEvents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.swtEditor = new TreeEditor(this.ppeer);
        this.swtEditor.horizontalAlignment = 16384;
        this.swtEditor.grabHorizontal = true;
        this.swtEditor.minimumWidth = 50;
        this.swtEditor.setEditor(this.editingComponent.getSWTPeer(), item);
        if (this.cellEditor instanceof DefaultCellEditor && node instanceof DefaultMutableTreeNode) {
            ((DefaultCellEditor)this.cellEditor).getHandler().setValue(((DefaultMutableTreeNode)node).getUserObject());
        }
        this.editingComponent.grabFocus();
    }

    public void editingStopped(ChangeEvent e) {
        TreeItem item;
        Object value = this.cellEditor.getCellEditorValue();
        if (this.editingNode instanceof DefaultMutableTreeNode) {
            ((DefaultMutableTreeNode)this.editingNode).setUserObject(value);
        }
        if ((item = this.getPeerTreeItem(this.editingNode)) == null) {
            return;
        }
        boolean isleaf = this.model.isLeaf(this.editingNode);
        JLabel cr = (JLabel)this.cellRenderer.getTreeCellRendererComponent(this, this.editingNode, false, isleaf, isleaf, 0, true);
        item.setText(cr.getText());
        if (cr.getIcon() != null) {
            item.setImage(SwingWTUtils.getSWTImageFromSwingIcon(this, cr.getIcon()));
        }
        if (cr.getBackground() != null && cr.getBackground().getSWTColor() != null) {
            item.setBackground(cr.getBackground().getSWTColor());
        }
        if (cr.getForeground() != null && cr.getForeground().getSWTColor() != null) {
            item.setForeground(cr.getForeground().getSWTColor());
        }
        if (cr.hasSetFont()) {
            item.setFont(cr.getFont().getSWTFont());
        }
    }

    public void fireTreeExpanded(TreePath path) {
        TreeExpansionEvent event = new TreeExpansionEvent(this, path);
        Iterator i = this.treeExpansionListeners.iterator();
        while (i.hasNext()) {
            ((TreeExpansionListener)i.next()).treeExpanded(event);
        }
    }

    public TreePath getAnchorSelectionPath() {
        return this.anchorSelectionPath;
    }

    public void setAnchorSelectionPath(TreePath path) {
        this.anchorSelectionPath = path;
    }

    protected void processTreeSelection(SelectionEvent e) {
        if (this.treeSelectionListeners.size() == 0) {
            return;
        }
        Iterator i = this.treeSelectionListeners.iterator();
        TreeSelectionEvent ev = new TreeSelectionEvent((Object)this, this.getTreePath(e.item.getData()), false, this.getTreePath(e.item.getData()), this.getTreePath(e.item.getData()));
        while (i.hasNext()) {
            TreeSelectionListener l = (TreeSelectionListener)i.next();
            l.valueChanged(ev);
        }
    }

    protected void processTreeExpansion(TreeEvent e, boolean collapse) {
        try {
            this.fireTreeWillExpandOrCollapse(e, collapse);
        }
        catch (ExpandVetoException ex) {
            e.doit = false;
            return;
        }
        this.renderNode((TreeItem)e.item);
        if (this.treeExpansionListeners.size() == 0) {
            return;
        }
        Iterator i = this.treeExpansionListeners.iterator();
        TreeExpansionEvent ev = new TreeExpansionEvent(e.item.getData(), this.getTreePath(e.item.getData()));
        while (i.hasNext()) {
            TreeExpansionListener l = (TreeExpansionListener)i.next();
            if (collapse) {
                l.treeCollapsed(ev);
                continue;
            }
            l.treeExpanded(ev);
        }
    }

    public void fireTreeWillExpandOrCollapse(TreeEvent e, boolean collapse) throws ExpandVetoException {
        if (this.treeWillExpansionListeners.size() != 0) {
            Iterator itrWillExpand = this.treeWillExpansionListeners.iterator();
            TreeExpansionEvent ev = new TreeExpansionEvent(e.item.getData(), this.getTreePath(e.item.getData()));
            while (itrWillExpand.hasNext()) {
                TreeWillExpandListener l = (TreeWillExpandListener)itrWillExpand.next();
                if (collapse) {
                    l.treeWillCollapse(ev);
                    continue;
                }
                l.treeWillExpand(ev);
            }
        }
    }

    private Vector findTreePath(Object root, Object searchedNode) {
        if (root == searchedNode) {
            Vector<Object> result = new Vector<Object>();
            result.add(root);
            return result;
        }
        int count = this.model.getChildCount(root);
        for (int i = 0; i < count; ++i) {
            Vector result = this.findTreePath(this.model.getChild(root, i), searchedNode);
            if (result == null) continue;
            result.add(root);
            return result;
        }
        return null;
    }

    public TreePath getTreePath(Object node) {
        Object[] retPath;
        Vector path = this.findTreePath(this.model.getRoot(), node);
        if (path != null) {
            retPath = path.toArray();
            path.removeAllElements();
            path = null;
        } else {
            retPath = new Object[]{node};
        }
        return new TreePath(retPath);
    }

    public void addSelectionPaths(TreePath[] path) {
    }

    public TreePath getSelectionPath() {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return null;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                TreeItem[] selpath = JTree.this.ppeer.getSelection();
                if (selpath.length == 0) {
                    JTree.this.retval = null;
                    return;
                }
                Object[] nodes = new Object[selpath.length];
                for (int i = 0; i < selpath.length; ++i) {
                    nodes[i] = selpath[i].getData();
                }
                JTree.this.retval = new TreePath(nodes);
            }
        });
        return (TreePath)this.retval;
    }

    public TreePath[] getSelectionPaths() {
        return new TreePath[]{this.getSelectionPath()};
    }

    public void addSelectionPath(TreePath t) {
        this.setSelectionPath(t);
    }

    public void removeSelectionPath(TreePath t) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTree.this.ppeer)) {
                    JTree.this.ppeer.deselectAll();
                }
            }
        });
    }

    public void removeSelectionPaths(TreePath[] t) {
        this.removeSelectionPath(null);
    }

    public void setScrollsOnExpand(boolean b) {
    }

    public void setShowsRootHandles(boolean b) {
    }

    public void setSelectionModel(TreeSelectionModel model) {
    }

    public TreeSelectionModel getSelectionModel() {
        return new DefaultTreeSelectionModel();
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return value == null ? "" : value.toString();
    }

    public void scrollPathToVisible(final TreePath t) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTree.this.ppeer)) {
                    Object dmt = t.getLastPathComponent();
                    JTree.this.ppeer.showItem(JTree.this.getPeerTreeItem(dmt));
                }
            }
        });
    }

    public void setSelectionPaths(TreePath[] t) {
        this.setSelectionPath(t[0]);
    }

    public void setSelectionPath(TreePath t) {
        if (t == null) {
            return;
        }
        if (t.getPathCount() == 0) {
            return;
        }
        if (this.ppeer == null) {
            return;
        }
        final Object[] nodes = t.getPath();
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                TreeItem[] ti = new TreeItem[nodes.length];
                for (int i = 0; i < nodes.length; ++i) {
                    ti[i] = JTree.this.getPeerTreeItem(nodes[i]);
                }
                JTree.this.ppeer.setSelection(ti);
            }
        });
    }

    public TreePath getPathForLocation(int x, int y) {
        return this.getClosestPathForLocation(x, y);
    }

    public TreePath getClosestPathForLocation(final int x, final int y) {
        final TreePath[] path = new TreePath[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                TreeItem item;
                path[0] = SwingWTUtils.isSWTControlAvailable((Control)JTree.this.ppeer) ? ((item = JTree.this.ppeer.getItem(new Point(x, y))) != null ? new TreePath(item.getData()) : null) : null;
            }
        });
        return path[0];
    }

    public TreePath getPathForRow(final int row) {
        final TreePath[] path = new TreePath[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTree.this.ppeer)) {
                    TreeItem item = JTree.this.ppeer.getItems()[row];
                    path[0] = new TreePath(item.getData());
                } else {
                    path[0] = null;
                }
            }
        });
        return path[0];
    }

    public int getRowCount() {
        final int[] rowCount = new int[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                rowCount[0] = SwingWTUtils.isSWTControlAvailable((Control)JTree.this.ppeer) ? JTree.this.ppeer.getItemHeight() : 0;
            }
        });
        return rowCount[0];
    }

    public void expandRow(int row) {
        this.expandPath(this.getPathForRow(row));
    }

    public void collapseRow(int row) {
        this.collapsePath(this.getPathForRow(row));
    }

    public void expandPath(TreePath parent) {
        if (parent == null) {
            return;
        }
        Object element = parent.getLastPathComponent();
        if (parent.getParentPath() != null && parent.getLastPathComponent() != null) {
            this.expandPath(parent.getParentPath());
        }
        if (element == null) {
            return;
        }
        this.fireTreeExpanded(parent);
        TreeItem peeritem = this.getPeerTreeItem(element);
        if (peeritem != null && !peeritem.isDisposed() && this.model.isLeaf(element) && !peeritem.getExpanded()) {
            peeritem.setExpanded(true);
            this.renderNode(peeritem);
        }
    }

    public void collapsePath(TreePath parent) {
        if (parent == null) {
            return;
        }
        Object element = parent.getLastPathComponent();
        if (parent.getParentPath() != null && parent.getLastPathComponent() != null) {
            this.collapsePath(parent.getParentPath());
        }
        if (element == null) {
            return;
        }
        TreeItem peeritem = this.getPeerTreeItem(element);
        if (peeritem != null && !peeritem.isDisposed() && this.model.getChildCount(element) != 0 && peeritem.getExpanded()) {
            peeritem.setExpanded(false);
            this.renderNode(peeritem);
        }
    }

    public void drawTree() {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return;
        }
        if (this.model == null) {
            return;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JTree.this.ppeer.removeAll();
                Object root = JTree.this.model.getRoot();
                if (root != null) {
                    if (JTree.this.isRootVisible) {
                        JTree.this.addNodes(JTree.this.ppeer, null, root);
                    } else {
                        int count = JTree.this.model.getChildCount(root);
                        if (count > 0) {
                            for (int i = 0; i < count; ++i) {
                                JTree.this.addNodes(JTree.this.ppeer, null, JTree.this.model.getChild(root, i));
                            }
                        }
                    }
                }
            }
        });
    }

    public Object getLastSelectedPathComponent() {
        TreePath t = this.getSelectionPath();
        return t != null ? t.getLastPathComponent() : null;
    }

    private void addNodes(Tree tree, TreeItem treeItem, Object swingNode) {
        TreeItem item = null;
        item = tree != null ? new TreeItem(tree, 2048) : new TreeItem(treeItem, 2048);
        this.mPeerMap.put(swingNode, item);
        Component renderer = this.cellRenderer.getTreeCellRendererComponent(this, swingNode, false, tree != null, this.model.isLeaf(swingNode), 0, true);
        this.renderNode(item, renderer);
        item.setData(swingNode);
        int count = this.model.getChildCount(swingNode);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                this.addNodes(null, item, this.model.getChild(swingNode, i));
            }
        }
        if (tree != null) {
            item.setExpanded(true);
        }
    }

    private void renderNode(TreeItem item) {
        Object swingNode = item.getData();
        this.mPeerMap.put(swingNode, item);
        Component renderer = this.cellRenderer.getTreeCellRendererComponent(this, swingNode, false, !item.getExpanded(), this.model.isLeaf(swingNode), 0, true);
        this.renderNode(item, renderer);
    }

    private void renderNode(TreeItem item, Component renderer) {
        if (renderer instanceof JLabel) {
            JLabel cr = (JLabel)renderer;
            item.setText(cr.getText());
            if (cr.getIcon() != null) {
                item.setImage(SwingWTUtils.getSWTImageFromSwingIcon(this, cr.getIcon()));
            }
            if (cr.getBackground() != null && cr.getBackground().getSWTColor() != null) {
                item.setBackground(cr.getBackground().getSWTColor());
            }
            if (cr.getForeground() != null && cr.getForeground().getSWTColor() != null) {
                item.setForeground(cr.getForeground().getSWTColor());
            }
            if (cr.hasSetFont()) {
                item.setFont(cr.getFont().getSWTFont());
            }
        } else {
            item.setText("CellRenderer not JLabel: " + renderer.getClass().getName());
        }
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        this.cellRenderer = renderer;
    }

    public TreeCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void treeNodesChanged(TreeModelEvent e) {
        this.drawTree();
    }

    public void treeNodesInserted(TreeModelEvent e) {
        this.drawTree();
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        this.drawTree();
    }

    public void treeStructureChanged(TreeModelEvent e) {
        this.drawTree();
    }

    public void setRootVisible(boolean rootVisible) {
        this.isRootVisible = rootVisible;
    }

    public boolean isRootVisible() {
        return this.isRootVisible;
    }

    public void editingCanceled(ChangeEvent e) {
    }

    public boolean isExpanded(int j) {
        return false;
    }

    public int getRowForLocation(int x, int y) {
        return 0;
    }

    public void setSelectionRow(int row) {
    }

    public boolean isEditing() {
        return false;
    }

    public void stopEditing() {
    }

    public void addTreeWillExpandListener(TreeWillExpandListener tree) {
    }

    protected void setInvokesStopCellEditing(boolean b) {
    }

    protected void startEditingAtPath(TreePath newChildPath) {
    }

    protected TreeUI getUI() {
        return null;
    }

    public void treeDidChange() {
    }

    public void setSelectionInterval(int i, int rowCount) {
    }

    private class TreeEditorContainer
    extends Container {
        public TreeEditorContainer(JTree parent) {
            this.peer = parent.getSWTPeer();
            this.composite = (Composite)parent.getSWTPeer();
        }
    }
}

