/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.plaf;

import swingwt.awt.Dimension;
import swingwt.awt.Graphics;
import swingwtx.accessibility.Accessible;
import swingwtx.swing.JComponent;
import swingwtx.swing.SwingUtilities;

public abstract class ComponentUI {
    public static ComponentUI createUI(JComponent component) {
        throw new UnsupportedOperationException("createUI(JComponent) must be implemented by final ComponentUI implementation!");
    }

    public void installUI(JComponent c) {
    }

    public void uninstallUI(JComponent c) {
    }

    public void paint(Graphics g, JComponent c) {
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    public Dimension getPreferredSize(JComponent component) {
        return null;
    }

    public Dimension getMinimumSize(JComponent component) {
        return this.getPreferredSize(component);
    }

    public Dimension getMaximumSize(JComponent component) {
        return this.getPreferredSize(component);
    }

    public boolean contains(JComponent component, int x, int y) {
        return false;
    }

    public int getAccessibleChildrenCount(JComponent c) {
        return SwingUtilities.getAccessibleChildrenCount(c);
    }

    public Accessible getAccessibleChild(JComponent c, int i) {
        return SwingUtilities.getAccessibleChild(c, i);
    }
}

