/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class TableDragUnderEffect
extends DragUnderEffect {
    private Table table;
    private TableItem currentItem;
    private TableItem[] selection = new TableItem[0];
    private int currentEffect = 0;

    TableDragUnderEffect(Table table) {
        this.table = table;
    }

    void show(int effect, int x, int y) {
        TableItem item = null;
        if (effect != 0) {
            item = this.findItem(x, y);
        }
        if (item == null) {
            effect = 0;
        }
        if (this.currentEffect != effect && this.currentEffect == 0) {
            this.selection = this.table.getSelection();
            this.table.setSelection(new TableItem[0]);
        }
        boolean restoreSelection = this.currentEffect != effect && effect == 0;
        this.setDragUnderEffect(effect, item);
        if (restoreSelection) {
            this.table.setSelection(this.selection);
            this.selection = new TableItem[0];
        }
    }

    private TableItem findItem(int x, int y) {
        if (this.table == null) {
            return null;
        }
        Point coordinates = new Point(x, y);
        coordinates = this.table.toControl(coordinates);
        return this.table.getItem(coordinates);
    }

    private void setDragUnderEffect(int effect, TableItem item) {
        if (this.currentItem != item) {
            if (item == null) {
                this.table.setSelection(new TableItem[0]);
            } else {
                this.table.setSelection(new TableItem[]{item});
            }
            this.currentItem = item;
        }
        this.currentEffect = effect;
    }
}

