/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.carbon.OS;

public final class Cursor {
    public int handle;
    Device device;
    static final short[] SIZENS_SOURCE;
    static final short[] SIZENS_MASK;

    static {
        short[] sArray = new short[16];
        sArray[1] = 384;
        sArray[2] = 960;
        sArray[3] = 2016;
        sArray[4] = 384;
        sArray[5] = 384;
        sArray[6] = 384;
        sArray[7] = 32766;
        sArray[8] = 32766;
        sArray[9] = 384;
        sArray[10] = 384;
        sArray[11] = 384;
        sArray[12] = 2016;
        sArray[13] = 960;
        sArray[14] = 384;
        SIZENS_SOURCE = sArray;
        SIZENS_MASK = new short[]{384, 960, 2016, 4080, 4080, 960, -1, -1, -1, -1, 960, 4080, 4080, 2016, 960, 384};
    }

    Cursor() {
    }

    public Cursor(Device device, int style) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        switch (style) {
            case 21: {
                this.handle = 10;
                break;
            }
            case 0: {
                this.handle = 0;
                break;
            }
            case 1: {
                this.handle = 14;
                break;
            }
            case 2: {
                this.handle = 5;
                break;
            }
            case 3: {
                this.handle = 0;
                break;
            }
            case 4: {
                this.handle = 5;
                break;
            }
            case 5: {
                this.handle = 5;
                break;
            }
            case 6: {
                this.handle = 5;
                break;
            }
            case 7: {
                org.eclipse.swt.internal.carbon.Cursor cursor = new org.eclipse.swt.internal.carbon.Cursor();
                cursor.data = SIZENS_SOURCE;
                cursor.mask = SIZENS_MASK;
                cursor.hotSpot_h = (short)7;
                cursor.hotSpot_v = (short)7;
                this.handle = OS.NewPtr((int)68);
                if (this.handle == 0) {
                    SWT.error(2);
                }
                OS.memcpy((int)this.handle, (org.eclipse.swt.internal.carbon.Cursor)cursor, (int)68);
                break;
            }
            case 8: {
                this.handle = 5;
                break;
            }
            case 9: {
                this.handle = 17;
                break;
            }
            case 10: {
                this.handle = 5;
                break;
            }
            case 11: {
                this.handle = 5;
                break;
            }
            case 12: {
                this.handle = 16;
                break;
            }
            case 13: {
                this.handle = 15;
                break;
            }
            case 14: {
                this.handle = 5;
                break;
            }
            case 15: {
                this.handle = 5;
                break;
            }
            case 16: {
                this.handle = 5;
                break;
            }
            case 17: {
                this.handle = 5;
                break;
            }
            case 18: {
                this.handle = 5;
                break;
            }
            case 19: {
                this.handle = 4;
                break;
            }
            case 20: {
                this.handle = 18;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
    }

    public Cursor(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            if (source.getTransparencyType() != 2) {
                SWT.error(4);
            }
            mask = source.getTransparencyMask();
        }
        if (mask.width != source.width || mask.height != source.height) {
            SWT.error(5);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        mask = ImageData.convertMask(mask);
        source = ImageData.convertMask(source);
        int width = source.width;
        int height = source.height;
        int minX = 0;
        int minY = 0;
        if (width > 16 || height > 16) {
            minX = width;
            minY = height;
            int maxX = 0;
            int maxY = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    if (source.getPixel(x, y) != 1 || mask.getPixel(x, y) != 0) {
                        minX = Math.min(minX, x);
                        minY = Math.min(minY, y);
                        maxX = Math.max(maxX, x);
                        maxY = Math.max(maxY, y);
                    }
                    ++x;
                }
                ++y;
            }
            width = maxX - minX + 1;
            height = maxY - minY + 1;
            if (width > 16 || height > 16) {
                int newWidth = Math.min(width, 16);
                int newHeight = Math.min(height, 16);
                ImageData newSource = new ImageData(newWidth, newHeight, source.depth, source.palette, 1, null, 0, null, null, -1, -1, source.type, source.x, source.y, source.disposalMethod, source.delayTime);
                ImageData newMask = new ImageData(newWidth, newHeight, mask.depth, mask.palette, 1, null, 0, null, null, -1, -1, mask.type, mask.x, mask.y, mask.disposalMethod, mask.delayTime);
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), minX, minY, width, height, null, null, null, 255, null, 0, minX, minY, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newWidth, newHeight, null, null, null, false, false);
                ImageData.blit(1, mask.data, mask.depth, mask.bytesPerLine, mask.getByteOrder(), minX, minY, width, height, null, null, null, 255, null, 0, minX, minY, newMask.data, newMask.depth, newMask.bytesPerLine, newMask.getByteOrder(), 0, 0, newWidth, newHeight, null, null, null, false, false);
                width = newWidth;
                height = newHeight;
                minY = 0;
                minX = 0;
                source = newSource;
                mask = newMask;
            }
        }
        org.eclipse.swt.internal.carbon.Cursor cursor = new org.eclipse.swt.internal.carbon.Cursor();
        short[] srcData = cursor.data;
        short[] maskData = cursor.mask;
        int y = 0;
        while (y < height) {
            short d = 0;
            short m = 0;
            int x = 0;
            while (x < width) {
                int bit = 1 << width - 1 - x;
                if (source.getPixel(minX + x, minY + y) == 0) {
                    m = (short)(m | bit);
                    if (mask.getPixel(minX + x, minY + y) == 0) {
                        d = (short)(d | bit);
                    }
                } else if (mask.getPixel(minX + x, minY + y) != 0) {
                    d = (short)(d | bit);
                }
                ++x;
            }
            srcData[y] = d;
            maskData[y] = m;
            ++y;
        }
        cursor.hotSpot_h = (short)Math.max(0, Math.min(15, hotspotY - minX));
        cursor.hotSpot_v = (short)Math.max(0, Math.min(15, hotspotY - minY));
        this.handle = OS.NewPtr((int)68);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.memcpy((int)this.handle, (org.eclipse.swt.internal.carbon.Cursor)cursor, (int)68);
    }

    public Cursor(Device device, ImageData source, int hotspotX, int hotspotY) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (source == null) {
            SWT.error(4);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        ImageData mask = source.getTransparencyMask();
        if (source.depth > 1) {
            ImageData newSource = new ImageData(source.width, source.height, 1, ImageData.bwPalette(), 1, null, 0, null, null, -1, -1, source.type, source.x, source.y, source.disposalMethod, source.delayTime);
            PaletteData palette = source.palette;
            if (palette.isDirect) {
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, 0, 0, 0, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newSource.width, newSource.height, 0, 0, 0, false, false);
            } else {
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, null, null, null, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newSource.width, newSource.height, null, null, null, false, false);
            }
            source = newSource;
        }
        int width = source.width;
        int height = source.height;
        int minX = 0;
        int minY = 0;
        if (width > 16 || height > 16) {
            minX = width;
            minY = height;
            int maxX = 0;
            int maxY = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    if (source.getPixel(x, y) != 1 || mask.getPixel(x, y) != 0) {
                        minX = Math.min(minX, x);
                        minY = Math.min(minY, y);
                        maxX = Math.max(maxX, x);
                        maxY = Math.max(maxY, y);
                    }
                    ++x;
                }
                ++y;
            }
            width = maxX - minX + 1;
            height = maxY - minY + 1;
            if (width > 16 || height > 16) {
                int newWidth = Math.min(width, 16);
                int newHeight = Math.min(height, 16);
                ImageData newSource = new ImageData(newWidth, newHeight, source.depth, source.palette, 1, null, 0, null, null, -1, -1, source.type, source.x, source.y, source.disposalMethod, source.delayTime);
                ImageData newMask = new ImageData(newWidth, newHeight, mask.depth, mask.palette, 1, null, 0, null, null, -1, -1, mask.type, mask.x, mask.y, mask.disposalMethod, mask.delayTime);
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), minX, minY, width, height, null, null, null, 255, null, 0, minX, minY, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newWidth, newHeight, null, null, null, false, false);
                ImageData.blit(1, mask.data, mask.depth, mask.bytesPerLine, mask.getByteOrder(), minX, minY, width, height, null, null, null, 255, null, 0, minX, minY, newMask.data, newMask.depth, newMask.bytesPerLine, newMask.getByteOrder(), 0, 0, newWidth, newHeight, null, null, null, false, false);
                width = newWidth;
                height = newHeight;
                minY = 0;
                minX = 0;
                source = newSource;
                mask = newMask;
            }
        }
        org.eclipse.swt.internal.carbon.Cursor cursor = new org.eclipse.swt.internal.carbon.Cursor();
        short[] srcData = cursor.data;
        short[] maskData = cursor.mask;
        int y = 0;
        while (y < height) {
            short d = 0;
            short m = 0;
            int x = 0;
            while (x < width) {
                int bit = 1 << width - 1 - x;
                if (source.getPixel(x + minX, y + minY) == 0) {
                    if (mask.getPixel(x + minX, y + minY) != 0) {
                        d = (short)(d | bit);
                        m = (short)(m | bit);
                    }
                } else if (mask.getPixel(x + minX, y + minY) != 0) {
                    m = (short)(m | bit);
                }
                ++x;
            }
            srcData[y] = d;
            maskData[y] = m;
            ++y;
        }
        cursor.hotSpot_h = (short)Math.max(0, Math.min(15, hotspotY - minX));
        cursor.hotSpot_v = (short)Math.max(0, Math.min(15, hotspotY - minY));
        this.handle = OS.NewPtr((int)68);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.memcpy((int)this.handle, (org.eclipse.swt.internal.carbon.Cursor)cursor, (int)68);
    }

    public void dispose() {
        if (this.handle == -1) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        switch (this.handle) {
            case 0: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            default: {
                OS.DisposePtr((int)this.handle);
            }
        }
        this.handle = -1;
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isDisposed() {
        return this.handle == -1;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    public static Cursor carbon_new(Device device, int handle) {
        if (device == null) {
            device = Device.getDevice();
        }
        Cursor cursor = new Cursor();
        cursor.handle = handle;
        cursor.device = device;
        return cursor;
    }
}

