/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.FontInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Combo
extends Composite {
    int menuHandle;
    int textLimit = LIMIT;
    String lastText = "";
    public static final int LIMIT = Integer.MAX_VALUE;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        if (ptr == 0) {
            this.error(14);
        }
        int result = (this.style & 8) != 0 ? OS.AppendMenuItemTextWithCFString((int)this.menuHandle, (int)ptr, (int)0, (int)0, null) : OS.HIComboBoxAppendTextItem((int)this.handle, (int)ptr, null);
        OS.CFRelease((int)ptr);
        if (result != 0) {
            this.error(14);
        }
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (index < 0 || index > count) {
            this.error(6);
        }
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        if (ptr == 0) {
            this.error(14);
        }
        int result = (this.style & 8) != 0 ? OS.InsertMenuItemTextWithCFString((int)this.menuHandle, (int)ptr, (short)((short)index), (int)0, (int)0) : OS.HIComboBoxInsertTextItemAtIndex((int)this.handle, (int)index, (int)ptr);
        OS.CFRelease((int)ptr);
        if (result != 0) {
            this.error(14);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Widget.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    void checkSelection() {
        if ((this.style & 8) != 0) {
            return;
        }
        String newText = this.getText();
        if (newText.equals(this.lastText)) {
            return;
        }
        if (this.hooks(25) || this.filters(25)) {
            this.setText(this.lastText, false);
            newText = this.verifyText(newText, 0, this.lastText.length(), null);
            if (newText == null) {
                return;
            }
            this.setText(newText, false);
        } else {
            this.lastText = newText;
        }
        this.sendEvent(24);
        if (this.isDisposed()) {
            return;
        }
        int index = this.indexOf(newText);
        if (index != -1) {
            this.postEvent(13);
        }
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            short[] selection = new short[2];
            OS.GetControlData((int)this.handle, (short)5, (int)1936026725, (int)4, (short[])selection, null);
            selection[1] = selection[0];
            OS.SetControlData((int)this.handle, (int)5, (int)1936026725, (int)4, (short[])selection);
        }
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        int[] currentPort = new int[1];
        short themeFont = (short)this.defaultThemeFont();
        if (this.font != null) {
            themeFont = 200;
            OS.GetPort((int[])currentPort);
            OS.SetPortWindowPort((int)OS.GetControlOwner((int)this.handle));
            OS.TextFont((short)this.font.id);
            OS.TextFace((short)this.font.style);
            OS.TextSize((short)this.font.size);
        }
        FontInfo info = new FontInfo();
        OS.GetFontInfo((FontInfo)info);
        height = info.ascent + info.descent;
        int[] ptr = new int[1];
        if ((this.style & 8) != 0) {
            int index = OS.GetControlValue((int)this.handle) - 1;
            OS.CopyMenuItemTextAsCFString((int)this.menuHandle, (short)((short)(index + 1)), (int[])ptr);
        } else {
            OS.GetControlData((int)this.handle, (short)5, (int)1667658612, (int)4, (int[])ptr, null);
        }
        Point ioBounds = new Point();
        if (ptr[0] != 0) {
            OS.GetThemeTextDimensions((int)ptr[0], (short)themeFont, (int)1, (boolean)false, (Point)ioBounds, null);
            width = Math.max(width, ioBounds.h);
            height = Math.max(height, ioBounds.v);
            OS.CFRelease((int)ptr[0]);
        }
        int count = (this.style & 8) != 0 ? OS.CountMenuItems((int)this.menuHandle) : OS.HIComboBoxGetItemCount((int)this.handle);
        int i = 0;
        while (i < count) {
            int result = (this.style & 8) != 0 ? OS.CopyMenuItemTextAsCFString((int)this.menuHandle, (short)((short)(i + 1)), (int[])ptr) : OS.HIComboBoxCopyTextItemAtIndex((int)this.handle, (int)i, (int[])ptr);
            if (result == 0) {
                OS.GetThemeTextDimensions((int)ptr[0], (short)themeFont, (int)1, (boolean)false, (Point)ioBounds, null);
                width = Math.max(width, ioBounds.h);
                OS.CFRelease((int)ptr[0]);
            }
            ++i;
        }
        if (this.font != null) {
            OS.SetPort((int)currentPort[0]);
        }
        int[] metric = new int[1];
        if ((this.style & 8) != 0) {
            OS.GetThemeMetric((int)22, (int[])metric);
            width += metric[0];
            width += 13;
        } else {
            OS.GetThemeMetric((int)74, (int[])metric);
            width += metric[0];
        }
        OS.GetThemeMetric((int)4, (int[])metric);
        width += metric[0] * 2;
        height += metric[0] * 2;
        Rect inset = this.getInset();
        width += inset.left + inset.right;
        height += inset.top + inset.bottom;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        org.eclipse.swt.graphics.Point selection = this.getSelection();
        if (selection.x == selection.y) {
            return;
        }
        this.copy(this.getText(selection.x, selection.y));
    }

    void copy(char[] buffer) {
        if (buffer.length == 0) {
            return;
        }
        OS.ClearCurrentScrap();
        int[] scrap = new int[1];
        OS.GetCurrentScrap((int[])scrap);
        OS.PutScrapFlavor((int)scrap[0], (int)1970567284, (int)0, (int)(buffer.length * 2), (char[])buffer);
    }

    void createHandle() {
        if ((this.style & 8) != 0) {
            int[] outControl = new int[1];
            int window = OS.GetControlOwner((int)this.parent.handle);
            OS.CreatePopupButtonControl((int)window, null, (int)0, (short)-12345, (boolean)false, (short)0, (short)0, (int)0, (int[])outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            int[] menuRef = new int[1];
            OS.CreateNewMenu((short)0, (int)0, (int[])menuRef);
            if (menuRef[0] == 0) {
                this.error(2);
            }
            this.menuHandle = menuRef[0];
            OS.SetControlPopupMenuHandle((int)this.handle, (int)this.menuHandle);
            OS.SetControl32BitMaximum((int)this.handle, (int)Short.MAX_VALUE);
        } else {
            int[] outControl = new int[1];
            CGRect rect = new CGRect();
            int inAttributes = 8;
            OS.HIComboBoxCreate((CGRect)rect, (int)0, null, (int)0, (int)inAttributes, (int[])outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            OS.SetControlData((int)this.handle, (int)5, (int)1684238964, (int)4, (byte[])new byte[1]);
            OS.SetControlVisibility((int)this.handle, (boolean)true, (boolean)false);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        org.eclipse.swt.graphics.Point selection = this.getSelection();
        if (selection.x == selection.y) {
            return;
        }
        int start = selection.x;
        int end = selection.y;
        String text = this.getText();
        String leftText = text.substring(0, start);
        String rightText = text.substring(end, text.length());
        String newText = "";
        if ((this.hooks(25) || this.filters(25)) && (newText = this.verifyText(newText, start, end, null)) == null) {
            return;
        }
        char[] buffer = new char[newText.length()];
        newText.getChars(0, buffer.length, buffer, 0);
        this.copy(buffer);
        this.setText(String.valueOf(leftText) + newText + rightText, false);
        this.setSelection(new org.eclipse.swt.graphics.Point(start += newText.length(), start));
        this.sendEvent(24);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
    }

    public void deselectAll() {
        this.checkWidget();
    }

    public String getItem(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        int[] ptr = new int[1];
        int result = (this.style & 8) != 0 ? OS.CopyMenuItemTextAsCFString((int)this.menuHandle, (short)((short)(index + 1)), (int[])ptr) : OS.HIComboBoxCopyTextItemAtIndex((int)this.handle, (int)index, (int[])ptr);
        if (result != 0) {
            this.error(8);
        }
        int length = OS.CFStringGetLength((int)ptr[0]);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters((int)ptr[0], (CFRange)range, (char[])buffer);
        OS.CFRelease((int)ptr[0]);
        return new String(buffer);
    }

    public int getItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return OS.CountMenuItems((int)this.menuHandle);
        }
        return OS.HIComboBoxGetItemCount((int)this.handle);
    }

    public int getItemHeight() {
        this.checkWidget();
        return 26;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.getItem(i);
            ++i;
        }
        return result;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public org.eclipse.swt.graphics.Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new org.eclipse.swt.graphics.Point(0, this.getCharCount());
        }
        short[] selection = new short[2];
        OS.GetControlData((int)this.handle, (short)5, (int)1936026725, (int)4, (short[])selection, null);
        return new org.eclipse.swt.graphics.Point(selection[0], selection[1]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return OS.GetControlValue((int)this.handle) - 1;
        }
        return this.indexOf(this.getText());
    }

    public String getText() {
        this.checkWidget();
        return new String(this.getText(0, -1));
    }

    char[] getText(int start, int end) {
        int result;
        int[] ptr = new int[1];
        if ((this.style & 8) != 0) {
            int index = OS.GetControlValue((int)this.handle) - 1;
            result = OS.CopyMenuItemTextAsCFString((int)this.menuHandle, (short)((short)(index + 1)), (int[])ptr);
        } else {
            int[] actualSize = new int[1];
            result = OS.GetControlData((int)this.handle, (short)5, (int)1667658612, (int)4, (int[])ptr, (int[])actualSize);
        }
        if (result != 0) {
            return new char[0];
        }
        CFRange range = new CFRange();
        range.location = start;
        if (end == -1) {
            int length = OS.CFStringGetLength((int)ptr[0]);
            range.length = length - start;
        } else {
            range.length = end - start + 1;
        }
        char[] buffer = new char[range.length];
        OS.CFStringGetCharacters((int)ptr[0], (CFRange)range, (char[])buffer);
        OS.CFRelease((int)ptr[0]);
        return buffer;
    }

    public int getTextHeight() {
        this.checkWidget();
        return 26;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return this.getItemCount();
        }
        int[] buffer = new int[1];
        OS.GetControlData((int)this.handle, (short)0, (int)1667395177, (int)4, (int[])buffer, null);
        return buffer[0];
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 8) != 0) {
            int commandProc = this.display.commandProc;
            int[] mask = new int[]{1668113523, 1};
            int menuTarget = OS.GetMenuEventTarget((int)this.menuHandle);
            OS.InstallEventHandler((int)menuTarget, (int)commandProc, (int)(mask.length / 2), (int[])mask, (int)this.handle, null);
        }
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (start < 0 || start >= count) {
            return -1;
        }
        int i = start;
        while (i < count) {
            if (string.equals(this.getItem(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    String getClipboardText() {
        int[] scrap = new int[1];
        OS.GetCurrentScrap((int[])scrap);
        int[] size = new int[1];
        if (OS.GetScrapFlavorSize((int)scrap[0], (int)1970567284, (int[])size) != 0 || size[0] == 0) {
            return "";
        }
        char[] buffer = new char[size[0]];
        if (OS.GetScrapFlavorData((int)scrap[0], (int)1970567284, (int[])size, (char[])buffer) != 0) {
            return "";
        }
        return new String(buffer);
    }

    int getCharCount() {
        int result;
        int[] ptr = new int[1];
        if ((this.style & 8) != 0) {
            int index = OS.GetControlValue((int)this.handle) - 1;
            result = OS.CopyMenuItemTextAsCFString((int)this.menuHandle, (short)((short)(index + 1)), (int[])ptr);
        } else {
            int[] actualSize = new int[1];
            result = OS.GetControlData((int)this.handle, (short)5, (int)1667658612, (int)4, (int[])ptr, (int[])actualSize);
        }
        if (result != 0) {
            return 0;
        }
        int length = OS.CFStringGetLength((int)ptr[0]);
        OS.CFRelease((int)ptr[0]);
        return length;
    }

    Rect getInset() {
        return this.display.comboInset;
    }

    int kEventControlActivate(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlActivate(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        return 0;
    }

    int kEventProcessCommand(int nextHandler, int theEvent, int userData) {
        int result = super.kEventProcessCommand(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.postEvent(24);
        if (this.isDisposed()) {
            return -9874;
        }
        this.postEvent(13);
        return -9874;
    }

    int kEventRawKeyPressed(int nextHandler, int theEvent, int userData) {
        int[] keyCode = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
        switch (keyCode[0]) {
            case 36: {
                if (this.translateTraversal(keyCode[0], theEvent)) {
                    return 0;
                }
                if (!this.sendKeyEvent(1, theEvent)) {
                    return 0;
                }
                this.postEvent(14);
                break;
            }
            case 125: 
            case 126: {
                if (this.sendKeyEvent(1, theEvent)) break;
                return 0;
            }
        }
        return -9874;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.style & 8) == 0) {
            short[] part = new short[1];
            OS.GetEventParameter((int)theEvent, (int)1668313716, (int)1668313716, null, (int)2, null, (short[])part);
            if (part[0] != 0) {
                this.display.focusCombo = this;
            }
        }
        return result;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        result = OS.CallNextEventHandler((int)nextHandler, (int)theEvent);
        this.lastText = this.getText();
        return result;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        org.eclipse.swt.graphics.Point selection = this.getSelection();
        int start = selection.x;
        int end = selection.y;
        String text = this.getText();
        String leftText = text.substring(0, start);
        String rightText = text.substring(end, text.length());
        String newText = this.getClipboardText();
        if ((this.hooks(25) || this.filters(25)) && (newText = this.verifyText(newText, start, end, null)) == null) {
            return;
        }
        this.setText(String.valueOf(leftText) + newText + rightText, false);
        this.setSelection(new org.eclipse.swt.graphics.Point(start += newText.length(), start));
        this.sendEvent(24);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.focusCombo == this) {
            this.display.focusCombo = null;
        }
        if (this.menuHandle != 0) {
            OS.DeleteMenu((short)OS.GetMenuID((int)this.menuHandle));
            OS.DisposeMenu((int)this.menuHandle);
        }
        this.menuHandle = 0;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index == -1) {
            this.error(6);
        }
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        if ((this.style & 8) != 0) {
            OS.DeleteMenuItems((int)this.menuHandle, (short)((short)(index + 1)), (int)1);
            if (index == OS.GetControlValue((int)this.handle) - 1) {
                OS.SetControl32BitValue((int)this.handle, (int)0);
            }
        } else {
            OS.HIComboBoxRemoveItemAtIndex((int)this.handle, (int)index);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int newEnd = Math.min(end, count - 1);
        if ((this.style & 8) != 0) {
            OS.DeleteMenuItems((int)this.menuHandle, (short)((short)(start + 1)), (int)(newEnd - start + 1));
            int index = OS.GetControlValue((int)this.handle) - 1;
            if (start <= index && index <= end) {
                OS.SetControl32BitValue((int)this.handle, (int)0);
            }
        } else {
            int i = newEnd;
            while (i >= start) {
                OS.HIComboBoxRemoveItemAtIndex((int)this.handle, (int)i);
                --i;
            }
        }
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        int count = this.getItemCount();
        if ((this.style & 8) != 0) {
            OS.DeleteMenuItems((int)this.menuHandle, (short)1, (int)count);
            OS.SetControl32BitValue((int)this.handle, (int)0);
        } else if (count > 0) {
            int i = count - 1;
            while (i >= 0) {
                OS.HIComboBoxRemoveItemAtIndex((int)this.handle, (int)i);
                --i;
            }
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void select(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index >= 0 && index < count) {
            if ((this.style & 8) != 0) {
                OS.SetControl32BitValue((int)this.handle, (int)(index + 1));
                this.sendEvent(24);
            } else {
                this.setText(this.getItem(index), true);
            }
        }
    }

    boolean sendKeyEvent(int type, Event event) {
        if (!super.sendKeyEvent(type, event)) {
            return false;
        }
        if (type != 1) {
            return true;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        String oldText = "";
        String newText = "";
        if (this.hooks(25) || this.filters(25)) {
            int charCount = this.getCharCount();
            org.eclipse.swt.graphics.Point selection = this.getSelection();
            int start = selection.x;
            int end = selection.y;
            switch (event.character) {
                case '\b': {
                    if (start != end) break;
                    if (start == 0) {
                        return true;
                    }
                    start = Math.max(0, start - 1);
                    break;
                }
                case '\u007f': {
                    if (start != end) break;
                    if (start == charCount) {
                        return true;
                    }
                    end = Math.min(end + 1, charCount);
                    break;
                }
                case '\r': {
                    return true;
                }
                default: {
                    if (event.character != '\t' && event.character < ' ') {
                        return true;
                    }
                    oldText = new String(new char[]{event.character});
                }
            }
            if ((newText = this.verifyText(oldText, start, end, event)) == null) {
                return false;
            }
            if (charCount - (end - start) + newText.length() > this.textLimit) {
                return false;
            }
            if (newText != oldText) {
                String text = this.getText();
                String leftText = text.substring(0, start);
                String rightText = text.substring(end, text.length());
                this.setText(String.valueOf(leftText) + newText + rightText, false);
                this.setSelection(new org.eclipse.swt.graphics.Point(start += newText.length(), start));
            }
        }
        this.postEvent(24);
        return newText == oldText;
    }

    public void setItem(int index, String string) {
        int result;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        if (ptr == 0) {
            this.error(14);
        }
        if ((this.style & 8) != 0) {
            result = OS.SetMenuItemTextWithCFString((int)this.menuHandle, (short)((short)(index + 1)), (int)ptr);
        } else {
            result = OS.HIComboBoxInsertTextItemAtIndex((int)this.handle, (int)index, (int)ptr);
            OS.HIComboBoxRemoveItemAtIndex((int)this.handle, (int)(index + 1));
        }
        OS.CFRelease((int)ptr);
        if (result != 0) {
            this.error(14);
        }
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        this.removeAll();
        if (items.length == 0) {
            return;
        }
        i = 0;
        while (i < items.length) {
            int result;
            String string = items[i];
            char[] buffer = new char[string.length()];
            string.getChars(0, buffer.length, buffer, 0);
            int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
            if (ptr == 0) {
                this.error(14);
            }
            if ((this.style & 8) != 0) {
                result = OS.AppendMenuItemTextWithCFString((int)this.menuHandle, (int)ptr, (int)0, (int)0, null);
            } else {
                int[] outIndex = new int[1];
                result = OS.HIComboBoxAppendTextItem((int)this.handle, (int)ptr, (int[])outIndex);
            }
            OS.CFRelease((int)ptr);
            if (result != 0) {
                this.error(14);
            }
            ++i;
        }
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(org.eclipse.swt.graphics.Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        if ((this.style & 8) == 0) {
            short[] s = new short[]{(short)selection.x, (short)selection.y};
            OS.SetControlData((int)this.handle, (int)5, (int)1936026725, (int)4, (short[])s);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.setText(string, true);
    }

    void setText(String string, boolean notify) {
        if (notify && (this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index != -1 && index != this.getSelectionIndex()) {
                this.select(index);
                if (notify) {
                    this.sendEvent(24);
                }
            }
        } else {
            char[] buffer = new char[string.length()];
            string.getChars(0, buffer.length, buffer, 0);
            int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
            if (ptr == 0) {
                this.error(13);
            }
            this.lastText = string;
            OS.SetControlData((int)this.handle, (int)5, (int)1667658612, (int)4, (int[])new int[]{ptr});
            OS.CFRelease((int)ptr);
            if (notify) {
                this.sendEvent(24);
            }
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        this.textLimit = limit;
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        if ((this.style & 8) == 0) {
            OS.SetControlData((int)this.handle, (int)0, (int)1667395177, (int)4, (int[])new int[]{count});
        }
    }

    String verifyText(String string, int start, int end, Event keyEvent) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent != null) {
            event.character = keyEvent.character;
            event.keyCode = keyEvent.keyCode;
            event.stateMask = keyEvent.stateMask;
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

