/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color linkColor;
    org.eclipse.swt.graphics.Point[] offsets;
    org.eclipse.swt.graphics.Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;

    public Link(Composite parent, int style) {
        super(parent, style);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        int height;
        int width;
        Rectangle rect;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int layoutWidth = this.layout.getWidth();
        if (wHint == 0) {
            this.layout.setWidth(1);
            rect = this.layout.getBounds();
            width = 0;
            height = rect.height;
        } else {
            this.layout.setWidth(wHint);
            rect = this.layout.getBounds();
            width = rect.width;
            height = rect.height;
        }
        this.layout.setWidth(layoutWidth);
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new org.eclipse.swt.graphics.Point(width += border * 2, height += border * 2);
    }

    void createHandle() {
        int features = 260;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner((int)this.parent.handle);
        OS.CreateUserPaneControl((int)window, null, (int)features, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        this.layout = new TextLayout(this.display);
        this.linkColor = new Color(this.display, 0, 51, 153);
        this.offsets = new org.eclipse.swt.graphics.Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.selection = new org.eclipse.swt.graphics.Point(-1, -1);
        this.focusIndex = -1;
    }

    void createWidget() {
        super.createWidget();
        this.layout.setFont(this.getFont());
        this.text = "";
    }

    void drawBackground(int control) {
        this.drawBackground(control, this.background);
    }

    void drawWidget(int control, int damageRgn, int visibleRgn, int theEvent) {
        GCData data = new GCData();
        data.paintEvent = theEvent;
        data.visibleRgn = visibleRgn;
        GC gc = GC.carbon_new(this, data);
        int selStart = this.selection.x;
        int selEnd = this.selection.y;
        if (selStart > selEnd) {
            selStart = this.selection.y;
            selEnd = this.selection.x;
        }
        selEnd = -1;
        selStart = -1;
        this.layout.draw(gc, 0, 0, selStart, selEnd, null, null);
        if (this.hasFocus() && this.focusIndex != -1) {
            Rectangle[] rects = this.getRectangles(this.focusIndex);
            int i = 0;
            while (i < rects.length) {
                Rectangle rect = rects[i];
                gc.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                ++i;
            }
        }
        gc.dispose();
    }

    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectangles(int linkIndex) {
        int lineCount = this.layout.getLineCount();
        Rectangle[] rects = new Rectangle[lineCount];
        int[] lineOffsets = this.layout.getLineOffsets();
        org.eclipse.swt.graphics.Point point = this.offsets[linkIndex];
        int lineStart = 1;
        while (point.x > lineOffsets[lineStart]) {
            ++lineStart;
        }
        int lineEnd = 1;
        while (point.y > lineOffsets[lineEnd]) {
            ++lineEnd;
        }
        int index = 0;
        if (lineStart == lineEnd) {
            rects[index++] = this.layout.getBounds(point.x, point.y);
        } else {
            rects[index++] = this.layout.getBounds(point.x, lineOffsets[lineStart] - 1);
            rects[index++] = this.layout.getBounds(lineOffsets[lineEnd - 1], point.y);
            if (lineEnd - lineStart > 1) {
                int i = lineStart;
                while (i < lineEnd - 1) {
                    rects[index++] = this.layout.getLineBounds(i);
                    ++i;
                }
            }
        }
        if (rects.length != index) {
            Rectangle[] tmp = new Rectangle[index];
            System.arraycopy(rects, 0, tmp, 0, index);
            rects = tmp;
        }
        return rects;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        this.redraw();
        return 0;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMouseDown(nextHandler, theEvent, userData);
        short[] button = new short[1];
        OS.GetEventParameter((int)theEvent, (int)1835168878, (int)1835168878, null, (int)2, null, (short[])button);
        int[] clickCount = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1667460724, (int)1835100014, null, (int)4, null, (int[])clickCount);
        if (button[0] == 1 && clickCount[0] == 1) {
            if (this.focusIndex != -1) {
                this.setFocus();
            }
            int sizeof = 4;
            Point pt = new Point();
            OS.GetEventParameter((int)theEvent, (int)1835822947, (int)1363439732, null, (int)sizeof, null, (Point)pt);
            Rect rect = new Rect();
            int window = OS.GetControlOwner((int)this.handle);
            OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
            int x = pt.h - rect.left;
            int y = pt.v - rect.top;
            OS.GetControlBounds((int)this.handle, (Rect)rect);
            int offset = this.layout.getOffset(x -= rect.left, y -= rect.top, null);
            int oldSelectionX = this.selection.x;
            int oldSelectionY = this.selection.y;
            this.selection.x = offset;
            this.selection.y = -1;
            if (oldSelectionX != -1 && oldSelectionY != -1) {
                if (oldSelectionX > oldSelectionY) {
                    int temp = oldSelectionX;
                    oldSelectionX = oldSelectionY;
                    oldSelectionY = temp;
                }
                Rectangle rectangle = this.layout.getBounds(oldSelectionX, oldSelectionY);
                this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            int j = 0;
            while (j < this.offsets.length) {
                Rectangle[] rects = this.getRectangles(j);
                int i = 0;
                while (i < rects.length) {
                    Rectangle rectangle = rects[i];
                    if (rectangle.contains(x, y)) {
                        this.focusIndex = j;
                        this.redraw();
                        return result;
                    }
                    ++i;
                }
                ++j;
            }
        }
        int window = OS.GetControlOwner((int)this.handle);
        int port = OS.GetWindowPort((int)window);
        int[] outModifiers = new int[1];
        short[] outResult = new short[1];
        Point outPt = new Point();
        block5: while (outResult[0] != 2) {
            OS.TrackMouseLocationWithOptions((int)port, (int)0, (double)-1.0, (Point)outPt, (int[])outModifiers, (short[])outResult);
            switch (outResult[0]) {
                case 1: 
                case 2: 
                case 5: {
                    int chord = OS.GetCurrentEventButtonState();
                    if ((chord & 1) == 0) continue block5;
                    Rect rect = new Rect();
                    OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
                    int x = outPt.h;
                    int y = outPt.v;
                    OS.GetControlBounds((int)this.handle, (Rect)rect);
                    int oldSelection = this.selection.y;
                    this.selection.y = this.layout.getOffset(x -= rect.left, y -= rect.top, null);
                    if (this.selection.y == oldSelection) continue block5;
                    int newSelection = this.selection.y;
                    if (oldSelection > newSelection) {
                        int temp = oldSelection;
                        oldSelection = newSelection;
                        newSelection = temp;
                    }
                    Rectangle rectangle = this.layout.getBounds(oldSelection, newSelection);
                    this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                    this.update();
                    break;
                }
                default: {
                    outResult[0] = 2;
                }
            }
        }
        return result;
    }

    int kEventMouseMoved(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMouseMoved(nextHandler, theEvent, userData);
        int sizeof = 4;
        Point pt = new Point();
        OS.GetEventParameter((int)theEvent, (int)1835822947, (int)1363439732, null, (int)sizeof, null, (Point)pt);
        Rect rect = new Rect();
        int window = OS.GetControlOwner((int)this.handle);
        OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
        int x = pt.h - rect.left;
        int y = pt.v - rect.top;
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        x -= rect.left;
        y -= rect.top;
        int j = 0;
        while (j < this.offsets.length) {
            Rectangle[] rects = this.getRectangles(j);
            int i = 0;
            while (i < rects.length) {
                Rectangle rectangle = rects[i];
                if (rectangle.contains(x, y)) {
                    this.setCursor(this.display.getSystemCursor(21));
                    return result;
                }
                ++i;
            }
            ++j;
        }
        this.setCursor(null);
        return result;
    }

    int kEventMouseUp(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMouseUp(nextHandler, theEvent, userData);
        if (this.focusIndex == -1) {
            return result;
        }
        short[] button = new short[1];
        OS.GetEventParameter((int)theEvent, (int)1835168878, (int)1835168878, null, (int)2, null, (short[])button);
        if (button[0] == 1) {
            int sizeof = 4;
            Point pt = new Point();
            OS.GetEventParameter((int)theEvent, (int)1835822947, (int)1363439732, null, (int)sizeof, null, (Point)pt);
            Rect rect = new Rect();
            int window = OS.GetControlOwner((int)this.handle);
            OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
            int x = pt.h - rect.left;
            int y = pt.v - rect.top;
            OS.GetControlBounds((int)this.handle, (Rect)rect);
            x -= rect.left;
            y -= rect.top;
            Rectangle[] rects = this.getRectangles(this.focusIndex);
            int i = 0;
            while (i < rects.length) {
                Rectangle rectangle = rects[i];
                if (rectangle.contains(x, y)) {
                    Event event = new Event();
                    event.text = this.ids[this.focusIndex];
                    this.notifyListeners(13, event);
                    return result;
                }
                ++i;
            }
        }
        return result;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if (this.focusIndex == -1) {
            return result;
        }
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1953721189, (int)1702261350, null, (int)(keyboardEvent.length * 4), null, (int[])keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter((int)keyboardEvent[0], (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
        switch (keyCode[0]) {
            case 36: 
            case 49: 
            case 76: {
                Event event = new Event();
                event.text = this.ids[this.focusIndex];
                this.sendEvent(13, event);
                break;
            }
            case 48: {
                boolean next;
                int[] modifiers = new int[1];
                OS.GetEventParameter((int)keyboardEvent[0], (int)1802334052, (int)1835100014, null, (int)4, null, (int[])modifiers);
                boolean bl = next = (modifiers[0] & 0x200) == 0;
                if (next) {
                    if (this.focusIndex >= this.offsets.length - 1) break;
                    ++this.focusIndex;
                    this.redraw();
                    break;
                }
                if (this.focusIndex <= 0) break;
                --this.focusIndex;
                this.redraw();
            }
        }
        return result;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        if (this.linkColor != null) {
            this.linkColor.dispose();
        }
        this.linkColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    String parse(String string) {
        int length = string.length();
        this.offsets = new org.eclipse.swt.graphics.Point[length / 4];
        this.ids = new String[length / 4];
        this.mnemonics = new int[length / 4];
        StringBuffer result = new StringBuffer();
        char[] buffer = new char[length];
        string.getChars(0, string.length(), buffer, 0);
        int index = 0;
        int state = 0;
        int linkIndex = 0;
        int start = 0;
        int tagStart = 0;
        int linkStart = 0;
        int endtagStart = 0;
        int refStart = 0;
        while (index < length) {
            char c = Character.toLowerCase(buffer[index]);
            block0 : switch (state) {
                case 0: {
                    if (c != '<') break;
                    tagStart = index;
                    ++state;
                    break;
                }
                case 1: {
                    if (c != 'a') break;
                    ++state;
                    break;
                }
                case 2: {
                    switch (c) {
                        case 'h': {
                            state = 7;
                            break block0;
                        }
                        case '>': {
                            linkStart = index + 1;
                            ++state;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(c)) break;
                    state = 13;
                    break;
                }
                case 3: {
                    if (c != '<') break;
                    endtagStart = index;
                    ++state;
                    break;
                }
                case 4: {
                    state = c == '/' ? state + 1 : 3;
                    break;
                }
                case 5: {
                    state = c == 'a' ? state + 1 : 3;
                    break;
                }
                case 6: {
                    if (c == '>') {
                        this.mnemonics[linkIndex] = this.parseMnemonics(buffer, start, tagStart, result);
                        int offset = result.length();
                        this.parseMnemonics(buffer, linkStart, endtagStart, result);
                        this.offsets[linkIndex] = new org.eclipse.swt.graphics.Point(offset, result.length() - 1);
                        if (this.ids[linkIndex] == null) {
                            this.ids[linkIndex] = new String(buffer, linkStart, endtagStart - linkStart);
                        }
                        ++linkIndex;
                        endtagStart = refStart = index + 1;
                        linkStart = refStart;
                        tagStart = refStart;
                        start = refStart;
                        state = 0;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 7: {
                    state = c == 'r' ? state + 1 : 0;
                    break;
                }
                case 8: {
                    state = c == 'e' ? state + 1 : 0;
                    break;
                }
                case 9: {
                    state = c == 'f' ? state + 1 : 0;
                    break;
                }
                case 10: {
                    state = c == '=' ? state + 1 : 0;
                    break;
                }
                case 11: {
                    if (c == '\"') {
                        ++state;
                        refStart = index + 1;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 12: {
                    if (c != '\"') break;
                    this.ids[linkIndex] = new String(buffer, refStart, index - refStart);
                    state = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        break;
                    }
                    if (c != '=') break;
                    ++state;
                    break;
                }
                case 14: {
                    state = c == '\"' ? state + 1 : 0;
                    break;
                }
                case 15: {
                    if (c != '\"') break;
                    state = 2;
                    break;
                }
                default: {
                    state = 0;
                }
            }
            ++index;
        }
        if (start < length) {
            int tmp = this.parseMnemonics(buffer, start, tagStart, result);
            int mnemonic = this.parseMnemonics(buffer, linkStart, index, result);
            if (mnemonic == -1) {
                mnemonic = tmp;
            }
            this.mnemonics[linkIndex] = mnemonic;
        } else {
            this.mnemonics[linkIndex] = -1;
        }
        if (this.offsets.length != linkIndex) {
            org.eclipse.swt.graphics.Point[] newOffsets = new org.eclipse.swt.graphics.Point[linkIndex];
            System.arraycopy(this.offsets, 0, newOffsets, 0, linkIndex);
            this.offsets = newOffsets;
            String[] newIDs = new String[linkIndex];
            System.arraycopy(this.ids, 0, newIDs, 0, linkIndex);
            this.ids = newIDs;
            int[] newMnemonics = new int[linkIndex + 1];
            System.arraycopy(this.mnemonics, 0, newMnemonics, 0, linkIndex + 1);
            this.mnemonics = newMnemonics;
        }
        return result.toString();
    }

    int parseMnemonics(char[] buffer, int start, int end, StringBuffer result) {
        int mnemonic = -1;
        int index = start;
        while (index < end) {
            if (buffer[index] == '&') {
                if (index + 1 < end && buffer[index + 1] == '&') {
                    result.append(buffer[index]);
                    ++index;
                } else {
                    mnemonic = result.length();
                }
            } else {
                result.append(buffer[index]);
            }
            ++index;
        }
        return mnemonic;
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if ((result & 0x80) != 0) {
            this.layout.setWidth(width > 0 ? width : -1);
        }
        return result;
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        this.layout.setFont(font);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        this.layout.setText(this.parse(string));
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        this.selection.y = -1;
        this.selection.x = -1;
        TextStyle linkStyle = new TextStyle(null, this.linkColor, null);
        linkStyle.underline = true;
        int i = 0;
        while (i < this.offsets.length) {
            org.eclipse.swt.graphics.Point point = this.offsets[i];
            this.layout.setStyle(linkStyle, point.x, point.y);
            ++i;
        }
        TextStyle mnemonicStyle = new TextStyle(null, null, null);
        mnemonicStyle.underline = true;
        int i2 = 0;
        while (i2 < this.mnemonics.length) {
            int mnemonic = this.mnemonics[i2];
            if (mnemonic != -1) {
                this.layout.setStyle(mnemonicStyle, mnemonic, mnemonic);
            }
            ++i2;
        }
        this.redraw();
    }

    int traversalCode(int key, int theEvent) {
        if (this.offsets.length == 0) {
            return 0;
        }
        int bits = super.traversalCode(key, theEvent);
        if (key == 48 && theEvent != 0) {
            boolean next;
            int[] modifiers = new int[1];
            OS.GetEventParameter((int)theEvent, (int)1802334052, (int)1835100014, null, (int)4, null, (int[])modifiers);
            boolean bl = next = (modifiers[0] & 0x200) == 0;
            if (next && this.focusIndex < this.offsets.length - 1) {
                return bits & 0xFFFFFFEF;
            }
            if (!next && this.focusIndex > 0) {
                return bits & 0xFFFFFFF7;
            }
        }
        return bits;
    }
}

