/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Sash
extends Control {
    Cursor sizeCursor;
    int lastX;
    int lastY;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
        int cursorStyle = (style & 0x200) != 0 ? 9 : 7;
        this.sizeCursor = new Cursor(this.display, cursorStyle);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style |= 0x10000, 256, 512, 0, 0, 0, 0);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 0x100) != 0) {
            width += 64;
            height += 5;
        } else {
            width += 5;
            height += 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    void createHandle() {
        int features = 4;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner((int)this.parent.handle);
        OS.CreateUserPaneControl((int)window, null, (int)features, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void drawBackground(int control) {
        this.drawBackground(control, this.background);
    }

    int kEventControlClick(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlClick(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (!this.isEnabled()) {
            return 0;
        }
        return result;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetCursor(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.display.setCursor(this.sizeCursor.handle);
        return 0;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        int startX = rect.left;
        int startY = rect.top;
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        OS.GetControlBounds((int)this.parent.handle, (Rect)rect);
        Event event = new Event();
        event.x = startX -= rect.left;
        event.y = startY -= rect.top;
        event.width = width;
        event.height = height;
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return result;
        }
        if (!event.doit) {
            return result;
        }
        int sizeof = 4;
        Point pt = new Point();
        OS.GetEventParameter((int)theEvent, (int)1835822947, (int)1363439732, null, (int)sizeof, null, (Point)pt);
        int window = OS.GetControlOwner((int)this.handle);
        OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
        int offsetX = pt.h - rect.left;
        int offsetY = pt.v - rect.top;
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        offsetX -= rect.left;
        offsetY -= rect.top;
        int port = OS.GetWindowPort((int)window);
        int[] outModifiers = new int[1];
        short[] outResult = new short[1];
        Point outPt = new Point();
        block3: while (outResult[0] != 2) {
            OS.TrackMouseLocationWithOptions((int)port, (int)0, (double)-1.0, (Point)outPt, (int[])outModifiers, (short[])outResult);
            switch (outResult[0]) {
                case 1: 
                case 2: 
                case 5: {
                    OS.GetControlBounds((int)this.parent.handle, (Rect)rect);
                    int x = outPt.h - rect.left;
                    int y = outPt.v - rect.top;
                    int newX = startX;
                    int newY = startY;
                    if ((this.style & 0x200) != 0) {
                        int clientWidth = rect.right - rect.left;
                        newX = Math.min(Math.max(0, x - offsetX), clientWidth - width);
                    } else {
                        int clientHeight = rect.bottom - rect.top;
                        newY = Math.min(Math.max(0, y - offsetY), clientHeight - height);
                    }
                    event = new Event();
                    event.x = newX;
                    event.y = newY;
                    event.width = width;
                    event.height = height;
                    this.sendEvent(13, event);
                    if (this.isDisposed()) {
                        return result;
                    }
                    if (!event.doit) continue block3;
                    this.setBounds(event.x, event.y, width, height);
                    if (this.isDisposed()) {
                        return result;
                    }
                    this.parent.update(true);
                    break;
                }
                default: {
                    outResult[0] = 2;
                }
            }
        }
        return result;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        org.eclipse.swt.graphics.Point location = this.getLocation();
        this.lastX = location.x;
        this.lastY = location.y;
        return 0;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1953721189, (int)1702261350, null, (int)(keyboardEvent.length * 4), null, (int[])keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter((int)keyboardEvent[0], (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
        switch (keyCode[0]) {
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                int xChange = 0;
                int yChange = 0;
                int stepSize = 9;
                int[] modifiers = new int[1];
                OS.GetEventParameter((int)theEvent, (int)1802334052, (int)1835100014, null, (int)4, null, (int[])modifiers);
                if ((modifiers[0] & 0x1000) != 0) {
                    stepSize = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (keyCode[0] == 126 || keyCode[0] == 125) break;
                    xChange = keyCode[0] == 123 ? -stepSize : stepSize;
                } else {
                    if (keyCode[0] == 123 || keyCode[0] == 124) break;
                    yChange = keyCode[0] == 126 ? -stepSize : stepSize;
                }
                Rectangle bounds = this.getBounds();
                int width = bounds.width;
                int height = bounds.height;
                Rectangle parentBounds = this.parent.getBounds();
                int parentWidth = parentBounds.width;
                int parentHeight = parentBounds.height;
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, this.lastX + xChange), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, this.lastY + yChange), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return result;
                }
                Event event = new Event();
                event.x = newX;
                event.y = newY;
                event.width = width;
                event.height = height;
                this.sendEvent(13, event);
                if (this.isDisposed() || !event.doit) break;
                this.setBounds(event.x, event.y, width, height);
                if (this.isDisposed()) break;
                this.lastX = event.x;
                this.lastY = event.y;
                if (this.isDisposed()) {
                    return result;
                }
                int cursorX = event.x;
                int cursorY = event.y;
                if ((this.style & 0x200) != 0) {
                    cursorY += height / 2;
                } else {
                    cursorX += width / 2;
                }
                this.display.setCursorLocation(this.parent.toDisplay(cursorX, cursorY));
            }
        }
        return result;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.sizeCursor != null) {
            this.sizeCursor.dispose();
        }
        this.sizeCursor = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    int traversalCode(int key, int theEvent) {
        return 0;
    }
}

