/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    int lastSelected = -1;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        style = Widget.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (wHint == -1 && this.items.length > 0) {
            Rect bounds;
            boolean fixBounds;
            int width = 0;
            GC gc = new GC(this);
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null) {
                    width += this.items[i].calculateWidth(gc);
                }
                ++i;
            }
            gc.dispose();
            Rect oldBounds = new Rect();
            OS.GetControlBounds((int)this.handle, (Rect)oldBounds);
            boolean bl = fixBounds = oldBounds.right - oldBounds.left < 100 || oldBounds.bottom - oldBounds.top < 100;
            if (fixBounds) {
                bounds = new Rect();
                bounds.bottom = (short)100;
                bounds.right = (short)100;
                OS.SetControlBounds((int)this.handle, (Rect)bounds);
            } else {
                bounds = oldBounds;
            }
            Rect client = new Rect();
            OS.GetTabContentRect((int)this.handle, (Rect)client);
            if (fixBounds) {
                OS.SetControlBounds((int)this.handle, (Rect)oldBounds);
            }
            width += bounds.right - bounds.left - (client.right - client.left);
            Rect inset = this.getInset();
            size.x = Math.max(width += inset.left + inset.right, size.x);
        }
        return size;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rect bounds;
        boolean fixBounds;
        this.checkWidget();
        Rect oldBounds = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)oldBounds);
        boolean bl = fixBounds = oldBounds.right - oldBounds.left < 100 || oldBounds.bottom - oldBounds.top < 100;
        if (fixBounds) {
            bounds = new Rect();
            bounds.bottom = (short)100;
            bounds.right = (short)100;
            OS.SetControlBounds((int)this.handle, (Rect)bounds);
        } else {
            bounds = oldBounds;
        }
        Rect client = new Rect();
        OS.GetTabContentRect((int)this.handle, (Rect)client);
        if (fixBounds) {
            OS.SetControlBounds((int)this.handle, (Rect)oldBounds);
        }
        x -= client.left - bounds.left;
        y -= client.top - bounds.top;
        width += bounds.right - bounds.left - (client.right - client.left);
        height += bounds.bottom - bounds.top - (client.bottom - client.top);
        Rect inset = this.getInset();
        return new Rectangle(x -= inset.left, y -= inset.top, width += inset.left + inset.right, height += inset.top + inset.bottom);
    }

    void createHandle() {
        int[] outControl = new int[1];
        int window = OS.GetControlOwner((int)this.parent.handle);
        short direction = (this.style & 0x400) != 0 ? (short)1 : 0;
        OS.CreateTabsControl((int)window, (Rect)new Rect(), (short)0, (short)direction, (short)0, (int)0, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void createItem(TabItem item, int index) {
        int count = OS.GetControl32BitMaximum((int)this.handle);
        if (index < 0 || index > count) {
            this.error(6);
        }
        OS.SetControl32BitMaximum((int)this.handle, (int)(count + 1));
        if (count == this.items.length) {
            TabItem[] newItems = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, count - index);
        this.items[index] = item;
        if (count == 0) {
            OS.SetControl32BitValue((int)this.handle, (int)1);
            this.lastSelected = 0;
            Event event = new Event();
            event.item = this.items[0];
            this.sendEvent(13, event);
        }
    }

    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    void destroyItem(TabItem item) {
        int count = OS.GetControl32BitMaximum((int)this.handle);
        int index = 0;
        while (index < count) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == count) {
            return;
        }
        int selectionIndex = OS.GetControl32BitValue((int)this.handle) - 1;
        OS.SetControl32BitMaximum((int)this.handle, (int)(--count));
        System.arraycopy(this.items, index + 1, this.items, index, count - index);
        this.items[count] = null;
        if (count == 0) {
            this.items = new TabItem[4];
        }
        if (count > 0 && index == selectionIndex) {
            this.setSelection(Math.max(0, selectionIndex - 1), true);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rect bounds = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)bounds);
        Rect client = new Rect();
        OS.GetControlData((int)this.handle, (short)0, (int)1919247220, (int)8, (Rect)client, null);
        int x = Math.max(0, client.left - bounds.left);
        int y = Math.max(0, client.top - bounds.top);
        int width = Math.max(0, client.right - client.left);
        int height = Math.max(0, client.bottom - client.top);
        return new Rectangle(x, y, width, height);
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        int count = OS.GetControl32BitMaximum((int)this.handle);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.GetControl32BitMaximum((int)this.handle);
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int count = OS.GetControl32BitMaximum((int)this.handle);
        TabItem[] result = new TabItem[count];
        System.arraycopy(this.items, 0, result, 0, count);
        return result;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int index = OS.GetControl32BitValue((int)this.handle) - 1;
        if (index == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[index]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.GetControl32BitValue((int)this.handle) - 1;
    }

    public int indexOf(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int count = OS.GetControl32BitMaximum((int)this.handle);
        int i = 0;
        while (i < count) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    Point minimumSize(int wHint, int hHint, boolean flushCache) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            int index = 0;
            int count = OS.GetControl32BitMaximum((int)this.handle);
            while (index < count) {
                if (this.items[index].control == child) break;
                ++index;
            }
            if (index == count) {
                Rectangle rect = child.getBounds();
                width = Math.max(width, rect.x + rect.width);
                height = Math.max(height, rect.y + rect.height);
            } else {
                Point size = child.computeSize(wHint, hHint, flushCache);
                width = Math.max(width, size.x);
                height = Math.max(height, size.y);
            }
            ++i;
        }
        return new Point(width, height);
    }

    Rect getInset() {
        return (this.style & 0x400) != 0 ? this.display.tabFolderSouthInset : this.display.tabFolderNorthInset;
    }

    int kEventControlApplyBackground(int nextHandler, int theEvent, int userData) {
        return 0;
    }

    int kEventControlHit(int nextHandler, int theEvent, int userData) {
        Control control;
        int result = super.kEventControlHit(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int index = OS.GetControl32BitValue((int)this.handle) - 1;
        if (index == this.lastSelected) {
            return result;
        }
        this.lastSelected = index;
        int count = OS.GetControl32BitMaximum((int)this.handle);
        int i = 0;
        while (i < count) {
            if (i != index && (control = this.items[i].control) != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            ++i;
        }
        TabItem item = null;
        if (index != -1) {
            item = this.items[index];
        }
        if (item != null && (control = item.control) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        Event event = new Event();
        event.item = item;
        this.postEvent(13, event);
        return 0;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        short[] part = new short[1];
        OS.GetEventParameter((int)theEvent, (int)1668313716, (int)1668313716, null, (int)2, null, (short[])part);
        if (part[0] == 0 || part[0] == -1) {
            return super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    void releaseWidget() {
        int count = OS.GetControl32BitMaximum((int)this.handle);
        int i = 0;
        while (i < count) {
            TabItem item = this.items[i];
            if (!item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        super.releaseWidget();
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int count = OS.GetControl32BitMaximum((int)this.handle);
        int i = 0;
        while (i < count) {
            TabItem item = this.items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int index;
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if ((result & 0x80) != 0 && (index = OS.GetControl32BitValue((int)this.handle) - 1) != -1) {
            TabItem item = this.items[index];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
            }
        }
        return result;
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1, false);
        } else {
            int i = items.length - 1;
            while (i >= 0) {
                int index = this.indexOf(items[i]);
                if (index != -1) {
                    this.setSelection(index, false);
                }
                --i;
            }
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        int count = OS.GetControl32BitMaximum((int)this.handle);
        if (index < 0 || index >= count) {
            return;
        }
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        Control control;
        TabItem item;
        if (index >= OS.GetControl32BitMaximum((int)this.handle)) {
            return;
        }
        int currentIndex = OS.GetControl32BitValue((int)this.handle) - 1;
        if (currentIndex != -1 && (item = this.items[currentIndex]) != null && (control = item.control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        OS.SetControl32BitValue((int)this.handle, (int)(index + 1));
        this.lastSelected = index = OS.GetControl32BitValue((int)this.handle) - 1;
        if (index != -1 && (item = this.items[index]) != null) {
            control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (notify) {
                Event event = new Event();
                event.item = item;
                this.sendEvent(13, event);
            }
        }
    }

    boolean traversePage(boolean next) {
        int count = this.getItemCount();
        if (count == 0) {
            return false;
        }
        int index = this.getSelectionIndex();
        if (index == -1) {
            index = 0;
        } else {
            int offset = next ? 1 : -1;
            index = (index + offset + count) % count;
        }
        this.setSelection(index, true);
        return index == this.getSelectionIndex();
    }
}

