/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.carbon.DataBrowserListViewHeaderDesc;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TableColumn
extends Item {
    Table parent;
    int id;
    int lastWidth;
    int lastPosition;
    boolean resizable = true;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getColumnCount());
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        int[] flags = new int[1];
        OS.GetDataBrowserPropertyFlags((int)this.parent.handle, (int)this.id, (int[])flags);
        return (flags[0] & 0x20000) != 0;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public int getWidth() {
        this.checkWidget();
        short[] width = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth((int)this.parent.handle, (int)this.id, (short[])width);
        return Math.max(0, width[0] - 24);
    }

    public void pack() {
        this.checkWidget();
        GC gc = new GC(this.parent);
        int width = gc.stringExtent((String)this.text).x;
        if ((this.parent.style & 0x10000000) == 0) {
            int index = this.parent.indexOf(this);
            int i = 0;
            while (i < this.parent.itemCount) {
                TableItem item = this.parent.items[i];
                if (item != null) {
                    width = Math.max(width, item.calculateWidth(index, gc));
                }
                ++i;
            }
        }
        gc.dispose();
        this.setWidth(width);
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resized(int newWidth) {
        this.lastWidth = newWidth;
        this.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        boolean moved = false;
        int[] order = this.parent.getColumnOrder();
        TableColumn[] columns = this.parent.getColumns();
        int i = 0;
        while (i < order.length) {
            TableColumn column = columns[order[i]];
            if (moved && !column.isDisposed()) {
                column.sendEvent(10);
            }
            if (column == this) {
                moved = true;
            }
            ++i;
        }
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        this.updateHeader();
    }

    public void setImage(Image image) {
        int index;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setImage(image);
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        int[] flags = new int[1];
        OS.GetDataBrowserPropertyFlags((int)this.parent.handle, (int)this.id, (int[])flags);
        flags[0] = moveable ? flags[0] | 0x20000 : flags[0] & 0xFFFDFFFF;
        OS.SetDataBrowserPropertyFlags((int)this.parent.handle, (int)this.id, (int)flags[0]);
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.resizable = resizable;
        this.updateHeader();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        this.updateHeader();
    }

    public void setWidth(int width) {
        this.checkWidget();
        OS.SetDataBrowserTableViewNamedColumnWidth((int)this.parent.handle, (int)this.id, (short)((short)(width += 24)));
        this.updateHeader();
        if (width != this.lastWidth) {
            this.resized(width);
        }
    }

    void updateHeader() {
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        int str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)length);
        if (str == 0) {
            this.error(13);
        }
        DataBrowserListViewHeaderDesc desc = new DataBrowserListViewHeaderDesc();
        desc.version = 0;
        desc.btnFontStyle_just = (short)-2;
        if ((this.style & 0x1000000) != 0) {
            desc.btnFontStyle_just = 1;
        }
        if ((this.style & 0x20000) != 0) {
            desc.btnFontStyle_just = (short)-1;
        }
        desc.btnFontStyle_flags = (short)(desc.btnFontStyle_flags | 0x40);
        if (this.resizable) {
            desc.minimumWidth = 0;
            desc.maximumWidth = Short.MAX_VALUE;
        } else {
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth((int)this.parent.handle, (int)this.id, (short[])width);
            desc.minimumWidth = desc.maximumWidth = width[0];
        }
        desc.titleString = str;
        OS.SetDataBrowserListViewHeaderDesc((int)this.parent.handle, (int)this.id, (DataBrowserListViewHeaderDesc)desc);
        OS.CFRelease((int)str);
    }
}

