/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.text.MessageFormat;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class ViewsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button showTextOnPerspectiveBar;
    private Button dockPerspectiveBar;
    private Button showTraditionalStyleTabs;
    private Button editorTopButton;
    private Button editorBottomButton;
    private Button viewTopButton;
    private Button viewBottomButton;
    int editorAlignment;
    int viewAlignment;
    static final String EDITORS_TITLE = WorkbenchMessages.getString("ViewsPreference.editors");
    private static final String EDITORS_TOP_TITLE = WorkbenchMessages.getString("ViewsPreference.editors.top");
    private static final String EDITORS_BOTTOM_TITLE = WorkbenchMessages.getString("ViewsPreference.editors.bottom");
    private static final String VIEWS_TITLE = WorkbenchMessages.getString("ViewsPreference.views");
    private static final String VIEWS_TOP_TITLE = WorkbenchMessages.getString("ViewsPreference.views.top");
    private static final String VIEWS_BOTTOM_TITLE = WorkbenchMessages.getString("ViewsPreference.views.bottom");
    private Combo themeCombo;

    private Group createButtonGroup(Composite composite, String title) {
        Group buttonComposite = new Group(composite, 0);
        buttonComposite.setText(title);
        buttonComposite.setFont(composite.getFont());
        FormLayout layout = new FormLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        buttonComposite.setLayoutData((Object)data);
        return buttonComposite;
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        WorkbenchHelp.setHelp((Control)parent, "org.eclipse.ui.views_preference_page_context");
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.editorAlignment = store.getInt("EDITOR_TAB_POSITION");
        this.viewAlignment = store.getInt("VIEW_TAB_POSITION");
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createEditorTabButtonGroup(composite);
        this.createViewTabButtonGroup(composite);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        Label label = new Label(composite, 0);
        label.setText(WorkbenchMessages.getString("ViewsPreference.currentTheme"));
        label.setLayoutData((Object)data);
        data = new GridData(256);
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        data.horizontalSpan = 2;
        this.themeCombo = new Combo(composite, 8);
        this.themeCombo.setLayoutData((Object)data);
        this.themeCombo.setFont(parent.getFont());
        this.refreshThemeCombo();
        this.createShowTextOnPerspectiveBarPref(composite);
        this.createDockPerspectiveBarPref(composite);
        this.createShowTraditionalStyleTabsPref(composite);
        return composite;
    }

    private void attachControls(Control leftControl, Control rightControl) {
        FormData leftData = new FormData();
        leftData.left = new FormAttachment(0, 0);
        FormData rightData = new FormData();
        rightData.left = new FormAttachment(leftControl, 5);
        leftControl.setLayoutData((Object)leftData);
        rightControl.setLayoutData((Object)rightData);
    }

    private void createEditorTabButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = this.createButtonGroup(composite, EDITORS_TITLE);
        this.editorTopButton = new Button((Composite)buttonComposite, 16);
        this.editorTopButton.setText(EDITORS_TOP_TITLE);
        this.editorTopButton.setSelection(this.editorAlignment == 128);
        this.editorTopButton.setFont(font);
        this.editorTopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.editorAlignment = 128;
            }
        });
        this.editorTopButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = EDITORS_TITLE;
            }
        });
        this.editorBottomButton = new Button((Composite)buttonComposite, 16);
        this.editorBottomButton.setText(EDITORS_BOTTOM_TITLE);
        this.editorBottomButton.setSelection(this.editorAlignment == 1024);
        this.editorBottomButton.setFont(font);
        this.editorBottomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.editorAlignment = 1024;
            }
        });
        this.attachControls((Control)this.editorTopButton, (Control)this.editorBottomButton);
    }

    private void createViewTabButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = this.createButtonGroup(composite, VIEWS_TITLE);
        buttonComposite.setFont(font);
        this.viewTopButton = new Button((Composite)buttonComposite, 16);
        this.viewTopButton.setText(VIEWS_TOP_TITLE);
        this.viewTopButton.setSelection(this.viewAlignment == 128);
        this.viewTopButton.setFont(font);
        this.viewTopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.viewAlignment = 128;
            }
        });
        this.viewBottomButton = new Button((Composite)buttonComposite, 16);
        this.viewBottomButton.setText(VIEWS_BOTTOM_TITLE);
        this.viewBottomButton.setSelection(this.viewAlignment == 1024);
        this.viewBottomButton.setFont(font);
        this.viewBottomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.viewAlignment = 1024;
            }
        });
        this.attachControls((Control)this.viewTopButton, (Control)this.viewBottomButton);
    }

    private void refreshThemeCombo() {
        this.themeCombo.removeAll();
        ITheme currentTheme = WorkbenchPlugin.getDefault().getWorkbench().getThemeManager().getCurrentTheme();
        IThemeDescriptor[] descs = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        int selection = 0;
        String themeString = WorkbenchMessages.getString("ViewsPreference.defaultTheme");
        if (currentTheme.getId() == null) {
            themeString = MessageFormat.format(WorkbenchMessages.getString("ViewsPreference.currentThemeFormat"), themeString);
        }
        this.themeCombo.add(themeString);
        int i = 0;
        while (i < descs.length) {
            themeString = descs[i].getLabel();
            if (descs[i].getId().equals(currentTheme.getId())) {
                themeString = MessageFormat.format(WorkbenchMessages.getString("ViewsPreference.currentThemeFormat"), themeString);
                selection = i + 1;
            }
            this.themeCombo.add(themeString);
            ++i;
        }
        this.themeCombo.select(selection);
    }

    protected void createShowTextOnPerspectiveBarPref(Composite composite) {
        this.showTextOnPerspectiveBar = new Button(composite, 32);
        this.showTextOnPerspectiveBar.setText(WorkbenchMessages.getString("WorkbenchPreference.showTextOnPerspectiveBar"));
        this.showTextOnPerspectiveBar.setFont(composite.getFont());
        this.showTextOnPerspectiveBar.setSelection(this.getPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
        this.setButtonLayoutData(this.showTextOnPerspectiveBar);
    }

    protected void createDockPerspectiveBarPref(Composite composite) {
        this.dockPerspectiveBar = new Button(composite, 32);
        this.dockPerspectiveBar.setText(WorkbenchMessages.getString("WorkbenchPreference.dockPerspectiveBar"));
        this.dockPerspectiveBar.setFont(composite.getFont());
        this.dockPerspectiveBar.setSelection(this.getPreferenceStore().getBoolean("DOCK_PERSPECTIVE_BAR"));
        this.setButtonLayoutData(this.dockPerspectiveBar);
    }

    protected void createShowTraditionalStyleTabsPref(Composite composite) {
        this.showTraditionalStyleTabs = new Button(composite, 32);
        this.showTraditionalStyleTabs.setText(WorkbenchMessages.getString("ViewsPreference.traditionalTabs"));
        this.showTraditionalStyleTabs.setFont(composite.getFont());
        this.showTraditionalStyleTabs.setSelection(this.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        this.setButtonLayoutData(this.showTraditionalStyleTabs);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.showTextOnPerspectiveBar.setSelection(store.getDefaultBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
        this.dockPerspectiveBar.setSelection(store.getDefaultBoolean("DOCK_PERSPECTIVE_BAR"));
        this.showTraditionalStyleTabs.setSelection(store.getDefaultBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        int editorTopValue = store.getDefaultInt("EDITOR_TAB_POSITION");
        this.editorTopButton.setSelection(editorTopValue == 128);
        this.editorBottomButton.setSelection(editorTopValue == 1024);
        this.editorAlignment = editorTopValue;
        int viewTopValue = store.getDefaultInt("VIEW_TAB_POSITION");
        this.viewTopButton.setSelection(viewTopValue == 128);
        this.viewBottomButton.setSelection(viewTopValue == 1024);
        this.viewAlignment = viewTopValue;
        WorkbenchPlugin.getDefault().savePluginPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("SHOW_TEXT_ON_PERSPECTIVE_BAR", this.showTextOnPerspectiveBar.getSelection());
        store.setValue("DOCK_PERSPECTIVE_BAR", this.dockPerspectiveBar.getSelection());
        store.setValue("SHOW_TRADITIONAL_STYLE_TABS", this.showTraditionalStyleTabs.getSelection());
        store.setValue("EDITOR_TAB_POSITION", this.editorAlignment);
        store.setValue("VIEW_TAB_POSITION", this.viewAlignment);
        int idx = this.themeCombo.getSelectionIndex();
        if (idx == 0) {
            Workbench.getInstance().getThemeManager().setCurrentTheme(IThemeManager.DEFAULT_THEME);
        } else {
            Workbench.getInstance().getThemeManager().setCurrentTheme(WorkbenchPlugin.getDefault().getThemeRegistry().getThemes()[idx - 1].getId());
        }
        this.refreshThemeCombo();
        return true;
    }
}

