/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;

public abstract class Action
implements IAction {
    private static final String VAL_PUSH_BTN = "PUSH_BTN";
    private static final Integer VAL_RADIO_BTN_ON = new Integer(1);
    private static final Integer VAL_RADIO_BTN_OFF = new Integer(0);
    private static final Boolean VAL_TOGGLE_BTN_ON = Boolean.TRUE;
    private static final Boolean VAL_TOGGLE_BTN_OFF = Boolean.FALSE;
    private static final IMenuCreator VAL_DROP_DOWN_MENU = new IMenuCreator(){

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            return null;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    };
    private static Map keyCodes = null;
    private static Map localizedKeyCodes = null;
    private static String LOCALIZED_CTRL;
    private static String LOCALIZED_SHIFT;
    private static String LOCALIZED_ALT;
    private static String LOCALIZED_COMMAND;
    private static Map keyStrings;
    private ListenerList listeners = new ListenerList(3);
    private String text;
    private String description;
    private String id;
    private String actionDefinitionId;
    private String toolTipText;
    private HelpListener helpListener;
    private ImageDescriptor image;
    private ImageDescriptor hoverImage;
    private ImageDescriptor disabledImage;
    private Object value = null;
    private int accelerator = 0;
    private boolean enabled = true;

    static {
        keyStrings = null;
    }

    protected Action() {
    }

    protected Action(String text) {
        this();
        this.setText(text);
    }

    protected Action(String text, ImageDescriptor image) {
        this(text);
        this.setImageDescriptor(image);
    }

    protected Action(String text, int style) {
        this(text);
        switch (style) {
            case 1: {
                this.value = VAL_PUSH_BTN;
                break;
            }
            case 2: {
                this.value = VAL_TOGGLE_BTN_OFF;
                break;
            }
            case 4: {
                this.value = VAL_DROP_DOWN_MENU;
                break;
            }
            case 8: {
                this.value = VAL_RADIO_BTN_OFF;
            }
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    private static int convertLocalizedAccelerator(String acceleratorText) {
        int accelerator = 0;
        StringTokenizer stok = new StringTokenizer(acceleratorText, "+");
        int keyCode = -1;
        boolean hasMoreTokens = stok.hasMoreTokens();
        while (hasMoreTokens) {
            String token = stok.nextToken();
            hasMoreTokens = stok.hasMoreTokens();
            if (hasMoreTokens) {
                int modifier = Action.findLocalizedModifier(token);
                if (modifier != 0) {
                    accelerator |= modifier;
                    continue;
                }
                return 0;
            }
            keyCode = Action.findLocalizedKeyCode(token);
        }
        if (keyCode != -1) {
            accelerator |= keyCode;
        }
        return accelerator;
    }

    public static int convertAccelerator(String acceleratorText) {
        int accelerator = 0;
        StringTokenizer stok = new StringTokenizer(acceleratorText, "+");
        int keyCode = -1;
        boolean hasMoreTokens = stok.hasMoreTokens();
        while (hasMoreTokens) {
            String token = stok.nextToken();
            hasMoreTokens = stok.hasMoreTokens();
            if (hasMoreTokens) {
                int modifier = Action.findModifier(token);
                if (modifier != 0) {
                    accelerator |= modifier;
                    continue;
                }
                return 0;
            }
            keyCode = Action.findKeyCode(token);
        }
        if (keyCode != -1) {
            accelerator |= keyCode;
        }
        return accelerator;
    }

    public static String convertAccelerator(int keyCode) {
        String modifier = Action.getModifierString(keyCode);
        String fullKey = modifier.equals("") ? Action.findKeyString(keyCode) : String.valueOf(modifier) + "+" + Action.findKeyString(keyCode);
        return fullKey;
    }

    private static String getModifierString(int keyCode) {
        String modString = "";
        if ((keyCode & 0x40000) != 0) {
            modString = Action.findModifierString(keyCode & 0x40000);
        }
        if ((keyCode & 0x10000) != 0) {
            modString = modString.equals("") ? Action.findModifierString(keyCode & 0x10000) : String.valueOf(modString) + "+" + Action.findModifierString(keyCode & 0x10000);
        }
        if ((keyCode & 0x20000) != 0) {
            modString = modString.equals("") ? Action.findModifierString(keyCode & 0x20000) : String.valueOf(modString) + "+" + Action.findModifierString(keyCode & 0x20000);
        }
        if ((keyCode & 0x400000) != 0) {
            modString = modString.equals("") ? Action.findModifierString(keyCode & 0x400000) : String.valueOf(modString) + "+" + Action.findModifierString(keyCode & 0x400000);
        }
        return modString;
    }

    private static String extractAcceleratorText(String text) {
        int index = text.lastIndexOf(9);
        if (index == -1) {
            index = text.lastIndexOf(64);
        }
        if (index >= 0) {
            return text.substring(index + 1);
        }
        return null;
    }

    public static int findKeyCode(String token) {
        Integer i;
        if (keyCodes == null) {
            Action.initKeyCodes();
        }
        if ((i = (Integer)keyCodes.get(token = token.toUpperCase())) != null) {
            return i;
        }
        if (token.length() == 1) {
            return token.charAt(0);
        }
        return -1;
    }

    private static int findLocalizedKeyCode(String token) {
        Integer i;
        if (localizedKeyCodes == null) {
            Action.initLocalizedKeyCodes();
        }
        if ((i = (Integer)localizedKeyCodes.get(token = token.toUpperCase())) != null) {
            return i;
        }
        if (token.length() == 1) {
            return token.charAt(0);
        }
        return -1;
    }

    public static String findKeyString(int keyCode) {
        int i;
        Integer integer;
        String result;
        if (keyStrings == null) {
            Action.initKeyStrings();
        }
        if ((result = (String)keyStrings.get(integer = new Integer(i = keyCode & 0xFFB8FFFF))) != null) {
            return result;
        }
        result = new String(new char[]{(char)i});
        return result;
    }

    public static int findModifier(String token) {
        if ((token = token.toUpperCase()).equals("CTRL")) {
            return 262144;
        }
        if (token.equals("SHIFT")) {
            return 131072;
        }
        if (token.equals("ALT")) {
            return 65536;
        }
        if (token.equals("COMMAND")) {
            return 0x400000;
        }
        return 0;
    }

    private static int findLocalizedModifier(String token) {
        if (LOCALIZED_CTRL == null) {
            Action.initLocalizedModifiers();
        }
        if ((token = token.toUpperCase()).equals(LOCALIZED_CTRL)) {
            return 262144;
        }
        if (token.equals(LOCALIZED_SHIFT)) {
            return 131072;
        }
        if (token.equals(LOCALIZED_ALT)) {
            return 65536;
        }
        if (token.equals(LOCALIZED_COMMAND)) {
            return 0x400000;
        }
        return 0;
    }

    private static void initLocalizedModifiers() {
        LOCALIZED_CTRL = JFaceResources.getString("Ctrl").toUpperCase();
        LOCALIZED_SHIFT = JFaceResources.getString("Shift").toUpperCase();
        LOCALIZED_ALT = JFaceResources.getString("Alt").toUpperCase();
        LOCALIZED_COMMAND = JFaceResources.getString("Command").toUpperCase();
    }

    public static String findModifierString(int keyCode) {
        if (keyCode == 262144) {
            return JFaceResources.getString("Ctrl");
        }
        if (keyCode == 65536) {
            return JFaceResources.getString("Alt");
        }
        if (keyCode == 131072) {
            return JFaceResources.getString("Shift");
        }
        if (keyCode == 0x400000) {
            return JFaceResources.getString("Command");
        }
        return null;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty()) {
            this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        Object[] listeners = this.listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    public int getAccelerator() {
        return this.accelerator;
    }

    public String getActionDefinitionId() {
        return this.actionDefinitionId;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.getToolTipText();
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return this.disabledImage;
    }

    public HelpListener getHelpListener() {
        return this.helpListener;
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this.hoverImage;
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.image;
    }

    public IMenuCreator getMenuCreator() {
        if (this.value == VAL_DROP_DOWN_MENU) {
            return null;
        }
        if (this.value instanceof IMenuCreator) {
            return (IMenuCreator)this.value;
        }
        return null;
    }

    public int getStyle() {
        if (this.value == VAL_PUSH_BTN || this.value == null) {
            return 1;
        }
        if (this.value == VAL_TOGGLE_BTN_ON || this.value == VAL_TOGGLE_BTN_OFF) {
            return 2;
        }
        if (this.value == VAL_RADIO_BTN_ON || this.value == VAL_RADIO_BTN_OFF) {
            return 8;
        }
        if (this.value instanceof IMenuCreator) {
            return 4;
        }
        return 1;
    }

    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    private static void initKeyCodes() {
        keyCodes = new HashMap(40);
        keyCodes.put("BACKSPACE", new Integer(8));
        keyCodes.put("TAB", new Integer(9));
        keyCodes.put("RETURN", new Integer(13));
        keyCodes.put("ENTER", new Integer(13));
        keyCodes.put("ESCAPE", new Integer(27));
        keyCodes.put("ESC", new Integer(27));
        keyCodes.put("DELETE", new Integer(127));
        keyCodes.put("SPACE", new Integer(32));
        keyCodes.put("ARROW_UP", new Integer(0x1000001));
        keyCodes.put("ARROW_DOWN", new Integer(0x1000002));
        keyCodes.put("ARROW_LEFT", new Integer(0x1000003));
        keyCodes.put("ARROW_RIGHT", new Integer(0x1000004));
        keyCodes.put("PAGE_UP", new Integer(0x1000005));
        keyCodes.put("PAGE_DOWN", new Integer(0x1000006));
        keyCodes.put("HOME", new Integer(0x1000007));
        keyCodes.put("END", new Integer(0x1000008));
        keyCodes.put("INSERT", new Integer(0x1000009));
        keyCodes.put("F1", new Integer(0x100000A));
        keyCodes.put("F2", new Integer(0x100000B));
        keyCodes.put("F3", new Integer(0x100000C));
        keyCodes.put("F4", new Integer(0x100000D));
        keyCodes.put("F5", new Integer(0x100000E));
        keyCodes.put("F6", new Integer(0x100000F));
        keyCodes.put("F7", new Integer(0x1000010));
        keyCodes.put("F8", new Integer(0x1000011));
        keyCodes.put("F9", new Integer(0x1000012));
        keyCodes.put("F10", new Integer(0x1000013));
        keyCodes.put("F11", new Integer(0x1000014));
        keyCodes.put("F12", new Integer(0x1000015));
    }

    private static void initLocalizedKeyCodes() {
        localizedKeyCodes = new HashMap(40);
        localizedKeyCodes.put(JFaceResources.getString("Backspace").toUpperCase(), new Integer(8));
        localizedKeyCodes.put(JFaceResources.getString("Tab").toUpperCase(), new Integer(9));
        localizedKeyCodes.put(JFaceResources.getString("Return").toUpperCase(), new Integer(13));
        localizedKeyCodes.put(JFaceResources.getString("Enter").toUpperCase(), new Integer(13));
        localizedKeyCodes.put(JFaceResources.getString("Escape").toUpperCase(), new Integer(27));
        localizedKeyCodes.put(JFaceResources.getString("Esc").toUpperCase(), new Integer(27));
        localizedKeyCodes.put(JFaceResources.getString("Delete").toUpperCase(), new Integer(127));
        localizedKeyCodes.put(JFaceResources.getString("Space").toUpperCase(), new Integer(32));
        localizedKeyCodes.put(JFaceResources.getString("Arrow_Up").toUpperCase(), new Integer(0x1000001));
        localizedKeyCodes.put(JFaceResources.getString("Arrow_Down").toUpperCase(), new Integer(0x1000002));
        localizedKeyCodes.put(JFaceResources.getString("Arrow_Left").toUpperCase(), new Integer(0x1000003));
        localizedKeyCodes.put(JFaceResources.getString("Arrow_Right").toUpperCase(), new Integer(0x1000004));
        localizedKeyCodes.put(JFaceResources.getString("Page_Up").toUpperCase(), new Integer(0x1000005));
        localizedKeyCodes.put(JFaceResources.getString("Page_Down").toUpperCase(), new Integer(0x1000006));
        localizedKeyCodes.put(JFaceResources.getString("Home").toUpperCase(), new Integer(0x1000007));
        localizedKeyCodes.put(JFaceResources.getString("End").toUpperCase(), new Integer(0x1000008));
        localizedKeyCodes.put(JFaceResources.getString("Insert").toUpperCase(), new Integer(0x1000009));
        localizedKeyCodes.put(JFaceResources.getString("F1").toUpperCase(), new Integer(0x100000A));
        localizedKeyCodes.put(JFaceResources.getString("F2").toUpperCase(), new Integer(0x100000B));
        localizedKeyCodes.put(JFaceResources.getString("F3").toUpperCase(), new Integer(0x100000C));
        localizedKeyCodes.put(JFaceResources.getString("F4").toUpperCase(), new Integer(0x100000D));
        localizedKeyCodes.put(JFaceResources.getString("F5").toUpperCase(), new Integer(0x100000E));
        localizedKeyCodes.put(JFaceResources.getString("F6").toUpperCase(), new Integer(0x100000F));
        localizedKeyCodes.put(JFaceResources.getString("F7").toUpperCase(), new Integer(0x1000010));
        localizedKeyCodes.put(JFaceResources.getString("F8").toUpperCase(), new Integer(0x1000011));
        localizedKeyCodes.put(JFaceResources.getString("F9").toUpperCase(), new Integer(0x1000012));
        localizedKeyCodes.put(JFaceResources.getString("F10").toUpperCase(), new Integer(0x1000013));
        localizedKeyCodes.put(JFaceResources.getString("F11").toUpperCase(), new Integer(0x1000014));
        localizedKeyCodes.put(JFaceResources.getString("F12").toUpperCase(), new Integer(0x1000015));
    }

    private static void initKeyStrings() {
        keyStrings = new HashMap(40);
        keyStrings.put(new Integer(8), JFaceResources.getString("Backspace"));
        keyStrings.put(new Integer(9), JFaceResources.getString("Tab"));
        keyStrings.put(new Integer(13), JFaceResources.getString("Return"));
        keyStrings.put(new Integer(13), JFaceResources.getString("Enter"));
        keyStrings.put(new Integer(27), JFaceResources.getString("Escape"));
        keyStrings.put(new Integer(27), JFaceResources.getString("Esc"));
        keyStrings.put(new Integer(127), JFaceResources.getString("Delete"));
        keyStrings.put(new Integer(32), JFaceResources.getString("Space"));
        keyStrings.put(new Integer(0x1000001), JFaceResources.getString("Arrow_Up"));
        keyStrings.put(new Integer(0x1000002), JFaceResources.getString("Arrow_Down"));
        keyStrings.put(new Integer(0x1000003), JFaceResources.getString("Arrow_Left"));
        keyStrings.put(new Integer(0x1000004), JFaceResources.getString("Arrow_Right"));
        keyStrings.put(new Integer(0x1000005), JFaceResources.getString("Page_Up"));
        keyStrings.put(new Integer(0x1000006), JFaceResources.getString("Page_Down"));
        keyStrings.put(new Integer(0x1000007), JFaceResources.getString("Home"));
        keyStrings.put(new Integer(0x1000008), JFaceResources.getString("End"));
        keyStrings.put(new Integer(0x1000009), JFaceResources.getString("Insert"));
        keyStrings.put(new Integer(0x100000A), JFaceResources.getString("F1"));
        keyStrings.put(new Integer(0x100000B), JFaceResources.getString("F2"));
        keyStrings.put(new Integer(0x100000C), JFaceResources.getString("F3"));
        keyStrings.put(new Integer(0x100000D), JFaceResources.getString("F4"));
        keyStrings.put(new Integer(0x100000E), JFaceResources.getString("F5"));
        keyStrings.put(new Integer(0x100000F), JFaceResources.getString("F6"));
        keyStrings.put(new Integer(0x1000010), JFaceResources.getString("F7"));
        keyStrings.put(new Integer(0x1000011), JFaceResources.getString("F8"));
        keyStrings.put(new Integer(0x1000012), JFaceResources.getString("F9"));
        keyStrings.put(new Integer(0x1000013), JFaceResources.getString("F10"));
        keyStrings.put(new Integer(0x1000014), JFaceResources.getString("F11"));
        keyStrings.put(new Integer(0x1000015), JFaceResources.getString("F12"));
    }

    public boolean isChecked() {
        return this.value == VAL_TOGGLE_BTN_ON || this.value == VAL_RADIO_BTN_ON;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static String removeAcceleratorText(String text) {
        int index = text.lastIndexOf(9);
        if (index == -1) {
            index = text.lastIndexOf(64);
        }
        if (index >= 0) {
            return text.substring(0, index);
        }
        return text;
    }

    public static String removeMnemonics(String text) {
        int index = text.indexOf(38);
        if (index == -1) {
            return text;
        }
        int len = text.length();
        StringBuffer sb = new StringBuffer(len);
        int lastIndex = 0;
        while (index != -1) {
            if (index == len - 1) break;
            if (text.charAt(index + 1) == '&') {
                ++index;
            }
            sb.append(text.substring(lastIndex, index));
            lastIndex = ++index;
            index = text.indexOf(38, index);
        }
        if (lastIndex < len) {
            sb.append(text.substring(lastIndex, len));
        }
        return sb.toString();
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void run() {
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    public void setActionDefinitionId(String id) {
        this.actionDefinitionId = id;
    }

    public void setChecked(boolean checked) {
        Comparable<Boolean> newValue = null;
        if (this.value == null || this.value == VAL_TOGGLE_BTN_ON || this.value == VAL_TOGGLE_BTN_OFF) {
            newValue = checked ? VAL_TOGGLE_BTN_ON : VAL_TOGGLE_BTN_OFF;
        } else if (this.value == VAL_RADIO_BTN_ON || this.value == VAL_RADIO_BTN_OFF) {
            newValue = checked ? VAL_RADIO_BTN_ON : VAL_RADIO_BTN_OFF;
        } else {
            return;
        }
        if (newValue != this.value) {
            this.value = newValue;
            if (checked) {
                this.firePropertyChange("checked", Boolean.FALSE, Boolean.TRUE);
            } else {
                this.firePropertyChange("checked", Boolean.TRUE, Boolean.FALSE);
            }
        }
    }

    public void setDescription(String text) {
        if (this.description == null && text != null || this.description != null && text == null || this.description != null && text != null && !text.equals(this.description)) {
            String oldDescription = this.description;
            this.description = text;
            this.firePropertyChange("description", oldDescription, this.description);
        }
    }

    public void setDisabledImageDescriptor(ImageDescriptor newImage) {
        if (this.disabledImage != newImage) {
            ImageDescriptor oldImage = this.disabledImage;
            this.disabledImage = newImage;
            this.firePropertyChange("image", oldImage, newImage);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            Boolean oldVal = this.enabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean newVal = enabled ? Boolean.TRUE : Boolean.FALSE;
            this.enabled = enabled;
            this.firePropertyChange("enabled", oldVal, newVal);
        }
    }

    public void setHelpListener(HelpListener listener) {
        this.helpListener = listener;
    }

    public void setHoverImageDescriptor(ImageDescriptor newImage) {
        if (this.hoverImage != newImage) {
            ImageDescriptor oldImage = this.hoverImage;
            this.hoverImage = newImage;
            this.firePropertyChange("image", oldImage, newImage);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setImageDescriptor(ImageDescriptor newImage) {
        if (this.image != newImage) {
            ImageDescriptor oldImage = this.image;
            this.image = newImage;
            this.firePropertyChange("image", oldImage, newImage);
        }
    }

    public void setMenuCreator(IMenuCreator creator) {
        if (this.value == null) {
            this.value = creator;
            return;
        }
        if (this.value instanceof IMenuCreator) {
            this.value = creator == null ? VAL_DROP_DOWN_MENU : creator;
        }
    }

    public void setText(String text) {
        int newAccelerator;
        String acceleratorText;
        String oldText = this.text;
        int oldAccel = this.accelerator;
        this.text = text;
        if (text != null && (acceleratorText = Action.extractAcceleratorText(text)) != null && (newAccelerator = Action.convertLocalizedAccelerator(acceleratorText)) > 0) {
            this.setAccelerator(newAccelerator);
        }
        if (this.accelerator != oldAccel || (oldText == null ? this.text != null : !oldText.equals(this.text))) {
            this.firePropertyChange("text", oldText, this.text);
        }
    }

    public void setToolTipText(String toolTipText) {
        String oldToolTipText = this.toolTipText;
        if (oldToolTipText == null ? toolTipText != null : !oldToolTipText.equals(toolTipText)) {
            this.toolTipText = toolTipText;
            this.firePropertyChange("toolTipText", oldToolTipText, toolTipText);
        }
    }

    public void setAccelerator(int keycode) {
        this.accelerator = keycode;
    }
}

