/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Checkbox.java,v $
   Revision 1.5  2005/01/05 09:22:24  bobintetley
   Updated copyright year on source

   Revision 1.4  2004/06/10 07:57:57  dannaab
   Added AWTSwingWrapper to map AWT components to the corresponding Swing version.  Implemted using it: TextComponent, TextArea, TextField; used similar technique for Menu components

   Revision 1.3  2004/03/12 16:35:13  bobintetley
   AWT CheckboxGroup support and fix for incorrectly named AWT Scrollbar

   Revision 1.2  2004/01/20 07:38:05  bobintetley
   Bug fixes and compatibility methods

   Revision 1.1  2004/01/15 15:20:29  bobintetley
   Java2D work


*/

package swingwt.awt;

public class Checkbox extends swingwtx.swing.JCheckBox {
    public Checkbox() { super(); }
    public Checkbox(String text) { super(text); }
    public Checkbox(String text, boolean b) { super(text, b); }
    public Checkbox(String text, CheckboxGroup cbg, boolean b) {
        this(text, b, cbg);
    }
    public Checkbox(String text, boolean b, CheckboxGroup cbg) {
        super(text, b, cbg);
        cbg.add(this);
    }

    public boolean getState() { return super.isSelected(); }
    public void setState(boolean b) { super.setSelected(b); }
}
