/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Frame.java,v $
   Revision 1.11  2005/01/05 09:22:25  bobintetley
   Updated copyright year on source

   Revision 1.10  2004/06/11 03:29:26  dannaab
   AWT improvements: implement Button over JButton; Menu fixes; add missing geom me
   thods; add some missing awt event methods/features

   Revision 1.9  2004/05/26 04:46:06  dannaab
   Changed how Window/Dialog/Frame are initialized.
   Now, the SWT peer's instantiation is delayed until setVisible(true).  This
   has the benefit of allowing Swing's setter methods that can only be set via
   the SWT Shell peer's construction (ie, setResizable(), setModel())

   Revision 1.8  2004/05/06 12:35:21  bobintetley
   Parity with Swing constants for Binary Compatibility + fixes to JDesktopPane

   Revision 1.7  2004/04/16 10:19:06  dannaab
   Misc bug fixes, InputMap implementation, preliminary undo support

   Revision 1.6  2004/03/22 15:10:21  bobintetley
   JRootPane and JLayeredPane implementation

   Revision 1.5  2004/03/18 14:42:10  bobintetley
   Fix to Window hierarchy to match Swing, and fix to allow MDI apps
      to work under SWT 2.x

   Revision 1.4  2004/01/15 10:11:14  bobintetley
   Fixed AWT constructors/hierarchy

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwt.awt;

import org.eclipse.swt.SWT;

/**
 * note: MenuContainer methods are actually implemented in Window, contrary to AWT/Swing.
 * Still, add the interface here.
 */
public class Frame extends Window implements MenuContainer {
    
    public final static int NORMAL = 0;
    public final static int ICONIFIED = 1;
    public final static int MAXIMIZED_HORIZ = 2;
    public final static int MAXIMIZED_VERT = 4;
    public final static int MAXIMIZED_BOTH = MAXIMIZED_HORIZ | MAXIMIZED_VERT;
    
    protected boolean isResizable = true;
    
    public Frame() {
        this("");
    }
    public Frame(GraphicsConfiguration gc) { this(); }
    public Frame(String title) { super((Frame)null); setTitle(title); }
    
    protected int getSWTFrameType()
    {
        int SWTFrameType = SWT.SHELL_TRIM;
        SWTFrameType |= isResizable ? SWT.RESIZE : 0;
        return SWTFrameType;
    }
    
    public void setResizable(boolean b) { this.isResizable = b; }
    public boolean isResizable() { return isResizable; }
    
    public void remove(MenuComponent menuComponent) { pMenuBar.remove(menuComponent); }
}
