/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: AbstractListModel.java,v $
   Revision 1.5  2005/01/05 09:22:30  bobintetley
   Updated copyright year on source

   Revision 1.4  2004/01/27 09:05:09  bobintetley
   ListModel and List Selection implemented. ScrollPane fix so all components
      scrollable

   Revision 1.3  2003/12/15 17:41:16  bobintetley
   Missing return value fixed

   Revision 1.2  2003/12/15 17:39:11  bobintetley
   Missing implementations completed

   Revision 1.1  2003/12/15 17:37:18  bobintetley
   ComboBox model interfaces and support


*/

package swingwtx.swing;

import java.util.*;
import swingwtx.swing.event.*;

public abstract class AbstractListModel implements ListModel {
    
    protected Vector listenerList = new Vector();

    public void addListDataListener(ListDataListener l) {
	listenerList.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
	listenerList.remove(l);
    }

    public Object[] getListDataListeners() {
        return listenerList.toArray();
    }
    
    protected void fireContentsChanged(Object source, int index0, int index1) {
	ListDataEvent e = new ListDataEvent(source, ListDataEvent.CONTENTS_CHANGED, index0, index1);
	for (int i = 0; i < listenerList.size(); i++) {
            ((ListDataListener) listenerList.get(i)).contentsChanged(e);       
	}
    }

    protected void fireIntervalAdded(Object source, int index0, int index1) {
	ListDataEvent e = new ListDataEvent(source, ListDataEvent.INTERVAL_ADDED, index0, index1);
	for (int i = 0; i < listenerList.size(); i++) {
            ((ListDataListener) listenerList.get(i)).intervalAdded(e);       
	}
    }

    protected void fireIntervalRemoved(Object source, int index0, int index1) {
	ListDataEvent e = new ListDataEvent(source, ListDataEvent.INTERVAL_REMOVED, index0, index1);
	for (int i = 0; i < listenerList.size(); i++) {
            ((ListDataListener) listenerList.get(i)).intervalRemoved(e);       
	}
    }

    public Object[] getListeners(Class listenerType) { 
	return listenerList.toArray(); 
    }
}

