/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.
   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JMenuBar.java,v $
   Revision 1.23  2005/02/22 17:47:38  bobintetley
   Fixed ConcurrentModification problem with menu items

   Revision 1.22  2005/02/16 08:34:36  bobintetley
   JFileChooser.showDialog support, JOptionPane instance support (no dialog creation at present), JSplitPane.getDividerLocation(), PixelGrabber.grabPixels(ms) throws InterruptedException, swingwtx.swing.MenuElement implemented, with JMenu* implementors, JPopupMenu.getSubElements(), JMenuBar.getSubElements(), JMenu.getSubElements()

   Revision 1.21  2005/01/05 09:22:31  bobintetley
   Updated copyright year on source

   Revision 1.20  2005/01/05 08:37:13  bobintetley
   Many compatibility fixes from David Barron

   Revision 1.19  2004/09/07 14:18:39  bobintetley
   JScrollPane fixes to Dan's Viewport work, additional compatibility add methods for JMenuBar
   JTable cell rendering fixes - DefaultCellRenderer clears itself prior to use to prevent
   images being rendered across all columns when using the default renderer

   Revision 1.18  2004/06/10 07:57:59  dannaab
   Added AWTSwingWrapper to map AWT components to the corresponding Swing version.  Implemted using it: TextComponent, TextArea, TextField; used similar technique for Menu components

   Revision 1.17  2004/05/05 12:43:21  bobintetley
   Patches/new files from Laurent Martell

   Revision 1.16  2004/05/01 09:33:39  bobintetley
   Removed broken impor

   Revision 1.15  2004/04/30 23:18:26  dannaab
   List selection support, misc bug fixes

   Revision 1.14  2004/04/30 16:52:17  bobintetley
   MenuListener support, JViewport support, TreeSelectionModel stubs, additional JTree methods

   Revision 1.13  2004/02/19 09:58:44  bobintetley
   Various small bug fixes and JTextArea should be much faster/lighter

   Revision 1.12  2004/01/26 14:05:23  bobintetley
   Compatibility methods

   Revision 1.11  2004/01/26 08:11:00  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.10  2004/01/20 09:17:15  bobintetley
   Menu class overhaul for compatibility, Action support and thread safety

   Revision 1.9  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications

   Revision 1.8  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import swingwt.awt.Component;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

import java.util.*;

public class JMenuBar extends JComponent implements MenuElement {
    
    /** The SWT menu this container represents */
    protected Menu menu = null;
    /** Stores children until we're ready */
    protected Vector components = new Vector();
    /** The SWT shell this MenuBar is attached to */
    protected Shell shell = null;
    private Object retval;

    private int iRetval;
    
    public JMenuBar() {
    }

    /** Adds a component to the container */
    public JSWTMenuComponent add(final JSWTMenuComponent c) {
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                try { 
                    components.add(c);
                    if (menu != null) {
                        c.setSwingWTParent(menu, shell);
                        c.setCachedProperties();
                        c.registerEvents();
                    }
                } 
                catch (Exception e) {
                    e.printStackTrace();
                } 
            }
        });
        return c;
    }
    
    public JMenu add(JMenu c) {
        return (JMenu) add((JSWTMenuComponent) c);    
    }
    
    public JMenuItem add(JMenuItem c) {
        return (JMenuItem) add((JSWTMenuComponent) c);    
    }
    
    public Component add(Component c) {
        if (c instanceof JSWTMenuComponent)
            return add(((JSWTMenuComponent) c));
        else
            return c;
    }
    
        
    public void remove(JSWTMenuComponent c) {
        c.dispose();    
    }
    
    public void setVisible(final boolean b) {
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (menu != null)
                    menu.setVisible(b);
            }
        });
    }
    
    public boolean isVisible() {
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (menu != null)
                    retval = new Boolean(menu.isVisible());
                else
                    retval = new Boolean(false);
            }
        });
        return ((Boolean) retval).booleanValue();
    }
    
    public swingwt.awt.Dimension getPreferredSize() {
        return new swingwt.awt.Dimension(0, 0);    
    }
    
    public void addSeparator() { 
        add(new JSeparator());
    }
    
    public Menu getSWTMenu() {
        return menu;
    }
    
    public void setSwingWTParent(Shell parent) {
        shell = parent;
        menu = new Menu(parent, SWT.BAR);    
        parent.setMenuBar(menu);
        
        // If we have some children waiting to be added, do it now
        if (components.size() > 0) {
	     Object[] o = components.toArray();
	     for (int i = 0; i < o.length; i++) {
		     add((JSWTMenuComponent) o[i]);
             }
        }
    }
    
    public JMenuItem getItem(final int index) {
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTControlAvailable(shell))
                    retval = menu.getItem(index);
                else
                    retval = components.get(index);
            }
        });
        return (JMenuItem) retval;
    }
    
    public int getItemCount() {
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTControlAvailable(shell))
                    iRetval = menu.getItemCount();
                else
                    iRetval = components.size();
            }
        });
        return iRetval;
    }

    public int getMenuCount() {
        // TODO
        return getItemCount();
    }

    public JMenu getMenu(final int index) {
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTControlAvailable(shell))
                    retval = menu.getItem(index);
                else
                    retval = components.get(index);
            }
        });
        return (JMenu) retval;
    }
    
    public Component getComponent() {
        return (Component) this;
    }
    
    public MenuElement[] getSubElements() {
        MenuElement[] me = new MenuElement[components.size()];
        for (int i = 0; i < components.size(); i++) {
            me[i] = (MenuElement) components.get(i);
        }
        return me;
    }
    
    public void menuSelectionChanged(boolean isIncluded) {
    }
    
    public void processKeyEvent(swingwt.awt.event.KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }
    
    public void processMouseEvent(swingwt.awt.event.MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }
    
}
