/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JToggleButton.java,v $
   Revision 1.10  2005/01/05 09:22:32  bobintetley
   Updated copyright year on source

   Revision 1.9  2005/01/05 08:37:13  bobintetley
   Many compatibility fixes from David Barron

   Revision 1.8  2004/09/17 19:15:24  dannaab
   Add SWT custom params to buttons; optimize some imports

   Revision 1.7  2004/04/28 08:38:12  bobintetley
   Hierarchy fixes, code cleanup for base classes, additional javadocs and use of flag to identify JComponent descendants with peers

   Revision 1.6  2004/03/30 10:42:46  bobintetley
   Many minor bug fixes, event improvements by Dan Naab. Full swing.Icon support

   Revision 1.5  2004/02/13 15:09:23  bobintetley
   JComboBox/Abstract button non-peer selection and JTable threading fixed

   Revision 1.4  2004/01/26 08:11:00  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.3  2004/01/20 07:38:05  bobintetley
   Bug fixes and compatibility methods

   Revision 1.2  2003/12/22 09:18:40  bobintetley
   Icon support for JToggleButton

   Revision 1.1  2003/12/22 09:17:21  bobintetley
   Added JToggleButton support

   
*/


package swingwtx.swing;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

import swingwt.awt.event.*;

import java.util.*;

public class JToggleButton extends swingwtx.swing.AbstractButton implements ButtonModel, SwingConstants {
    
    protected Icon pImage = null;
    
    /** boolean thread safe accessor */
    private boolean bRetVal;
    
    public JToggleButton() {this(""); }
    public JToggleButton(String text) { pText = text; setModel(this);  showMnemonic(); }
    public JToggleButton(String text, Icon icon) { pText = text; pImage = icon; setModel(this);  showMnemonic(); }
    
    public JToggleButton(String title, boolean selected) {
        this(title);
        setSelected(selected);
    }
    
    public void setIcon(Icon icon) { 
        pImage = icon;
        final JToggleButton pthis = this;
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTControlAvailable(ppeer)) 
                    ppeer.setImage(SwingWTUtils.getSWTImageFromSwingIcon(pthis, pImage)); 
            }
        });
    }
    
    /**
     *  Sends mouse events to component listeners 
     *  Overriden from Component to handle ItemEvents
     */
    public void processMouseEvent(MouseEvent e) {
        Iterator i = mouseListeners.iterator();
        while (i.hasNext()) {
            MouseListener ml = (MouseListener) i.next();
            if (e.eventID == MouseEvent.CLICKED) { ml.mouseClicked(e); processItemEvent(); }
            if (e.eventID == MouseEvent.ENTERED) ml.mouseEntered(e);
            if (e.eventID == MouseEvent.EXITED) ml.mouseExited(e);
            if (e.eventID == MouseEvent.PRESSED) ml.mousePressed(e);
            if (e.eventID == MouseEvent.RELEASED) ml.mouseReleased(e);
        }
    }
    
    /**
     * Sends KeyEvents to component listeners
     * Overriden from Component to handle ItemEvents
     */
    public void processKeyEvent(KeyEvent e) {
        Iterator i = keyListeners.iterator();
        while (i.hasNext()) {
            KeyListener ml = (KeyListener) i.next();
            if (e.eventID == KeyEvent.PRESSED) { ml.keyTyped(e); processItemEvent(); }
            if (e.eventID == KeyEvent.RELEASED) ml.keyReleased(e);
            if (e.eventID == KeyEvent.PRESSED) ml.keyPressed(e);
        }  
    }
    
    protected int customStyle = 0;
    public void setCustomSWTStyle(int style) {
        this.customStyle = style;
    }
    
    /**
     * Once a parent component receives an "add" call for a child, this being
     * the child, this should be called to tell us to instantiate the peer
     * and load in any cached properties.
     */
    public void setSwingWTParent(swingwt.awt.Container parent) throws Exception {
        descendantHasPeer = true;
        ppeer = new Button(parent.getComposite(), SWT.TOGGLE | customStyle);
        if (pText != null) ppeer.setText(pText);
        ppeer.setSelection(pSelection);
        ppeer.setAlignment(pVAlign | pHAlign);
        peer = ppeer;
        this.parent = parent;
    }
    
    public boolean isSelected() { 
        bRetVal = false;
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable(ppeer)) bRetVal = false; else bRetVal = ppeer.getSelection();
            }
        });
        return bRetVal;
    }
        
    public void setSelected(final boolean b) { 
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTControlAvailable(ppeer)) ppeer.setSelection(b); else pSelection = b; 
            }
        });
    }

    public Object[] getSelectedObjects() {
        return null;
    }          
    
    public boolean isArmed() {
        return false;
    }
    
    public boolean isPressed() {
        return false;
    }
    
    public boolean isRollover() {
        return false;
    }
    
    public void setArmed(boolean b) {
    }
    
    public void setPressed(boolean b) {
    }
    
    public void setRollover(boolean b) {
    }
    
}
