/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JViewport.java,v $
   Revision 1.6  2005/01/05 09:22:32  bobintetley
   Updated copyright year on source

   Revision 1.5  2005/01/05 08:37:13  bobintetley
   Many compatibility fixes from David Barron

   Revision 1.4  2004/08/02 22:01:03  dannaab
   JViewport/JScrollPane integration

   Revision 1.3  2004/07/16 00:29:32  dannaab
   Bug fixes: Fix init order in JTable to ensure registration of all event listeners; reset isClosed in Window (to false) on peer creation, allowing reuse of the swing window objects (a common practice)

   Revision 1.2  2004/05/05 13:24:32  bobintetley
   Bugfixes and Laurent's patch for binary compatibility on Container.add()

   Revision 1.1  2004/04/30 16:52:17  bobintetley
   MenuListener support, JViewport support, TreeSelectionModel stubs, additional JTree methods

*/

package swingwtx.swing;

import java.util.Vector;

import swingwt.awt.*;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;

/**
 * Simple JViewport class. This could be expanded at a
 * later date.
 *
 * @author  Robin Rawson-Tetley
 */
public class JViewport extends JPanel {
    
    Vector changeListeners = null;
    
    public JViewport() {
        super(new BorderLayout());
    }

    public Component getView() {
        return getComponents()[0];
    }
    
    public void setView(Component view) {
        
        // Remove all components
        Component[] components = super.getComponents();
        for (int i=0; i<components.length; i++) {
            super.remove(components[i]);
        }
        
        if (view != null) add(view, BorderLayout.CENTER);
    }
    
    public Point getViewPosition() {
        return getLocation();
    }
    
    public void setViewPosition(Point position) {
        setLocation(position);
    }
    
    public Rectangle getViewRect() {
        return getBounds();    
    }
    
    public Dimension getViewSize() {
        return getSize();    
    }
    
    public void addChangeListener(ChangeListener changeListener) {
        if (changeListeners == null) changeListeners = new Vector();
        changeListeners.add(changeListener);
    }
    
    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListeners != null)
            changeListeners.remove(changeListener);
    }
    
    protected void fireStateChanged()
    {
        if (changeListeners != null) {
	        ChangeEvent changeEvent = new ChangeEvent(this);
	        for (int i = 0; i < changeListeners.size(); i++) {
	            ((ChangeListener)changeListeners.get(i)).stateChanged(changeEvent);
	        }
        }
    }

    public Dimension getExtentSize() {
        // TODO
        return getSize();
    }
}
