/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JWindow.java,v $
   Revision 1.25  2005/01/05 09:22:32  bobintetley
   Updated copyright year on source

   Revision 1.24  2004/10/30 20:11:57  bobintetley
   Code cleanup

   Revision 1.23  2004/04/16 10:19:07  dannaab
   Misc bug fixes, InputMap implementation, preliminary undo support

   Revision 1.22  2004/03/22 15:10:22  bobintetley
   JRootPane and JLayeredPane implementation

   Revision 1.21  2004/03/18 14:42:11  bobintetley
   Fix to Window hierarchy to match Swing, and fix to allow MDI apps
      to work under SWT 2.x

   Revision 1.20  2004/01/23 08:05:32  bobintetley
   JComboBox fixes and better Action implementation

   Revision 1.19  2004/01/16 09:35:47  bobintetley
   Full event dispatch thread support!

   Revision 1.18  2004/01/09 10:33:57  bobintetley
   Changes for JToolBar to allow platform ToolBars, mixed with other components

   Revision 1.17  2004/01/05 09:10:43  bobintetley
   Merged

   Revision 1.16  2004/01/05 09:09:22  bobintetley
   Merged Daniel's changes by hand

   Revision 1.14  2003/12/16 14:51:16  bobintetley
   Fixed hang when a window close event closes itself again

   Revision 1.13  2003/12/16 11:01:02  bobintetley
   Additional Swing compatibility

   Revision 1.12  2003/12/16 09:19:02  bobintetley
   Various small fixes to match Swing more closely

   Revision 1.11  2003/12/15 15:54:25  bobintetley
   Additional core methods

   Revision 1.10  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import swingwt.awt.*;

public class JWindow extends swingwt.awt.Window implements WindowConstants, RootPaneContainer {
    
    public JWindow() { this((Frame)null); }
    public JWindow(GraphicsConfiguration gc) { this(null, gc); }
    public JWindow(Frame owner) { super(owner); }
    public JWindow(Window owner) { super(owner); }
    public JWindow(Window owner, GraphicsConfiguration gc) { super(owner, gc); }
    
    public Container getContentPane() {
        return rootPane.getContentPane();
    }
    
    public Component getGlassPane() {
        return rootPane.getGlassPane();
    }
    
    public JLayeredPane getLayeredPane() {
        return rootPane.getLayeredPane();
    }
    
    public JRootPane getRootPane() {
        return rootPane;
    }
    
    public void setContentPane(Container contentPane) {
        rootPane.setContentPane(contentPane);
    }
    
    public void setGlassPane(Component glassPane) {
        rootPane.setGlassPane(glassPane);
    }
    
    public void setLayeredPane(JLayeredPane layeredPane) {
        rootPane.setLayeredPane(layeredPane);
    }
    
}
