/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FRMMAIN_H
#define FRMMAIN_H

#include <iostream>
#include "iwlib.h"
#include <linux/if.h>
#include <arpa/inet.h>
#include <unistd.h>

#include <qheader.h>
#include <qprocess.h>
#include <qstrlist.h>
#include <qdatatable.h>
#include <qpushbutton.h>
#include <qtimer.h>
#include <qmessagebox.h>
#include <qtextedit.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qstringlist.h>
#include <qcheckbox.h>
#include <qiconset.h>
#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qgroupbox.h>
#include <qprogressbar.h>
#include <qprocess.h>
#include <qlistview.h>
#include <qaction.h>

#include <kled.h>
#include <kaboutdialog.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "gpslog.h"
#include "frmconfig.h"
#include "aplist.h"
#include "apentry.h"
#include "scanning.h"
#include "myevents.h"
#include "interface.h"
#include "frmPrincipal.h"
#include "gpserial.h"
#include "aplist.h"
#include "shapehandler.h"
#include "gpslog.h"
#include "frmutils.h"
#include "frmconfigini.h"
#include "swsconfig.h"
#include "scanthread.h"
#include "licen.h"

using namespace std;

void delay (int sec);
QPixmap getPix(int signal);
QPixmap getPix2(int signal);

class frmmain : public SWScanner
{
        Q_OBJECT
private:
	QTimer *timer;
	QTimer *timerStatus;
	QHeader *header;
	APList * plistAP;		// continuously regenerated ap list (in each scan)
	GPSerial * gps;			// thread reading GPS data
	scanThread * sct;		// thread for scanning
	gpslog * log;			// gps log, log gps, gps log ;-)
	ShapeHandler * shapefile;
	
public:
        frmmain(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
        ~frmmain();
        /*$PUBLIC_FUNCTIONS$*/
	void		getStatus(QString iface);
	void		startDhcp(QString client);
	void		executeScript(QString script);
	void		updateMaclist(APList* List, QStrList* maclist);
	bool		isInList(QStrList* macList, char * mac);
	void		flushOldNodes();
	bool		IsInTable(QString MAC);
	bool		IsInList (QString MAC);
	void		addNewAP (APEntry* ap);
	void		addNewRow(APEntry* ap);
	void		updateRow(APEntry* ap);
	void		repaintTable();
	int		getCol(QString title);
	int		getRow(QString mac);
	bool		IsInTree (QListViewItem * parentNode, QString strToFind);
	void		deleteChildren (QListViewItem * parentNode);
	bool		passTheFilter(QListViewItem * it);
        void		fileOpen(char * name);
	void		fileAdd(char * name);	
	//QString	getPix(int signal);
	virtual void 	customEvent(QCustomEvent * e);

public slots:
        /*$PUBLIC_SLOTS$*/
        virtual void          showPopupMenu(QListViewItem * it, const QPoint & pos, int col);
        virtual void          changeInterface();
        virtual void          changeInterval();
        virtual void          stopScan();
        virtual void          start();
	virtual void          headerClick(int);
	virtual void          timerDone();
	virtual void          timerStatusDone();
        virtual void          helpAbout();
        virtual void          helpContents();
        virtual void          helpIndex();
        virtual void          editFind();
        virtual void          editPaste();
        virtual void          editCopy();
        virtual void          editCut();
        virtual void          editRedo();
        virtual void          editUndo();
	virtual void          toolsUtilities();
	virtual void          toolsSettings();
        virtual void          fileExit();
        virtual void          filePrint();
        virtual void          fileSaveAs();
        virtual void          fileSave();
        virtual void          fileOpen();
	virtual void          fileAdd();	
        virtual void          fileNew();
	virtual void          clearTable();
	virtual void          startConfig();
	virtual void          removeConfig();
	virtual void          asociate();
	virtual void          dhclientStdout();
	virtual void          deleteLog();
	virtual void          GPStart();
	virtual void          chkPreserveClick();
	virtual void          refreshCombo();
	virtual void          applyFilter(QListViewItem * node);

protected:
        /*$PROTECTED_FUNCTIONS$*/

protected slots:
        /*$PROTECTED_SLOTS$*/
};

#endif

