/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "aplist.h"
#include "functions.h"
#include <time.h>

#include <qstring.h>
#include <qtable.h>
#include <qvariant.h>
#include <qpixmap.h> 
#include <qlistview.h>
#include <qmessagebox.h>
#include <qsound.h>


//Check if a MAC is already displayed in the current table
bool IsInTable (QTable* table, char* MAC)
{
	QString mac=MAC;
	int numRows = table->numRows();

	for (int i=0 ; i < numRows ; i++)
		if( table->text(i,getCol(table,(char *)"MAC")) == MAC)
			return true;
			
	//only reach this point if MAC is not in list
	return false;
}

// Check if a MAC is in the AP list of AP's detected in the scan
bool IsInList (APList* list, char* MAC)
{
	char temp[20];
	
	for (int i=0 ; i < list->getLast() ; i++)
		if( QString(list->operator [ ](i).getMAC(temp)) == QString(MAC))	//convert from char* to QString to be able
			return true;							//to compare with '==' instead strcmp
			
	//only reach this point if MAC is not in list
	return false;

}
 
void flushOldNodes (QTable* table, APList* list, bool preserve)
{
	int numRows = table->numRows();
	
	for (int i=0 ; i < numRows ; i++)  //for each row in the table...
	{
		if (!IsInList(list,(char *)table->text(i,getCol(table,(char *)"MAC")).ascii()))
		{
			if (preserve)
			{
				table->setText(i,getCol(table,(char *)"SIGNAL"),"N.A.");
				table->setText(i,getCol(table,(char *)"SNR"),"0");
				table->setPixmap(i,0,QPixmap(getPix(-99)));
			}
			else
			{
				table->removeRow(i);
				i--; numRows--;		//adjust the table size and index
			}
		}	
	}
}

void addNewAP(QTable* table, APEntry* ap, QListView* listV)
{
	char mac[20];
	
	if (IsInTable(table,ap->getMAC(mac)))	//then update the existing row with the new signal-noise
		updateRow(table, ap, listV);
	else if (passTheFilter(listV,ap))	//only add a row if the new ap passes the filter
		addNewRow(table,ap,listV);
}

/* This function updates a previously existing row, taking into account 
if doesn't pass the filter, when it deletes the row */
void updateRow(QTable* table, APEntry* ap, QListView* listV)
{
	char temp[20];
	int sig, snrold, snrnew;
	QString mac = ap->getMAC(temp);
	QPixmap pix  = getPix(ap->getSignal());
	
	//if (QSound::isAvailable()) QSound::play("./ap_update.wav");
	
	for (int i=0 ; i < table->numRows() ; i++)
		if( table->text(i,getCol(table,(char *)"MAC")) == mac)
		{
			if (passTheFilter(listV, ap))
			{	
				sig = table->text(i,getCol(table,(char *)"SIGNAL(MAX)")).toInt();
				snrold = table->text(i,getCol(table,(char *)"SNR(MAX)")).toInt();
				snrnew = ap->getSignal()-ap->getNoise();
				
				table->setText(i,getCol(table,(char *)"SIGNAL"),QVariant(ap->getSignal()).toString());
				table->setText(i,getCol(table,(char *)"NOISE"),QVariant(ap->getNoise()).toString());
				table->setText(i,getCol(table,(char *)"SNR"),QVariant(snrnew).toString());
				if (ap->getSignal() > sig)
					table->setText(i,getCol(table,(char *)"SIGNAL(MAX)"),QVariant(ap->getSignal()).toString());
				if (snrnew > snrold)
					table->setText(i,getCol(table,(char *)"SNR(MAX)"),QVariant(snrnew).toString());
				
				table->setPixmap(i,0,pix);
				return;
			}
			else
				table->removeRow(i);
		}

}

void addNewRow(QTable* table, APEntry* ap, QListView* listV)
{
	int n = table->numRows();
	char temp[255];
	char mac[20];
	QPixmap pix = getPix(ap->getSignal());
	QListViewItem * item;
	
	// if (QSound::isAvailable()) QSound::play("./ap_new.wav");
				
	table->insertRows(n);	//insert a row at the end
	
	table->setPixmap(n,0,pix);
	table->setText(n,getCol(table,(char *)"ESSID"),ap->getEssid(temp));
	table->setText(n,getCol(table,(char *)"MAC"),ap->getMAC(mac));
	table->setText(n,getCol(table,(char *)"CHANNEL"),QVariant(ap->getChannel()).toString());
	table->setText(n,getCol(table,(char *)"SIGNAL(MAX)"),QVariant(ap->getSignal()).toString());
	table->setText(n,getCol(table,(char *)"MODE"),ap->getModeString());
	table->setText(n,getCol(table,(char *)"SIGNAL"),QVariant(ap->getSignal()).toString());
	table->setText(n,getCol(table,(char *)"NOISE"),QVariant(ap->getNoise()).toString());
	table->setText(n,getCol(table,(char *)"SNR"),QVariant(ap->getSignal()-ap->getNoise()).toString());
	table->setText(n,getCol(table,(char *)"SNR(MAX)"),QVariant(ap->getSignal()-ap->getNoise()).toString());
	if (ap->getWEP())
		table->setText(n,getCol(table,(char *)"WEP"),"YES");
	else
		table->setText(n,getCol(table,(char *)"WEP"),"NO");
	
	//add the mac'x to the filter tree
	item=listV->findItem(QString("MAC"),0);
	if (!IsInTree(item,QString(ap->getMAC(temp))))
		new QCheckListItem(item,mac);
	//add the channel to the filter, only if it isn't there yet
	item=listV->findItem(QString("CHANNEL"),0);
	if (!IsInTree(item,QVariant(ap->getChannel()).toString()))
		new QCheckListItem(item,QVariant(ap->getChannel()).toString());
	//the same with essid:
	item=listV->findItem(QString("ESSID"),0);
	if (!IsInTree(item,QString(ap->getEssid(temp))))
		new QCheckListItem(item,QString(temp));
	
	//adjust columns width
	for (int i=0; i < table->numCols() ; i++) 
		table->adjustColumn(i);;	
}

int getCol(QTable* table, char* title)	//gives me the column index of a field name(header)
{
	QHeader* head = table->horizontalHeader();
	QString tit = title;
	
	for (int i=0 ; i < head->count() ; i++)
		if (tit == head->label(i))
			return i;
	
	return -1;
}
QString getPix(int signal)
{
	if (signal < -90)
		return QString("./signal_none.png");
	else if ((signal >= -90) && (signal < -80))
		return QString("./signal_low.png");
	else if ((signal >= -80) && (signal < -70))
		return QString("./signal_medium.png");
	else if (signal >= -70)
		return QString("./signal_good.png");
		
	return "";
}
//Search in the parentNode's childs, but not in the child's child's..
bool IsInTree (QListViewItem * parentNode, QString strToFind)
{
	QListViewItem * myChild = parentNode->firstChild();
	while( myChild ) 
	{
        	if (myChild->key(0,true) == strToFind)
			return true;
        	myChild = myChild->nextSibling();
        }
	return false;
}

bool passTheFilter(QListView * list, APEntry * ap)
{
	QListViewItem * sel = list->selectedItem();
	char temp [255];
	
	
	if (sel == 0)
		return true;
     
 	if (sel->key(0,true) == QString("MAC")) return true;
	if (sel->key(0,true) == QString("ESSID")) return true;
	if (sel->key(0,true) == QString("CHANNEL")) return true;
	if (sel->key(0,true) == QString("/")) return true;
    			
	if (sel->parent()->key(0,true) == QString("MAC"))   //filter by MAC
	{
		if (sel->key(0,true) == QString(ap->getMAC(temp)))
			return true;	//this mac is the one filtered
	}
	else if (sel->parent()->key(0,true) == QString("ESSID"))   //filter by Essid
	{
		if (sel->key(0,true) == QString(ap->getEssid(temp)))
			return true;	//this essid is the one filtered	
	}
	else if (sel->parent()->key(0,true) == QString("CHANNEL"))   //filter by channel
	{
		if (sel->key(0,true) == QVariant(ap->getChannel()).toString())
			return true;	//this channel is the one filtered
	}
	
	return false;
}

void delay (int sec)
{
	time_t start;
	time_t current;

	time(&start);
	do
	{
		time(&current);
	}while(difftime(current,start) < (double)sec);
}
