//
// C++ Implementation: mainwindow
//
// Description: 
//
//
// Author: Ivn Forcada Atienza <ivan@swscanner.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this disi18nibution
//
//

#include "mainwindow.h"

MainWindow::MainWindow ( const char * name, WFlags f ) :  DCOPObject("SWScannerIface"), KMainWindow ( 0, name, f )
{

	char names[255];
	int num;
	QString interface;
	SWSconfig cfg;

	qDebug("Creating MainWindow...");

	// instantiate members
	nodes = SWSglobals::nodes();
        gps = new GPSerial( this , "gpserial" );
        shapefile = new ShapeHandler;
        log = new gpslog;
	apConfigActions = 0;

	// reset the statistics structure
	bzero(&nodeStats, sizeof(nodeStats));

        // get wireless interfaces
        names[0]='\0';
        GetWirelessInterfacesNames_new(names,&num);
        QStringList strlist = QStringList::split( "#", names );

	setCaption("Simple Wireless Scanner");
	if ( !name )
		setName( "SWScanner" );
	
	setIcon( DesktopIcon("swscanner") );
	
	setCentralWidget( new QWidget( this, "centralwidget" ) );
	frmPrincipalLayout = new QGridLayout( centralWidget(), 1, 1, 11, 6, "frmPrincipalLayout"); 
	
	layout1 = new QHBoxLayout( 0, 0, 6, "layout1"); 
	
	lstFilter = new TreeFilterListView( centralWidget(), "lstFilter" );
	tblScan = new AccessPointListView( centralWidget(), "tblScan" );

	layout1->addWidget( lstFilter );
	layout1->addWidget( tblScan );

	frmPrincipalLayout->addLayout( layout1, 1, 0 );

	layout11 = new QVBoxLayout( 0, 0, 6, "layout11");

	QFont fontBold;
	fontBold.setBold(TRUE);
	lblStats = new QLineEdit( centralWidget(), "lblStats");
	lblStats->setText(i18n("Statistics"));
	lblStats->setAlignment(Qt::AlignHCenter);
	lblStats->setReadOnly(TRUE);
	lblStats->setFont(fontBold);
	lblStats->hide();
	layout11->addWidget(lblStats);

	tblStatsWEP = new QTable(3, 1, centralWidget(), "tblStats" );
	tblStatsWEP->setNumRows(2);
	tblStatsWEP->setNumCols(1);
	tblStatsWEP->horizontalHeader()->setLabel(0, i18n("WEP"));
	tblStatsWEP->verticalHeader()->setLabel(0, i18n("ON"));
	tblStatsWEP->verticalHeader()->setLabel(1, i18n("OFF"));
	tblStatsWEP->setReadOnly(TRUE);
	tblStatsWEP->adjustColumn(0);
	tblStatsWEP->setFixedHeight(tblStatsWEP->contentsHeight() + tblStatsWEP->horizontalHeader()->height() + 10);
	tblStatsWEP->setFixedWidth(tblStatsWEP->contentsWidth() + tblStatsWEP->verticalHeader()->width() + 10);
	tblStatsWEP->setSelectionMode(QTable::NoSelection);
	tblStatsWEP->hide();
	layout11->addWidget( tblStatsWEP );

	tblStatsChan = new QTable(3, 1, centralWidget(), "tblStats" );
	tblStatsChan->setNumRows(13);
	tblStatsChan->setNumCols(1);
	tblStatsChan->setReadOnly(TRUE);
	tblStatsChan->horizontalHeader()->setLabel(0, i18n("CHANNEL"));
	tblStatsChan->verticalHeader()->setLabel(0, "1");
	tblStatsChan->verticalHeader()->setLabel(1, "2");
	tblStatsChan->verticalHeader()->setLabel(2, "3");
	tblStatsChan->verticalHeader()->setLabel(3, "4");
	tblStatsChan->verticalHeader()->setLabel(4, "5");
	tblStatsChan->verticalHeader()->setLabel(5, "6");
	tblStatsChan->verticalHeader()->setLabel(6, "7");
	tblStatsChan->verticalHeader()->setLabel(7, "8");
	tblStatsChan->verticalHeader()->setLabel(8, "9");
	tblStatsChan->verticalHeader()->setLabel(9, "10");
	tblStatsChan->verticalHeader()->setLabel(10, "11");
	tblStatsChan->verticalHeader()->setLabel(11, "12");
	tblStatsChan->verticalHeader()->setLabel(12, "13");
	tblStatsChan->adjustColumn(0);
	tblStatsChan->setFixedHeight(tblStatsChan->contentsHeight() + tblStatsChan->horizontalHeader()->height() + 10);
	tblStatsChan->setFixedWidth(tblStatsChan->contentsWidth() + tblStatsChan->verticalHeader()->width() + 10);	
	tblStatsChan->setSelectionMode(QTable::NoSelection);
	tblStatsChan->hide();
	lblStats->setMaximumWidth(tblStatsChan->width());
	layout11->addWidget( tblStatsChan );

	spacer16 = new QSpacerItem( 2, 20, QSizePolicy::Minimum, QSizePolicy::Expanding);
	layout11->addItem( spacer16 );	

	layout1->addItem(layout11);

	layout2 = new QHBoxLayout( 0, 0, 6, "layout2"); 

	buttonCancel = new QPushButton( centralWidget(), "buttonCancel" );
	buttonCancel->setText( QString::null );
	buttonCancel->setAccel( QKeySequence( QString::null ) );
	buttonCancel->setMinimumSize( QSize( 50, 45 ) );
	buttonCancel->setPixmap( DesktopIcon("exit") );
	buttonCancel->setToggleButton( TRUE );
	buttonCancel->setOn( TRUE );
	buttonCancel->setAutoDefault( TRUE );
	QToolTip::add( buttonCancel, i18n( "Exit SWScanner" ) );
	layout2->addWidget( buttonCancel );
	spacer1 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
	layout2->addItem( spacer1 );
	
	buttonOk = new QPushButton( centralWidget(), "buttonOk" );
	buttonOk->setText( QString::null );
	buttonOk->setAccel( QKeySequence( QString::null ) );
	buttonOk->setMinimumSize( QSize( 50, 45 ) );
	buttonOk->setPixmap( DesktopIcon("exec") );
	buttonOk->setAutoDefault( TRUE );
	buttonOk->setDefault( TRUE );
	QToolTip::add( buttonOk, i18n( "Start scanning" ) );
	layout2->addWidget( buttonOk );
	
	btnStop = new QPushButton( centralWidget(), "btnStop" );
	btnStop->setText( QString::null );
	btnStop->setAccel( QKeySequence( QString::null ) );
	btnStop->setMinimumSize( QSize( 50, 45 ) );
	btnStop->setPixmap( DesktopIcon("stop") );
	QToolTip::add( btnStop, i18n( "Stop scanning" ) );
	layout2->addWidget( btnStop );
	spacer2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
	layout2->addItem( spacer2 );
	
	btnClear = new QPushButton( centralWidget(), "btnClear" );
	btnClear->setText( QString::null );
	btnClear->setAccel( QKeySequence( QString::null ) );
	btnClear->setMinimumSize( QSize( 50, 45 ) );
	btnClear->setPixmap( DesktopIcon("eraser") );
	QToolTip::add( btnClear, i18n( "Clear list" ) );	
	layout2->addWidget( btnClear );
	spacer3 = new QSpacerItem( 679, 31, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout2->addItem( spacer3 );
	
	frmPrincipalLayout->addLayout( layout2, 3, 0 );
	
	layout3 = new QHBoxLayout( 0, 0, 6, "layout3"); 

	btnShowFilter = new QPushButton( centralWidget(), "btnShowFilter");
	btnShowFilter->setPixmap(BarIcon("edit_remove"));
	btnShowFilter->setMaximumSize( QSize(25, 25) );
	QToolTip::add(btnShowFilter, i18n("Show/Hide filters frame"));
	layout3->addWidget(btnShowFilter);

	spacer4 = new QSpacerItem( 261, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout3->addItem( spacer4 );

	textLabel1 = new QLabel( centralWidget(), "textLabel1" );
	textLabel1->setText( i18n( "AccessPoints in list:" ) );
	textLabel1->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	layout3->addWidget( textLabel1 );
	
	lblAPnum = new QLabel( centralWidget(), "lblAPnum" );
	lblAPnum->setText( i18n( "shown" ) + " <b>(0)</b>, " + i18n("total") + " <b>(0)</b>" );
// 	lblAPnum->setMinimumSize( QSize( 200, 20 ) );
	lblAPnum->setAlignment( int( QLabel::AlignVCenter ) );
	layout3->addWidget( lblAPnum );

	btnShowStats = new QPushButton( centralWidget(), "btnShowStats");
	btnShowStats->setPixmap(BarIcon("edit_add"));
	btnShowStats->setMaximumSize( QSize(25, 25) );
	QToolTip::add(btnShowStats, i18n("Show/Hide statistics frame"));
	layout3->addWidget(btnShowStats);

	frmPrincipalLayout->addLayout( layout3, 2, 0 );
	
	layout4 = new QHBoxLayout( 0, 0, 6, "layout4"); 
	
	chkPreserve = new QCheckBox( centralWidget(), "chkPreserve" );
	chkPreserve->setText(i18n("Show all AccessPoints"));
	QToolTip::add( chkPreserve, i18n("Showing all AccessPoints in memory"));
	chkPreserve->setChecked( TRUE );
	layout4->addWidget( chkPreserve );

	spacer15 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
	layout4->addItem( spacer15 );

	chkSound = new QCheckBox( centralWidget(), "chkSound" );
	chkSound->setText(i18n("Using sound"));
	chkSound->setChecked( FALSE );
	QToolTip::add(chkSound, i18n("Sound disabled"));
	layout4->addWidget(chkSound);	

	spacer5 = new QSpacerItem( 313, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout4->addItem( spacer5 );


	textLabel2 = new QLabel( centralWidget(), "textLabel2" );
	textLabel2->setText( i18n( "Choose interface:" ) );		
	layout4->addWidget( textLabel2 );
	
	cmbIface = new QComboBox( FALSE, centralWidget(), "cmbIface" );
	cmbIface->insertStringList(strlist);	// Add interface list
	QToolTip::add( cmbIface, i18n( "Select the interface to use" ) );
	layout4->addWidget( cmbIface );
	
	btnRefresh = new QPushButton( centralWidget(), "btnRefresh" );
	btnRefresh->setText( QString::null );
	QToolTip::add( btnRefresh, i18n( "Update interface list" ) );
	btnRefresh->setPixmap( SmallIcon("reload") );
	layout4->addWidget( btnRefresh );
	spacer6 = new QSpacerItem( 20, 20, QSizePolicy::Fixed, QSizePolicy::Minimum );
	layout4->addItem( spacer6 );
	
	textLabel3 = new QLabel( centralWidget(), "textLabel3" );
	textLabel3->setText( i18n( "Scanning interval:" ) );
	layout4->addWidget( textLabel3 );
	
	spInterval = new QSpinBox( centralWidget(), "spInterval" );
	QToolTip::add( spInterval, i18n( "Scanning Interval" ) );	
	spInterval->setButtonSymbols( QSpinBox::UpDownArrows );
	spInterval->setMaxValue( 10 );
	spInterval->setMinValue( 1 );
	layout4->addWidget( spInterval );
	
		
	textLabel4 = new QLabel( centralWidget(), "textLabel4" );
	textLabel4->setText( i18n( "secs." ) );
	layout4->addWidget( textLabel4 );
	
	frmPrincipalLayout->addLayout( layout4, 0, 0 );
	
	layout5 = new QHBoxLayout( 0, 0, 6, "layout5"); 
	
	grpStatus = new QGroupBox( centralWidget(), "grpStatus" );
	grpStatus->setTitle( i18n( "Status (%1)" ).arg("wlanX") );
	grpStatus->setMaximumWidth( 800 );
	grpStatus->setColumnLayout(0, Qt::Vertical );
	grpStatus->layout()->setSpacing( 6 );
	grpStatus->layout()->setMargin( 11 );
	grpStatusLayout = new QGridLayout( grpStatus->layout() );
	grpStatusLayout->setAlignment( Qt::AlignTop );
	
	layout6 = new QHBoxLayout( 0, 0, 6, "layout6"); 
	
	textLabel5 = new QLabel( grpStatus, "textLabel5" );
	textLabel5->setText( i18n( "IP:" ) );
	textLabel5->setMinimumSize( QSize( 0, 0 ) );
	textLabel5->setFont(fontBold);
	layout6->addWidget( textLabel5 );
	
	lblIP = new QLabel( grpStatus, "lblIP" );
	lblIP->setText( "0.0.0.0" );
	lblIP->setMinimumSize( QSize( 0, 0 ) );
	layout6->addWidget( lblIP );
	spacer7 = new QSpacerItem( 31, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout6->addItem( spacer7 );
	
	textLabel6 = new QLabel( grpStatus, "textLabel6" );
	textLabel6->setText( i18n( "Netmask:" ) );	
	textLabel6->setMinimumSize( QSize( 0, 0 ) );
	textLabel6->setFont(fontBold);
	layout6->addWidget( textLabel6 );
	
	lblMask = new QLabel( grpStatus, "lblMask" );
	lblMask->setText( "0.0.0.0" );
	lblMask->setMinimumSize( QSize( 0, 0 ) );
	layout6->addWidget( lblMask );
	spacer8 = new QSpacerItem( 31, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout6->addItem( spacer8 );
	
	textLabel7 = new QLabel( grpStatus, "textLabel7" );
	textLabel7->setText( i18n( "Broadcast:" ) );		
	textLabel7->setMinimumSize( QSize( 0, 0 ) );
	textLabel7->setFont(fontBold);
	layout6->addWidget( textLabel7 );
	
	lblBcast = new QLabel( grpStatus, "lblBcast" );
	lblBcast->setText( "0.0.0.0" );
	lblBcast->setMinimumSize( QSize( 0, 0 ) );
	layout6->addWidget( lblBcast );
	spacer9 = new QSpacerItem( 21, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout6->addItem( spacer9 );
	
	grpStatusLayout->addLayout( layout6, 0, 0 );
	
	layout7 = new QHBoxLayout( 0, 0, 6, "layout7"); 
	
	textLabel8 = new QLabel( grpStatus, "textLabel8" );
	textLabel8->setText( i18n( "Mode:" ) );	
	textLabel8->setMinimumSize( QSize( 0, 0 ) );
	textLabel8->setFont(fontBold);
	layout7->addWidget( textLabel8 );
	
	lblMode = new QLabel( grpStatus, "lblMode" );
	lblMode->setText( "??????" );
	lblMode->setMinimumSize( QSize( 0, 0 ) );
	layout7->addWidget( lblMode );
	
	textLabel9 = new QLabel( grpStatus, "textLabel9" );
	textLabel9->setMinimumSize( QSize( 0, 0 ) );
	textLabel9->setText( i18n( "ESSID:" ) );
	textLabel9->setFont(fontBold);
	layout7->addWidget( textLabel9 );
	
	lblEssid = new QLabel( grpStatus, "lblEssid" );
	lblEssid->setText( "??????" );
	lblEssid->setMinimumSize( QSize( 0, 0 ) );
	layout7->addWidget( lblEssid );
	
	textLabel10 = new QLabel( grpStatus, "textLabel10" );
	textLabel10->setText( i18n( "Channel:" ) );			
	textLabel10->setMinimumSize( QSize( 0, 0 ) );
	textLabel10->setFont(fontBold);
	layout7->addWidget( textLabel10 );
	
	lblChan = new QLabel( grpStatus, "lblChan" );
	lblChan->setText( "??" );
	lblChan->setMinimumSize( QSize( 0, 0 ) );
	layout7->addWidget( lblChan );
	
	textLabel11 = new QLabel( grpStatus, "textLabel11" );
	textLabel11->setText( i18n( "WEP:" ) );	
	textLabel11->setMinimumSize( QSize( 0, 0 ) );
	textLabel11->setFont(fontBold);
	layout7->addWidget( textLabel11 );
	
	lblWEP = new QLabel( grpStatus, "lblWEP" );
	lblWEP->setText( "???" );
	lblWEP->setMinimumSize( QSize( 0, 0 ) );
	layout7->addWidget( lblWEP );
	
	textLabel12 = new QLabel( grpStatus, "textLabel12" );
	textLabel12->setText( i18n( "KeyLength:" ) );	
	textLabel12->setMinimumSize( QSize( 0, 0 ) );
	textLabel12->setFont(fontBold);
	layout7->addWidget( textLabel12 );
	
	lblKLen = new QLabel( grpStatus, "lblKLen" );
	lblKLen->setText( "??" );
	lblKLen->setMinimumSize( QSize( 0, 0 ) );
	layout7->addWidget( lblKLen );
	
	grpStatusLayout->addLayout( layout7, 1, 0 );
	
	layout8 = new QHBoxLayout( 0, 0, 6, "layout8"); 
	
	textLabel13 = new QLabel( grpStatus, "textLabel13" );
	textLabel13->setText( i18n( "Signal:" ) );	
	textLabel13->setMinimumSize( QSize( 0, 0 ) );
	textLabel13->setFont(fontBold);
	layout8->addWidget( textLabel13 );
	
	lblSignal = new QLabel( grpStatus, "lblSignal" );
	lblSignal->setText( "???" );
	lblSignal->setMinimumSize( QSize( 0, 0 ) );
	layout8->addWidget( lblSignal );
	
	pixSignal = new QLabel( grpStatus, "pixSignal" );
	pixSignal->setMinimumSize( QSize( 0, 0 ) );
	pixSignal->setMaximumSize( QSize( 25, 25 ) );
	pixSignal->setPixmap( KGlobal::iconLoader()->loadIcon("excellent", KIcon::User) );
	pixSignal->setScaledContents( TRUE );
	layout8->addWidget( pixSignal );
	
	textLabel14 = new QLabel( grpStatus, "textLabel14" );
	textLabel14->setText( i18n( "Noise:" ) );	
	textLabel14->setMinimumSize( QSize( 0, 0 ) );
	textLabel14->setFont(fontBold);
	layout8->addWidget( textLabel14 );
	
	lblNoise = new QLabel( grpStatus, "lblNoise" );
	lblNoise->setText( "???" );
	lblNoise->setMinimumSize( QSize( 0, 0 ) );
	layout8->addWidget( lblNoise );
	
	textLabel15 = new QLabel( grpStatus, "textLabel15" );
	textLabel15->setText( i18n( "Link Qual:" ) );
	textLabel15->setMinimumSize( QSize( 0, 0 ) );
	textLabel15->setFont(fontBold);
	layout8->addWidget( textLabel15 );
	
	lblSNR = new QLabel( grpStatus, "lblSNR" );
	lblSNR->setText( "???" );
	lblSNR->setMinimumSize( QSize( 0, 0 ) );
	layout8->addWidget( lblSNR );
	
	textLabel16 = new QLabel( grpStatus, "textLabel16" );
	textLabel16->setText( i18n( "AP:" ) );	
	textLabel16->setMinimumSize( QSize( 0, 0 ) );
	textLabel16->setFont(fontBold);
	layout8->addWidget( textLabel16 );
	
	lblAP = new QLabel( grpStatus, "lblAP" );
	lblAP->setText( "??:??:??:??:??:??" );
	lblAP->setMinimumSize( QSize( 0, 0 ) );
	layout8->addWidget( lblAP );
	
	grpStatusLayout->addLayout( layout8, 2, 0 );
	layout5->addWidget( grpStatus );

	grpGPS = new QGroupBox( centralWidget(), "grpGPS" );
	grpGPS->setTitle( i18n( "GPS" ) );
	grpGPS->setColumnLayout(0, Qt::Vertical );
	grpGPS->setMaximumWidth( 800 );
	grpGPS->layout()->setSpacing( 6 );
	grpGPS->layout()->setMargin( 11 );
	grpGPSLayout = new QGridLayout( grpGPS->layout() );
	grpGPSLayout->setAlignment( Qt::AlignTop );
	
	layout9 = new QHBoxLayout( 0, 0, 6, "layout9"); 
	
	btnGPS = new QPushButton( grpGPS, "btnGPS" );
	btnGPS->setText( i18n( "Start GPS" ) );
	btnGPS->setIconSet(BarIcon("exec"));
	btnGPS->setAccel( QKeySequence( "Alt+G" ) );
	btnGPS->setMinimumSize( QSize( 0, 0 ) );
	layout9->addWidget( btnGPS );
	
	GPSLed = new KLed( grpGPS, "GPSLed" );
	GPSLed->setMinimumSize( QSize( 30, 30 ) );
	GPSLed->setState( KLed::Off );
	GPSLed->setLook( KLed::Raised );
	GPSLed->setColor( QColor( 0, 255, 0 ) );
	layout9->addWidget( GPSLed );
	spacer10 = new QSpacerItem( 216, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout9->addItem( spacer10 );
	
	grpGPSLayout->addLayout( layout9, 0, 0 );
	
	layout10 = new QGridLayout( 0, 1, 1, 0, 6, "layout10"); 
	spacer11 = new QSpacerItem( 16, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout10->addItem( spacer11, 0, 6 );
	
	textLabel17 = new QLabel( grpGPS, "textLabel17" );
	textLabel17->setText( i18n( "AP's" ) );
	textLabel17->setFont(fontBold);
	textLabel17->setMinimumSize( QSize( 0, 0 ) );
	textLabel17->setMaximumSize( QSize( 30, 16 ) );
	layout10->addMultiCellWidget( textLabel17, 0, 0, 4, 5 );
	spacer12 = new QSpacerItem( 52, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout10->addItem( spacer12, 1, 3 );
	
	textLabel18 = new QLabel( grpGPS, "textLabel18" );
	textLabel18->setText( i18n( "Long(deg):" ) );
	textLabel18->setFont(fontBold);	
	textLabel18->setMinimumSize( QSize( 0, 0 ) );
	textLabel18->setMaximumSize( QSize( 32767, 32767 ) );
	layout10->addWidget( textLabel18, 0, 1 );
	
	lblSpeedUnits = new QLabel( grpGPS, "lblSpeedUnits" );
	if (cfg.getSpeedUnits() == "kph")
		lblSpeedUnits->setText( i18n( "Speed (km/h):" ) );
	else if (cfg.getSpeedUnits() == "mph")
		lblSpeedUnits->setText( i18n( "Speed (mi/h):" ) );
	else
		lblSpeedUnits->setText( i18n( "Speed (knots):" ) );
	lblSpeedUnits->setFont(fontBold);
	lblSpeedUnits->setMinimumSize( QSize( 0, 0 ) );
	lblSpeedUnits->setMaximumSize( QSize( 32767, 16 ) );
	layout10->addWidget( lblSpeedUnits, 0, 2 );
	
	lblAPs = new QLabel( grpGPS, "lblAPs" );
	lblAPs->setText( "0" );
	lblAPs->setMinimumSize( QSize( 18, 0 ) );
	lblAPs->setMaximumSize( QSize( 30, 20 ) );
	lblAPs->setFrameShape( QLabel::Panel );
	lblAPs->setFrameShadow( QLabel::Sunken );
	lblAPs->setAlignment( int( QLabel::AlignCenter ) );
	
	layout10->addWidget( lblAPs, 1, 4 );
	spacer13 = new QSpacerItem( 16, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout10->addItem( spacer13, 1, 5 );
	spacer14 = new QSpacerItem( 56, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout10->addItem( spacer14, 0, 3 );
	
	textLabel19 = new QLabel( grpGPS, "textLabel20" );
	textLabel19->setText( i18n( "Lat(deg):" ) );
	textLabel19->setFont(fontBold);
	textLabel19->setMinimumSize( QSize( 0, 0 ) ); 
	textLabel19->setMaximumSize( QSize( 32767, 16 ) );
	layout10->addWidget( textLabel19, 0, 0 );
	
	lblLat = new QLabel( grpGPS, "lblLat" );
	lblLat->setText( "0,0000000000" );
	lblLat->setMinimumSize( QSize( 0, 0 ) );
	lblLat->setFrameShape( QLabel::Panel );
	lblLat->setFrameShadow( QLabel::Sunken );
	
	layout10->addWidget( lblLat, 1, 0 );
	
	lblSpeed = new QLabel( grpGPS, "lblSpeed" );	
	lblSpeed->setText( "0,000000000" );
	lblSpeed->setMinimumSize( QSize( 0, 0 ) );
	lblSpeed->setFrameShape( QLabel::Panel );
	lblSpeed->setFrameShadow( QLabel::Sunken );
	
	layout10->addWidget( lblSpeed, 1, 2 );
	
	lblLong = new QLabel( grpGPS, "lblLong" );
	lblLong->setText( "0,0000000000" );
	lblLong->setMinimumSize( QSize( 0, 0 ) );
	lblLong->setFrameShape( QLabel::Panel );
	lblLong->setFrameShadow( QLabel::Sunken );
	
	layout10->addWidget( lblLong, 1, 1 );
	
	grpGPSLayout->addLayout( layout10, 1, 0 );
	layout5->addWidget( grpGPS );

	frmPrincipalLayout->addLayout( layout5, 4, 0 );

	layout12 = new QHBoxLayout( 0, 0, 6, "layout12"); 

	btnShowStatus = new QPushButton( centralWidget(), "btnShowStatus");
	btnShowStatus->setPixmap(BarIcon("edit_remove"));
	btnShowStatus->setMaximumSize( QSize(25, 25) );
	QToolTip::add(btnShowStatus, i18n("Show/Hide status frame"));
	layout12->addWidget(btnShowStatus);
	
	spacer17 = new QSpacerItem( 16, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout12->addItem(spacer17);

	btnShowGPS = new QPushButton( centralWidget(), "btnShowGPS");
	btnShowGPS->setPixmap(BarIcon("edit_remove"));
	btnShowGPS->setMaximumSize( QSize(25, 25) );
	QToolTip::add(btnShowGPS, i18n("Show/Hide GPS frame"));
	layout12->addWidget(btnShowGPS);

	frmPrincipalLayout->addLayout( layout12, 5, 0);

	// ACTIONS
	// "file" menu
	KStdAction::open(this, SLOT(fileOpen()), actionCollection());
	recentsAction = KStdAction::openRecent ( this, SLOT(fileRecents(const KURL&)), actionCollection());
	recentsAction->loadEntries(KGlobal::config(), "RecentFiles");
	KStdAction::save(this, SLOT(fileSave()), actionCollection());
	KAction * joinAction = new KAction(i18n("Add-Merge"), "edit_add", KShortcut("Ctrl+A"), this, 
				SLOT(fileAdd()), actionCollection(), "file_add_merge");
		joinAction->setToolTip(i18n("Select a data file to merge with the current one"));
	KStdAction::quit(kapp, SLOT(quit()), actionCollection());
	
	// "edit" menu
	KStdAction::cut (this, SLOT(editCut()), actionCollection());
	KStdAction::copy (this, SLOT(editCopy()), actionCollection());
	KStdAction::paste (this, SLOT(editPaste()), actionCollection());

	// "view" menu
	viewStatusAction = new KToggleAction(i18n("View status"), KShortcut("Ctrl+W"), this,
				SLOT(showStatus()), actionCollection(), "view_status");
		viewStatusAction->setChecked(TRUE);
	viewStatsAction = new KToggleAction(i18n("View statistics"), KShortcut ("Ctrl+T"), this,
				SLOT(showStats()), actionCollection(), "view_statistics");
		viewStatsAction->setChecked(FALSE);

	viewGPSAction = new KToggleAction(i18n("View GPS"), KShortcut("Ctrl+G"), this,
				SLOT(showGPS()), actionCollection(), "view_gps");
		viewGPSAction->setChecked(TRUE);
	viewFilterAction = new KToggleAction(i18n("View Filter"), KShortcut("Ctrl+F"), this,
				SLOT(showFilter()), actionCollection(), "view_filter");
		viewFilterAction->setChecked(TRUE);

	// "actions" menu
	new KAction(i18n("Start scanning"), "exec", KShortcut("Ctrl+R"), this,
				SLOT(start()), actionCollection(), "actions_start");
	new KAction(i18n("Stop scanning"), "stop", KShortcut("Ctrl+P"), this,
				SLOT(stopScan()), actionCollection(), "actions_stop");
	new KAction(i18n("Clear list"), "eraser", KShortcut("Ctrl+E"), this,
				SLOT(clearAll()), actionCollection(), "actions_clear");

	new KAction(i18n("GPS Start"), "exec", KShortcut("Ctrl+R"), this,
				SLOT(GPSstart()), actionCollection(), "actions_gps_start");
	new KAction(i18n("GPS Stop"), "stop", KShortcut("Ctrl+P"), this,
				SLOT(GPSstop()), actionCollection(), "actions_gps_stop");
	

	// "tools" menu
	new KAction(i18n("Conversion utility"), "wizard", KShortcut("Ctrl+U"), this,
				SLOT(toolsUtilities()), actionCollection(), "tools_conversion");
	new KAction(i18n("Configure SWScanner..."), "configure_toolbars", KShortcut("Ctrl+P"), this,
				SLOT(toolsSettings()), actionCollection(), "settings_configure");

	createGUI();
	applyMainWindowSettings(KGlobal::config(), "MainWindow");

	// Tray icon:
	SWSTray = new SWSystemTray(QString::null, this, "SWSTRay");
	SWSTray->setMovie(QMovie(locate("appdata", "pics/swscanner.gif")));
	SWSTray->show();
	
	// Timers:
        scanTimer = new QTimer( this , "scanTimer" );
        statusTimer = new QTimer ( this, "statusTimer" );
        statusTimer->start(1000);

	// signals and slots connections
	connect( spInterval, SIGNAL( valueChanged(int) ), this, SLOT( changeInterval() ) );
	connect( lstFilter, SIGNAL( clicked(QListViewItem*) ), this, SLOT( applyFilter(QListViewItem*) ) );
	connect( cmbIface, SIGNAL( activated(const QString&) ), this, SLOT( changeInterface() ) );
	connect( chkPreserve, SIGNAL( clicked() ), this, SLOT( chkPreserveClick() ) );
	connect( chkSound, SIGNAL( clicked() ), this, SLOT( chkSoundClick() ) );
	connect( buttonOk, SIGNAL( clicked() ), this, SLOT( start() ) );
	connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( close() ) );
	connect( btnStop, SIGNAL( clicked() ), this, SLOT( stopScan() ) );
	connect( btnRefresh, SIGNAL( clicked() ), this, SLOT( refreshCombo() ) );
	connect( btnGPS, SIGNAL( clicked() ), this, SLOT( GPSstart() ) );
	connect( btnClear, SIGNAL( clicked() ), this, SLOT( clearAll() ) );
	connect( tblScan, SIGNAL( rightButtonPressed(QListViewItem*,const QPoint&,int) ), this, SLOT( showPopupMenu(QListViewItem*,const QPoint&,int) ) );
	connect( scanTimer, SIGNAL(timeout()), this, SLOT(timerScanDone()) );
	connect( statusTimer, SIGNAL(timeout()), this, SLOT(timerStatusDone()) );
	connect( btnShowStats, SIGNAL(clicked() ), this, SLOT( showStats()) );
	connect( btnShowFilter, SIGNAL(clicked() ), this, SLOT( showFilter()) );
	connect( btnShowStatus, SIGNAL(clicked() ), this, SLOT( showStatus()) );
	connect( btnShowGPS, SIGNAL(clicked() ), this, SLOT( showGPS()) );
 	connect( getActionsMenu(), SIGNAL( aboutToShow() ), this, SLOT( apItemChanged()) );

	// Tab order
	setTabOrder( chkPreserve, chkSound );
	setTabOrder( cmbIface, btnRefresh );	
	setTabOrder( spInterval, lstFilter );
	setTabOrder( lstFilter, tblScan );
	setTabOrder( tblScan, buttonCancel );
	setTabOrder( buttonCancel, buttonOk );
	setTabOrder( buttonOk, btnStop );
	setTabOrder( btnStop, btnClear );
	setTabOrder( btnClear, btnGPS) ;
	setTabOrder( btnGPS, btnShowFilter );
	setTabOrder( btnShowFilter, btnShowStats );
	setTabOrder( btnShowStats, btnShowStatus );
	setTabOrder( btnShowStatus, btnShowGPS);

	// Update thes 'status' box
        getStatus(cmbIface->currentText());

	// Load configuration
	interface = cfg.getDefIface();
	
        // Commandline options:
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->isSet("iface")) 
		interface = args->getOption("iface");
	
	// Preference to the file from command line:
        if (args->isSet("fileopen"))	// First place: command line '-f' argument
                fileOpen((char *)QString(args->getOption("fileopen")).ascii());
	else if (args->count()) // Second place: filename w/o '-f' argument
		fileOpen((char *)QString(args->arg(0)).ascii());
	else if (cfg.getFileToOpen().length() > 0)  // Third place: filename from config file
		fileOpen((char *)cfg.getFileToOpen().ascii());	
	
	for(QStringList::Iterator it = strlist.begin(); it != strlist.end(); it ++)
		if ( interface == *it)
			cmbIface->setCurrentText(interface);
	
	sct = new ScanThread( this, "scanThread", (char *)interface.ascii() );	// Initialize the thread with the aproppriate interface name.
	SWSTray->setIface( cmbIface->currentText() );
	
	if (args->isSet("on") || cfg.getStartScanning())
		start();
	else
		stopScan();	
	
	if (args->isSet("enable-sound")) {
		chkSound->setChecked(TRUE);
		chkSoundClick();
	}

	// Configure database Connection.
	frmconfig * dlgCfg = new frmconfig;
		dlgCfg->configureConnection();
	delete dlgCfg;

	setAutoSaveSettings();
}

MainWindow::~MainWindow()
{
	qDebug("Deleting MainWindow...");
        if (gps->running()) {
                cout << "Waiting for 'gpScanner' thread..." << endl;
                gps->terminate();
                gps->wait();
        }
	if (sct->running()) {
                cout << "Waiting for 'scanThread' thread..." << endl;
                sct->terminate();
                sct->wait();
        }

        delete gps;
        delete shapefile;
        delete log;
	delete sct;
}

void MainWindow::showStats()
{
	if (tblStatsWEP->isHidden()) {
		tblStatsWEP->show();
		tblStatsChan->show();
		lblStats->show();
		btnShowStats->setPixmap(BarIcon("edit_remove"));
		if (viewStatsAction->isChecked() == FALSE) 
			viewStatsAction->setChecked(TRUE);
		
	} else {
		tblStatsWEP->hide();
		tblStatsChan->hide();
		lblStats->hide();
		btnShowStats->setPixmap(BarIcon("edit_add"));
		if (viewStatsAction->isChecked() == TRUE) 
			viewStatsAction->setChecked(FALSE);
	}
}

void MainWindow::showStatus()
{
	if (grpStatus->isVisible()) {
		grpStatus->hide();
		btnShowStatus->setPixmap(BarIcon("edit_add"));
		if (viewStatusAction->isChecked() == TRUE) 
			viewStatusAction->setChecked(FALSE);
	} else {
		grpStatus->show();
		btnShowStatus->setPixmap(BarIcon("edit_remove"));
		if (viewStatusAction->isChecked() == FALSE) 
			viewStatusAction->setChecked(TRUE);
	}
}

void MainWindow::showGPS()
{
	if (grpGPS->isVisible()) {
		grpGPS->hide();
		btnShowGPS->setPixmap(BarIcon("edit_add"));
		if (viewGPSAction->isChecked() == TRUE) 
			viewGPSAction->setChecked(FALSE);
	} else {
		grpGPS->show();
		btnShowGPS->setPixmap(BarIcon("edit_remove"));
		if (viewGPSAction->isChecked() == FALSE) 
			viewGPSAction->setChecked(TRUE);
	}
}

void MainWindow::showFilter()
{
	if (lstFilter->isVisible()) {
		lstFilter->hide();
		btnShowFilter->setPixmap(BarIcon("edit_add"));
		if (viewFilterAction->isChecked() == TRUE) 
			viewFilterAction->setChecked(FALSE);

	} else {
		lstFilter->show();
		btnShowFilter->setPixmap(BarIcon("edit_remove"));
		if (viewFilterAction->isChecked() == FALSE) 
			viewFilterAction->setChecked(TRUE);
	}
}

void MainWindow::fileSave()
{
        bool isActive = scanTimer->isActive();;
	QString aux;
	APEntry ap;

	// Warning if there are hidden accesspoint rows
	if (tblScan->childCount() > (int)tblScan->visiblesCount())
	{
		int msgResponse = KMessageBox::warningContinueCancel(this, i18n("There are some hidden AccessPoints which will not be included in the saved file"));
		switch(msgResponse)
		{
			case KMessageBox::Continue:
				break;
			default:
				return;
		}
	}

	// Can't use getSaveFileName because I need to access the selected extension (filter)
	KFileDialog dlg(":<swsfiles>", QString::null, this, "filesavedialog",true);
	dlg.setOperationMode( KFileDialog::Saving );
	dlg.setFilter("*.sws|" + i18n("SWScanner files") + " (*.sws) \n *.nsf|" + i18n("NetStumbler Summary files") + " (*.nsf)");
	dlg.setCaption(i18n("Choose a filename to save under"));

	// Stop scanning
	if (isActive)
		MainWindow::stopScan();

	// Necesary a populated table
	if (tblScan->childCount() == 0) 
	{
		KMessageBox::information( this, i18n("Sorry, but I can't save an empty table."));
		return;
	}

	// Show the fileSave dialog and get the filename and extension
	dlg.exec();
	QString filename = dlg.selectedFile();
	QString extension = dlg.currentFilter().right(3);

	// Control if a file has been selected or not
	if (!filename.isEmpty())
		KRecentDocument::add(filename);
	else
		return;

	// Add the apropriate extension if user didn't added it
	if (filename.right(3).lower() != extension)
	{
		if ( KMessageBox::questionYesNo(this, i18n("You haven't typed an extension. Sould I add it for you?")) == KMessageBox::Yes )
			filename.append("." + extension);
	}

	APList * list = new APList();
	tblScan->aplistFromTable(list);
	QFile file( filename );

        if ( extension == "sws" ) 
	{
		fileHandler::writeToSWS(&file, list);
        }
	else if ( extension == "nsf" )
	{

		if ( KMessageBox::warningContinueCancel(this, i18n("Although using 'nsf' format will allow you to open this\n"
								"file with NetStumbler, take into account that no geographical\n"
								"data will be saved on it" )) == KMessageBox::Cancel )
		{
			delete list;
			return;
		}
		fileHandler::writeToNSF(&file, list);
	}
	delete list;

        if(isActive)
                MainWindow::start();
}

void MainWindow::editCut()
{
    qWarning( "MainWindow::editCut(): Not implemented yet" );
}

void MainWindow::editCopy()
{
    qWarning( "MainWindow::editCopy(): Not implemented yet" );
}

void MainWindow::editPaste()
{
    qWarning( "MainWindow::editPaste(): Not implemented yet" );
}

void MainWindow::changeInterface(QString iface)
{
	bool doChange=FALSE;

	// Check the iface passed really exists
	refreshCombo();
	for (int i = 0; i < cmbIface->count(); i++)
	{
		if (cmbIface->text(i) == iface)
			doChange=TRUE;
	}
	if (doChange)
	{
		cmbIface->setCurrentText(iface);
		changeInterface();
	}
}

void MainWindow::changeInterface()
{
	sct->setIface( (char *) cmbIface->currentText().ascii() );
	SWSTray->setIface( cmbIface->currentText() );
}

void MainWindow::showPopupMenu(QListViewItem * it, const QPoint & pos, int col)
{
        if (it == 0) return;
	QString essid = it->text(tblScan->getCol(i18n("ESSID")));
        QString mac = it->text(tblScan->getCol(i18n("MAC")));
	bool wep = ((it->text(tblScan->getCol(i18n("WEP")))==i18n("YES")));
	
	configPopupMenu * cfgPopup = new configPopupMenu(this, "configmenu", essid, mac, wep, cmbIface->currentText());
	col=col;	//avoid the warning
        cfgPopup->exec(pos);
	delete cfgPopup;
}

KPopupMenu * MainWindow::getActionsMenu()
{
	KPopupMenu * actions = 0;
	QObjectList * list = queryList( "KPopupMenu" );
	QObjectListIt it( *list ); // iterate over the buttons
	QObject *obj;

	// Search for the XMLGUI added 'actions' menu
	while ( (obj = it.current()) != 0 )
	{
        	// for each found object...
        	++it;
		if (strcmp(obj->name(), "actions") == 0)
		{
			actions = (KPopupMenu *) obj;
			break;
		}
	}
	return actions;
}

void MainWindow::apItemChanged()
{
	apItemChanged(tblScan->selectedItem());
}

void MainWindow::apItemChanged( QListViewItem * item )
{ 
	static int idToRemove = -1;

	// Delete the accesspoint entry in 'actions' menu if:
	if (item == 0)
	{
		delete apConfigActions;
		apConfigActions = 0;
		idToRemove = -1;
		return;
	}
	if (!item->isVisible())
	{
		delete apConfigActions;
		apConfigActions = 0;
		idToRemove = -1;
		return;
	}

	QString essid = tblScan->getSelectedESSID();
	QString mac = tblScan->getSelectedMAC();
	bool wep = tblScan->getSelectedWEP();
	KPopupMenu * actions = getActionsMenu();

	// Preserve the old pointer
	KPopupMenu * oldpointer = apConfigActions;

	apConfigActions = new configPopupMenu(this, "accesspoint_actions", 
					essid,
					mac,
					wep,
					cmbIface->currentText());

	if (idToRemove != -1)
		delete oldpointer;

	idToRemove = actions->insertItem( SmallIcon(wep ? "redled" : "greenled"), essid + " (" + mac + ")",  apConfigActions );
}

void MainWindow::clearAll()
{
	tblScan->clear();
	lstFilter->clear();
	
	updateNumLabel();
	updateStatistics();
}

void MainWindow::GPSstart()
{
	// Don't do anything if it's already running
	if (gps->running())
		return;

	switch (log->open())
	{
		case -1: // Empty filename = cancelled
			KMessageBox::information(this, i18n("Empty filename. Cancelling action."));
			return;
		case -2: // User cancelled
			KMessageBox::information(this, i18n("Action cancelled by user."));
			return;
		case -3: // Error opening file - emits error inside the class
			return;
	}

	SWSconfig conf;
	int fd = gps->openPort((char *)conf.getSerialDev().ascii());
	gps->configure(fd);
	gps->start();

	btnGPS->setText(i18n("Stop GPS"));
	btnGPS->disconnect( SIGNAL(clicked()) );
	connect( btnGPS, SIGNAL( clicked() ), this, SLOT( GPSstop() ) );
}

void MainWindow::GPSstop()
{
	// Don't do anything if it's not running
	if (!gps->running())
		return;

	gps->terminate();
	gps->wait();
	btnGPS->setText(i18n("Start GPS"));
	GPSLed->off();
	log->close();
	lblLat->setText("0,0000000000");
	lblLong->setText("0,0000000000");
	lblSpeed->setText("0,0000000000");

	btnGPS->disconnect( SIGNAL(clicked()) );
	connect( btnGPS, SIGNAL( clicked() ), this, SLOT( GPSstart() ) );
}

void MainWindow::changeInterval()
{
        //this function is called when interval or interface are changed
        scanTimer->stop();
        scanTimer->start(spInterval->value()*1000);
}

void MainWindow::toolsUtilities()
{
        frmUtils utils;
        utils.exec();	//Show dialog in modal form
}

void MainWindow::toolsSettings()
{
	frmConfigIni config(this);
        config.exec();
}

void MainWindow::applyFilter(QListViewItem * node)
{
        int j=0;
        node=node;	// To avoid the warning --> not used
	QListViewItem * it = tblScan->firstChild();
	
	while ( it ) {
                if ( chkPreserve->isChecked() && lstFilter->passTheFilter(it) )
		{
                        it->setVisible(TRUE);
			j++;
		}
                else if ( !chkPreserve->isChecked() && lstFilter->passTheFilter(it) && (it->text(tblScan->getCol(i18n("SIGNAL")))!=i18n("N.A.")) )
		{
                        it->setVisible(TRUE);
			j++;
		}
                else
                        it->setVisible(FALSE);
		it=it->nextSibling();
        }

	updateNumLabel();
	updateStatistics();
}

void MainWindow::chkSoundClick()
{
	QToolTip::remove(chkSound);
	if (chkSound->isChecked()) {
// 		chkSound->setText(i18n("Sound enabled"));
		QToolTip::add(chkSound, i18n("Sound enabled"));
		tblScan->setSoundEnabled(TRUE);
	} else {
// 		chkSound->setText(i18n("Sound disabled"));
		QToolTip::add(chkSound, i18n("Check to enable sound"));
		tblScan->setSoundEnabled(FALSE);
	}
}

void MainWindow::chkPreserveClick()
{
        int j=0;
	QListViewItem * it = tblScan->firstChild();

	tblScan->setPreserve(chkPreserve->isChecked());
	
	if (chkPreserve->isChecked()) {
//                 chkPreserve->setText(i18n("Show all AccessPoints in memory"));
		QToolTip::remove (chkPreserve);
		QToolTip::add( chkPreserve, i18n("Showing all AccessPoints in memory"));
		while ( it ) {
                        if (lstFilter->passTheFilter(it))
			{
                                it->setVisible(TRUE);
				j++;
			}
                        else
                                it->setVisible(FALSE);
			it=it->nextSibling();
                }
        } else {
//                 chkPreserve->setText(i18n("Show active AccessPoints"));
		QToolTip::remove (chkPreserve);
		QToolTip::add( chkPreserve, i18n("Showing only active AccessPoints"));
		while ( it ) {
                        if (lstFilter->passTheFilter(it) && it->text(tblScan->getCol(i18n("SIGNAL")))!=i18n("N.A."))
			{
                                it->setVisible(TRUE);
				j++;
			}
                        else
                                it->setVisible(FALSE);
			it=it->nextSibling();
                }
        }

	updateNumLabel();
	updateStatistics();
}

void MainWindow::refreshCombo()
{
        char names[256];
        int num, i;
	QString actual = cmbIface->currentText();

        // get wireless interfaces
        names[0]='\0';
        GetWirelessInterfacesNames_new(names,&num);
        QStringList strlist = QStringList::split( "#", names );
        // configure combobox and add interfaces
        cmbIface->clear();
        cmbIface->insertStringList(strlist);
	
	for  (i=0; i< cmbIface->count(); i++)
	{
		if (actual == cmbIface->text(i))
			cmbIface->setCurrentText(actual);
	}
}

void MainWindow::getStatus(QString ifc)
{
        struct interface ife;
        struct sockaddr_in *pdir_inet;
        char iface[50];
        char ipaddr[16];
        int skfd=0, ch=0;

        /************ GENERAL INFO *************/

        if (ifc.isNull() || ifc.isEmpty())
                return;
        strcpy(iface,ifc.ascii());
        strncpy(ife.name, iface, IFNAMSIZ);
        cout << "if(" << ife.name << ")->";

        if (if_fetch(&ife) < 0) {
                cout << "Error fetching interface intormation(" << iface << ")";
                return;
        }

        grpStatus->setTitle(i18n("Status (%1)").arg(ifc));
        pdir_inet = (struct sockaddr_in*)&ife.addr;
        strcpy(ipaddr,inet_ntoa(pdir_inet->sin_addr));
        lblIP->setText(ipaddr);
        cout << ipaddr << "/";
        pdir_inet = (struct sockaddr_in*)&ife.netmask;
        strcpy(ipaddr,inet_ntoa(pdir_inet->sin_addr));
        lblIP->text() == "0.0.0.0" ? lblMask->setText("0.0.0.0") : lblMask->setText(ipaddr);
        cout << ipaddr;
        pdir_inet = (struct sockaddr_in*)&ife.broadaddr;
        strcpy(ipaddr,inet_ntoa(pdir_inet->sin_addr));
        lblIP->text() == "0.0.0.0" ? lblBcast->setText("0.0.0.0") : lblBcast->setText(ipaddr);
        cout << "/" << ipaddr << "####";

        /************ SPECIFIC WIRELESS INFO *************/
        //wireless_config wdata;
        wireless_info wdata;
        skfd = iw_sockets_open();

        //iw_get_basic_config(skfd, ife.name, &wdata);	//extracts information with low details

        iw_get_info(skfd, ife.name, &wdata);		//more details
        // ESSID
        if (wdata.b.has_essid == 1)
                lblEssid->setText(wdata.b.essid);
        else
                lblEssid->setText("????");
        // MODE
        if (wdata.b.has_mode == 1)
                switch (wdata.b.mode) {
                case 1:
                        lblMode->setText(i18n("Ad-hoc"));
                        break;
                case 2:
                        lblMode->setText(i18n("Managed"));
                        break;
                case 3:
                        lblMode->setText(i18n("Master"));
                        break;
                default:
                        lblMode->setText("????");
                        break;
                }
        else
                lblMode->setText("????");
        // CHANNEL
        struct iw_range		range;
        if (wdata.b.has_freq == 1) {
                iw_get_range_info(skfd, ife.name, &range);
                if (wdata.b.freq > 1000)
                        ch = iw_freq_to_channel(wdata.b.freq,&range);
                else
                        ch = (int) wdata.b.freq;
                lblChan->setText(QVariant(ch).toString());
        } else
                lblChan->setText("?");
        // ENCRIPTION
        if (wdata.b.has_key == 1)
                if ((wdata.b.key_flags & IW_ENCODE_DISABLED) || (wdata.b.key_size == 0)) {
                        lblWEP->setText(i18n("NO"));
                        lblKLen->setText("-");
                } else {
                        lblWEP->setText(i18n("YES"));
                        //lblWEP->setText((const char *)wdata.key);	//for debugging only
                        lblKLen->setText(QVariant(wdata.b.key_size).toString());
                }
        //ASOCIATED AP
        char buffer[25];
        lblAP->setText(iw_pr_ether(buffer, (const unsigned char *)wdata.ap_addr.sa_data));

        // STATISTICS
        iwstats stats;
        iw_get_stats (skfd,ife.name, &stats, &wdata.range, wdata.has_range);
        cout << "\tlevel: " << stats.qual.level - 0x100 << "  ";
        cout << "noise: " << stats.qual.noise - 0x100;
        cout << " (" << stats.qual.qual + 0 << ")" << endl;
        lblSignal->setText(QVariant(stats.qual.level - 0x100).toString());
        lblNoise->setText(QVariant(stats.qual.noise - 0x100).toString());
        lblSNR->setText(QVariant(stats.qual.qual).toString());
        pixSignal->setPixmap(getPix2(QVariant(lblSignal->text()).toInt()));

        ::close(skfd);

}

bool MainWindow::queryClose()
{
	recentsAction->saveEntries(KGlobal::config(), "RecentFiles");
// 	saveMainWindowSettings(KGlobal::config(), "MainWindow");
	return TRUE;
}

void MainWindow::fileRecents(const KURL& url)
{
	QString fileToOpen = url.directory() + "/" + url.fileName();
	fileOpen((char*) fileToOpen.ascii());
}

void MainWindow::fileOpen()
{
        fileOpen(0);
}

void MainWindow::fileAdd()
{
        fileAdd(0);
}

void MainWindow::fileOpen(char * name)
{
        if (name != 0)
                printf ("Opening file: %s", name);
        clearAll();
        fileAdd(name);
}

void MainWindow::fileAdd(char * name)
{

QString fileName;
APList * list = new APList();
APEntry * ap;

if (scanTimer->isActive())
	MainWindow::stopScan();

if (name == 0) {
	fileName = KFileDialog::getOpenFileName(
			":<swsfiles>", 
			"*.sws|" + i18n("SWScanner files") + " (*.sws) \n *.nsf|" + i18n("NetStumbler Summary files") + " (*.nsf)",
			this,
			i18n("Open file dialog"));
} else {
	fileName=QString(name);
}
if (fileName == "") return;

recentsAction->addURL(fileName);
QFile file (fileName);
// Search for the extension, case insensitive
if (fileName.right(3).contains("sws", FALSE))
{
	fileHandler::readFromSWS(&file, list);
}
else	// type = .nsf
{
	fileHandler::readFromNSF(&file, list);
}

// Now i've got the list of ap's to add to the table
for ( ap = list->first(); ap; ap = list->next() )
	tblScan->addNewAP(ap);

delete list;
chkPreserve->setChecked(TRUE);
chkPreserveClick();
flushOldNodes();	// Fills the signal cell with N.A. among other things
updateNumLabel();	// Update accesspoint count label
updateStatistics();	// UPdate statistics
}

QPixmap getPix2(int signal)
{
        QFile file;
        KIconLoader *loader = KGlobal::iconLoader();
        QPixmap icon;

        if ((signal > -100) && (signal < -90)) {
                file.setName("./minimum.png");
                if (file.exists())
                        icon = QPixmap("./minimum.png");
                else
                        icon = loader->loadIcon("minimum", KIcon::User);
        } else if ((signal >= -90) && (signal < -80)) {
                file.setName("./marginal.png");
                if (file.exists())
                        icon = QPixmap("./marginal.png");
                else
                        icon = loader->loadIcon("marginal", KIcon::User);
        } else if ((signal >= -80) && (signal < -70)) {
                file.setName("./good.png");
                if (file.exists())
                        icon = QPixmap("./good.png");
                else
                        icon = loader->loadIcon("good", KIcon::User);
        } else if ( (signal >= -70) || (signal < -200) ) {
                file.setName("./excellent.png");
                if (file.exists())
                        icon = QPixmap("./excellent.png");
                else
                        icon = loader->loadIcon("excellent", KIcon::User);
        } else {
                file.setName("./offline.png");
                if (file.exists())
                        icon = QPixmap("./offline.png");
                else
                        icon = loader->loadIcon("offline", KIcon::User);
        }
        return icon;
}

void delay (int sec)
{
        time_t start;
        time_t current;

        time(&start);
        do {
                time(&current);
        } while(difftime(current,start) < (double)sec);
}

void MainWindow::flushOldNodes ()
{
	QString soundPath = KStandardDirs::kfsstnd_defaultprefix() + "/" + KStandardDirs::kde_default("data") + "swscanner/sounds/";
	
	// If the ap is not in the list (table) then updates his row if chkPreserve is checked. Otherwise it is hidden.
 	QListViewItem * it = tblScan->firstChild();
	while ( it )
	{
		if ( !nodes->isInList ( (char *)it->text(tblScan->getCol(i18n("MAC"))).ascii()) )	//if it isn't in the list of current ap's:
                {
			it->setText(tblScan->getCol(i18n("SIGNAL")),i18n("N.A."));
			it->setText(tblScan->getCol(i18n("NOISE")),i18n("N.A."));
			it->setText(tblScan->getCol(i18n("SNR")), i18n("N.A."));
			it->setPixmap(0,getPix(-99));
			if (chkPreserve->isChecked() && lstFilter->passTheFilter(it))
			{
				it->setVisible(TRUE);	// show it if pass the filter and i want to preserve in list even non-active ap's
			}
			else	
			{
				if (it->text(tblScan->getCol(i18n("SIGNAL"))) == i18n("N.A.") && chkSound->isChecked() && it->isVisible())
					KAudioPlayer::play(soundPath + "swscanner_disappear.ogg");
				it->setVisible(FALSE);	// otherwise, hide it
			}
                }
		it=it->nextSibling();
        }
}

void MainWindow::repaintTable()
{
	tblScan->repaintTable();
        flushOldNodes();
// 	tblScan->adjustColumns();

	// Update the ap count label
	updateNumLabel();
	// Update the statustics;
	updateStatistics();
}

void MainWindow::timerScanDone()
{
	static bool makeSound = false;
	QString soundPath = KStandardDirs::kfsstnd_defaultprefix() + "/" + KStandardDirs::kde_default("data") + "swscanner/sounds/";

	if (sct->running()) return;	// Only go on if the previous scan has finished

	if (spInterval->value()/2 < 1)
		makeSound = !makeSound;
	else
		makeSound = TRUE;

	if (makeSound && chkSound->isChecked())
		KAudioPlayer::play(soundPath + "swscanner_scan.ogg");
	
	sct->start();
}

void MainWindow::timerStatusDone()
{
        getStatus(cmbIface->currentText());
}

void MainWindow::start()
{
        // put the card into managed mode 
        struct iwreq wrq;
        int skfd = iw_sockets_open();
	QString errnum;

        strncpy(wrq.ifr_name, cmbIface->currentText().ascii(), IFNAMSIZ);
        wrq.u.mode = 2;

        if(iw_get_ext(skfd, (char *)cmbIface->currentText().ascii(), SIOCSIWMODE, &wrq) < 0) {
                perror ("Error in SIOCSIWMODE");
                KMessageBox::error(this, "[SIOCSIWMODE] " + errnum.setNum(errno) + ": " + strerror(errno));
	}

        tblScan->setColumnText(0, SmallIcon("exec"), "  (" + i18n("ON") + ")");
        scanTimer->start(spInterval->value()*1000);
        //chkPreserve->setEnabled(TRUE);

	// get the iface up (necesary for the scanning process)
        struct ifreq ifr;		//structure passed as ioctl() argument
        memset(&ifr, 0, sizeof(ifr));	//reset the interface request structure
        strcpy(ifr.ifr_ifrn.ifrn_name, cmbIface->currentText().ascii());
        ifr.ifr_flags|=IFF_UP;		//add the 'up' flag to the interface
        if (ioctl(skfd, SIOCSIFFLAGS, &ifr) < 0) {
                perror ("Error in SIOCSIFFLAGS");
                KMessageBox::error(this, "[SIOCSIFFLAGS] " + errnum.setNum(errno) + ": " + strerror(errno));
        }
	::close(skfd);

	SWSTray->movie()->unpause();
	QToolTip::add( SWSTray, "<center>SWScanner</center>\n<center>Simple Wireless Scanner</center>\n<center><b>" + i18n("Scanning") + "</center></b>");
}

void MainWindow::stopScan()
{
        tblScan->setColumnText(0, SmallIcon("stop"), "  (" + i18n("OFF") + ")");
        scanTimer->stop();
	nodes->lock();
        nodes->clear();
	nodes->unlock();
        chkPreserve->setChecked(TRUE);
        chkPreserveClick();
        flushOldNodes();
        //chkPreserve->setEnabled(FALSE);

	SWSTray->movie()->step();	// Advance one frame and pause it
	QToolTip::add( SWSTray, "<center>SWScanner</center>\n<center>Simple Wireless Scanner</center>\n<center><b>" + i18n("Stopped") + "</center></b>" );
}

void MainWindow::customEvent( QCustomEvent * e )
{
	QString aux;
	char mac[20];
	APEntry * ap;
	frmSignalChart * chart = 0;
	SWSconfig cfg;
	
	if ( e->type() == (QEvent::Type) newGPSPositionEventNum )	// It must be a newPosEvent
	{
		cout << "New geoposition event received..." << endl;
		GPSLed->toggle();
		newGPSPositionEvent* pe = (newGPSPositionEvent *)e;
		geodata pos = pe->getPos();		
		lblLat->setText(aux.sprintf("%.10f",pos.lat_ddeg));
		lblLong->setText(aux.sprintf("%.10f",pos.long_ddeg));
		if (cfg.getSpeedUnits() == "kph")
			lblSpeed->setText(aux.sprintf("%.10f",pos.speed_kph));
		else if (cfg.getSpeedUnits() == "mph")
			lblSpeed->setText(aux.sprintf("%.10f",pos.speed_mph));
		else
			lblSpeed->setText(aux.sprintf("%.10f",pos.speed_knots));
		lblAPs->setText(QVariant(nodes->count()).toString());
		nodes->lock();
		for (uint i = 0; i < nodes->count(); i++)
			log->addLine(nodes->at(i), pos.long_ddeg, pos.lat_ddeg);
			//shapefile->newData(&(*nodes)[i],pos.long_ddeg, pos.lat_ddeg);	// Obsolete: before I writed directly the shapefile
		nodes->unlock();
	} else if (e->type() == (QEvent::Type) scanFinishedEventNum )
	{
		cout << "New 'scan finished' event received..." << endl;
		nodes->lock();	// Mutual exclusion
		repaintTable();
		// For each ap detected:
		for (uint i = 0; i < nodes->count(); i++) 
		{
			ap = nodes->at(i);	// Extract the ap information
			ap->getMAC(mac);	// Get the mac
			// Notify the new situation to the chart window only if it has been previously created
			chart = (frmSignalChart *)this->child(QString("chart_" + QString(mac)).ascii());
			if (chart)
			{
				// Create and send event
				newSignalDataReceivedEvent * ev = new newSignalDataReceivedEvent(ap);
				QApplication::postEvent(chart,ev); 
			}
		}
		nodes->unlock();
	} else if (e->type() == (QEvent::Type) parseFinishedEventNum )
	{
		cout << "New 'parse finished' event received..." << endl;
		chkPreserve->setChecked(TRUE);
		chkPreserveClick();
		flushOldNodes();	// Fills the signal cell with N.A. among other things
		updateNumLabel();
		updateStatistics();
	} else if (e->type() == (QEvent::Type) scanErrorEventNum )
	{
		cout << "New 'scan error' event received..." << endl;
		scanErrorEvent* ev = (scanErrorEvent *)e;
		stopScan();
		KMessageBox::error(this, ev->getError());
	}
}

//Update de label below the table:
void MainWindow::updateNumLabel()
{
	// Update label
	lblAPnum->setText(i18n("shown") + " <b>(" + QVariant(tblScan->visiblesCount()).toString() + ")</b>, " + i18n("total") + " <b>(" + QVariant(tblScan->childCount()).toString() + ")</b>");

}

void MainWindow::updateStatistics()
{
	QString number;
	bzero(&nodeStats, sizeof(nodeStats));

	QListViewItem * it = tblScan->firstChild();
	while ( it ) {
		if ( it->isVisible() ) {
			nodeStats.chans[it->text(tblScan->getCol(i18n("CHANNEL"))).toInt() - 1]++;
			(it->text(tblScan->getCol(i18n("WEP"))) == i18n("YES")) ? nodeStats.wepon++ : nodeStats.wepoff++;
		}
		it=it->nextSibling();
	}

	// Update stats table
	tblStatsWEP->setText(0, 0, number.setNum(nodeStats.wepon));
	tblStatsWEP->setText(1, 0, number.setNum(nodeStats.wepoff));
	for (int i=0; i<13; i++)
		tblStatsChan->setText(i, 0, number.setNum(nodeStats.chans[i]));
}

void MainWindow::asociate()
{
	QString essid = tblScan->currentItem()->text(tblScan->getCol(i18n("ESSID")));
	QString mac = tblScan->currentItem()->text(tblScan->getCol(i18n("MAC")));
	QString errnum;

        frmconfig * dlgCfg = new frmconfig;
        if (dlgCfg->isConfigured(essid, mac))
                dlgCfg->loadConfiguration(essid,mac);	//now I can access the properties directly from the widgets

        QString ip = dlgCfg->gettxtIP1()->text() + "." + dlgCfg->gettxtIP2()->text() + "." + dlgCfg->gettxtIP3()->text() + "." + dlgCfg->gettxtIP4()->text();
        QString mask = dlgCfg->gettxtMask1()->text() + "." + dlgCfg->gettxtMask2()->text() + "." + dlgCfg->gettxtMask3()->text() + "." + dlgCfg->gettxtMask4()->text();
        QString gw = dlgCfg->gettxtGat1()->text() + "." + dlgCfg->gettxtGat2()->text() + "." + dlgCfg->gettxtGat3()->text() + "." + dlgCfg->gettxtGat4()->text();

        // WIRELESS CONFIGURATION
        wireless_config wconf;
        memset((char *) &wconf, 0, sizeof(struct wireless_config)); //  reset the structure
        //  configure the structure:
        strcpy(wconf.name,cmbIface->currentText().ascii());
        wconf.has_nwid = 0;
        wconf.has_freq = 0;
        wconf.has_key = 1; // Allways 1 to enter the 'key stuff' part in iw_set_basic_config()
        strcpy((char *)wconf.key,dlgCfg->gettxtKey()->text().ascii());
        //  It's necesary to explicitly tell the driver to disable the key
        wconf.key_flags |= (dlgCfg->getchkWEP()->isChecked()) ? 0 : IW_ENCODE_DISABLED;
        wconf.key_size = (wconf.key_flags & IW_ENCODE_DISABLED)?0:((dlgCfg->getcmbKeyLength()->currentItem()) == 0 ? 5 : 13);
        wconf.has_essid = 1;
        wconf.essid_on = 1;
        strcpy(wconf.essid,essid.ascii());
        wconf.has_mode = 1;
        wconf.mode = 2;		//managed

        //commit the changes
        int skfd = iw_sockets_open();
        iw_set_basic_config(skfd, (char *)cmbIface->currentText().ascii(), &wconf);

        //INET CONFIGURATION
        //dhcp
        if (dlgCfg->getfrmDhcp()->isChecked()) {
                startDhcp(dlgCfg->gettxtDhcpClient()->text());
                if (dlgCfg->gettxtScript()->text().isNull() || dlgCfg->gettxtScript()->text().isEmpty()) {
                        ::close(skfd);
                        return;
                }
                executeScript(dlgCfg->gettxtScript()->text());
                ::close(skfd);
                return;
        }

        //static ip
        struct ifreq ifr;	//structure passed as ioctl() argument
        struct in_addr ipaddr;	//this struct only contains a ulong
        struct sockaddr_in *sin = (struct sockaddr_in *)&ifr.ifr_ifru.ifru_addr;	//first reference to the part
        										//that configures the ip address

        inet_aton(ip.ascii(),&ipaddr);	//convert fron ip in string(dotted) mode to a network address (ulong ins a in_addr struct)
        //ipaddr.s_addr=inet_addr(ip.ascii());
        memset(&ifr, 0, sizeof(ifr));	//reset the interface request structure
        //let's start configuring the structure:
        //-->IP ADDRESS:
        strcpy(ifr.ifr_ifrn.ifrn_name, cmbIface->currentText().ascii());
        sin->sin_family = AF_INET;
        sin->sin_addr.s_addr = ipaddr.s_addr;
        sin->sin_port = 0;	//not used
        if (ioctl(skfd, SIOCSIFADDR, &ifr) < 0) {
                perror ("Error in SIOCSIFADDR");
                KMessageBox::error(this, "[SIOCSIFADDR] " + errnum.setNum(errno) + ": " + strerror(errno));
        }

        //-->NETMASK:
        else {
                inet_aton(mask.ascii(),&ipaddr);	   //now ipaddr has the 'dotted' netmask transformed into a network address
                //ipaddr.s_addr=inet_addr(mask.ascii());
                sin =  (struct sockaddr_in *)&ifr.ifr_ifru.ifru_netmask;  //now sin points to the structure that controls the mask
                sin->sin_family = AF_INET;
                sin ->sin_addr.s_addr = ipaddr.s_addr;
                sin->sin_port = 0;	//not used
                if (ioctl(skfd, SIOCSIFNETMASK, &ifr) < 0) {
                        perror ("Error in SIOCSIFNETMASK");
                        KMessageBox::error(this, "[SIOCSIFNETMASK] " + errnum.setNum(errno) + ": " + strerror(errno));
                }
        }

        //-->DEFAULT GATEWAY:
	if (dlgCfg->getfrmGate()->isChecked())
        	if (set_default_gw( skfd, (char *)gw.ascii()) < 0)
                	KMessageBox::error(this, "[Adding default route] " + errnum.setNum(errno) + ": " + strerror(errno));

        // FINAL SCRIPT:
        if (dlgCfg->gettxtScript()->text().isNull() || dlgCfg->gettxtScript()->text().isEmpty()) {
                ::close(skfd);
                return;
        }
        executeScript(dlgCfg->gettxtScript()->text());

        ::close(skfd);

        delete dlgCfg;
}

void MainWindow::showConfig()
{
        QString essid = tblScan->currentItem()->text(tblScan->getCol(i18n("ESSID")));
        QString mac = tblScan->currentItem()->text(tblScan->getCol(i18n("MAC")));
        bool wep = tblScan->currentItem()->text(tblScan->getCol(i18n("WEP")))==i18n("YES")?true:false;

        frmconfig * config = new frmconfig (this, essid + "-configuration");	//call to constructor->configure the connections

	// Set the labels text and checkboxes
        config->getlblEssid()->setText(essid);
        config->getlblMAC()->setText(mac);
        config->getchkWEP()->setChecked(wep);
        if (wep) {
                config->gettxtKey()->setEnabled(true);
                config->getcmbKeyLength()->setEnabled(true);
        } else {
                config->gettxtKey()->setEnabled(false);
                config->getcmbKeyLength()->setEnabled(false);
        }
	
	// isConfigured() also sets the private boolean member "Configured" (for internal uses)
        if (config->isConfigured(essid, mac)) {
		config->setButtonGuiItem(KDialogBase::User1, KGuiItem(i18n("Change"), "filesave"));
		config->loadConfiguration(essid, mac);
	}
        else
		config->setButtonGuiItem(KDialogBase::User1, KGuiItem(i18n("Save"), "filesave"));

        config->exec();
	apItemChanged(tblScan->currentItem()); // update 'actions' menu because it could have changed
}

void MainWindow::removeConfig()
{
        QString essid = tblScan->currentItem()->text(tblScan->getCol(i18n("ESSID")));
        QString mac = tblScan->currentItem()->text(tblScan->getCol(i18n("MAC")));

        frmconfig * dlgCfg;
        dlgCfg = new frmconfig;	//call to constructor->configure the connections
        dlgCfg->removeConfig(essid,mac);
        delete dlgCfg;
	apItemChanged(tblScan->currentItem()); // update 'actions' menu because it could have changed
}

void MainWindow::showChart()
{
	QString mac = tblScan->currentItem()->text(tblScan->getCol(i18n("MAC")));
	
	if ((frmSignalChart *)this->child(QString("chart_" + mac).ascii())) 
		qDebug ("Chart for %s already present", mac.ascii());
	else {
		frmSignalChart * chart = new frmSignalChart(mac, this, QString("chart_" + mac).ascii(), false);
		chart->flushData();
		chart->show();
	}
}

void MainWindow::startDhcp(QString dhclient)
{
	SWSconfig conf;
        QProcess * proc;
	proc = new QProcess( this );
	
	if (conf.getUseTerminal())	// if it's configured to show dhclient stdout in a terminal:
	{
		proc->addArgument(conf.getTerminal());	//execute the dhcp client in the configured terminal.
		proc->addArgument("-e");
	}
	
        proc->addArgument(dhclient);
        proc->addArgument(cmbIface->currentText());

        delay(2);
	
        if (!proc ->launch(QString::null))
		if (conf.getUseTerminal())
                	KMessageBox::information(this, i18n("Error when executing") + " '" + conf.getTerminal() + QString(" -e %1 %2'").arg(dhclient,cmbIface->currentText()));
		else
			KMessageBox::information(this, i18n("Error when executing %1 %2").arg(dhclient,cmbIface->currentText()));
	delete proc;

}

void MainWindow::executeScript(QString script)
{
	SWSconfig conf;
        QStringList strL = QStringList::split(" ", script);
        QProcess * pscript;
	
	pscript = new QProcess( this );
	
	if (conf.getUseTerminal())	// if it's configured to show dhclient stdout in a terminal:
	{
		pscript->addArgument(conf.getTerminal());	//execute the script in the configured terminal.
		pscript->addArgument("-e");
	}
        //  Extract arguments and add them to the process
        for ( QStringList::Iterator it = strL.begin(); it != strL.end(); ++it )
                pscript->addArgument(*it);

        delete pscript;
	cout << "Executing '" << script.ascii() << "'  ...." << endl;
        delay(1);
        if (!pscript ->launch(QString::null))
                KMessageBox::information(this, i18n("Error when executing %1").arg(script));

}

void MainWindow::keyReleaseEvent(QKeyEvent * e)
{
 	if ( e->key() == Key_Escape ) close();
}
