#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
This module contains tools for consistent naming of classes.
"""

__author__ = "Martin Sandve Alnes"
__date__   = "2008-08-12 -- 2009-04-23"
__copyright__ = "(C) 2008-2009 Martin Sandve Alnes and Simula Resarch Laboratory"
__license__  = "GNU GPL Version 2, or (at your option) any later version"

import re
import hashlib

def short_name(prefix, name, max_name_length = 60):
    if len(name) > max_name_length:
        name = hashlib.md5(name).hexdigest().lower()
    return prefix + name

def base_element_classname(element):
    #return "%s_%s_%d" % (element.family, element.cell, element.degree)
    s = repr(element).strip()
    s = re.sub("[^\w]", "_", s)
    s = re.sub("_+", "_", s)
    s = s.strip("_")
    return s

def finite_element_classname(element):
    return short_name("fe_", base_element_classname(element))

def dof_map_classname(element):
    return short_name("dm_", base_element_classname(element))

def integral_classname(integral, form_name):
    m = integral.measure()
    prefix = "%s_integral_%s" % (m.domain_type(), m.domain_id())
    return short_name(prefix, form_name)

def form_classname(form, options):
    if options.code.form.name:
        form_name = options.code.form.name
    else:
        checksum = hashlib.md5(repr(form) + repr(options))
        form_name = checksum.hexdigest().lower()
    
    return short_name("form_", form_name)
