// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#ifndef CROUZEIXRAVIART_IS_INCLUDED
#define CROUZEIXRAVIART_IS_INCLUDED

#include "FE.h"

namespace SyFi
{

	class CrouzeixRaviart : public StandardFE
	{
		public:
			CrouzeixRaviart();
			CrouzeixRaviart(Polygon& p, unsigned int order = 1);
			virtual ~CrouzeixRaviart() {}

			void compute_basis_functions();
	};

	class VectorCrouzeixRaviart : public StandardFE
	{
		protected:
			unsigned int size;
		public:
			VectorCrouzeixRaviart();
			VectorCrouzeixRaviart(Polygon& p, unsigned int order = 1, unsigned int size = -1);
			virtual ~VectorCrouzeixRaviart() {}

			virtual void set_size(unsigned int size_);
			virtual void compute_basis_functions();
	};

}
#endif
