// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#include "Dof.h"

using namespace std;

namespace SyFi
{

	void Dof::clear()
	{
		counter = 0;
		emax = 0;
		imax = 0;

		loc2glob.clear();
		dof2glob.clear();
		glob2dof.clear();
		glob2loc_map.clear();
	}

	unsigned int Dof:: insert_dof(unsigned int e, unsigned int i, GiNaC::ex Li)
	{
		if (e > emax) emax = e;
		if (i > imax) imax = i;

		unsigned int return_dof;

		// check if the dof is new, if so
		// update counter, dof2glob and create
		// a new vector in glob2loc_map

		std::map< GiNaC::ex, unsigned int, GiNaC::ex_is_less >::iterator index_iter = dof2glob.find(Li);

		if( index_iter == dof2glob.end() )
		{
			// define a new dof
			return_dof = counter;

			// count inserted global indices
			counter++;

			// the central "D -> global index" map
			dof2glob[Li] = return_dof;

			if ( create_glob2dof )
			{
				std::pair<unsigned int, GiNaC::ex> p(return_dof, Li);
				glob2dof.insert(p);
			}

			if ( create_glob2loc )
			{
				// initialize with empty vector
				glob2loc_map[return_dof] = vector_ii();
				glob2loc_map[return_dof].reserve(imax);
			}
		}
		else					 // dof is not new
		{
			return_dof = index_iter->second;
		}

		// loc2glob should always be updated
		pair_ii index(e, i);
		loc2glob[index] = return_dof;

		// insert (e,i) in glob2loc_map[Li]
		if ( create_glob2loc )
		{
			glob2loc_map[return_dof].push_back(index);
		}

		return return_dof;
	}

	unsigned int Dof::glob_dof(unsigned int e, unsigned int i)
	{
		pair_ii index(e, i);
		std::map<pair_ii, unsigned int >::iterator res = loc2glob.find(index);

		if ( res == loc2glob.end() )
		{
			//throw std::runtime_error("In glob_dof(e,i): Not found");
			return -1;
		}

		return res->second;
	}

	unsigned int Dof::glob_dof(GiNaC::ex Lj)
	{
		std::map<GiNaC::ex, unsigned int, GiNaC::ex_is_less>::iterator res = dof2glob.find(Lj);

		if ( res == dof2glob.end() )
		{
			//throw std::runtime_error("In glob_dof(Lj): Not found");
			return -1;
		}

		return res->second;
	}

	GiNaC::ex Dof::glob_dof(unsigned int j)
	{
		if ( !create_glob2dof )
		{
			throw std::runtime_error("This structure has not been created, you must turn on the create_glob2dof flag before initialization!");
		}

		std::map<unsigned int, GiNaC::ex>::iterator iter = glob2dof.find(j);

		if ( iter == glob2dof.end() )
		{
			//throw std::runtime_error("In glob_dof(j): Not found");
			std::cerr << "In glob_dof(j): Not found" << std::endl;
			return GiNaC::ex();
		}

		return iter->second;
	}

	vector_ii Dof::glob2loc(unsigned int j)
	{
		if ( !create_glob2loc )
		{
			throw std::runtime_error("This structure has not been created, you must turn on the create_glob2loc flag before initialization!");
		}

		return glob2loc_map[j];
	}

}
