// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#ifndef P0FE_IS_INCLUDED
#define P0FE_IS_INCLUDED

#include "FE.h"

namespace SyFi
{

	class P0 : public StandardFE
	{
		public:
			P0();
			P0(Polygon& p, unsigned int order = 0);
			virtual ~P0() {}

			virtual void compute_basis_functions();
	};

	class VectorP0 : public StandardFE
	{
		protected:
			unsigned int size;
		public:
			VectorP0();
			VectorP0(Polygon& p, unsigned int order = 0, unsigned int size = 0 );
			~VectorP0() {}

			virtual void set_size(unsigned int size_);
			virtual void compute_basis_functions();
	};

	class TensorP0 : public StandardFE
	{
		protected:
			unsigned int size;
		public:
			TensorP0();
			TensorP0(Polygon& p, unsigned int order = 0, unsigned int size = 0 );
			~TensorP0() {}

			virtual void set_size(unsigned int size_);
			virtual void compute_basis_functions();
	};

}
#endif
