// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef SYFI_IS_INCLUDED
#define SYFI_IS_INCLUDED

// misc
#include "tools.h"

// dof mapping
#include "Dof.h"
#include "DofT.h"

// base classes for element hierarchy
#include "Polygon.h"
#include "FE.h"
#include "MixedFE.h"

// concrete element implementations
#include "Lagrange.h"
#include "CrouzeixRaviart.h"
#include "P0.h"
#include "RaviartThomas.h"
#include "BrezziDouglasMarini.h"
#include "DiscontinuousLagrange.h"
#include "Hermite.h"
#include "Nedelec.h"
#include "Nedelec2Hdiv.h"
#include "Bubble.h"
#include "ArnoldFalkWintherWeakSym.h"
#include "Robust.h"
#include "SpaceTimeElement.h"

// example code
#include "ElementComputations.h"

// code generation related
/*
#include "TempSymbolHandler.h"
#include "ExpressionCollection.h"
#include "ExpressionSimplifier.h"
*/
#endif
