/*
 * Sylpheed -- a GTK+ based, lightweight, and fast e-mail client
 * Copyright (C) 1999,2000 Hiroyuki Yamamoto
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stddef.h>
#include <glib.h>
#include <gtk/gtkstatusbar.h>

#include "intl.h"
#include "inputdialog.h"
#include "alertpanel.h"
#include "mainwindow.h"
#include "gtkutils.h"
#include "mh.h"

#define SETUP_DIALOG_WIDTH	540

static void scan_tree_func(Folder *folder, FolderItem *item, gpointer data);

void setup(MainWindow *mainwin)
{
	gchar *path;
	Folder *folder;

	path = input_dialog
		(_("Mailbox setting"),
		 _("First, you have to set the location of mailbox.\n"
		   "You can use existing mailbox in MH format\n"
		   "if you have the one.\n"
		   "If you're not sure, just select OK."),
		 "Mail");
	if (!path) return;
	if (folder_find_from_path(path)) {
		g_warning("The mailbox already exists.\n");
		g_free(path);
		return;
	}

	folder = folder_new(mh_get_class(), !strcmp(path, "Mail") ? _("Mailbox") : g_basename(path), path);
	g_free(path);

	if (folder->klass->create_tree(folder) < 0) {
		alertpanel_error(_("Creation of the mailbox failed.\n"
				   "Maybe some files already exist, or you don't have the permission to write there."));
		folder_destroy(folder);
		return;
	}

	folder_add(folder);
	folder_set_ui_func(folder, scan_tree_func, mainwin);
	folder_scan_tree(folder);
	folder_set_ui_func(folder, NULL, NULL);
}

static void scan_tree_func(Folder *folder, FolderItem *item, gpointer data)
{
	MainWindow *mainwin = (MainWindow *)data;
	gchar *str;

	if (item->path)
		str = g_strdup_printf(_("Scanning folder %s%c%s ..."),
				      LOCAL_FOLDER(folder)->rootpath,
				      G_DIR_SEPARATOR,
				      item->path);
	else
		str = g_strdup_printf(_("Scanning folder %s ..."),
				      LOCAL_FOLDER(folder)->rootpath);

	gtk_statusbar_push(GTK_STATUSBAR(mainwin->statusbar),
			   mainwin->mainwin_cid, str);
	gtkut_widget_wait_for_draw(mainwin->hbox_stat);
	gtk_statusbar_pop(GTK_STATUSBAR(mainwin->statusbar),
			  mainwin->mainwin_cid);
	g_free(str);
}
