/*
 * synaptiks -- a touchpad control tool
 *
 *
 * Copyright (C) 2009, 2010 Sebastian Wiesner <basti.wiesner@gmx.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef QXINPUT_H
#define QXINPUT_H

/**
 * @file
 *
 * This file exports functions from the X11 XInput extension.  The functions
 * work just like their counterparts from the XLib headers, except that they
 * are overloaded to implicitly use QX11Info::display().
 *
 * Read the Xlib manpages for detailled information about the function
 * parameters.
 */

#include "config-synaptiks.h"
#ifdef HAVE_XINPUT2
#error "XInput2 enabled, do NOT use this file"
#endif

#include <QtGui/QX11Info>
extern "C" {
#include <X11/extensions/XInput.h>
}
#include "qxlib.h"

namespace QX11 {

    inline XExtensionVersion *GetExtensionVersion(const char *name) {
        return XGetExtensionVersion(QX11Info::display(), name);
    }

    inline XDeviceInfo *ListInputDevices(int *ndevices_return) {
        return XListInputDevices(QX11Info::display(), ndevices_return);
    }

    inline XDevice *OpenDevice(XID id) {
        return XOpenDevice(QX11Info::display(), id);
    }

    inline void CloseDevice(XDevice *device) {
        XCloseDevice(QX11Info::display(), device);
    }

    inline Atom *ListDeviceProperties(XDevice *device, int *nprops) {
        return XListDeviceProperties(QX11Info::display(), device, nprops);
    }

    inline int GetDeviceProperty(
        XDevice *device, Atom property, long offset, long format,
        bool deleted, Atom type, Atom *return_type, int *return_format,
        unsigned long *nitems, unsigned long *bytes_after,
        unsigned char **data) {
        return XGetDeviceProperty(QX11Info::display(), device, property,
                                  offset, format, deleted, type,
                                  return_type, return_format, nitems,
                                  bytes_after, data);
    }

    inline void ChangeDeviceProperty(
        XDevice *device, Atom property, Atom type, int format, int mode,
        const unsigned char *data, int nelements) {
        XChangeDeviceProperty(QX11Info::display(), device, property, type,
                              format, mode, data, nelements);
    }
}

#endif /* QXINPUT_H */
