#!/usr/bin/env python

import os
import re
from distutils.sysconfig import get_config_var
from distutils.core import setup
from distutils.command.install import install

class my_install(install):
	def run(self):
		preprocess("src/Syncropated.py.in")
		install.run(self)
		os.system('touch ' + os.path.join(get_config_var('prefix'), "share/icons/hicolor/"))

def preprocess(path):
	if os.path.exists(path):
		src = open(path, "r")
		target = open(path.strip(".in"), "w")

		lines = src.readlines()[:]
	
		for line in lines:
			target.write(re.sub("@PREFIX@", get_config_var('prefix'), line))

		target.close()
		src.close()

def main():
	setup(name='syncropated',
			version='0.1.2',
			description='An application for syncing Music Player generated playlists for Mass Storage Devices such as the N770, MCC, and SD cards',
			long_description='Syncropated! is an application for syncing music player (Rhythmbox, Banshee, Amarok, iTunes, Window Media Player, ...) generated playlists, as well as photo albums (F-spot, Picasa) with mass storage devices such as the Nokia N770, MMC and SD cards.',
			author='Kenneth Rohde Christiansen',
			author_email='kenneth.christiansen@gmail.com',
			url='http://garage.maemo.org/syncropated',
			scripts=['src/syncropated'],
			package_dir={'syncropated': 'src', 'syncropated.data': 'data'},
			packages=['syncropated', 'syncropated.data'],
			data_files = [
                ('share/applications', ['data/syncropated.desktop']),
                ('share/icons/hicolor/scalable/apps', ['data/icons/scalable/syncropated.svg']),
                ('share/icons/hicolor/16x16/apps', ['data/icons/16x16/syncropated.png']),
                ('share/icons/hicolor/22x22/apps', ['data/icons/22x22/syncropated.png']),
                ('share/icons/hicolor/24x24/apps', ['data/icons/24x24/syncropated.png']),
                ('share/icons/hicolor/32x32/apps', ['data/icons/32x32/syncropated.png']),
				('share/syncropated/data/ui', ['data/glade/syncropated-ui.glade']),
				('share/syncropated/data/icons', ['data/icons/770.png']),
			],
			cmdclass = { 'install' : my_install },
	)

if __name__ == '__main__':
	main()
