C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE EVADFF
C                       *****************
C
C     --------------------------------------------------------------
     *(NODEBF,NELEBF,NDMASF,NREFAF,NPOIFF,NBCOUF,NBRAF,NELESF,NELRAF,
     * ITRAV)
C     --------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C              EVALUATION DES DIMENSIONS DES TABLEAUX NECESSAIRES      *
C              POUR LE FLUIDE                                          *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !  NODEBF   ! TE ! D  ! CONNECTIVITE DE MAILLAGE DE BORD FLUIDE      !
C !  NELEBF   !  E ! D  ! NBRE D'ELEMENT DE BORD FLUIDE                !
C !  NELESF   !  E ! R  ! NOMBRE D'ELTS DU MAILLAGE SURF COUPLE FLUIDE !
C !  NDMASF   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS FLUIDES SURF       !
C !  NREFF    ! TE ! D  ! REFERENCES DES NOEUDS FLUIDES                !
C !  NPOINF   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE FLUIDE  VOL     !
C !  NBCOUF   !  E ! R  ! NOMBRE DE NOEUDS FLUIDES COUPLES             !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :  
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "xrefer.h"
#include "nlofes.h"
#include "optct.h"
C
C**********************************************************************
C
C.. Variables externes
      INTEGER NELEBF,NELESF,NDMASF,NBCOUF
      INTEGER NELRAF,NBRAF
      INTEGER NODEBF(NELEBF,NDMASF),NREFAF(NELEBF)
      INTEGER NPOIFF,ITRAV(NPOIFF)
C
C
C.. Variables internes
      INTEGER I,M,N1,NUMREF
C
C**********************************************************************
C
      DO I=1,NPOIFF
       ITRAV(I)=0
      ENDDO
C
C     1 Nombre d'elements fluides couples
C     -------------------------------------
C
      NELESF = 0
      NELRAF = 0
C
      DO I=1,NELEBF
        NUMREF = NREFAF(I)
        IF (NUMREF.NE.0) THEN
           DO N1=1,NRFMAX
            IF (NUMREF.EQ.N1) THEN
             IF (IREFFC(N1).NE.0 .AND. IREFRF(N1).NE.0)  THEN
               NELESF=NELESF+1
               NELRAF=NELRAF+1
               DO M=1,NDMASF
                  ITRAV(NODEBF(I,M))=3
               ENDDO
             ELSEIF (IREFFC(N1).NE.0)  THEN
               NELESF=NELESF+1
               DO M=1,NDMASF
                  ITRAV(NODEBF(I,M))=1
               ENDDO
             ELSEIF (IREFRF(N1).NE.0)  THEN
               NELRAF=NELRAF+1
               DO M=1,NDMASF
                  ITRAV(NODEBF(I,M))=2
               ENDDO
             ENDIF
            ENDIF
           ENDDO
        ENDIF
      ENDDO
C
C     2 Nombre de noeuds fluides couples
C     -----------------------------------
      NBCOUF = 0
      NBRAF  = 0
C
C
      DO I=1,NPOIFF
        IF (ITRAV(I).EQ.1) THEN
          NBCOUF=NBCOUF+1
        ELSEIF (ITRAV(I).EQ.2) THEN
          NBRAF=NBRAF+1
        ELSEIF (ITRAV(I).EQ.3) THEN
          NBCOUF=NBCOUF+1
          NBRAF=NBRAF+1
        ENDIF
      ENDDO
C
C
C     3- IMPRESSIONS
C     ==============
C
      IF (NBLBLA.GT.0) THEN
        WRITE(NFECRA,3000) NBCOUF,NELESF,NBRAF,NELRAF
      ENDIF
C
C
C--------
C FORMATS
C--------
C
C
 3000 FORMAT(/,' *** EVADFF : CARACTERISTIQUES DU MAILLAGE ',
     &       'FLUIDE : ',/,
     &         '              NOMBRE DE ...',/,
     &   15X,'- nombre de noeuds couples avec le solide ',I9,/,
     &   15X,'- d''elements couples avec le solide       ',I9,/,
     &   15X,'- nombre de noeuds avec rayonnement       ',I9,/,
     &   15X,'- d''elements avec rayonnement             ',I9)
C
C----
C FIN
C----
C
      RETURN
      END

