C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
                        SUBROUTINE FI2TEQ
C                       *****************
C
C      -------------------------------------------------------- 
     * (NELRAY,NFFIRA,NGFFIR,EMISSI,TEMRAY,FIRAY,VFIRAY,FDFRAY,
     *  RADIOS,ERAYEQ,TRAYEQ,SUFRAY,FDFNP1)
C      -------------------------------------------------------- 
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            CALCUL DES TEMPERATURES ET EMISSIVITE EQUIVALENTE         *
C            LORSQU'IL Y A PLUSIEURS BANDES SPECTRALES                 *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NELRAY   !  E ! D  ! NOMBRE DE FACES DU MAILLAGE DE RAYONNEMENT   !
C !  NODRAY   ! TE ! D  ! CONNECTIVITE DU MAILLAGE DE RAYONNEMENT      !
C !  EMISSI   ! TE ! D  ! EMISSIVITE DE FACETTE POUR CHAQUE BANDE      !
C !  TEMRAY   ! TR ! D  ! TEMPERATURE DE LA FACE DE RAYONNT A L'ETAPE N!
C !  FIRAY    ! TR ! R  ! FLUX DE LA FACE DE RAYONNT A L'ETAPE N       !
C !  FDFRAY   ! TR ! R  ! FACTEURS DE FORME RAYONNEMENT                !
C !  RADIOS   ! TR ! R  ! RADIOSITE (maillage rayt)                    !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "divct.h"
#include "rayonn.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NELRAY,NFFIRA,NGFFIR(NFFIRA)
      DOUBLE PRECISION TEMRAY(NELRAY),FIRAY(NELRAY,NBANDE)  
      DOUBLE PRECISION FDFRAY(NELRAY*(NELRAY+1)/2),RADIOS(NELRAY,NBANDE)
      DOUBLE PRECISION EMISSI(NELRAY,2,NBANDE),ERAYEQ(NELRAY)
      DOUBLE PRECISION TRAYEQ(NELRAY)
      DOUBLE PRECISION VFIRAY(NFFIRA,NBANDE,2)
      DOUBLE PRECISION SUFRAY(NELRAY),FDFNP1(NELRAY)
C
C.. Variables internes
      INTEGER N,M,I,J,NGFAC
      DOUBLE PRECISION EPS
      DOUBLE PRECISION W1,W2,TFAC,XJ(NBAMAX)
      DOUBLE PRECISION C2,X1,X2,V,V2,V4,RR
C
      LOGICAL LVERIF
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      LVERIF = .FALSE.
      EPS = 1E-6
      C2 = 1.4388E-2
      DO 100 I=1,NELRAY
           TRAYEQ(I) = 0.D0
           ERAYEQ(I) = 0.D0
  100 CONTINUE
C
C***********************************************************************
C
C     2- Cas d'une seule bande spectrale
C     ================================== 
      IF ( NBANDE .EQ. 1 ) THEN
C
         IF (LROUVR) THEN
           XJ(1) = SIGMA * (TEMINF+TKEL)**4
         ENDIF 
C
        DO 200 I=1,NELRAY
              ERAYEQ(I) = EMISSI(I,1,1)
              RR        = 0.
              DO 210 J=1,I
                 RR = RR + FDFRAY((J-1)*NELRAY-(J-1)*J/2+I)* RADIOS(J,1)
  210         CONTINUE
              DO 211 J=I+1,NELRAY
                 RR = RR + FDFRAY((I-1)*NELRAY-(I-1)*I/2+J)* RADIOS(J,1)
  211         CONTINUE
              IF (LROUVR) THEN
                 RR = RR + FDFNP1(I)*XJ(1)
              ENDIF
              TRAYEQ(I) = (RR/SUFRAY(I)/SIGMA)**0.25
C
C
C        2.1- Calcul du Flux de rayonnement
C        -----------------------------------------------------------
              FIRAY(I,1) = EMISSI(I,1,1)*( SIGMA*TEMRAY(I)**4 -
     &                     RR/SUFRAY(I)) 
C
  200   CONTINUE
C
C
      ELSE
C
C     3- Cas de plusieurs bandes spectrales
C     ===================================== 
C
      DO 300 N=1,NBANDE
C
        X1 = C2/SPECTL(N,1)
        X2 = C2/SPECTL(N,2)
C
        IF (LROUVR) THEN
          V = X1/(TEMINF+TKEL)
          CALL WIEBEL(V,W1)
          V = X2/(TEMINF+TKEL)
          CALL WIEBEL(V,W2)
          XJ(N) = SIGMA * (TEMINF+TKEL)**4 * (W2-W1)
        ENDIF 
C
        DO 310 I=1,NELRAY
C
          V = X1/TEMRAY(I)
          CALL WIEBEL(V,W1)
C
          V = X2/TEMRAY(I)
          CALL WIEBEL(V,W2)
C
          ERAYEQ(I) = ERAYEQ(I) +  (W2-W1) * EMISSI(I,1,N)
  310   CONTINUE
C
  300   CONTINUE
C
        DO 320 I=1,NELRAY
            RR = 0.
            DO 339 N=1,NBANDE
              DO 340 J=1,I
                 RR = RR + FDFRAY((J-1)*NELRAY-(J-1)*J/2+I)*
     &                     EMISSI(I,1,N)*RADIOS(J,N)
  340         CONTINUE
              DO 350 J=I+1,NELRAY
                 RR = RR + FDFRAY((I-1)*NELRAY-(I-1)*I/2+J)*
     &                     EMISSI(I,1,N)*RADIOS(J,N)
  350         CONTINUE
              IF (LROUVR) THEN
                 RR = RR + FDFNP1(I)*XJ(N)
              ENDIF
  339       CONTINUE
            TRAYEQ(I) = (RR/SUFRAY(I)/ERAYEQ(I)/SIGMA)**0.25
  320   CONTINUE
C
C
C     4.- Calcul du Flux de rayonnemnent (pour le post-processing)
C     ========================================================
      DO 400 N=1,NBANDE
C
        X1 = C2/SPECTL(N,1)
        X2 = C2/SPECTL(N,2)
C
        DO 410 I=1,NELRAY
C
          V = X1/TEMRAY(I)
          CALL WIEBEL(V,W1)
C
          V = X2/TEMRAY(I)
          CALL WIEBEL(V,W2)
C
          RR        = 0.
          DO 440 J=1,I
              RR = RR + FDFRAY((J-1)*NELRAY-(J-1)*J/2+I)*RADIOS(J,N)
  440     CONTINUE
          DO 450 J=I+1,NELRAY
              RR = RR + FDFRAY((I-1)*NELRAY-(I-1)*I/2+J)*RADIOS(J,N)
  450     CONTINUE
          IF (LROUVR) THEN
              RR = RR + FDFNP1(I)*XJ(N)
          ENDIF
          FIRAY(I,N) =  EMISSI(I,1,N)*(SIGMA* (W2-W1)*TEMRAY(I)**4-
     &                   RR/SUFRAY(I))
C
  410   CONTINUE
C
  400 CONTINUE

      ENDIF
C
C
C     5-Mise a jour des facettes avec flux imposee stockee dans vfiray
C     ================================================================
      DO 500 N=1,NBANDE
         DO 510 I=1,NFFIRA
           NGFAC = NGFFIR(I)
           FIRAY(NGFAC,N)  = VFIRAY(I,N,1)
           EMISSI(NGFAC,1,N) = VFIRAY(I,N,2)
  510    CONTINUE
  500 CONTINUE
C
C     6-Calcul de la temperature de la facette necessaire 
C     ================================================================
      DO 600 I=1,NFFIRA
         TFAC = 0.
         NGFAC = NGFFIR(I)
         DO 610 N=1,NBANDE
           TFAC = TFAC + (1. - VFIRAY(I,N,2)) / VFIRAY(I,N,2) *
     &                    VFIRAY(I,N,1) + RADIOS(I,N)
  610    CONTINUE
C
         TEMRAY(NGFAC) = (TFAC/SIGMA)**0.25
  600 CONTINUE
C
C***********************************************************************
C
C     8- IMPRESSION DE CONTROLE
C     =========================
C
      IF (NBLBLR .GE. 10) THEN
         WRITE(NFECRA,8000) 
         WRITE(NFECRA,8010) 
         DO 8100 I=1,NELRAY
            WRITE(NFECRA,8110) I,ERAYEQ(I),TRAYEQ(I)-TKEL
 8100    CONTINUE
      ENDIF
C
C
C--------
C FORMATS
C-------- 
C
 8000 FORMAT(/,'  *** FI2TEQ : CALCUL DES EMISSIVITES EQUIVALENTES',
     &          ' DES TEMPERATURES DE RAYONNEMENT EQUIVALENTES')
 8010 FORMAT(/,'  *** FI2TEQ : Facette    Emissivite equivalente  ',
     &          ' Temp equivalente (degres C)')
 8110 FORMAT(10X,I6,10X,E13.5,10X,E13.5)
 9110 FORMAT(5X,I6,3X,E13.5,3X,E13.5,3X,E13.5,3X,E13.5,3X,E13.5)
C
C----
C FIN
C----
      END


