/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "tree.h"
# include "abs.h"
# include "interfaces.h"


/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | ivoitj_2d                                                            |
  |         Detecter si deux point se voient                             |
  |======================================================================| */

void ivoitj_2d(struct node *arbre, struct node *noeud, struct node *noeud_arr,
            double ro[],double rd[],double pt_arr[],int *intersect, double size_min,
	    int nelray, int npoinr, int *nodray, double * cooray, int *arrivee,
	    double dim_boite[])
{

    struct element *fa1;
    int numel;
    struct node  *n_en_cours;  /*    int n_en_cours;*/
    double xv,yv,epsi;


    fa1 = noeud->lelement;
    n_en_cours =  noeud;   /*    n_en_cours =  noeud->name;*/
    epsi=1.E-6;

  /*  printf(">>> ivoitj_2d : on est dans la boite %d\n", noeud->name); 
    printf(">>> ivoitj_2d : xmin,xmax,ymin,ymax, %f %f %f %f \n", 
	   noeud->xc-noeud->size,noeud->xc+noeud->size, 
	   noeud->yc-noeud->size,noeud->yc+noeud->size ); */

 /*   printf(" on est dans la boite %d \n", noeud->name); */
    while (fa1 != NULL)
	{
	    numel = fa1->num;
/*	    printf(" on teste la facette %d\n",numel); */

/*	    printf(" ro, rd %f %f %f %f   \n", ro[0],ro[1],rd[0]*1.e6,rd[1]*1.e6); */
	    *intersect = ray_inter_seg(arbre,n_en_cours,numel,ro,rd,
				       npoinr,nelray,nodray,cooray,arrivee);

	    if (*intersect==0)
	      {
		fa1 = fa1->suivant;
		continue;
	      }
	    else
	      {
		/* printf(" >>> ivoitj_2d : intersection  avec l'element %d \n",*intersect); */
		break;
	      }

	} /* fin du while */




/* printf(" >> ivoitj_2d : test d'intersection : *intersect %d *arrivee %d\n", *intersect,*arrivee);*/
/*    if (!( *intersect || *arrivee ||(noeud->name==noeud_arr->name) ))  */
    if (!( *intersect || *arrivee ||(noeud==noeud_arr) ))
	{
	    voxel_voisin_2d(&xv,&yv,noeud->xc,noeud->yc, noeud->sizx,noeud->sizy,
		            ro,rd,pt_arr,size_min);
	    if (abs(rd[0])<epsi && abs(rd[1])<epsi)
	      {
		*arrivee=1;
		*intersect=0;
	/*	printf(" >> ivoitj_2d : on sort par rd nul\n"); */
	      }
	    else
	      {
		noeud = arbre;
		find_node_2d(&noeud,xv,yv);
		if (in_rectan(xv,yv,dim_boite[0],dim_boite[1],dim_boite[2],dim_boite[3]))
		  ivoitj_2d(arbre,noeud,noeud_arr,ro,rd,pt_arr,intersect,size_min,
		            nelray,npoinr,nodray,cooray,arrivee,dim_boite);
		else
		  {
		    *intersect=0;
	/*	    printf(" >> ivoitj_2d : on est sorti de la boite noeud->name= %d\n",noeud->name); */
		  }
	      }
	}
}






/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | ray_inter_seg                                                        |
  |         detection de l'intersection entre un rayon et un segment     |
  |======================================================================| */
int ray_inter_seg(struct node *arbre,struct node *n_en_cours,
		       int numel,double ro[],double rd[],
		       int npoinr,int nelray,int *nodray,double *cooray,
		       int *arrivee)
{

  int nelray2,npoinr2,na,nb,i,j;
  double xa,ya,xb,yb;
  double a,b,c,t,den,epsi,xp,yp;
  struct node *noeud;


  epsi=1.E-6;    
  npoinr2 = npoinr*2;    nelray2 = nelray*2;


  na = *(nodray+numel-1); nb = *(nodray+numel-1+nelray); 
  xa= *(cooray+na-1); ya= *(cooray+na-1+npoinr);
  xb= *(cooray+nb-1); yb= *(cooray+nb-1+npoinr); 

  a = ya-yb; b = xb-xa;  c = -(a*xa+b*ya);

  den = a*rd[0]+b*rd[1];


 /*  printf( " den %f \n",den);*/

  if (abs(den)<epsi)
      return(0);
  
  t = - (c  + a*ro[0]+b*ro[1] ) / den; 

  if (t<epsi)     
      return(0);

  else if (t>(1+epsi)) 
      return(0);



  xp = ro[0]+t*rd[0];  yp = ro[1]+t*rd[1]; 
  if (in_seg(xa,ya,xb,yb,xp,yp))
    {
      if (abs(t-1.)<epsi) 
	{      
	  noeud = arbre;
	  find_node_2d(&noeud,xp,yp);
/*	  printf("recherche preliminaire : %d\n",noeud->name); */
	  for (i=-1;i<2;i=i+2)
	    for (j=-1;j<2;j=j+2)
		{
		  noeud = arbre;
		  find_node_2d(&noeud,xp+epsi*i,yp+epsi*j);
/*		  printf("i,j,k,noeud->name n_en_cours %d %d %d %d  xp yp %f %f  \n",
			 i,j,k,noeud->name,n_en_cours,xp,yp); */

		  if (noeud == n_en_cours) 
		    {*arrivee = 1;}
		}

	  return(0); 
	}
      else
	return(numel);
    }
  else
    return(0);
}



/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | voxel_voisin_2d                                                      |
  |         Recherche du voxel voisin                                    |
  |======================================================================| */

void voxel_voisin_2d (double *xv,double *yv,double xc, double yc, double dx,double dy,
		      double ro[], double rd[], double pt_arr[], double size_min)

{
    int it;
    double t,tt[2],orient[2],xpi,ypi,ddx,ddy,size,epsv,xn;

    size = size_min/4.;
    epsv=1.E-6;

    if (abs(rd[0])<epsv)
	tt[0] = 1.E6;  
    else
	{
	    t=(xc+dx-ro[0])/rd[0]; tt[0]=t; orient[0] = 1.;                  /* plan x=xc+dx */
	    t=(xc-dx-ro[0])/rd[0]; if(t>tt[0]) {tt[0]=t; orient[0] = -1.;}   /* plan x=xc-dx */
	}

    if (abs(rd[1])<epsv)
	tt[1] = 1.E6;  
    else
	{
	    t=(yc+dy-ro[1])/rd[1]; tt[1]=t; orient[1] = 1.;                  /* plan y=yc+dy */
	    t=(yc-dy-ro[1])/rd[1]; if(t>tt[1]) {tt[1]=t; orient[1] = -1.;}   /* plan y=yc-dy */
	}


    it = 0; t=tt[0];
    if (tt[1]<t) {it=1; t= tt[1];}
 
    xpi = ro[0] + t*rd[0]; ypi = ro[1] + t*rd[1];

    if (abs(tt[0]-tt[1])<epsv)
	{ddx=orient[0]*size; ddy=orient[1]*size;}

    else if (it==0)
	{ddx=orient[0]*size; ddy=0. ;}

    else if (it==1)
	{ddx=0.; ddy=orient[1]*size;}

    if (abs(xpi-ro[0])<epsv && abs(ypi-ro[1])<epsv )
	{
	    xn = sqrt(rd[0]*rd[0]+rd[1]*rd[1]);
	    *xv = xpi + rd[0]/xn*size;        
	    *yv = ypi + rd[1]/xn*size;    
	}
    else
	{
	    *xv = xpi + ddx;         
	    *yv = ypi + ddy;
	}

    ro[0] = xpi;
    ro[1] = ypi;

    rd[0] = pt_arr[0] - xpi;
    rd[1] = pt_arr[1] - ypi;
/*    printf(">>> ivoitj_2d : intersection avec boite %f %f %f \n",xpi,ypi,zpi);  */


}
