C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=LIMRES,SSI=0
                        SUBROUTINE LIMRES
C                       *****************
C
C      -----------------------------------------------------------
     * (NDIM,NPOINS,NBRESS,NRESCS,VRESCS,
     *  NODERC,VFRESC,NELERC,NDMASS,TMPSA,ITRAV1)
C      -----------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            MISE A JOUR DES CONDITIONS AUX LIMITES POUR LE TRAITEMENT *
C            DES RESISTANCES DE CONTACT                                *
C            On rappelle que les resistances de contact sont traitees  * 
C            comme une condition  a la limite du type coefficient      *
C            d'echange. L'utilisateur donne la valeur de la resistance,*
C            le programme retrouve le temperature sur la face opposee  *
C            L'objet de se sous-programme est justement de mettre      *
C            a jour cette temperature "exterieure" en realite issue    *
C            de l'autre face solide.                                   *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NBRESS   !  E ! D  ! NOMBRE DE NOEUDS AVEC RESISTANCE DE CONTACT  !
C !  NRESCS   ! TE ! D  ! NUMERO DES NOEUDS AVEC RESISTANCE DE CONTACT ! 
C !  VRESCS   ! TR ! M  ! VALEUR DE LA RESISTANCE                      !
C !  NODERC   ! TE ! D  ! TABLE DES ELEMENTS SURF AVEC REST DE CONTACT !
C !  VFRESC   ! TR ! M  ! RESISTANCES CONTACT SUR LES FACES            !
C !  NELERC   !  E ! D  ! NOMBRE D'ELETS AVEC RESTANCE DE CONTACT      !
C !  NDMASS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS AVEC RESIST        !
C !  TMPSA    ! TR ! D  ! TEMPERATURE DANS LE SOLIDE A L'ETAPE N       !
C !  ITRAV1   ! TE ! A  ! TABLEAU DE TRAVAIL                           !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : RESSOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINS,NBRESS,NRESCS(NBRESS,2)
      INTEGER NELERC,NDMASS
      DOUBLE PRECISION  TMPSA(NPOINS)
      DOUBLE PRECISION  VRESCS(NBRESS,2),VFRESC(NELERC,NDMASS,2)
      INTEGER NODERC(NELERC,NDMASS)
      INTEGER ITRAV1(NPOINS)
C
C.. Variables internes
      INTEGER N,M,NG,NL,NGC,NLC
C
C***********************************************************************
C
C     1- CAS DES CL SUR LES NOEUDS
C     ============================
C
      IF (.NOT. LCFACE) THEN
C
        DO 100 N=1,NBRESS
C
          IF (NRESCS(N,2).NE.-1) THEN
            VRESCS(N,1) = TMPSA( NRESCS(NRESCS(N,2),1) )
          ENDIF
C
  100   CONTINUE
C
C     2- CAS DES CL SUR LES FACES
C     ===========================
C
      ELSE
C
C
        DO 210 N=1,NPOINS
          ITRAV1(N) = 0
  210   CONTINUE
C
      DO 211 N=1,NBRESS
        ITRAV1(NRESCS(N,1)) = N
  211 CONTINUE
C
C
        DO 220 N=1,NELERC
          DO 221 M=1,NDMASS
C
            NG = NODERC(N,M)
            NL = ITRAV1(NG)  
            NLC = NRESCS(NL,2)
            NGC = NRESCS(NLC,1)
            IF (NLC.NE.-1) THEN
               VFRESC(N,M,1) = TMPSA(NGC)
            ENDIF      
C
  221     CONTINUE
  220   CONTINUE
C
C
      ENDIF
C
C
C----
C FIN
C----
      END
