C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MATELE,SSI=0
C
                     SUBROUTINE MATELE
C                    ******************
C
C     ------------------------------------------------------
     *( OP,DMAT,XMAT,COEFMA,PHYSOL,NODES,COORDS,VOLUME,
     *  NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     *  NPOUE,NPPEL,NBPHYS,
     *  WCT )
C     ------------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DES MATRICES ELEMENTAIRES POUR             *
C                    PROBLEMES BIDIMENSIONNELS ET TRIDIMENSIONNEL      *
C                    pour les cas  isotropes et non isotropes          *
C                                                                      *
C                                                                      *
C                                                                      *
C      Ce sous programme constitue une extension de travaux effectuees *
C      par F. JAUBERTEAU et J.P. GREGOIRE, portant sur l'integration   *
C      analytique des matrices elementaires par les formules de        *
C      Zienkiewicz                                                     *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   OP      !  A   ! D  ! DEFINITION DU TYPE D'OPERATION           !
C   !   DMAT    !  TR  ! R  ! DIAGONALE DE LA MATRICE M                !
C   !   XMAT    !  TR  ! R  ! TERMES EXTRA DIAGONAUX DE LA MATRICE M   !
C   !   COEFMA  !  TR  ! D  ! COEFFICIENTS DES MATRICES                !
C   !           !      !    !  coefma(n) = rho Cp / dt pour masse      !
C   !   PHYSOL  !  TR  ! D  ! Tableau contenant les propri physiques   !
C   !           !  TR  ! D  !   On utilise uniquement PHYSOL(n,>=3)    !
C   !           !      !    !   contient les valeurs des kii sui isotro!
C   !   COORDS  !  TR  ! D  ! COORDONNEES DU MAILLAGE                  !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX GLOBAUX     !
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE EN 2D                !
C   !           !      !    ! VOLUME DU TETRAEDRE EN 3D                ! 
C   !   W1...W10!  TR  ! M  ! TABLEAUX DE TRAVAIL (TAILLE: NELMXS )    !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ASSEMB,OV
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : DIFSOL
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "divct.h"
C    
C***********************************************************************
C
      CHARACTER*8 OP
      INTEGER NELEMS,NDMATS,NPOINS,NDIM,NDIELE,NCOEMA
      INTEGER NPOUE,NPPEL,NBPHYS
C
      INTEGER NODES(NELEMS,NDMATS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)  
      DOUBLE PRECISION DMAT(NPOINS),COEFMA(NPOINS)
      DOUBLE PRECISION XMAT(NELEMS,NCOEMA)      
      DOUBLE PRECISION WCT(NELEMS,NDMATS)
      DOUBLE PRECISION VOLUME(NELEMS)    
      DOUBLE PRECISION PHYSOL(NPOUE,NPPEL,NBPHYS)
C
C..Variables internes
      DOUBLE PRECISION ZERO
      INTEGER I,J
C    
C***********************************************************************
C
C     INITIALISATIONS
C     ================
C
      ZERO = 0.D0
C
C     
C     1-  CONSTRUCTION DE LA MATRICE DE MASSE ELEMENTAIRE
C      ===================================================
C
      IF (OP(1:8).EQ.'MASSE   ') THEN
C
        CALL MAMASS( XMAT,COEFMA,PHYSOL,NODES,COORDS,VOLUME,
     *               NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     *               NPOUE,NPPEL,NBPHYS,
     *               WCT )
C       
C
C     2-  CONSTRUCTION DE LA MATRICE DE MASSE ELEMENTAIRE
C     ===================================================
      ELSEIF (OP(1:8).EQ.'DIFFU   ') THEN
C
C       2.1 CAS ISOTROPES 
C       -----------------  
        IF (ISOTRO .EQ. 1) THEN
          CALL MADIF1 (XMAT,COEFMA,PHYSOL,NODES,COORDS,VOLUME,
     *                 NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     *                 NPOUE,NPPEL,NBPHYS,
     *                 WCT ) 
C
C       2.2 CAS ORTHOTROPES 
C       -------------------  
        ELSEIF (ISOTRO .EQ. 2) THEN
          CALL MADIF2 (XMAT,COEFMA,PHYSOL,NODES,COORDS,VOLUME,
     *                 NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     *                 NPOUE,NPPEL,NBPHYS,
     *                 WCT ) 
C
C       2.3 CAS ANISOTROPES 
C       -------------------  
        ELSEIF (ISOTRO .EQ. 3) THEN
          CALL MADIF3 (XMAT,COEFMA,PHYSOL,NODES,COORDS,VOLUME,
     *                 NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     *                 NPOUE,NPPEL,NBPHYS,
     *                 WCT ) 
C
        ELSE
          WRITE(NFECRA,2309)
          STOP
        ENDIF
C
      ELSE
        WRITE(NFECRA,2009)
        STOP
      ENDIF
C
C     3-  ASSEMBLAGE DE LA DIAGONALE DE LA MATRICE
C     ============================================
C
      CALL OV ( 'X=C     ',DMAT,DMAT,DMAT,ZERO,NPOINS )
      CALL ASSEMB ( DMAT,NODES,NELEMS,NDIELE,NPOINS,NDMATS,WCT)
C
C
C     3-  IMPRESSIONS DE CONTROLE
C     ===========================
C           
      IF (NBLBLA.EQ.11 .AND. OP(1:8).EQ.'MASSE   ') THEN
         WRITE(NFECRA,3002) 
         DO  I=1,NPOINS
            WRITE(NFECRA,3003) I,DMAT(I)
         ENDDO
      ENDIF
C
      IF ( NBLBLA.EQ.11 .AND. OP(1:8).EQ.'DIFFU   ') THEN
          WRITE(NFECRA,3000) 
          DO 300 I=1,NELEMS
            WRITE(NFECRA,3001) I,(XMAT(I,J),J=1,NCOEMA)
  300   CONTINUE
      ENDIF
C
C
C------ 
C FORMAT
C------
C
 2309 FORMAT(' %% ERREUR MATELE : Mauvaise valeur de ISOTRO')
 2009 FORMAT(' %% ERREUR MATELE : Mauvais operateur demande')
C
 3000 FORMAT ( ' MATELE :  NUMERO DE L''ELEMENT ',
     &        'ET VECTEURS ELEMENTAIRES POUR LA MATRICE DE DIFFUSION')
 3001 FORMAT (I7,5X,25E22.15)
 3002 FORMAT ( ' MATELE :  NUMERO DE L''ELEMENT ',
     &        'ET MATRICE DE MASSE')
 3003 FORMAT (I7,5X,E22.15)
C
      END

