C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=SMEXPS,SSI=0
C
                     SUBROUTINE SMEXPS
C                    *****************
C
C     ------------------------
     *( TMPSA,B,DMATL,NPOINS )  
C      -----------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DU SECOND MEMBRE                           *
C                    PARTIE EXPLICITE                                  *
C                                                                      *
C                  /              T                                    *
C                 /                n                                   *
C                /   Rho  Cp     ---       dV                          *
C               /       n   n    dt                                    *
C              /                   n                                   *
C                                                                      *
C   En fait cela revient a faire un produit vecteur vecteur.           *
C   car on travail sur des matrices de masse masslumpee                *
C                                                                      *
C   Second membre i   =  DMATLii   Ti                                  *
C                  n            n    n                                 *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NPOINS  !  E   !    ! Nombre de poins du maillage solide       !
C   !   TMPSA   !  TR  ! M  ! TEMPERATURE EN CHAQUE POINS A T = N - 1  !
C   !   B       !  TR  ! M  ! SECOND MEMBRE  (Partie explicite         !
C   !   DMATL   !  TR  ! D  ! DIAGONALE DE LA MATRICE M masse lumpee   !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "nlofes.h"
#include "optct.h"
C
C***********************************************************************
C
C..Variables internes
      INTEGER NPOINS
C
      DOUBLE PRECISION DMATL(NPOINS)
      DOUBLE PRECISION B(NPOINS),TMPSA(NPOINS)
C
C..Variables locales
      INTEGER I
      DOUBLE PRECISION ZERO
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      ZERO   = 0.D0
C
      CALL OV ( 'X=C     ',B,B,B,ZERO,NPOINS )
C
C     2- CALCUL DU SECOND MEMBRE (Partie explicite)
C     =============================================
C
      DO 20 I=1,NPOINS
          B(I) = DMATL(I) * TMPSA(I)
   20 CONTINUE  
C
C     3- IMPRESSIONS POUR CONTROLE
C     ============================
C
      IF ( NBLBLA.EQ.11 ) THEN
        WRITE(NFECRA,3000)
        DO 300 I=1,NPOINS
          WRITE(NFECRA,3010) I,B(I),DMATL(I),TMPSA(I)
  300   CONTINUE
      ENDIF
C
C--------
C FORMATS
C--------
 3000 FORMAT(/,' *** SMEXPS : SECOND MEMBRE (PARTIE EXPLICITE)',/,
     &         '        NOEUD       SECOND MEMBRE   DMATL    TMPSA ')
 3010 FORMAT(7X,I10,5X,G10.4,5X,G10.4,5X,G10.4)
C
      END
