C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=SMFVOS,SSI=0
C
                     SUBROUTINE SMFVOS
C                    *****************
C
C     ----------------------------------------------------
     *( NFLUVS,VFLUVS,B,NODES,VOLUME,COORDS,
     *  NELEMS,NPOINS,NDMATS,NDIM,NBFLVS,NPFEL,NDIELE,
     *  TRAV,WCT )
C     ----------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DU SECOND MEMBRE                           *
C                    PARTIE FLUX VOLUMIQUE                             *
C                                                                      *
C     Le flux est discretise en iso P2                                 *
C      ce qui revient a                                                *
C                                                                      *
C                                 /                                    *
C                    B  =  B  +  / (  FLUX   PHI  .  PHI  )  dV        *
C                     i     i   /        j      j       i              *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NFLUVS  !  TR  ! D  ! NOEUD FLUX VOLUMIQUE LOCAL --> GLOBAL    !
C   !   VFLUVS  !  TR  ! D  ! VALEUR DU FLUX VOLUMIQUE AU NOEUD        !      
C   !   B       !  TR  ! M  ! SECOND MEMBRE  (Partie explicite         !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX GLOBAUX     !
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE EN 2D                !
C   !           !      !    ! VOLUME DU TETRAEDRE EN 3D                !
C   !   TRAV    !  TR  ! M  ! TABLEAU DE TRAVAIL (Taille: NPOINS)      !
C   !   W1...W10!  TR  ! M  ! TABLEAUX DE TRAVAIL (Taille: NELMXS )    !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NELEMS,NDMATS,NBFLVS,NPFEL,NDIM,NDIELE
      INTEGER NFLUVS(NBFLVS),NODES(NELEMS,NDMATS)
C
      DOUBLE PRECISION B(NPOINS),COORDS(NPOINS,NDIM)
      DOUBLE PRECISION TRAV(NPOINS),VOLUME(NELEMS)
      DOUBLE PRECISION VFLUVS(NBFLVS,NPFEL)
      DOUBLE PRECISION WCT(NELEMS,NDMATS)
C
C..Variables internes
      DOUBLE PRECISION ZERO
      DOUBLE PRECISION R1,R2,R3
      DOUBLE PRECISION S48,SV48,S160,SV160,S480,SV480
      DOUBLE PRECISION F1,F2,F3,F4,F5,F6,F7,F8,F9,F10
      INTEGER N1,N2,N3,N4,N5,N6,N7,N8,N9,N10
      INTEGER I,IFLV,NCA
      LOGICAL LVERIF
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      LVERIF = .TRUE.
      ZERO   = 0.D0
      IF (IAXISY.EQ.1) THEN
         NCA=2
      ELSE
         NCA=1
      ENDIF
C
      CALL OV ( 'X=C     ',TRAV,TRAV,TRAV,ZERO,NPOINS ) 
C
      S48 = 1.D0 / 48.D0
      S160 = 1.D0 / 160.D0
      S480 = 1.D0 / 480.D0
C
      CALL OV('X=C     ',WCT,TRAV,TRAV,ZERO,NELEMS*NDMATS) 
C
C     2- PRISE EN COMPTE DU FLUX VOLUMIQUE PAR NOEUD
C     ==============================================
      IF(NDFLUV.EQ.1) THEN
C       On stocke toutes les informations sur le flux dans un vecteur
        DO 210 I=1,NBFLVS
           TRAV(NFLUVS(I)) = VFLUVS(I,1)
  210   CONTINUE
C
C  
C       3- CALCUL DU VECTEUR ELEMENTAIRE 
C       ================================    
C         3.1- Cas 2D
C         -----------
          IF ( NDIM .EQ. 2 ) THEN
C
C             3.1.1- Cas cartesien
C             --------------------
              IF (IAXISY.EQ.0) THEN
C
                   DO 311 I=1,NELEMS
C
C                  Calcul des indices globaux
                   N1 = NODES(I,1)
                   N2 = NODES(I,2)
                   N3 = NODES(I,3)
                   N4 = NODES(I,4)
                   N5 = NODES(I,5)
                   N6 = NODES(I,6)                   
C
                   SV48 = S48 * VOLUME(I)         
C            
C
                     F1  = TRAV(N1) * SV48 
                     F2  = TRAV(N2) * SV48 
                     F3  = TRAV(N3) * SV48
                     F4  = TRAV(N4) * SV48 
                     F5  = TRAV(N5) * SV48 
                     F6  = TRAV(N6) * SV48          
C
C
                   WCT(I,1) = 2 * F1 + F4 + F6
                   WCT(I,2) = 2 * F2 + F4 + F5
                   WCT(I,3) = 2 * F3 + F5 + F6
                   WCT(I,4) = F1 + F2 + 6 * F4 + 2 * F5 + 2 * F6
                   WCT(I,5) = F2 + F3 + 2 * F4 + 6 * F5 + 2 * F6
                   WCT(I,6) = F1 + F3 + 2 * F4 + 2 * F5 + 6 * F6              
C            
  311              CONTINUE
C
C             3.1.2- Cas axisymetrique
C             ------------------------
              ELSE
C              
                   DO 312 I=1,NELEMS
C
                   N1 = NODES(I,1)
                   N2 = NODES(I,2)
                   N3 = NODES(I,3)
                   N4 = NODES(I,4)
                   N5 = NODES(I,5)
                   N6 = NODES(I,6)
C
C
                   SV480 = S480 * VOLUME(I) 
C                   
C                  l'axe Y est pris comme coordonne radiale
C                  l'axe X est pris comme axe de rotation    
                   R1 = ABS( COORDS(N1,NCA) ) * SV480
                   R2 = ABS( COORDS(N2,NCA) ) * SV480 
                   R3 = ABS( COORDS(N3,NCA) ) * SV480    
C            
                   F1  = TRAV(N1) 
                   F2  = TRAV(N2) 
                   F3  = TRAV(N3)
                   F4  = TRAV(N4) 
                   F5  = TRAV(N5) 
                   F6  = TRAV(N6)                   
C
C 
                   WCT(I,1) = F1 * ( 16*R1 + 2*R2 + 2*R3 ) 
     &                       +F4 * ( 7*R1 + 2*R2 + R3 )
     &                       +F6 * ( 7*R1 + R2 + 2*R3 )
                   WCT(I,2) = F2 * ( 2*R1 + 16*R2 + 2*R3 )
     &                       +F4 * ( 2*R1 + 7 *R2 + R3 )
     &                       +F5 * ( R1 + 7*R2 + 2*R3 )
                   WCT(I,3) = F3 * ( 2*R1 + 2*R2 + 16*R3 )
     &                       +F5 * ( R1 + 2*R2 + 7*R3 )
     &                       +F6 * ( 2*R1 + R2 + 7*R3 )
                   WCT(I,4) = F1 * ( 7*R1 + 2*R2 + R3 )
     &                       +F2 * ( 2*R1 + 7*R2 + R3 )
     &                       +F4 * ( 26*R1 + 26*R2 + 8*R3 )
     &                       +F5 * ( 5*R1 + 10*R2 +5*R3 )
     &                       +F6 * ( 10*R1 + 5*R2 + 5*R3 )
                   WCT(I,5) = F2 * ( R1 + 7*R2 + 2*R3 )
     &                       +F3 * ( R1 + 2*R2 + 7*R3 )
     &                       +F4 * ( 5*R1 + 10*R2 + 5*R3 )
     &                       +F5 * ( 8*R1 + 26*R2 + 26*R3 )
     &                       +F6 * ( 5*R1 + 5*R2 + 10*R3 )
                   WCT(I,6) = F1 * ( 7*R1 + R2 + 2*R3 )
     &                       +F3 * ( 2*R1 + R2 + 7*R3 )
     &                       +F4 * ( 10*R1 + 5*R2 + 5*R3 )
     &                       +F5 * ( 5*R1 + 5*R2 + 10*R3 )
     &                       +F6 * ( 26*R1 + 8*R2 + 26*R3 )
C            
  312              CONTINUE
C              
              ENDIF
C
C         3.2- Cas 3D
C         -----------          
          ELSE
C
              DO 320 I=1,NELEMS
C
                  N1 = NODES(I,1)
                  N2 = NODES(I,2)
                  N3 = NODES(I,3)
                  N4 = NODES(I,4)
                  N5 = NODES(I,5)
                  N6 = NODES(I,6)
                  N7 = NODES(I,7)
                  N8 = NODES(I,8)
                  N9 = NODES(I,9)
                  N10 = NODES(I,10)
C
                  SV160 = S160 * VOLUME(I)                      
C            
                  F1  = TRAV(N1) * SV160 
                  F2  = TRAV(N2) * SV160 
                  F3  = TRAV(N3) * SV160
                  F4  = TRAV(N4) * SV160 
                  F5  = TRAV(N5) * SV160 
                  F6  = TRAV(N6) * SV160
                  F7  = TRAV(N7) * SV160
                  F8  = TRAV(N8) * SV160
                  F9  = TRAV(N9) * SV160
                  F10  = TRAV(N10) * SV160           
C
C              
                  WCT(I,1) = 2 * F1 + F5 + F7 + F8 
                  WCT(I,2) = 2 * F2 + F5 + F6 + F9
                  WCT(I,3) = 2 * F3 + F6 + F7 + F10
                  WCT(I,4) = 2 * F4 + F8 + F9 + F10
                  WCT(I,5) = F1 + F2 + 8 * F5 + 3 * F6 + 2 * F7
     &                     + 3 * F8 + 2 * F9
                  WCT(I,6) = F2 + F3 + 3 * F5 + 12 * F6 + 3 * F7
     &                     + 4 * F8 + 3 * F9 + 3 * F10
                  WCT(I,7) = F1 + F3 + 2 * F5 + 3 * F6 + 8 * F7
     &                     + 3 * F8 + 2 * F10
                  WCT(I,8) = F1 + F4 + 3 * F5 + 4 * F6 + 3 * F7
     &                     + 12 * F8 + 3 * F9 + 3 * F10
                  WCT(I,9) = F2 + F4 + 2 * F5 + 3 * F6 + 3 * F8
     &                     + 8 * F9 + 2 * F10
                  WCT(I,10) = F3 + F4 + 3 * F6 + 2 * F7 + 3 * F8
     &                       + 2 * F9 + 8 * F10
C
  320         CONTINUE
C              
C         Fin du cas 3D               
          ENDIF                            
C
          CALL OV ( 'X=C     ',TRAV,TRAV,TRAV,ZERO,NPOINS )
          CALL ASSEMB ( TRAV,NODES,NELEMS,NDIELE,NPOINS,NDMATS,WCT )
C            
      ELSEIF(NDFLUV.EQ.2) THEN
C       4- PRISE EN COMPTE DU FLUX VOLUMIQUE CONSTANT PAR ELEMENT
C       =========================================================
C         4.1- Cas 2D
C         -----------
          IF ( NDIM .EQ. 2 ) THEN
C
C             4.1.1- Cas cartesien
C             --------------------
              IF (IAXISY.EQ.0) THEN
C
                 DO 411 IFLV=1,NBFLVS
C
                   I = NFLUVS(IFLV)
C
                   SV48 = S48 * VOLUME(I)                                                                             
C            
C
                     F1  = VFLUVS(IFLV,1) * SV48 
                     F2  = VFLUVS(IFLV,1) * SV48 
                     F3  = VFLUVS(IFLV,1) * SV48
                     F4  = VFLUVS(IFLV,1) * SV48 
                     F5  = VFLUVS(IFLV,1) * SV48 
                     F6  = VFLUVS(IFLV,1) * SV48          
C
C
                   WCT(I,1) = 2 * F1 + F4 + F6
                   WCT(I,2) = 2 * F2 + F4 + F5
                   WCT(I,3) = 2 * F3 + F5 + F6
                   WCT(I,4) = F1 + F2 + 6 * F4 + 2 * F5 + 2 * F6
                   WCT(I,5) = F2 + F3 + 2 * F4 + 6 * F5 + 2 * F6
                   WCT(I,6) = F1 + F3 + 2 * F4 + 2 * F5 + 6 * F6              
C            
  411              CONTINUE
C
C             4.1.2- Cas axisymetrique
C             ------------------------
              ELSE
C              
                   DO 412 IFLV=1,NBFLVS
C
                   I = NFLUVS(IFLV)
C
                   SV480 = S480 * VOLUME(I) 
C                   
                   N1 = NODES(I,1)
                   N2 = NODES(I,2)
                   N3 = NODES(I,3)
C
                   R1 = ABS( COORDS(N1,NCA) ) * SV480
                   R2 = ABS( COORDS(N2,NCA) ) * SV480 
                   R3 = ABS( COORDS(N3,NCA) ) * SV480   
C            
                   F1  = VFLUVS(IFLV,1) 
                   F2  = VFLUVS(IFLV,1) 
                   F3  = VFLUVS(IFLV,1) 
                   F4  = VFLUVS(IFLV,1) 
                   F5  = VFLUVS(IFLV,1) 
                   F6  = VFLUVS(IFLV,1)                 
C
C 
                   WCT(I,1) = F1 * ( 16*R1 + 2*R2 + 2*R3 ) 
     &                       +F4 * ( 7*R1 + 2*R2 + R3 )
     &                       +F6 * ( 7*R1 + R2 + 2*R3 )
                   WCT(I,2) = F2 * ( 2*R1 + 16*R2 + 2*R3 )
     &                       +F4 * ( 2*R1 + 7 *R2 + R3 )
     &                       +F5 * ( R1 + 7*R2 + 2*R3 )
                   WCT(I,3) = F3 * ( 2*R1 + 2*R2 + 16*R3 )
     &                       +F5 * ( R1 + 2*R2 + 7*R3 )
     &                       +F6 * ( 2*R1 + R2 + 7*R3 )
                   WCT(I,4) = F1 * ( 7*R1 + 2*R2 + R3 )
     &                       +F2 * ( 2*R1 + 7*R2 + R3 )
     &                       +F4 * ( 26*R1 + 26*R2 + 8*R3 )
     &                       +F5 * ( 5*R1 + 10*R2 +5*R3 )
     &                       +F6 * ( 10*R1 + 5*R2 + 5*R3 )
                   WCT(I,5) = F2 * ( R1 + 7*R2 + 2*R3 )
     &                       +F3 * ( R1 + 2*R2 + 7*R3 )
     &                       +F4 * ( 5*R1 + 10*R2 + 5*R3 )
     &                       +F5 * ( 8*R1 + 26*R2 + 26*R3 )
     &                       +F6 * ( 5*R1 + 5*R2 + 10*R3 )
                   WCT(I,6) = F1 * ( 7*R1 + R2 + 2*R3 )
     &                       +F3 * ( 2*R1 + R2 + 7*R3 )
     &                       +F4 * ( 10*R1 + 5*R2 + 5*R3 )
     &                       +F5 * ( 5*R1 + 5*R2 + 10*R3 )
     &                       +F6 * ( 26*R1 + 8*R2 + 26*R3 )
C            
  412              CONTINUE
C              
              ENDIF
C
C         4.2- Cas 3D
C         -----------          
          ELSE
C
              DO 420 IFLV=1,NBFLVS 
C
                  I = NFLUVS(IFLV)
C
                  SV160 = S160 * VOLUME(I)                      
C            
                  F1  = VFLUVS(IFLV,1)  * SV160 
                  F2  = VFLUVS(IFLV,1)  * SV160 
                  F3  = VFLUVS(IFLV,1)  * SV160
                  F4  = VFLUVS(IFLV,1)  * SV160 
                  F5  = VFLUVS(IFLV,1)  * SV160 
                  F6  = VFLUVS(IFLV,1)  * SV160
                  F7  = VFLUVS(IFLV,1)  * SV160
                  F8  = VFLUVS(IFLV,1)  * SV160
                  F9  = VFLUVS(IFLV,1)  * SV160
                  F10 = VFLUVS(IFLV,1)  * SV160           
C
C              
                  WCT(I,1) = 2 * F1 + F5 + F7 + F8 
                  WCT(I,2) = 2 * F2 + F5 + F6 + F9
                  WCT(I,3) = 2 * F3 + F6 + F7 + F10
                  WCT(I,4) = 2 * F4 + F8 + F9 + F10
                  WCT(I,5) = F1 + F2 + 8 * F5 + 3 * F6 + 2 * F7
     &                     + 3 * F8 + 2 * F9
                  WCT(I,6) = F2 + F3 + 3 * F5 + 12 * F6 + 3 * F7
     &                     + 4 * F8 + 3 * F9 + 3 * F10
                  WCT(I,7) = F1 + F3 + 2 * F5 + 3 * F6 + 8 * F7
     &                     + 3 * F8 + 2 * F10
                  WCT(I,8) = F1 + F4 + 3 * F5 + 4 * F6 + 3 * F7
     &                     + 12 * F8 + 3 * F9 + 3 * F10
                  WCT(I,9) = F2 + F4 + 2 * F5 + 3 * F6 + 3 * F8
     &                     + 8 * F9 + 2 * F10
                  WCT(I,10) = F3 + F4 + 3 * F6 + 2 * F7 + 3 * F8
     &                       + 2 * F9 + 8 * F10
C
  420         CONTINUE
C              
C         Fin du cas 3D               
          ENDIF                            
C
          CALL OV ( 'X=C     ',TRAV,TRAV,TRAV,ZERO,NPOINS )
          CALL ASSEMB ( TRAV,NODES,NELEMS,NDIELE,NPOINS,NDMATS,WCT )
C 
      ELSE
C       5- PRISE EN COMPTE DU FLUX VOLUMIQUE PAR NOEUD PAR ELEMENT
C       ==========================================================
C         5.1- Cas 2D
C         -----------
          IF ( NDIM .EQ. 2 ) THEN
C
C             5.1.1- Cas cartesien
C             --------------------
              IF (IAXISY.EQ.0) THEN
C
                 DO 511 IFLV=1,NBFLVS  
C
                   I = NFLUVS(IFLV)
C
                   SV48 = S48 * VOLUME(I)   
C
                   F1  = VFLUVS(IFLV,1) * SV48 
                   F2  = VFLUVS(IFLV,2) * SV48 
                   F3  = VFLUVS(IFLV,3) * SV48
                   F4  = VFLUVS(IFLV,4) * SV48 
                   F5  = VFLUVS(IFLV,5) * SV48 
                   F6  = VFLUVS(IFLV,6) * SV48          
C
C
                   WCT(I,1) = 2 * F1 + F4 + F6
                   WCT(I,2) = 2 * F2 + F4 + F5
                   WCT(I,3) = 2 * F3 + F5 + F6
                   WCT(I,4) = F1 + F2 + 6 * F4 + 2 * F5 + 2 * F6
                   WCT(I,5) = F2 + F3 + 2 * F4 + 6 * F5 + 2 * F6
                   WCT(I,6) = F1 + F3 + 2 * F4 + 2 * F5 + 6 * F6              
C            
  511            CONTINUE
C
C             5.1.2- Cas axisymetrique
C             ------------------------
              ELSE
C              
                 DO 512 IFLV=1,NBFLVS  
C
                   I = NFLUVS(IFLV)
C
                   SV480 = S480 * VOLUME(I) 
C                   
                   N1 = NODES(I,1)
                   N2 = NODES(I,2)
                   N3 = NODES(I,3)
C
C                  l'axe Y est pris comme coordonne radiale
C                  l'axe X est pris comme axe de rotation    
                   R1 = ABS( COORDS(N1,NCA) ) * SV480
                   R2 = ABS( COORDS(N2,NCA) ) * SV480 
                   R3 = ABS( COORDS(N3,NCA) ) * SV480   
C            
                   F1  = VFLUVS(IFLV,1) 
                   F2  = VFLUVS(IFLV,2) 
                   F3  = VFLUVS(IFLV,3) 
                   F4  = VFLUVS(IFLV,4) 
                   F5  = VFLUVS(IFLV,5)
                   F6  = VFLUVS(IFLV,6)        
C
C 
                   WCT(I,1) = F1 * ( 16*R1 + 2*R2 + 2*R3 ) 
     &                       +F4 * ( 7*R1 + 2*R2 + R3 )
     &                       +F6 * ( 7*R1 + R2 + 2*R3 )
                   WCT(I,2) = F2 * ( 2*R1 + 16*R2 + 2*R3 )
     &                       +F4 * ( 2*R1 + 7 *R2 + R3 )
     &                       +F5 * ( R1 + 7*R2 + 2*R3 )
                   WCT(I,3) = F3 * ( 2*R1 + 2*R2 + 16*R3 )
     &                       +F5 * ( R1 + 2*R2 + 7*R3 )
     &                       +F6 * ( 2*R1 + R2 + 7*R3 )
                   WCT(I,4) = F1 * ( 7*R1 + 2*R2 + R3 )
     &                       +F2 * ( 2*R1 + 7*R2 + R3 )
     &                       +F4 * ( 26*R1 + 26*R2 + 8*R3 )
     &                       +F5 * ( 5*R1 + 10*R2 +5*R3 )
     &                       +F6 * ( 10*R1 + 5*R2 + 5*R3 )
                   WCT(I,5) = F2 * ( R1 + 7*R2 + 2*R3 )
     &                       +F3 * ( R1 + 2*R2 + 7*R3 )
     &                       +F4 * ( 5*R1 + 10*R2 + 5*R3 )
     &                       +F5 * ( 8*R1 + 26*R2 + 26*R3 )
     &                       +F6 * ( 5*R1 + 5*R2 + 10*R3 )
                   WCT(I,6) = F1 * ( 7*R1 + R2 + 2*R3 )
     &                       +F3 * ( 2*R1 + R2 + 7*R3 )
     &                       +F4 * ( 10*R1 + 5*R2 + 5*R3 )
     &                       +F5 * ( 5*R1 + 5*R2 + 10*R3 )
     &                       +F6 * ( 26*R1 + 8*R2 + 26*R3 )
C            
  512            CONTINUE
C              
              ENDIF
C
C         5.2- Cas 3D
C         -----------          
          ELSE
C
              DO 520 IFLV=1,NBFLVS  
C
                  I = NFLUVS(IFLV)
C
                  SV160 = S160 * VOLUME(I)                      
C            
                  F1  = VFLUVS(IFLV,1) * SV160 
                  F2  = VFLUVS(IFLV,2) * SV160 
                  F3  = VFLUVS(IFLV,3) * SV160
                  F4  = VFLUVS(IFLV,4) * SV160 
                  F5  = VFLUVS(IFLV,5) * SV160 
                  F6  = VFLUVS(IFLV,6) * SV160
                  F7  = VFLUVS(IFLV,7) * SV160
                  F8  = VFLUVS(IFLV,8) * SV160
                  F9  = VFLUVS(IFLV,9) * SV160
                  F10 = VFLUVS(IFLV,10) * SV160           
C
C              
                  WCT(I,1) = 2 * F1 + F5 + F7 + F8 
                  WCT(I,2) = 2 * F2 + F5 + F6 + F9
                  WCT(I,3) = 2 * F3 + F6 + F7 + F10
                  WCT(I,4) = 2 * F4 + F8 + F9 + F10
                  WCT(I,5) = F1 + F2 + 8 * F5 + 3 * F6 + 2 * F7
     &                     + 3 * F8 + 2 * F9
                  WCT(I,6) = F2 + F3 + 3 * F5 + 12 * F6 + 3 * F7
     &                     + 4 * F8 + 3 * F9 + 3 * F10
                  WCT(I,7) = F1 + F3 + 2 * F5 + 3 * F6 + 8 * F7
     &                     + 3 * F8 + 2 * F10
                  WCT(I,8) = F1 + F4 + 3 * F5 + 4 * F6 + 3 * F7
     &                     + 12 * F8 + 3 * F9 + 3 * F10
                  WCT(I,9) = F2 + F4 + 2 * F5 + 3 * F6 + 3 * F8
     &                     + 8 * F9 + 2 * F10
                  WCT(I,10) = F3 + F4 + 3 * F6 + 2 * F7 + 3 * F8
     &                       + 2 * F9 + 8 * F10
C
  520         CONTINUE
C              
C         Fin du cas 3D               
          ENDIF                            
C
          CALL OV ( 'X=C     ',TRAV,TRAV,TRAV,ZERO,NPOINS )
          CALL ASSEMB ( TRAV,NODES,NELEMS,NDIELE,NPOINS,NDMATS,WCT )
C
      ENDIF
C
C
C     6- MISE A JOUR DU SECOND MEMBRE 
C     =============================== 
C  
      DO 600 I=1,NPOINS
          B(I) = B(I) + TRAV(I)
  600 CONTINUE                 
C
      END
