C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                          *****************                           
                           SUBROUTINE WHISOR
C                          *****************
C
C     ----------------------------------------------
     *(NELRAY,TEMRAY)
C     ----------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C  FONCTION :
C  ---------
C
C     ECRITURE DES HISTORIQUES EN TEMPS SUR LE RAYONNEMENT
C
C-----------------------------------------------------------------------
C               (*)   (*)     ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ------
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C*************************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON
C **********************************************************************
C
#include "divct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "rayonn.h"
C
C***********************************************************************
C
C...  Declaration des variables externes
C 
      INTEGER NELRAY
      DOUBLE PRECISION TEMRAY(NELRAY)
C
C...  Declaration des variables internes
C
      INTEGER N,NUM
C
C
C***********************************************************************
C
      DO N=1,NBHSOR
        NUM = NHISOR(N)
        WRITE(NFHIRA,1000) TEMPSS,NUM,TEMRAY(NUM)
      ENDDO
C
      CALL FLUSHF(NFHIRA)
C
C
C-------
C FORMAT
C-------
C
 1000 FORMAT ( 1X,E15.9,1X,I6,1X,E15.9)
C
C----
C FIN
C----
C
      RETURN
      END
