#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define max(a,b) (a>b  ? a:b)

FILE  *fsyrg,*fsyrr,*fgeom,*fcase,*fvar;

void entete(int*,int*,int*,int*,int*,int*,int*);
void geom_syr(int,int,int,int,int,int**,double**,int*,int*,int**,int*,int,int**,int*);
void resu_syr_entete(int,int*,double*);
void resu_syr_nomvar(char*,int*);
void resu_syr_var(int,double*);

void geom_ens(int,int,int,int,int,int, int**,int*,int**,double **, int,int,int,
	      int,int**,int*,int);
void ecrit_var_ensight(FILE *,int,int,int,int,int,int,double,char*,double *);
void combien_scalaires(FILE *,int *,int *,int *,int *);

/*|======================================================================|
  | SYRTHES - Utilitaires      JUIL 95                                   |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | syrthes2ensight                                                      |
  |        Transformation d'un resultat Syrthes au format Ensight        |
  |======================================================================| */
main (argc,argv)

    int	argc;
    char *argv[];
{
  int version;
  int i,lbase,n,quegeo=0,queresu=0,decoup=0;
  int ndim,ndiele,nelem,nbno,nbface,npoin,nt,noface,nelembord,indip1=1;
  int *discr,nbscal,npdt;
  int **node,**nodebord;
  int *nrefn,*nrefe,**nrefac,*nrefebord;
  double *temps,**coord,*var;
  char nomfichcase[200],nomfichgeom[200],nomfichvar[200];
  char ch[90],*nomvar[90],nombase[90],nomnum[5];
  int c;

  while ((c = getopt(argc, argv, "hgqrd")) != EOF)
    switch (c) {    
    case '?':
      exit(0);
      break;
    case 'g':
      quegeo=1;
      break;
    case 'r':
      queresu=1;
      break;
    case 'q':
      indip1=0;
      break;
    case 'd':
      decoup=1;
      break;
    case 'h':
      printf("\n syrthes2ensight : utilitaire de transformation du resultat Syrthes au format Ensight\n");
      printf("      Auteur  : I. Rupp \n");
      printf("        Usage : \n");
      printf("           syrthes2ensight [-h] [-g] [-q] [-r]\n");
      printf("                --> -h : mode d'emploi\n");
      printf("                --> -g : geometrie seulement\n");
      printf("                --> -d : decoupage des elements P2 en elements P1\n");
      printf("                --> -q : conservation des elements quadratique (sinon passage en P1)\n");
      printf("                --> -r : fichier resultat seulement\n");
      printf("           syrthes2ensight  -h  : informations\n");
      printf("           syrthes2ensight  syr.geom syr.res fich_ensight\n");
      printf("           syrthes2ensight -g  syr.geom  fich_ensight\n");
      exit(0);
      break;
    }

  if (argc<4) 
    {
      printf("syrthes2ensight [-h] [-g] [-d] [-q] [-r] [syr.geom] et/ou [syr.res] fich_ensight\n");
      exit(0);
    }

  printf("\n\n");
  printf("===============================================================\n");
  printf("                         SYRTHES2ENSIGHT                          \n");
  printf("===============================================================\n");
  printf("                                                        I. Rupp\n\n");

  if (quegeo) printf(" Traitement de la geometrie uniquement\n");

  /* -------------------------------------------------------------------- */
  /*                           ouverture des fichiers                     */
  /* -------------------------------------------------------------------- */
  if (quegeo)
    {
      if ((fsyrg=fopen(argv[argc-2],"r")) == NULL)
	{
	  printf("Impossible d'ouvrir le fichier %s\n",argv[argc-2]);	
	  exit(1) ;
	}
    }
  else if (queresu)
    {
      if ((fsyrr=fopen(argv[argc-2],"r")) == NULL)
	{
	  printf("Impossible d'ouvrir le fichier %s\n",argv[argc-2]);	
	  exit(1) ;
	}
    }
  else
    {
      if ((fsyrg=fopen(argv[argc-3],"r")) == NULL)
	{
	  printf("Impossible d'ouvrir le fichier %s\n",argv[argc-3]);	
	  exit(1) ;
	}
      if ((fsyrr=fopen(argv[argc-2],"r")) == NULL)
	{
	  printf("Impossible d'ouvrir le fichier %s\n",argv[argc-2]);	
	  exit(1) ;
	}
    }


  /* contitution des noms des fichiers geom et case */

  lbase=strlen(argv[argc-1]);

  strcpy(nombase,argv[argc-1]);

  strcpy(nomfichcase,argv[argc-1]);
  strncat(nomfichcase,".ensight.case",13); 
  
  strcpy(nomfichgeom,argv[argc-1]);
  strncat(nomfichgeom,".ensight.geom",13);
    
  if (!queresu) printf("--> nom du fichier geom : %s\n",nomfichgeom);	
  printf("--> nom du fichier case : %s\n",nomfichcase);	

  if (!queresu)
    if ((fgeom=fopen(nomfichgeom,"w")) == NULL) 
      {
	printf("Impossible d'ouvrir le fichier %s\n",nomfichgeom);	
	exit(1) ;
      }
  
  if ((fcase=fopen(nomfichcase,"w")) == NULL) 
    {
      printf("Impossible d'ouvrir le fichier %s\n",nomfichcase);	
      exit(1) ;
    }
  


  /* -------------------------------------------------------------------- */
  /*              traitement de la geometrie                              */
  /* -------------------------------------------------------------------- */


    
  if (!queresu)
    {

      /* lecture de la geometrie Syrthes */
      entete(&ndim,&ndiele,&npoin,&nelem,&nbno,&nelembord,&version);
      
      coord=(double**)malloc(ndim * sizeof(double*));
      for (n=0;n<ndim;n++) coord[n]=(double*)malloc(npoin* sizeof(double));
      
      node=(int**)malloc(nbno * sizeof(int*));
      for (n=0;n<nbno;n++) node[n]=(int*)malloc(nelem* sizeof(int));
      
      if (ndiele==3) 
	nbface=4; 
      else if (ndiele==2) 
	nbface=3;
      else
	nbface=1;
      
      if (version<39)
	{
	  nrefac=(int**)malloc(nbface * sizeof(int*));
	  for (n=0;n<nbface;n++) nrefac[n]=(int*)malloc(nelem* sizeof(int));
	}
      else
	{
	  nodebord=(int**)malloc(ndim * sizeof(int*));
	  for (n=0;n<ndim;n++) nodebord[n]=(int*)malloc(nelembord* sizeof(int));
	  nrefebord=(int*)malloc(nelembord * sizeof(int));
	}

      nrefn=(int*)malloc(npoin * sizeof(int));
      nrefe=(int*)malloc(nelem * sizeof(int));
      
      
      geom_syr(ndim,npoin,nelem,nbno,nbface,node,coord,nrefn,nrefe,nrefac,
	       &noface,nelembord,nodebord,nrefebord);
      
      geom_ens(ndim,ndiele,npoin,nelem,nbno,nbface,node,nrefe,nrefac,coord,
	       noface,indip1,decoup,nelembord,nodebord,nrefebord,version);
    }

  /* -------------------------------------------------------------------- */
  /*                     traitement des resultats                         */
  /* -------------------------------------------------------------------- */

  if (!quegeo)
    {
      printf("\n\n Traitement des resultats\n");
      
      for (i=0;i<90;i++) nomvar[i]=(char*)malloc(90*sizeof(char));
      temps=(double*)malloc(10000*sizeof(double));
      

      combien_scalaires(fsyrr,&nbscal,&npoin,&nelem,&version);
      discr=(int*)malloc(nbscal*sizeof(int));
      
      fseek(fsyrr,0,SEEK_SET);
      
      var=(double*)malloc(max(npoin,nelem) * sizeof(double));
      
      npdt=0;
      
      while (fgets(ch,90,fsyrr))
	{
	  if ( !strncmp(ch,"*",1) )
	    {
	      npdt++;
	      sprintf(nomnum,"%.4d",npdt);
	      
	      resu_syr_entete(version,&nt,temps+npdt-1);
	      
	      for (i=0;i<nbscal;i++) 
		{
		  /* lecture de la variable syrthes et de sa localisation */
		  /* (sur les noeuds ou les elements)  */
		  resu_syr_nomvar(nomvar[i],discr+i);
		  
		  if (discr[i]==3)
		    resu_syr_var(npoin,var);
		  else if (discr[i]==1) 
		    resu_syr_var(nelem,var);

		  /* ouverture du fichier resultat ensight */
		  strcpy(nomfichvar,nombase);
		  strncat(nomfichvar,".",1);
		  strncat(nomfichvar,nomvar[i],strlen(nomvar[i]));
		  strncat(nomfichvar,".",1);
		  strncat(nomfichvar,nomnum,4);

		  fvar=fopen(nomfichvar,"w");
		  ecrit_var_ensight(fvar,ndim,discr[i],indip1,npoin,nelem,nbno,temps[i],nomvar[i],var);
 		  fclose(fvar); 
		}
	    }
	}
    } /* fin de !quegeo */

  /* -------------------------------------------------------------------- */
  /*                       ecriture du fichier CASE                       */
  /* -------------------------------------------------------------------- */
  fprintf(fcase,"FORMAT\n");
  fprintf(fcase,"type: ensight\n");
  fprintf(fcase,"GEOMETRY\n");
  fprintf(fcase,"model: %s\n",nomfichgeom);

  if (!quegeo)
    {
      fprintf(fcase,"VARIABLE\n");
      for (i=0;i<nbscal;i++)
	{
	  if (discr[i]==3)
	    fprintf(fcase,"scalar per node: 1     %s        %s.%s.****\n",
		    nomvar[i],nombase,nomvar[i]);
	  else if (discr[i]==1) 
	    fprintf(fcase,"scalar per element: 1     %s        %s.%s.****\n",
		    nomvar[i],nombase,nomvar[i]);
	}      
      fprintf(fcase,"TIME\n");
      fprintf(fcase,"time set:%15d\n",1);
      fprintf(fcase,"number of steps:%15d\n",npdt);
      fprintf(fcase,"filename start number:     1\n");
      fprintf(fcase,"filename increment:        1\n");
      fprintf(fcase,"time values:             %12.5e\n",temps[0]);
      for (i=1;i<npdt;i++)
	fprintf(fcase,"                         %12.5e\n",temps[i]);
    }


    printf("\n\n");
    printf("===============================================================\n");
    printf("                       SYRTHES2ENSIGHT                         \n");
    printf("                      Fin du traitement                        \n");
    printf("===============================================================\n");
    printf("\n");

    exit(0);

}

/*|======================================================================|
  | SYRTHES - Utilitaires      JUIL 95                                   |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | entete                                                               |
  |        lecture de l'entete du fichier geom de Syrthes                |
  |======================================================================| */
void entete(int *ndim,int *ndiele,int *npoin,int *nelem,int *nbno,
	    int *nelembord, int *version)
{
  char ch[90];

  fgets(ch,90,fsyrg);

    /* entete version 4.0 */
    if (!strncmp(ch,"C*V4.0",6))
      {
	*version=40;
	fgets(ch,90,fsyrg);
	fgets(ch,90,fsyrg);
	fscanf(fsyrg,"%s%s%s%d\n",ch,ch,ch,ndim);
	fscanf(fsyrg,"%s%s%s%s%s%d\n",ch,ch,ch,ch,ch,ndiele);
	fscanf(fsyrg,"%s%s%s%s%s%d",ch,ch,ch,ch,ch,npoin);
	fscanf(fsyrg,"%s%s%s%s%d",ch,ch,ch,ch,nelem);
	fscanf(fsyrg,"%s%s%s%s%s%s%d",ch,ch,ch,ch,ch,ch,nelembord);
	fscanf(fsyrg,"%s%s%s%s%s%s%s%d",ch,ch,ch,ch,ch,ch,ch,nbno);
      }
    else
      /* entete version 3.x */
      {
	*version=33;
	fgets(ch,90,fsyrg);
	fgets(ch,90,fsyrg);
	fscanf(fsyrg,"%s%s%s%d%s%s%s%s%d\n",ch,ch,ch,ndim,ch,ch,ch,ch,ndiele);
	fscanf(fsyrg,"%s%s%s%s%s%d",ch,ch,ch,ch,ch,npoin);
	fscanf(fsyrg,"%s%s%s%s%d",ch,ch,ch,ch,nelem);
	fscanf(fsyrg,"%s%s%s%s%s%s%s%d",ch,ch,ch,ch,ch,ch,ch,nbno);
	*nelembord=0;
      }

    printf("\n\nMAILLAGE SYRTHES :\n");
    printf("------------------\n");
    printf("   Dimension                    %d\n",*ndim);
    printf("   Dimension des elements       %d\n",*ndiele);
    printf("   Nombre de noeuds             %d\n",*npoin);
    printf("   Nombre d'elements            %d\n",*nelem);
    printf("   Nombre de noeuds par element %d\n",*nbno);
}
/*|======================================================================|
  | SYRTHES - Utilitaires      JUIL 95                                   |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | geom_syr                                                             |
  |        lecture de la geometrie du fichier Syrthes                    |
  |======================================================================| */
void geom_syr(int ndim,int npoin,int nelem,int nbno,int nbface,int **node,
	      double **coord, int *nrefn,int *nrefe,int **nrefac,
	      int *noface,int nelembord,int **nodebord,int *nrefebord)
{
    char ch[90],ccc[3];
    double z;
    int n,i,j,ii,np1;
    int version,nbligne_entete;


    /* lecture du numero de version du fichier */
    rewind(fsyrg);
    fgets(ch,90,fsyrg);
    nbligne_entete=11;
    if (!strncmp(ch,"C*V4.0",6)) 
      {
	version=40;
	nbligne_entete=13;
      }
    else
      version=33;
    

    /* lecture du fichier */
    rewind(fsyrg);
    for (n=0;n<nbligne_entete;n++) fgets(ch,90,fsyrg);

    /* coordonnees noeuds maillage SYRTHES */
    if (ndim==2) 
      {
	for (n=0;n<npoin;n++) 
	  { 
	    fgets(ccc,2,fsyrg);
	    fscanf(fsyrg,"%d%d%lf%lf%lf",&i,&ii,(coord[0]+n),(coord[1]+n),&z);
	    fgets(ch,90,fsyrg);
	  }
      }
    else
      {
	for (n=0;n<npoin;n++) 
	  { 
	    fgets(ccc,2,fsyrg);
	    fscanf(fsyrg,"%d%d%lf%lf%lf",&i,&ii,(coord[0]+n),(coord[1]+n),(coord[2]+n));
	    fgets(ch,90,fsyrg);
	  }
      }
    
    printf("\n   Fin de la lecture des coordonnees des noeuds Syrthes\n");
     

    /* connectivite maillage SYRTHES */
    fgets(ch,90,fsyrg);
    fgets(ch,90,fsyrg);
    fgets(ch,90,fsyrg);
    
    if (nbno==6)
      for (i=0;i<nelem;i++)
	  fscanf(fsyrg,"%d%d%d%d%d%d%d%d",&n,(nrefe+i),
		    (node[0]+i),(node[1]+i),(node[2]+i),(node[3]+i),
		    (node[4]+i),(node[5]+i)); 

    else if (nbno==3)
      for (i=0;i<nelem;i++)
	  fscanf(fsyrg,"%d%d%d%d%d",&n,(nrefe+i),
		    (node[0]+i),(node[1]+i),(node[2]+i));

    else if (nbno==2)
      for (i=0;i<nelem;i++)
	  fscanf(fsyrg,"%d%d%d%d",&n,(nrefe+i),
		    (node[0]+i),(node[1]+i));

    else if (nbno==4)
      for (i=0;i<nelem;i++)
	  fscanf(fsyrg,"%d%d%d%d%d%d",&n,(nrefe+i),
		 (node[0]+i),(node[1]+i),(node[2]+i),(node[3]+i));

    else if (nbno==10)
      for (i=0;i<nelem;i++)
	fscanf(fsyrg,"%d%d%d%d%d%d%d%d%d%d%d%d",&n,(nrefe+i),
	       (node[0]+i),(node[1]+i),(node[2]+i),(node[3]+i),
	       (node[4]+i),(node[5]+i),(node[6]+i),(node[7]+i),
	       (node[8]+i),(node[9]+i));


    fgets(ch,90,fsyrg);
    printf("\n   Fin de la lecture de la connectivite Syrthes\n\n");

    /* on decale la numerotation de 1 pour etre coherent*/
/*     for (i=0;i<nelem;i++) */
/*       for (j=0;j<nbno;j++) */
/* 	node[j][i]--; */


    if (version<39)
      {
	/*  references eventuelles des faces */
	fgets(ch,90,fsyrg);
	if (!strncmp(ch,"C",1))
	  {
	    *noface=0;
	    fgets(ch,90,fsyrg);
	    fgets(ch,90,fsyrg);
	    if (nbface==3)
	      for (i=0;i<nelem;i++)
		fscanf(fsyrg,"%d%d%d%d",&n,(nrefac[0]+i),(nrefac[1]+i),(nrefac[2]+i));
	    else if (nbface==4)
	      for (i=0;i<nelem;i++)
		fscanf(fsyrg,"%d%d%d%d%d",&n,(nrefac[0]+i),(nrefac[1]+i),
		                             (nrefac[2]+i),(nrefac[3]+i));
	  }
	else
	  *noface=1;
      }
    else
      {
	/* connectivite maillage de bord SYRTHES */
	fgets(ch,90,fsyrg);
	fgets(ch,90,fsyrg);
	fgets(ch,90,fsyrg);
	
	if (ndim==2)
	  for (i=0;i<nelembord;i++)
	    fscanf(fsyrg,"%d%d%d%d",&n,(nrefebord+i),(nodebord[0]+i),(nodebord[1]+i));

	
	else if (ndim==3)
	  for (i=0;i<nelembord;i++)
	    fscanf(fsyrg,"%d%d%d%d%d",&n,(nrefebord+i),
		   (nodebord[0]+i),(nodebord[1]+i),(nodebord[2]+i));

	/* on decale la numerotation de 1 pour etre coherent*/
/* 	for (i=0;i<nelembord;i++) */
/* 	  for (j=0;j<ndim;j++) */
/* 	    nodebord[j][i]--; */
      }
}

/*|======================================================================|
  | SYRTHES - Utilitaires      JUIL 95                                   |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | combien_scalaires                                                    |
  |        lecture de l'enete du fichier resu pour determiner le nombre  |
  |        de scalaires a lire                                           |
  |======================================================================| */
void combien_scalaires(FILE *fsyrr,int *nbscal,int *npoin,int *nelem,int *version)
{
  int n1,n,i;
  char ch[90],chrien[20],chlong[200];


  /* lecture de l'entete du fichier resultat */
  fseek(fsyrr,0,SEEK_SET);

  /* determination de la version du fichier */
  fgets(ch,90,fsyrr);

  /* entete version 4.0 */
  if (!strncmp(ch,"*V4.0",5))
    {
      *version=40;
      fgets(ch,120,fsyrr);
      fgets(ch,120,fsyrr);
      fscanf(fsyrr,"%4s%4s%1s%d%1s%7s%d%1s%6s%d\n",
	     chrien,chrien,chrien,&n,chrien,chrien,&n,chrien,chrien,nbscal);
      fscanf(fsyrr,"%4s%5s%1s%d%1s%5s%1s%d\n",
	     chrien,chrien,chrien,npoin,chrien,chrien,chrien,nelem);
    }
  else
    {
      for (i=0;i<3;i++) fgets(chlong,200,fsyrr);
      if (!strncmp(chlong+39,"NBNP2",5))
	{
	  *version=33;
	  fscanf(fsyrr,"%s%d%d%d%d%d%d",ch,&n,&n,nelem,&n1,npoin,nbscal);
	}
      else
	{
	  *version=34;
	  fscanf(fsyrr,"%s%d%d%d%d%d",ch,&n,&n,nelem,npoin,nbscal);
	}
    }

  printf("  --> nombre de variables par pas de temps = %d\n\n",*nbscal);
}

/*|======================================================================|
  | SYRTHES - Utilitaires      JUIL 95                                   |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | resu_syr                                                             |
  |        lecture des resultats Syrthes                                 |
  |======================================================================| */
void resu_syr_entete(int version,int *nt,double *temps)
{
    int i;
    char ch[90],chrien[20],chlong[200];

    /* on passe l'entete (-1 ligne deja lue avant pour voir s'il reste
       un pas de temps a lire)                                         */

    if (version==40)
      {
	fgets(ch,120,fsyrr);
	fgets(ch,120,fsyrr);
	fgets(ch,120,fsyrr);
	fgets(ch,120,fsyrr);
	fscanf(fsyrr,"%s%s%s%d%s%s%s%lf\n",chrien,chrien,chrien,nt,chrien,chrien,chrien,temps);
	fgets(ch,90,fsyrr);
	fgets(ch,90,fsyrr);
      }
    else
      {
	/* on passe l'entete (-1 ligne deja lue avant)*/
	for (i=0;i<5;i++) fgets(chlong,200,fsyrr);
	fscanf(fsyrr,"%s%d%lf",ch,nt,temps);fgets(ch,90,fsyrr);
	for (i=0;i<3;i++) fgets(ch,90,fsyrr);
      }

    printf("      Traitement du pas de temps %d (%f secondes)\n",*nt,*temps);

}

/*|======================================================================|
  | SYRTHES - Utilitaires      JUIL 95                                   |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | resu_syr                                                             |
  |        lecture des resultats Syrthes                                 |
  |======================================================================| */
void resu_syr_var(int npoin,double *var)
{
    int nbl,i,j;

    nbl=npoin/6;
    for (i=0;i<nbl;i++) 
      {
        j=i*6;
        fscanf(fsyrr,"%13lf%13lf%13lf%13lf%13lf%13lf",
                  (var+j),(var+j+1),(var+j+2),
           	  (var+j+3),(var+j+4),(var+j+5));
      }
    for (i=nbl*6;i<npoin;i++) fscanf(fsyrr,"%13lf",(var+i));

    
}
/*|======================================================================|
  | SYRTHES - Utilitaires      JUIL 95                                   |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | resu_syr                                                             |
  |        lecture des resultats Syrthes                                 |
  |======================================================================| */
void resu_syr_nomvar(char *nomvar,int *discr)
{
    char ch[90];

    /* on lit le nom de la variable et on passe une ligne */
    fscanf(fsyrr,"%s",nomvar);
    fgets(ch,90,fsyrr);

    /* on lit la localisation de la variable (noeuds ou elements) */
    fscanf(fsyrr,"%1d",discr);
    fgets(ch,90,fsyrr);
    
    printf("       --> lecture de la variable %s (localisation %d)\n",nomvar,*discr);
}
/*|======================================================================|
  | SYRTHES - Utilitaires      JUIL 95                                   |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | geom_ens                                                             |
  |        eciture de la geometrie au format Ensight                     |
  |======================================================================| */
void geom_ens(int ndim,int ndiele,int npoin,int nelem,int nbno,int nbface,
	      int **node,int *nrefe,int **nrefac,double **coord,
	      int noface,int indip1,int decoup,
	      int nelembord,int **nodebord,int *nrefebord,int version)
{
  int i,j,n,nelemd,nbsselt,numpart;
  int nare[2][3], nfac[3][4];
  int *iref;

  nare[0][0]=0; nare[1][0]=1;
  nare[0][1]=1; nare[1][1]=2;
  nare[0][2]=2; nare[1][2]=0;

  nfac[0][0]=0; nfac[1][0]=1;  nfac[2][0]=2;
  nfac[0][1]=0; nfac[1][1]=1;  nfac[2][1]=3;
  nfac[0][2]=0; nfac[1][2]=2;  nfac[2][2]=3;
  nfac[0][3]=1; nfac[1][3]=2;  nfac[2][3]=3;

  /* ecriture des coorodonnees */

  fprintf(fgeom,"CALCUL SYRTHES\n");                                                         
  fprintf(fgeom,"conduction/rayonnement thermique\n"); 
  fprintf(fgeom,"node id given\n");  
  fprintf(fgeom,"element id given\n");  

  printf("\n   Ecriture des %d noeuds au format Ensight\n",npoin);
  fprintf(fgeom,"coordinates \n%8d\n",npoin);
  if (ndim==2)
    for (n=0;n<npoin;n++) 
      fprintf(fgeom,"%8d%12.5e%12.5e%12.5e\n",n+1,coord[0][n],coord[1][n],0.);
  else
    for (n=0;n<npoin;n++) 
      fprintf(fgeom,"%8d%12.5e%12.5e%12.5e\n",n+1,coord[0][n],coord[1][n],coord[2][n]);

  /* ecriture des elements */
  if (!decoup)
    {
      printf("   Ecriture des %d elements au format Ensight\n",nelem);
      if (ndiele==1)
	{
	  if (nbno==2) 
	    {
	      fprintf(fgeom,"part       1\n  Solide entier bar2\nbar2\n%8d\n",nelem);
	      for (n=0;n<nelem;n++) fprintf(fgeom,"%8d%8d%8d\n",n+1,node[0][n],node[1][n]);
	    }
	  else
	    {
	      fprintf(fgeom,"part       1\n  Solide entier bar3\nbar3\n%8d\n",nelem);
	      for (n=0;n<nelem;n++) fprintf(fgeom,"%8d%8d%8d%8d\n",n+1,node[0][n],node[1][n],node[2][n]);
	    }
	}
      
      else if (ndiele==2)
	{
	  if (nbno==3 || (nbno==6 && indip1)) 
	    {
	      fprintf(fgeom,"part       1\n  Solide entier tria3\ntria3\n%8d\n",nelem);
	      for (n=0;n<nelem;n++) fprintf(fgeom,"%8d%8d%8d%8d\n",n+1,node[0][n],node[1][n],node[2][n]);
	    }
	  else
	    {
	      fprintf(fgeom,"part       1\n  Solide entier tria6\ntria6\n%8d\n",nelem);
	      for (n=0;n<nelem;n++) 
		{
		  fprintf(fgeom,"%8d",n+1);
		  for (j=0;j<nbno;j++) fprintf(fgeom,"%8d",node[j][n]);
		  fprintf(fgeom,"\n");
		}
	    }
	}
      else if (ndiele==3)
	{  
	  if (nbno==4 || (nbno==10 && indip1)) 
	    {
	      fprintf(fgeom,"part       1\n  Solide entier tetra4\ntetra4\n%8d\n",nelem);
	      for (n=0;n<nelem;n++) 
		{
		  fprintf(fgeom,"%8d",n+1);
		  for (j=0;j<4;j++) fprintf(fgeom,"%8d",node[j][n]);
		  fprintf(fgeom,"\n");
		}
	    }
	  else
	    {
	      fprintf(fgeom,"part       1\n  Solide entier tetra10\ntetra10\n%8d\n",nelem);
	      for (n=0;n<nelem;n++) 
		{
		  fprintf(fgeom,"%8d",n+1);
		  for (j=0;j<nbno;j++) fprintf(fgeom,"%8d",node[j][n]);
		  fprintf(fgeom,"\n");
		}
	    }
	}
    }
  else  /* decoupage des elements P2 en P1 */
    {
      if (ndiele==1 && nbno==3)
	{
	  nelemd=nelem*2;
	  printf("   Ecriture des %d elements au format Ensight\n",nelemd);
	  fprintf(fgeom,"part       1\n  Solide entier bar2\nbar2\n%8d\n",nelemd);
	  for (n=0;n<nelem;n++) 
	    {
	      fprintf(fgeom,"%8d%8d%8d\n",n*2+1,node[0][n],node[2][n]);
	      fprintf(fgeom,"%8d%8d%8d\n",n*2+2,node[2][n],node[1][n]);
	    }
	}
      
      else if (ndiele==2 && nbno==6)
	{
	  nelemd=nelem*4;
	  printf("   Ecriture des %d elements au format Ensight\n",nelemd);
	  fprintf(fgeom,"part       1\n  Solide entier tria3\ntria3\n%8d\n",nelemd);
	  for (n=0;n<nelem;n++) 
	    {
	      fprintf(fgeom,"%8d%8d%8d%8d\n",n*4+1,node[0][n],node[3][n],node[5][n]);
	      fprintf(fgeom,"%8d%8d%8d%8d\n",n*4+2,node[3][n],node[1][n],node[4][n]);
	      fprintf(fgeom,"%8d%8d%8d%8d\n",n*4+3,node[2][n],node[5][n],node[4][n]);
	      fprintf(fgeom,"%8d%8d%8d%8d\n",n*4+3,node[3][n],node[4][n],node[5][n]);
	    }

	}
      else if (ndiele==3 && nbno==10)
	{  
	  nelemd=nelem*8;
	  printf("   Ecriture des %d elements au format Ensight\n",nelemd);
	  fprintf(fgeom,"part       1\n  Solide entier tetra4\ntetra4\n%8d\n",nelemd);
	  for (n=0;n<nelem;n++) 
	    {
	      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+1,node[0][n],node[4][n],node[6][n],node[7][n]);
	      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+2,node[4][n],node[1][n],node[5][n],node[8][n]);
	      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+3,node[6][n],node[5][n],node[2][n],node[9][n]);
	      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+4,node[7][n],node[8][n],node[9][n],node[3][n]);
	      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+5,node[4][n],node[5][n],node[6][n],node[7][n]);
	      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+6,node[4][n],node[5][n],node[8][n],node[7][n]);
	      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+7,node[5][n],node[6][n],node[7][n],node[9][n]);
	      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+8,node[7][n],node[8][n],node[9][n],node[5][n]);

	    }
	}
    }

  /* numero de la part courante */
  numpart=1;

  /* creation de part pour les proprietes physiques */
  /* ---------------------------------------------- */

  iref=(int*)malloc(100*sizeof(int));
  for (n=0;n<100;n++) iref[n]=0;

  /* on compte combien il y d'elements de chaque couleur */
  for (n=0;n<nelem;n++)
    if (nrefe[n]>0) iref[nrefe[n]]++;
  
  /* prise en compte du decoupage eventuel */
  if (ndiele==1) nbsselt=2;
  else if (ndiele==2) nbsselt=4;
  else if (ndiele==3) nbsselt=8;
  if (!decoup) nbsselt=1;
  for (n=0;n<100;n++) iref[n]*=nbsselt;

  for (n=0;n<100;n++) 
    if (iref[n]>0) 
      if (!decoup) printf("   Nombre d'elements de sous-domaine %2d = %8d\n",n,iref[n]);
      else         printf("   Nombre d'elements (decoupes) de sous-domaine %2d = %8d\n",n,iref[n]);
  


  for (i=0;i<100;i++)
    if (iref[i]>0)
      {
	if (ndiele==1)
	  {
	    numpart++;
	    fprintf(fgeom,"part %8d\n  Sous-domaine %3d\nbar2\n%8d\n",numpart,i,iref[i]);
	    for (n=0;n<nelem;n++) 
	      if (nrefe[n]==i) 
		{
		  fprintf(fgeom,"%8d%8d%8d\n",n+1,node[0][n],node[1][n]); 
		}
	  }
	else if (ndiele==2)
	  {
	    numpart++;
	    fprintf(fgeom,"part %8d\n  Sous-domaine %3d\ntria3\n%8d\n",numpart,i,iref[i]);
	    for (n=0;n<nelem;n++) 
	      if (nrefe[n]==i) 
		{
		  if (!decoup) fprintf(fgeom,"%8d%8d%8d%8d\n",n+1,node[0][n],node[1][n],node[2][n]); 
		  else 
		    {
		      fprintf(fgeom,"%8d%8d%8d%8d\n",n*4+1,node[0][n],node[3][n],node[5][n]);
		      fprintf(fgeom,"%8d%8d%8d%8d\n",n*4+2,node[3][n],node[1][n],node[4][n]);
		      fprintf(fgeom,"%8d%8d%8d%8d\n",n*4+3,node[2][n],node[5][n],node[4][n]);
		      fprintf(fgeom,"%8d%8d%8d%8d\n",n*4+4,node[3][n],node[4][n],node[5][n]);
		    }
		}
	  }
	else
	  {
	    numpart++;
	    fprintf(fgeom,"part %8d\n  Sous-domaine %3d\ntetra4\n%8d\n",numpart,i,iref[i]);
	    for (n=0;n<nelem;n++) 
	      if (nrefe[n]==i)
		{ 
		  if (!decoup)
		    {
		      fprintf(fgeom,"%8d",n+1);
		      for (j=0;j<4;j++) fprintf(fgeom,"%8d",node[j][n]);
		      fprintf(fgeom,"\n");
		    }
		  else
		    {
		      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+1,node[0][n],node[4][n],node[6][n],node[7][n]);
		      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+2,node[4][n],node[1][n],node[5][n],node[8][n]);
		      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+3,node[6][n],node[5][n],node[2][n],node[9][n]);
		      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+4,node[7][n],node[8][n],node[9][n],node[3][n]);
		      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+5,node[4][n],node[5][n],node[6][n],node[7][n]);
		      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+6,node[4][n],node[5][n],node[8][n],node[7][n]);
		      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+7,node[5][n],node[6][n],node[7][n],node[9][n]);
		      fprintf(fgeom,"%8d%8d%8d%8d%8d\n",n*8+8,node[7][n],node[8][n],node[9][n],node[5][n]);
		    }
		}
	  }
      }
  printf("\n");

  /* creation de part pour les conditions aux limites */
  /* cas de Syrthes version 3.x                       */
  /* ------------------------------------------------ */

  if (!noface && version<39)
    {
      for (n=0;n<100;n++) iref[n]=0;
      
      /* on compte combien il y de faces chaque couleur */
      for (n=0;n<nelem;n++)
	for (j=0;j<nbface;j++)
	  if (nrefac[j][n]>0) iref[nrefac[j][n]]++;
      
      for (i=0;i<100;i++)
	if (iref[i]>0)
	  {
	    printf("   Nombre de faces de reference %2d = %8d\n",i,iref[i]);
	    if (ndiele==2)
	      {
		numpart++;
		fprintf(fgeom,"part %8d\n  Reference %3d\nbar2\n%8d\n",numpart,i,iref[i]);
		for (n=0;n<nelem;n++) 
		  for (j=0;j<nbface;j++) 
		    if (nrefac[j][n]==i)
		      fprintf(fgeom,"%8d%8d%8d\n",n+1,node[nare[0][j]][n],node[nare[1][j]][n]);
	      }
	    else
	      {
		numpart++;
		fprintf(fgeom,"part %8d\n  Reference %3d\ntria3\n%8d\n",numpart,i,iref[i]);
		for (n=0;n<nelem;n++) 
		  for (j=0;j<nbface;j++) 
		    if (nrefac[j][n]==i)
		      fprintf(fgeom,"%8d%8d%8d%8d\n",n+1,node[nfac[0][j]][n],node[nfac[1][j]][n],
			                            node[nfac[2][j]][n]);
	      }
	  }
      
    } /* fin de "s'il y a des faces */

  /* creation de la part pour le maillage de bord   */
  /* cas de Syrthes version 4.x                     */
  /* ---------------------------------------------- */
  if (version==40)
    {
      numpart++;
      if (ndiele==2) 
	{
	  fprintf(fgeom,"part %8d\n  Solide Bord\nbar2\n%8d\n",numpart,nelembord);
	  for (n=0;n<nelembord;n++) fprintf(fgeom,"%8d%8d%8d\n",n+1,nodebord[0][n],nodebord[1][n]);
	}
      else if (ndiele==3) 
	{
	  fprintf(fgeom,"part %8d\n  Solide Bord\ntria3\n%8d\n",numpart,nelembord);
	  for (n=0;n<nelembord;n++) fprintf(fgeom,"%8d%8d%8d%8d\n",
					    n+1,nodebord[0][n],nodebord[1][n],nodebord[2][n]);
	}

      /* creation d'une part par numero de reference */
      for (n=0;n<100;n++) iref[n]=0;

      /* on compte combien il y d'elements de chaque couleur */
      for (n=0;n<nelembord;n++)
	if (nrefebord[n]>0) iref[nrefebord[n]]++;
  
      for (n=0;n<100;n++) 
	if (iref[n]>0) 
	  if (!decoup) printf("   Nombre d'elements de bord de reference %2d = %8d\n",n,iref[n]);



      for (i=0;i<100;i++)
	if (iref[i]>0)
	  {
	    if (ndiele==2) /* alors elements de bord sont des poutres */
	      {
		numpart++;
		fprintf(fgeom,"part %8d\n  Reference %3d\nbar2\n%8d\n",numpart,i,iref[i]);
		for (n=0;n<nelembord;n++) 
		  if (nrefebord[n]==i) 
		    fprintf(fgeom,"%8d%8d%8d\n",n+1,nodebord[0][n],nodebord[1][n]); 
	      }
	    else if (ndiele==3) /* alors elements de bord sont des triangles */
	      {
		numpart++;
		fprintf(fgeom,"part %8d\n  Reference %3d\ntria3\n%8d\n",numpart,i,iref[i]);
		for (n=0;n<nelembord;n++) 
		  if (nrefebord[n]==i)
		    fprintf(fgeom,"%8d%8d%8d%8d\n",n+1,nodebord[0][n],nodebord[1][n],nodebord[2][n]); 
	      }
	  }

    } /* fin de la version 4.x */

}

/*|======================================================================|
  | SYRTHES - Utilitaires      JUIL 95                                   |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | ecrit_var_ensigh                                                     |
  |        eciture d'une varaible au format Ensight                      |
  |======================================================================| */
void ecrit_var_ensight(FILE *fvar,int ndim,int discr,int indip1,
		       int npoin,int nelem,int nbno,
		       double temps,char *nomvar,
		       double *var)
{
  int nbl,i,j;
  
  if (discr==3)
    {
      fprintf(fvar,"%s a t= %12.5e (variable sur les noeuds)\n",nomvar,temps);
      
      nbl=npoin/6;
      for (i=0;i<nbl;i++) 
	{
	  j=i*6;
	  fprintf(fvar,"%12.5e%12.5e%12.5e%12.5e%12.5e%12.5e\n",
                  *(var+j),*(var+j+1),*(var+j+2),
           	  *(var+j+3),*(var+j+4),*(var+j+5));
	}
      for (i=nbl*6;i<npoin;i++) fprintf(fvar,"%12.5e",*(var+i));
      fprintf(fvar,"\n");
    }

  else if (discr==1)
    {
      fprintf(fvar,"%s a t= %12.5e (variable sur les elements)\n",nomvar,temps);
      fprintf(fvar,"part 1\n");
      if (nbno==3 || (nbno==6 && indip1))
	fprintf(fvar,"tria3\n");
      else if (nbno==4 || (nbno==10 && indip1))
	fprintf(fvar,"tetra4\n");
      else if (nbno==6)
	fprintf(fvar,"tria6\n");
      else if (nbno==10)
	fprintf(fvar,"tetra10\n");
      else
	fprintf(fvar,"bar2\n");
	
      nbl=nelem/6;
      for (i=0;i<nbl;i++) 
	{
	  j=i*6;
	  fprintf(fvar,"%12.5e%12.5e%12.5e%12.5e%12.5e%12.5e\n",
                  *(var+j),*(var+j+1),*(var+j+2),
           	  *(var+j+3),*(var+j+4),*(var+j+5));
	}
      for (i=nbl*6;i<nelem;i++) fprintf(fvar,"%12.5e",*(var+i));
      fprintf(fvar,"\n");

    }

}
