//Filename: sysinfo.h
/*
 * Sysinfo
 * Copyright (C) Nil Gradisnik 2005 <ghaefb@gmail.com>
 * 
 * Sysinfo is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * sysinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.cc.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */

#ifndef SYSINFO_H
#define SYSINFO_H

#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/window.h>
#include <gtkmm/imagemenuitem.h>
#include <gtkmm/aboutdialog.h>
#include <gtkmm/notebook.h>
#include <gtkmm/entry.h>
#include <gtkmm/statusbar.h>
#include <gtkmm/progressbar.h>
#include <gtkmm/label.h>
#include <gtkmm/textview.h>
#include <gtkmm/button.h>
#include <gtkmm/filechooserdialog.h>
#include <libglademm/xml.h>
#include <iostream>
	
//sysinfo class
class Sysinfo : public Gtk::Window {
    public:
		Sysinfo(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>&refGlade);
	    virtual ~Sysinfo();
	
	protected:
		virtual void on_menuitem_quit();
	    virtual void on_menuitem_save();
		virtual void on_menuitem_refresh();
	    virtual void on_menuitem_about();
	    virtual void on_selection_changed();
	    virtual void on_filesystem_set();
	    virtual void on_button_nvi();
		
	
		//treeview columns
		class ModelColumns : public Gtk::TreeModel::ColumnRecord {
			public:
				ModelColumns() { 
					add(pix1);
					add(m_col1);
				}
			
			Gtk::TreeModelColumn< Glib::RefPtr<Gdk::Pixbuf> > pix1;
			Gtk::TreeModelColumn<Glib::ustring> m_col1;
			
		};
		ModelColumns m_Columns;
		
		Glib::RefPtr<Gnome::Glade::Xml> m_refGlade;
		Gtk::TreeView *m_TreeView;
		Glib::RefPtr<Gtk::ListStore> m_refTreeModel;
		Glib::RefPtr<Gtk::TreeSelection> m_refTreeSelection;
		
		//menuitems 
		Gtk::ImageMenuItem *menuitem_quit;
		Gtk::ImageMenuItem *menuitem_save;
		Gtk::ImageMenuItem *menuitem_refresh;
		Gtk::ImageMenuItem *menuitem_about;
		
		//notebook
		Gtk::Notebook *notebook;
		
		//dialogs
		Gtk::AboutDialog *aboutdialog;
		Gtk::FileChooserDialog *filechooserdialog;
		
		//system info entry widgets
		Gtk::Entry *entry_ostype;
		Gtk::Entry *entry_release;
		Gtk::Entry *entry_kernel;
		Gtk::Entry *entry_buildtime;
		Gtk::Entry *entry_hostname;
		Gtk::Entry *entry_domainname;
		Gtk::Entry *entry_gnomeversion;
		Gtk::Entry *entry_gccversion;
		Gtk::Entry *entry_xorgversion;
		Gtk::Entry *entry_uptime;
		
		//cpu info entry widgets
		Gtk::Entry *entry_cpu_name;
		Gtk::Entry *entry_cpu_vendor;
		Gtk::Entry *entry_cpu_frequency;
		Gtk::Entry *entry_cpu_cache;
		Gtk::Entry *entry_cpu_bogomips;
		Gtk::Entry *entry_cpu_model;
		Gtk::Entry *entry_cpu_family;
		Gtk::Entry *entry_cpu_stepping;
		
		//memory info entry widgets
		Gtk::Entry *entry_mem_total;
		Gtk::ProgressBar *progressbar_mem;
		Gtk::Entry *entry_mem_cached;
		Gtk::Entry *entry_mem_active;
		Gtk::Entry *entry_mem_inactive;
		Gtk::Entry *entry_mem_swaptotal;
		Gtk::Entry *entry_mem_swapfree;
		
		//ide info entry widgets
		Gtk::Label *label_ide_pm;
		Gtk::Label *label_ide_ps;
		Gtk::Label *label_ide_sm;
		Gtk::Label *label_ide_ss;
		Gtk::Entry *entry_idepm_model;
		Gtk::Entry *entry_idepm_capa;
		Gtk::Entry *entry_idepm_cache;
		Gtk::Entry *entry_ideps_model;
		Gtk::Entry *entry_ideps_capa;
		Gtk::Entry *entry_ideps_cache;
		Gtk::Entry *entry_idesm_model;
		Gtk::Entry *entry_idesm_capa;
		Gtk::Entry *entry_idesm_cache;
		Gtk::Entry *entry_idess_model;
		Gtk::Entry *entry_idess_capa;
		Gtk::Entry *entry_idess_cache;
		
		//filesystem treeview
		class ModelColumns3 : public Gtk::TreeModel::ColumnRecord {
			public:
				ModelColumns3() { 
					add(col_filesys);
					add(col_type);
					add(col_size);
					add(col_used);
					add(col_avalible);
					add(col_use1);
					add(col_mounted);
				}
			
				Gtk::TreeModelColumn<Glib::ustring> col_filesys;
				Gtk::TreeModelColumn<Glib::ustring> col_type;
				Gtk::TreeModelColumn<Glib::ustring> col_size;
				Gtk::TreeModelColumn<Glib::ustring> col_used;
				Gtk::TreeModelColumn<Glib::ustring> col_avalible;
				Gtk::TreeModelColumn<Glib::ustring> col_use1;
				Gtk::TreeModelColumn<Glib::ustring> col_mounted;
			
		};
		ModelColumns3 m_Columns3;
		
		Glib::RefPtr<Gnome::Glade::Xml> m_refGlade3;
		Gtk::TreeView *m_TreeView3;
		Glib::RefPtr<Gtk::ListStore> m_refTreeModel3;
		
		//hardware info widgets
		Gtk::TextView *textview_hardware_mot;
		Glib::RefPtr<Gtk::TextBuffer> text_hardware_mot;
		Gtk::TextView *textview_hardware_sound;
		Glib::RefPtr<Gtk::TextBuffer> text_hardware_sou;
		Gtk::TextView *textview_hardware_eth;
		Glib::RefPtr<Gtk::TextBuffer> text_hardware_eth;
		Gtk::Entry *entry_hardware_ide;
		Gtk::Entry *entry_hardware_vga;
		
		//usb info widgets
		Gtk::TextView *textview_usb;
		Glib::RefPtr<Gtk::TextBuffer> text_usb;
		
		//other info widgets
		Gtk::TextView *textview_other_sound;
		Glib::RefPtr<Gtk::TextBuffer> text_other_sound;
		Gtk::TextView *textview_other_input;
		Glib::RefPtr<Gtk::TextBuffer> text_other_input;
		Gtk::Entry *entry_other_screen;
		
		//nvidia info entry widgets
		Gtk::Entry *entry_nvi_mod;
		Gtk::Entry *entry_nvi_agp;
		Gtk::Entry *entry_nvi_fw;
		Gtk::Entry *entry_nvi_sba;
		Gtk::Entry *entry_nvi_ver;
		Gtk::Button *button_nvi;
		
		//statusbar
		Gtk::Statusbar *statusbar;
		
	
};

#endif //SYSINFO_H

//ghaefb
