#
# Turn _boot_flavor into a parameter that can be set with --define
%{!?_boot_flavor:%define _boot_flavor standard}
# Turn _build_only_boot into a parameter that can be set with --define
%{!?_build_only_boot:%define _build_all 1}
%{?_build_only_boot:%define _build_all 0}
# Create a variable that can be used to monkey with the release name with --define
# This is an attempt to support the Fedora distro rpm naming nightmare.
%{!?release_extras:%define release_extras %{nil}}
# Don't create a debug package unless the builder explicitly requests it via --with debugpackage
%{!?_with_debugpackage:%define debug_package %{nil}}

# Sample invocations
# rpmbuild --rebuild systemimager-3.4.0-1.src.rpm
# rpmbuild --rebuild --define "_build_only_boot 1" systemimager-3.4.0-1.src.rpm
# I really loathe this sort of obfuscation
# rpmbuild --rebuild --define "release_extras .FC2_1" systemimager-3.4.0-1.src.rpm
# And here's what to do if you know how to use a debugpackage (does anyone?)
# rpmbuild --rebuild --with debugpackage systemimager-3.4.0-1.src.rpm

Summary: Software that automates Linux installs, software distribution, and production deployment.
Name: systemimager
Epoch: 0
Version: 3.4.0
Release: 1%{release_extras}
Copyright: GPL
Group: Applications/System
Source0: http://download.sourceforge.net/systemimager/%{name}-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildArchitectures: noarch
URL: http://systemimager.org/
Packager: Jerry DeLapp <jerrygd@users.sourceforge.net>
Distribution: System Installation Suite
Requires: rsync >= 2.4.6, syslinux >= 1.48, libappconfig-perl, dosfstools, /usr/bin/perl
AutoReqProv: no

%description
This is bogus and not used anywhere

%if %{_build_all}

%package server
Summary: Software that automates Linux installs, software distribution, and production deployment.
Group: Applications/System
Requires: rsync >= 2.4.6, systemimager-common = %{version}, systemimager-client = %{version}, perl-AppConfig, dosfstools, /sbin/chkconfig, perl, perl-XML-Simple
AutoReqProv: no

%description server
SystemImager is software that automates Linux installs, software 
distribution, and production deployment.  SystemImager makes it easy to
do installs, software distribution, content or data distribution, 
configuration changes, and operating system updates to your network of 
Linux machines. You can even update from one Linux release version to 
another!  It can also be used to ensure safe production deployments.  
By saving your current production image before updating to your new 
production image, you have a highly reliable contingency mechanism.  If
the new production enviroment is found to be flawed, simply roll-back 
to the last production image with a simple update command!  Some 
typical environments include: Internet server farms, database server 
farms, high performance clusters, computer labs, and corporate desktop
environments.

The server package contains those files needed to run a SystemImager
server.

%package flamethrower
Summary: Software that automates Linux installs, software distribution, and production deployment.
Group: Applications/System
Requires: systemimager-server = %{version}, /sbin/chkconfig, perl, flamethrower >= 0.1.6
AutoReqProv: no

%description flamethrower
SystemImager is software that automates Linux installs, software 
distribution, and production deployment.  SystemImager makes it easy to
do installs, software distribution, content or data distribution, 
configuration changes, and operating system updates to your network of 
Linux machines. You can even update from one Linux release version to 
another!  It can also be used to ensure safe production deployments.  
By saving your current production image before updating to your new 
production image, you have a highly reliable contingency mechanism.  If
the new production enviroment is found to be flawed, simply roll-back 
to the last production image with a simple update command!  Some 
typical environments include: Internet server farms, database server 
farms, high performance clusters, computer labs, and corporate desktop
environments.

The server package allows you to use the flamethrower utility to perform
installations over multicast.

%package common
Summary: Software that automates Linux installs, software distribution, and production deployment.
Group: Applications/System
Requires: perl, systemconfigurator
AutoReqProv: no

%description common
SystemImager is software that automates Linux installs, software 
distribution, and production deployment.  SystemImager makes it easy to
do installs, software distribution, content or data distribution, 
configuration changes, and operating system updates to your network of 
Linux machines. You can even update from one Linux release version to 
another!  It can also be used to ensure safe production deployments.  
By saving your current production image before updating to your new 
production image, you have a highly reliable contingency mechanism.  If
the new production enviroment is found to be flawed, simply roll-back 
to the last production image with a simple update command!  Some 
typical environments include: Internet server farms, database server 
farms, high performance clusters, computer labs, and corporate desktop
environments.

The common package contains files common to SystemImager clients 
and servers.

%package client
Summary: Software that automates Linux installs, software distribution, and production deployment.
Group: Applications/System
Requires: systemimager-common = %{version}, systemconfigurator, perl-AppConfig, rsync >= 2.4.6, perl, mtools
AutoReqProv: no

%description client
SystemImager is software that automates Linux installs, software
distribution, and production deployment.  SystemImager makes it easy to
do installs, software distribution, content or data distribution,
configuration changes, and operating system updates to your network of
Linux machines. You can even update from one Linux release version to
another!  It can also be used to ensure safe production deployments.
By saving your current production image before updating to your new
production image, you have a highly reliable contingency mechanism.  If
the new production enviroment is found to be flawed, simply roll-back
to the last production image with a simple update command!  Some
typical environments include: Internet server farms, database server
farms, high performance clusters, computer labs, and corporate desktop
environments.

The client package contains the files needed on a machine for it to
be imaged by a SystemImager server.

%endif

%package %{_build_arch}boot-%{_boot_flavor}
Summary: Software that automates Linux installs, software distribution, and production deployment.
Group: Applications/System
Obsoletes: systemimager-%{_build_arch}boot
Requires: systemimager-server >= %{version}
AutoReqProv: no

%description %{_build_arch}boot-%{_boot_flavor}
SystemImager is software that automates Linux installs, software 
distribution, and production deployment.  SystemImager makes it easy to
do installs, software distribution, content or data distribution, 
configuration changes, and operating system updates to your network of 
Linux machines. You can even update from one Linux release version to 
another!  It can also be used to ensure safe production deployments.  
By saving your current production image before updating to your new 
production image, you have a highly reliable contingency mechanism.  If
the new production enviroment is found to be flawed, simply roll-back 
to the last production image with a simple update command!  Some 
typical environments include: Internet server farms, database server 
farms, high performance clusters, computer labs, and corporate desktop
environments.

The %{_build_arch}boot package provides specific kernel, ramdisk, and fs utilities
to boot and install %{_build_arch} Linux machines during the SystemImager autoinstall
process.

%package doc
Summary: Software that automates Linux installs, software distribution, and production deployment.
Group: Applications/System
AutoReqProv: no

%description doc
SystemImager is software that automates Linux installs, software 
distribution, and production deployment.  SystemImager makes it easy to
do installs, software distribution, content or data distribution, 
configuration changes, and operating system updates to your network of 
Linux machines. You can even update from one Linux release version to 
another!  It can also be used to ensure safe production deployments.  
By saving your current production image before updating to your new 
production image, you have a highly reliable contingency mechanism.  If
the new production enviroment is found to be flawed, simply roll-back 
to the last production image with a simple update command!  Some 
typical environments include: Internet server farms, database server 
farms, high performance clusters, computer labs, and corporate desktop
environments.

The doc package contains documentation and examples for systemimager packages.

%prep
%setup -q

make -j11 get_source

# Only build everything if on x86, this helps with PPC build issues
%if %{_build_all}
%build
cd $RPM_BUILD_DIR/%{name}-%{version}/
PATH=/usr/sbin:/sbin:${PATH} make all

%else
%build
cd $RPM_BUILD_DIR/%{name}-%{version}/
PATH=/usr/sbin:/sbin:${PATH} make binaries

%endif

%if %{_build_all}

%install
cd $RPM_BUILD_DIR/%{name}-%{version}/
make install_server_all DESTDIR=$RPM_BUILD_ROOT PREFIX=%{_prefix}
make install_client_all DESTDIR=$RPM_BUILD_ROOT PREFIX=%{_prefix}
(cd doc/manual_source;PATH=/usr/sbin:/sbin:${PATH} make html)

%else

%install
cd $RPM_BUILD_DIR/%{name}-%{version}/
PATH=/usr/sbin:/sbin:${PATH} make install_binaries DESTDIR=$RPM_BUILD_ROOT PREFIX=%{_prefix}

%endif

# Some things that get duplicated because there are multiple calls to
# the make install_* phases.
find %{_tmppath}/%{name}-%{version}-root/ -name \*~ -exec rm -f '{}' \;

%clean
cd $RPM_BUILD_DIR/%{name}-%{version}/
#make distclean
rm -rf $RPM_BUILD_ROOT

%if %{_build_all}

%pre server
# /etc/systemimager/rsyncd.conf is now generated from stubs stored
# in /etc/systemimager/rsync_stubs.  if upgrading from an early
# version, we need to create stub files for all image entries
if [ -f /etc/systemimager/rsyncd.conf -a \
    ! -d /etc/systemimager/rsync_stubs ]; then
    echo "You appear to be upgrading from a pre-rsync stubs release."
    echo "/etc/systemimager/rsyncd.conf is now auto-generated from stub"
    echo "files stored in /etc/systemimager/rsync_stubs."
    echo "Backing up /etc/systemimager/rsyncd.conf to:"
    echo -n "  /etc/systemimager/rsyncd.conf-before-rsync-stubs... "
    mv /etc/systemimager/rsyncd.conf \
      /etc/systemimager/rsyncd.conf-before-rsync-stubs

    ## leave an extra copy around so the postinst knows to make stub files from it
    cp /etc/systemimager/rsyncd.conf-before-rsync-stubs \
      /etc/systemimager/rsyncd.conf-before-rsync-stubs.tmp
    echo "done."
fi    


%post server
# First we check for rsync service under xinetd and get rid of it
# also note the use of DURING_INSTALL, which is used to
# support using this package in Image building without affecting
# processes running on the parrent
if [[ -a /etc/xinetd.d/rsync ]]; then
    mv /etc/xinetd.d/rsync /etc/xinetd.d/rsync.presis~
    `pidof xinetd > /dev/null`
    if [[ $? == 0 ]]; then
        if [ -z $DURING_INSTALL ]; then
            /etc/init.d/xinetd restart
        fi
    fi
fi

# If we are upgrading from a pre-rsync-stubs release, the preinst script
# will have left behind a copy of the old rsyncd.conf file.  we need to parse
# it and make stubs files for each image.

# This assumes that this file has been managed by systemimager, and
# that there is nothing besides images entries that need to be carried
# forward.

in_image_section=0
current_image=""
if [ -f /etc/systemimager/rsyncd.conf-before-rsync-stubs.tmp ]; then
    echo "Migrating image entries from existing /etc/systemimager/rsyncd.conf to"
    echo "individual files in the /etc/systemimager/rsync_stubs/ directory..."
    while read line; do
	## Ignore all lines until we get to the image section
	if [ $in_image_section -eq 0 ]; then
	    echo $line | grep -q "^# only image entries below this line"
	    if [ $? -eq 0 ]; then
		in_image_section=1
	    fi
	else
	    echo $line | grep -q "^\[.*]$"
	    if [ $? -eq 0 ]; then
		current_image=$(echo $line | sed 's/^\[//' | sed 's/\]$//')
		echo -e "\tMigrating entry for $current_image"
		if [ -e "/etc/systemimager/rsync_stubs/40$current_image" ]; then
		    echo -e "\t/etc/systemimager/rsync_stubs/40$current_image already exists."
		    echo -e "\tI'm not going to overwrite it with the value from"
		    echo -e "\t/etc/systemimager/rsyncd.conf-before-rsync-stubs.tmp"
		    current_image=""
		fi
	    fi
	    if [ "$current_image" != "" ]; then
		echo "$line" >> /etc/systemimager/rsync_stubs/40$current_image
	    fi
	fi
    done < /etc/systemimager/rsyncd.conf-before-rsync-stubs.tmp
    rm -f /etc/systemimager/rsyncd.conf-before-rsync-stubs.tmp
    echo "Migration complete - please make sure to migrate any configuration you have"
    echo "    made in /etc/systemimager/rsyncd.conf outside of the image section."
fi
## END make stubs from pre-stub /etc/systemimager/rsyncd.conf file

/usr/sbin/si_mkrsyncd_conf

if [[ -a /usr/lib/lsb/install_initd ]]; then
    /usr/lib/lsb/install_initd /etc/init.d/systemimager-server-rsyncd
fi

if [[ -a /sbin/chkconfig ]]; then
    /sbin/chkconfig --add systemimager-server-rsyncd
fi

%preun server
/etc/init.d/systemimager-server-rsyncd stop

if [[ -a /usr/lib/lsb/remove_initd ]]; then
    /usr/lib/lsb/remove_initd /etc/init.d/systemimager-server-rsyncd
fi

if [[ -a /sbin/chkconfig ]]; then
    /sbin/chkconfig --del systemimager-server-rsyncd
fi

if [[ -a /etc/xinetd.d/rsync.presis~ ]]; then
    mv /etc/xinetd.d/rsync.presis~ /etc/xinetd.d/rsync
    `pidof xinetd > /dev/null`
    if [[ $? == 0 ]]; then
        /etc/init.d/xinetd restart
    fi
fi


%files doc
%defattr(0644, root, root, 0755)
%doc CHANGE.LOG COPYING CREDITS README VERSION
%doc doc/manual_source/html
%doc doc/examples
# %doc doc/autoinstall* doc/local.cfg
# The above section needs reworked in concert with the
# problem that we don't do 'make install_docs' in the build section.

%files common
# The following defattr is probably wrong.  It's dangerous to go with
# - in the first field because if you don't explicitly set modes during
# installation, then you'll get the builder's modes.
# The defatters in subsequent packages are probably broken too.
%defattr(-, root, root)
%doc CHANGE.LOG COPYING CREDITS README VERSION
%{_prefix}/bin/si_lsimage
%{_prefix}/share/man/man8/si_lsimage*
%{_prefix}/share/man/man5/autoinstall*
%dir %{_prefix}/lib/systemimager
%{_prefix}/lib/systemimager/perl/SystemImager/Common.pm
%{_prefix}/lib/systemimager/perl/SystemImager/Config.pm
%{_prefix}/lib/systemimager/perl/SystemImager/Options.pm

%files server
%defattr(-, root, root)
%doc CHANGE.LOG COPYING CREDITS README VERSION
%dir /var/log/systemimager
%dir /var/lib/systemimager/images
%dir /var/lib/systemimager/scripts/pre-install
%dir /var/lib/systemimager/scripts/post-install
%dir /var/lib/systemimager/overrides
/var/lib/systemimager/overrides/README
%dir /etc/systemimager
%config /etc/systemimager/pxelinux.cfg/*
%config /etc/systemimager/autoinstallscript.template
%config(noreplace) /etc/systemimager/rsync_stubs/*
%config(noreplace) /etc/systemimager/systemimager.conf
%config /etc/systemimager/imagemanip.conf
%config /etc/systemimager/imagemanip.perm
/etc/init.d/systemimager-server-rsyncd
/etc/init.d/systemimager-server-netboot*
/var/lib/systemimager/images/*
/var/lib/systemimager/scripts/post-install/*
/var/lib/systemimager/scripts/pre-install/*
%{_prefix}/sbin/si_addclients
%{_prefix}/sbin/si_cpimage
%{_prefix}/sbin/si_getimage
%{_prefix}/sbin/si_imagemanip
%{_prefix}/sbin/si_mkautoinstallscript
%{_prefix}/sbin/si_mkbootpackage
%{_prefix}/sbin/si_mkbootserver
%{_prefix}/sbin/si_mkclientnetboot
%{_prefix}/sbin/si_mkdhcpserver
%{_prefix}/sbin/si_mkdhcpstatic
%{_prefix}/sbin/si_mkrsyncd_conf
%{_prefix}/sbin/si_mvimage
%{_prefix}/sbin/si_netbootmond
%{_prefix}/sbin/si_pushupdate
%{_prefix}/sbin/si_rmimage
%{_prefix}/bin/si_mkautoinstallcd
%{_prefix}/bin/si_mkautoinstalldiskette
%{_prefix}/bin/si_mkbootmedia
%{_prefix}/lib/systemimager/perl/SystemImager/Server.pm
# These four were omitted in prior RPM releases
%{_prefix}/lib/systemimager/perl/BootMedia/alpha.pm
%{_prefix}/lib/systemimager/perl/BootMedia/BootMedia.pm
%{_prefix}/lib/systemimager/perl/BootMedia/i386.pm
%{_prefix}/lib/systemimager/perl/BootMedia/MediaLib.pm
%{_prefix}/lib/systemimager/perl/confedit
%{_prefix}/share/man/man5/systemimager*
%{_prefix}/share/man/man8/si_addclients.8.gz
%{_prefix}/share/man/man8/si_cpimage.8.gz
%{_prefix}/share/man/man8/si_getimage.8.gz
%{_prefix}/share/man/man8/si_lsimage.8.gz
%{_prefix}/share/man/man8/si_mkautoinstallcd.8.gz
%{_prefix}/share/man/man8/si_mkautoinstalldiskette.8.gz
%{_prefix}/share/man/man8/si_mkautoinstallscript.8.gz
%{_prefix}/share/man/man8/si_mkbootserver.8.gz
%{_prefix}/share/man/man8/si_mkclientnetboot.8.gz
%{_prefix}/share/man/man8/si_mkdhcpserver.8.gz
%{_prefix}/share/man/man8/si_mkdhcpstatic.8.gz
%{_prefix}/share/man/man8/si_mkrsyncd_conf.8.gz
%{_prefix}/share/man/man8/si_mvimage.8.gz
%{_prefix}/share/man/man8/si_pushupdate.8.gz
%{_prefix}/share/man/man8/si_rmimage.8.gz

%files client
%defattr(-, root, root)
%doc CHANGE.LOG COPYING CREDITS README VERSION
%dir /etc/systemimager
%config /etc/systemimager/updateclient.local.exclude
%config /etc/systemimager/client.conf
%{_prefix}/sbin/si_updateclient
%{_prefix}/sbin/si_prepareclient
%{_prefix}/share/man/man8/si_updateclient*
%{_prefix}/share/man/man8/si_prepareclient*
%{_prefix}/lib/systemimager/perl/SystemImager/Client.pm

%files flamethrower
%defattr(-, root, root)
%doc CHANGE.LOG COPYING CREDITS README VERSION
%dir /var/state/systemimager/flamethrower
%config /etc/systemimager/flamethrower.conf
/etc/init.d/systemimager-server-flamethrowerd

%endif

%files %{_build_arch}boot-%{_boot_flavor}
%defattr(-, root, root)
%doc CHANGE.LOG COPYING CREDITS README VERSION
%dir %{_prefix}/share/systemimager/boot/%{_build_arch}
%{_prefix}/share/systemimager/boot/%{_build_arch}/*

%changelog
* Tue Apr 19 2005 sis devel <sisuite-devel@lists.sourceforge.net> 3.4.0-1
- myriad changes, such as %{_prefix} instead of Prefix, and other wider
- use of rpm macros to enable non-root user builds.
- si_ naming convention
- BootMedia, which was missing from numerous prior RPM releases
- remove redundant %package entries (e.g. Packager:)
- prototypes of this specfile built successfully on debian 3.0r4 (stable),
- rh9 and FC2.  This will not build on FC3 because the kernel doesn't
- build with newer gcc.
- systemimager-doc package
- ability to tweak key variables from rpmbuild command line

* Wed Jun 02 2004 sis devel <sisuite-devel@lists.sourceforge.net> 3.3.1-1
- include pre-install and post-install directories

* Fri Mar 12 2004 sis devel <sisuite-devel@lists.sourceforge.net> 3.2.0-3
- html documentation returned to systemimager-server package

* Wed Mar 10 2004 sis devel <sisuite-devel@lists.sourceforge.net> 3.2.0-2
- remove more files created by multiple calls to install phases

* Wed Mar 03 2004 sis devel <sisuite-devel@lists.sourceforge.net> 3.2.0-1

* Wed Nov 12 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.1.6-1
- new upstream release
- add version dependency for systemimager-flamethrower package

* Tue Aug 19 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.1.5-1
- new upstream release

* Tue Jul 14 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.1.4-1
- new upstream release

* Tue Jul 09 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.1.3-1
- new upstream release

* Tue Jul 08 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.1.2-5
- add missing Client.pm, pushupdate manpage & overrides readme

* Sun Jul 06 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.1.2-4
- add missing conf file & state dir to systemimager-server-flamethrower

* Sat Jul 05 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.1.2-3
- install missing autoinstallscript.template

* Tue Jul 01 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.1.2-2
- make systemimager-flamethrower depend on flamethrower
- patch the x86 config to support sk98lin, so it does not go interactive

* Tue Jul 01 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.1.2-1
- new upstream development release

* Tue Apr 02 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.0.1-4
- fix mkautoinstallcd on ia64 - 751740

* Tue Apr 02 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.0.1-3
- added a patch from bef that no longer sorts module names - 755463

* Tue Apr 02 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.0.1-2
- remove eepro100 (but keep e100) so boel will fit on a floppy again

* Sun Mar 30 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.0.1-1
- new upstream bug-fix release

* Sun Jan 08 2003 sis devel <sisuite-devel@lists.sourceforge.net> 3.0.0-2
- various ia64 fixes
- stop attempting to build ps manual

* Sun Dec 08 2002 sis devel <sisuite-devel@lists.sourceforge.net> 3.0.0-1
- new upstream release

* Sun Nov 18 2002 dann frazier <dannf@dannf.org> 2.9.5-1
- new upstream release

* Sun Oct 27 2002 dann frazier <dannf@dannf.org> 2.9.4-1
- new upstream release

* Thu Oct 13 2002 dann frazier <dannf@dannf.org> 2.9.3-2
- added code to migrate users to rsync stubs

* Thu Oct 02 2002 dann frazier <dannf@dannf.org> 2.9.3-1
- new upstream release

* Thu Sep 19 2002 Sean Dague <sean@dague.net> 2.9.1-1
- Added \%if \%{_build_all} stanzas to make building easier.

* Tue Feb  5 2002 Sean Dague <sean@dague.net> 2.1.1-1
- Added section 5 manpages
- removed syslinux requirement, as it isn't need for ia64

* Mon Jan 14 2002 Sean Dague <sean@dague.net> 2.1.0-1
- Set Macro to build $ARCHboot packages propperly
- Targetted rpms for noarch target (dannf@dannf.org)
- Synced up file listing

* Wed Dec  5 2001 Sean Dague <sean@dague.net> 2.0.1-1
- Update SystemImager version
- Changed prefix to /usr
- Made seperate i386boot package

* Mon Nov  5 2001 Sean Dague <sean@dague.net> 2.0.0-4
- Added build section for true SRPM ability

* Mon Oct  28 2001 Sean Dague <sean@dague.net> 2.0.0-3
- Added common package

* Sat Oct 20 2001  Sean Dague <sean@dague.net> 2.0.0-2
- Recombined client and server into one spec file

* Thu Oct 18 2001 Sean Dague <sean@dague.net> 2.0.0-1
- Initial build
- Based on work by Ken Segura <ksegura@5o7.org>

